/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.event.brigadier.AsyncPlayerSendSuggestionsEvent;
import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import com.destroystokyo.paper.event.player.PlayerRecipeBookClickEvent;
import com.destroystokyo.paper.event.player.PlayerUseUnknownEntityEvent;
import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.ChatProcessor;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.entity.TeleportFlag;
import io.papermc.paper.event.player.PlayerArmSwingEvent;
import io.papermc.paper.event.player.PlayerFailMoveEvent;
import io.papermc.paper.event.player.PlayerPickItemEvent;
import io.papermc.paper.util.CollisionUtil;
import io.papermc.paper.util.MCUtil;
import io.papermc.paper.util.TraceUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.Translator;
import net.minecraft.EnumChatFormat;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.ThreadNamedUncaughtExceptionHandler;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketPlayInAbilities;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import net.minecraft.network.protocol.game.PacketPlayInArmAnimation;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayInBEdit;
import net.minecraft.network.protocol.game.PacketPlayInBeacon;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayInBlockPlace;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyChange;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyLock;
import net.minecraft.network.protocol.game.PacketPlayInEnchantItem;
import net.minecraft.network.protocol.game.PacketPlayInEntityAction;
import net.minecraft.network.protocol.game.PacketPlayInEntityNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInFlying;
import net.minecraft.network.protocol.game.PacketPlayInHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayInItemName;
import net.minecraft.network.protocol.game.PacketPlayInJigsawGenerate;
import net.minecraft.network.protocol.game.PacketPlayInPickItem;
import net.minecraft.network.protocol.game.PacketPlayInRecipeDisplayed;
import net.minecraft.network.protocol.game.PacketPlayInRecipeSettings;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandBlock;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandMinecart;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInSetJigsaw;
import net.minecraft.network.protocol.game.PacketPlayInSpectate;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInStruct;
import net.minecraft.network.protocol.game.PacketPlayInTabComplete;
import net.minecraft.network.protocol.game.PacketPlayInTeleportAccept;
import net.minecraft.network.protocol.game.PacketPlayInTileNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInTrSel;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayInUseItem;
import net.minecraft.network.protocol.game.PacketPlayInVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayInWindowClick;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutVehicleMove;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.status.PacketStatusInPing;
import net.minecraft.network.protocol.status.PacketStatusOutPong;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.util.FutureChain;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.InventoryClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_20_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_20_R2.util.CraftNamespacedKey;
import org.bukkit.craftbukkit.v1_20_R2.util.LazyPlayerSet;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryCreativeEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.SmithItemEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;
import org.spigotmc.SpigotConfig;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.bot.ServerBot;
import top.leavesmc.leaves.protocol.syncmatica.exchange.ExchangeTarget;
import top.leavesmc.leaves.replay.ServerPhotographer;
import top.leavesmc.leaves.util.ArrayConstants;

public class PlayerConnection
extends ServerCommonPacketListenerImpl
implements PacketListenerPlayIn,
ServerPlayerConnection,
TickablePacketListener {
    static final Logger g = LogUtils.getLogger();
    public static final double d = MathHelper.k(6.0);
    private static final int h = -1;
    private static final int i = 4096;
    private static final IChatBaseComponent j = IChatBaseComponent.c("multiplayer.disconnect.chat_validation_failed");
    public EntityPlayer e;
    public final PlayerChunkSender f;
    private int k;
    private int l = -1;
    private final AtomicInteger chatSpamTickCount = new AtomicInteger();
    private final AtomicInteger tabSpamLimiter = new AtomicInteger();
    private final AtomicInteger recipeSpamPackets = new AtomicInteger();
    private int n;
    private double o;
    private double p;
    private double q;
    private double r;
    private double s;
    private double t;
    @Nullable
    private net.minecraft.world.entity.Entity u;
    private double v;
    private double w;
    private double x;
    private double y;
    private double z;
    private double A;
    @Nullable
    private Vec3D B;
    private int C;
    private int D;
    private boolean E;
    private int F;
    private boolean G;
    private int H;
    private int I;
    private int J;
    private final AtomicReference<Instant> K;
    @Nullable
    private RemoteChatSession L;
    private boolean hasLoggedExpiry = false;
    private SignedMessageChain.b M;
    private final LastSeenMessagesValidator N;
    private final MessageSignatureCache O;
    private final FutureChain P;
    private boolean Q;
    private static final int MAX_SIGN_LINE_LENGTH = Integer.getInteger("Paper.maxSignLength", 80);
    private int lastTick = MinecraftServer.currentTick;
    private int allowedPlayerTicks = 1;
    private int lastDropTick = MinecraftServer.currentTick;
    private int lastBookTick = MinecraftServer.currentTick;
    private int dropCount = 0;
    private double lastPosX = Double.MAX_VALUE;
    private double lastPosY = Double.MAX_VALUE;
    private double lastPosZ = Double.MAX_VALUE;
    private float lastPitch = Float.MAX_VALUE;
    private float lastYaw = Float.MAX_VALUE;
    private boolean justTeleported = false;
    private boolean hasMoved;
    public final ExchangeTarget exchangeTarget;
    private static final ExecutorService TAB_COMPLETE_EXECUTOR = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Async Tab Complete Thread - #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new ThreadNamedUncaughtExceptionHandler(MinecraftServer.n)).build());
    private int limitedPackets;
    private long lastLimitedPacket = -1L;

    public PlayerConnection(MinecraftServer server, NetworkManager connection, EntityPlayer player, CommonListenerCookie clientData) {
        super(server, connection, clientData, player);
        this.K = new AtomicReference<Instant>(Instant.EPOCH);
        this.N = new LastSeenMessagesValidator(20);
        this.O = MessageSignatureCache.a();
        this.f = new PlayerChunkSender(connection.g());
        if (player instanceof ServerBot || player instanceof ServerPhotographer) {
            connection.setListenerForce(this);
        } else {
            connection.a(this);
        }
        this.e = player;
        player.c = this;
        player.V().a();
        this.M = server.aw() ? SignedMessageChain.b.a : SignedMessageChain.b.unsigned(player.cv());
        this.P = new FutureChain(server.chatExecutor);
        this.exchangeTarget = new ExchangeTarget(this);
    }

    @Override
    public void e() {
        int spam;
        if (this.l > -1) {
            this.b(new ClientboundBlockChangedAckPacket(this.l));
            this.l = -1;
        }
        this.m();
        this.e.K = this.e.dq();
        this.e.L = this.e.ds();
        this.e.M = this.e.dw();
        this.e.m();
        this.e.a(this.o, this.p, this.q, this.e.dB(), this.e.dD());
        ++this.k;
        this.J = this.I;
        if (this.E && !this.e.fC() && !this.e.bN() && !this.e.ev()) {
            if (++this.F > 80) {
                g.warn("{} was kicked for floating too long!", (Object)this.e.ab().getString());
                this.disconnect(GlobalConfiguration.get().messages.kick.flyingPlayer, PlayerKickEvent.Cause.FLYING_PLAYER);
                return;
            }
        } else {
            this.E = false;
            this.F = 0;
        }
        this.u = this.e.cV();
        if (this.u != this.e && this.u.cN() == this.e) {
            this.v = this.u.dq();
            this.w = this.u.ds();
            this.x = this.u.dw();
            this.y = this.u.dq();
            this.z = this.u.ds();
            this.A = this.u.dw();
            if (this.G && this.e.cV().cN() == this.e) {
                if (++this.H > 80) {
                    g.warn("{} was kicked for floating a vehicle too long!", (Object)this.e.ab().getString());
                    this.disconnect(GlobalConfiguration.get().messages.kick.flyingVehicle, PlayerKickEvent.Cause.FLYING_VEHICLE);
                    return;
                }
            } else {
                this.G = false;
                this.H = 0;
            }
        } else {
            this.u = null;
            this.G = false;
            this.H = 0;
        }
        this.f();
        while ((spam = this.chatSpamTickCount.get()) > 0 && !this.chatSpamTickCount.compareAndSet(spam, spam - 1)) {
        }
        if (this.tabSpamLimiter.get() > 0) {
            this.tabSpamLimiter.getAndDecrement();
        }
        if (this.recipeSpamPackets.get() > 0) {
            this.recipeSpamPackets.getAndDecrement();
        }
        if (this.n > 0) {
            --this.n;
        }
        if (this.e.K() > 0L && this.b.al() > 0 && SystemUtils.b() - this.e.K() > (long)this.b.al() * 1000L * 60L && !this.e.f) {
            this.e.E();
            this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.idling"), PlayerKickEvent.Cause.IDLING);
        }
        if (!this.hasLoggedExpiry && this.L != null && this.L.d().b().a()) {
            g.info("Player profile key for {} has expired!", (Object)this.e.ab().getString());
            this.hasLoggedExpiry = true;
        }
    }

    public void m() {
        this.o = this.e.dq();
        this.p = this.e.ds();
        this.q = this.e.dw();
        this.r = this.e.dq();
        this.s = this.e.ds();
        this.t = this.e.dw();
    }

    @Override
    public boolean c() {
        return this.c.k() && !this.Q;
    }

    @Override
    public boolean a(Packet<?> packet) {
        return super.a(packet) ? true : this.Q && this.c.k() && packet instanceof ServerboundConfigurationAcknowledgedPacket;
    }

    @Override
    protected GameProfile j() {
        return this.e.fQ();
    }

    private <T, R> CompletableFuture<R> a(T text, BiFunction<ITextFilter, T, CompletableFuture<R>> filterer) {
        return filterer.apply(this.e.V(), (ITextFilter)text).thenApply(object -> {
            if (!this.c()) {
                g.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return object;
        });
    }

    private CompletableFuture<FilteredText> a(String text) {
        return this.a(text, ITextFilter::a);
    }

    private CompletableFuture<List<FilteredText>> a(List<String> texts) {
        return this.a(texts, ITextFilter::a);
    }

    @Override
    public void a(PacketPlayInSteerVehicle packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        this.e.a(packet.a(), packet.d(), packet.e(), packet.f());
    }

    private static boolean b(double x2, double y2, double z2, float yaw, float pitch) {
        return Double.isNaN(x2) || Double.isNaN(y2) || Double.isNaN(z2) || !Floats.isFinite((float)pitch) || !Floats.isFinite((float)yaw);
    }

    private static double a(double d2) {
        return MathHelper.a(d2, -3.0E7, 3.0E7);
    }

    private static double b(double d2) {
        return MathHelper.a(d2, -2.0E7, 2.0E7);
    }

    @Override
    public void a(PacketPlayInVehicleMove packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (PlayerConnection.b(packet.a(), packet.d(), packet.e(), packet.f(), packet.g())) {
            this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.invalid_vehicle_movement"), PlayerKickEvent.Cause.INVALID_VEHICLE_MOVEMENT);
        } else {
            net.minecraft.world.entity.Entity entity = this.e.cV();
            if (this.B != null || this.e.eX() || entity.dG()) {
                return;
            }
            if (entity != this.e && entity.cN() == this.e && entity == this.u) {
                EntityLiving entityliving;
                double d5;
                double d4;
                double d3;
                double d2;
                double d1;
                double d0;
                WorldServer worldserver = this.e.x();
                double fromX = d0 = entity.dq();
                double fromY = d1 = entity.ds();
                double fromZ = d2 = entity.dw();
                double toX = d3 = PlayerConnection.a(packet.a());
                double toY = d4 = PlayerConnection.b(packet.d());
                double toZ = d5 = PlayerConnection.a(packet.e());
                float f2 = MathHelper.g(packet.f());
                float f1 = MathHelper.g(packet.g());
                double d6 = d3 - this.v;
                double d7 = d4 - this.w;
                double d8 = d5 - this.x;
                double d9 = entity.do().g();
                double currDeltaX = toX - fromX;
                double currDeltaY = toY - fromY;
                double currDeltaZ = toZ - fromZ;
                double d10 = Math.max(d6 * d6 + d7 * d7 + d8 * d8, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                double otherFieldX = d3 - this.y;
                double otherFieldY = d4 - this.z - 1.0E-6;
                double otherFieldZ = d5 - this.A;
                d10 = Math.max(d10, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                this.lastTick = (int)(System.currentTimeMillis() / 50L);
                ++this.I;
                int i2 = this.I - this.J;
                if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                    g.debug(this.e.cx() + " is sending move packets too frequently (" + i2 + " packets since last tick)");
                    i2 = 1;
                }
                this.allowedPlayerTicks = d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                double speed = this.e.fS().b ? (double)(this.e.fS().f * 20.0f) : (double)(this.e.fS().g * 10.0f);
                speed *= 2.0;
                if (!(!this.e.dL().paperConfig().chunks.preventMovingIntoUnloadedChunks || this.e.elytraAeronauticsNoChunk || worldserver.areChunksLoadedForMove(this.e.cG().b(new Vec3D(toX, toY, toZ).d(this.e.dj()))) && worldserver.areChunksLoadedForMove(entity.cG().b(new Vec3D(toX, toY, toZ).d(entity.dj()))))) {
                    this.c.a(new PacketPlayOutVehicleMove(entity));
                    return;
                }
                if (d10 - d9 > Math.max(100.0, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.i()) {
                    g.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{entity.ab().getString(), this.e.ab().getString(), d6, d7, d8});
                    this.b(new PacketPlayOutVehicleMove(entity));
                    return;
                }
                AxisAlignedBB oldBox = entity.cG();
                d6 = d3 - this.y;
                d7 = d4 - this.z - 1.0E-6;
                d8 = d5 - this.A;
                boolean flag1 = entity.R;
                if (entity instanceof EntityLiving && (entityliving = (EntityLiving)entity).c_()) {
                    entityliving.n();
                }
                entity.a(EnumMoveType.b, new Vec3D(d6, d7, d8));
                boolean didCollide = toX != entity.dq() || toY != entity.ds() || toZ != entity.dw();
                double d11 = d7;
                d6 = d3 - entity.dq();
                d7 = d4 - entity.ds();
                if (d7 > -0.5 || d7 < 0.5) {
                    d7 = 0.0;
                }
                d8 = d5 - entity.dw();
                d10 = d6 * d6 + d7 * d7 + d8 * d8;
                boolean flag2 = false;
                if (!LeavesConfig.disableMovedWronglyThreshold && d10 > SpigotConfig.movedWronglyThreshold) {
                    flag2 = true;
                    g.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{entity.ab().getString(), this.e.ab().getString(), Math.sqrt(d10)});
                }
                Location curPos = this.getCraftPlayer().getLocation();
                entity.a(d3, d4, d5, f2, f1);
                this.e.a(d3, d4, d5, this.e.dB(), this.e.dD());
                boolean teleportBack = flag2;
                if (!teleportBack) {
                    AxisAlignedBB newBox = entity.cG();
                    if (didCollide || !oldBox.equals(newBox)) {
                        teleportBack = this.hasNewCollision(worldserver, entity, oldBox, newBox);
                    }
                }
                if (teleportBack) {
                    entity.a(d0, d1, d2, f2, f1);
                    this.e.a(d0, d1, d2, this.e.dB(), this.e.dD());
                    this.b(new PacketPlayOutVehicleMove(entity));
                    return;
                }
                CraftPlayer player = this.getCraftPlayer();
                if (!this.hasMoved) {
                    this.lastPosX = curPos.getX();
                    this.lastPosY = curPos.getY();
                    this.lastPosZ = curPos.getZ();
                    this.lastYaw = curPos.getYaw();
                    this.lastPitch = curPos.getPitch();
                    this.hasMoved = true;
                }
                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                Location to = player.getLocation().clone();
                to.setX(packet.a());
                to.setY(packet.d());
                to.setZ(packet.e());
                to.setYaw(packet.f());
                to.setPitch(packet.g());
                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.e.eX()) {
                    this.lastPosX = to.getX();
                    this.lastPosY = to.getY();
                    this.lastPosZ = to.getZ();
                    this.lastYaw = to.getYaw();
                    this.lastPitch = to.getPitch();
                    Location oldTo = to.clone();
                    PlayerMoveEvent event = new PlayerMoveEvent((Player)player, from, to);
                    this.cserver.getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        this.teleport(from);
                        return;
                    }
                    if (!oldTo.equals((Object)event.getTo()) && !event.isCancelled()) {
                        this.e.getBukkitEntity().teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                        return;
                    }
                    if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                        this.justTeleported = false;
                        return;
                    }
                }
                this.e.x().k().a(this.e);
                this.e.r(this.e.dq() - d0, this.e.ds() - d1, this.e.dw() - d2);
                this.G = d11 >= -0.03125 && !flag1 && !this.b.Z() && !entity.aT() && this.a(entity);
                this.y = entity.dq();
                this.z = entity.ds();
                this.A = entity.dw();
            }
        }
    }

    private boolean a(net.minecraft.world.entity.Entity entity) {
        AxisAlignedBB box = entity.cG().g(0.0625).b(0.0, -0.55, 0.0);
        int minX = MathHelper.a(box.a);
        int minY = MathHelper.a(box.b);
        int minZ = MathHelper.a(box.c);
        int maxX = MathHelper.a(box.d);
        int maxY = MathHelper.a(box.e);
        int maxZ = MathHelper.a(box.f);
        net.minecraft.world.level.World world = entity.dL();
        BlockPosition.MutableBlockPosition pos = new BlockPosition.MutableBlockPosition();
        for (int y2 = minY; y2 <= maxY; ++y2) {
            for (int z2 = minZ; z2 <= maxZ; ++z2) {
                for (int x2 = minX; x2 <= maxX; ++x2) {
                    pos.d(x2, y2, z2);
                    IBlockData type = world.getBlockStateIfLoaded(pos);
                    if (type == null || type.i()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void a(PacketPlayInTeleportAccept packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (packet.a() == this.C) {
            if (this.B == null) {
                this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
                return;
            }
            this.e.b(this.B.c, this.B.d, this.B.e, this.e.dB(), this.e.dD());
            this.r = this.B.c;
            this.s = this.B.d;
            this.t = this.B.e;
            if (this.e.M()) {
                this.e.N();
            }
            this.B = null;
            this.e.x().k().a(this.e);
        }
    }

    @Override
    public void a(PacketPlayInRecipeDisplayed packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        Optional<RecipeHolder<?>> optional = this.b.aE().a(packet.a());
        RecipeBookServer recipebookserver = this.e.G();
        Objects.requireNonNull(recipebookserver);
        optional.ifPresent(recipebookserver::e);
    }

    @Override
    public void a(PacketPlayInRecipeSettings packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        CraftEventFactory.callRecipeBookSettingsEvent(this.e, packet.a(), packet.d(), packet.e());
        this.e.G().a(packet.a(), packet.d(), packet.e());
    }

    @Override
    public void a(PacketPlayInAdvancements packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (packet.d() == PacketPlayInAdvancements.Status.a) {
            MinecraftKey minecraftkey = Objects.requireNonNull(packet.e());
            AdvancementHolder advancementholder = this.b.az().a(minecraftkey);
            if (advancementholder != null) {
                this.e.O().a(advancementholder);
            }
        }
    }

    @Override
    public void a(PacketPlayInTabComplete packet) {
        if (this.chatSpamTickCount.addAndGet(GlobalConfiguration.get().spamLimiter.tabSpamIncrement) > GlobalConfiguration.get().spamLimiter.tabSpamLimit && !this.b.ac().f(this.e.fQ())) {
            this.b.scheduleOnMain(() -> this.disconnect(IChatBaseComponent.a("disconnect.spam", ArrayConstants.emptyObjectArray), PlayerKickEvent.Cause.SPAM));
            return;
        }
        String str = packet.d();
        int index = -1;
        if (str.length() > 64 && ((index = str.indexOf(32)) == -1 || index >= 64)) {
            this.b.scheduleOnMain(() -> this.b(IChatBaseComponent.a("disconnect.spam", ArrayConstants.emptyObjectArray)));
            return;
        }
        if (SpigotConfig.tabComplete < 0) {
            return;
        }
        TAB_COMPLETE_EXECUTOR.execute(() -> {
            Object completions;
            StringReader stringreader = new StringReader(packet.d());
            if (stringreader.canRead() && stringreader.peek() == '/') {
                stringreader.skip();
            }
            String command = packet.d();
            AsyncTabCompleteEvent event = new AsyncTabCompleteEvent((CommandSender)this.getCraftPlayer(), command, true, null);
            event.callEvent();
            Object object = completions = event.isCancelled() ? ImmutableList.of() : event.completions();
            if (!event.isHandled()) {
                if (!event.isCancelled()) {
                    this.b.scheduleOnMain(() -> {
                        ParseResults<CommandListenerWrapper> parseresults = this.b.aC().a().parse(stringreader, this.e.dc());
                        this.b.aC().a().getCompletionSuggestions(parseresults).thenAccept(suggestions -> {
                            if (!SpigotConfig.sendNamespaced && suggestions.getRange().getStart() <= 1) {
                                suggestions.getList().removeIf(suggestion -> suggestion.getText().contains(":"));
                            }
                            AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((Player)this.getCraftPlayer(), suggestions, command);
                            suggestEvent.setCancelled(suggestions.isEmpty());
                            if (!suggestEvent.callEvent()) {
                                return;
                            }
                            this.c.a(new PacketPlayOutTabComplete(packet.a(), suggestEvent.getSuggestions()));
                        });
                    });
                }
            } else if (!completions.isEmpty()) {
                SuggestionsBuilder builder0 = new SuggestionsBuilder(command, stringreader.getTotalLength());
                SuggestionsBuilder builder = builder0.createOffset(builder0.getInput().lastIndexOf(32) + 1);
                completions.forEach(completion -> {
                    Integer intSuggestion = Ints.tryParse((String)completion.suggestion());
                    if (intSuggestion != null) {
                        builder.suggest(intSuggestion.intValue(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
                    } else {
                        builder.suggest(completion.suggestion(), (Message)PaperAdventure.asVanilla(completion.tooltip()));
                    }
                });
                Suggestions suggestions = (Suggestions)builder.buildFuture().join();
                AsyncPlayerSendSuggestionsEvent suggestEvent = new AsyncPlayerSendSuggestionsEvent((Player)this.getCraftPlayer(), suggestions, command);
                suggestEvent.setCancelled(suggestions.isEmpty());
                if (!suggestEvent.callEvent()) {
                    return;
                }
                this.c.a(new PacketPlayOutTabComplete(packet.a(), suggestEvent.getSuggestions()));
            }
        });
    }

    @Override
    public void a(PacketPlayInSetCommandBlock packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (!this.b.o()) {
            this.e.a(IChatBaseComponent.c("advMode.notEnabled"));
        } else if (!(this.e.go() || this.e.f() && this.e.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.e.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = null;
            TileEntityCommand tileentitycommand = null;
            BlockPosition blockposition = packet.a();
            TileEntity tileentity = this.e.dL().c_(blockposition);
            if (tileentity instanceof TileEntityCommand) {
                tileentitycommand = (TileEntityCommand)tileentity;
                commandblocklistenerabstract = tileentitycommand.c();
            }
            String s2 = packet.d();
            boolean flag = packet.e();
            if (commandblocklistenerabstract != null) {
                TileEntityCommand.Type tileentitycommand_type = tileentitycommand.v();
                IBlockData iblockdata = this.e.dL().a_(blockposition);
                EnumDirection enumdirection = iblockdata.c(BlockCommand.a);
                IBlockData iblockdata2 = (IBlockData)((IBlockData)(switch (packet.h()) {
                    case TileEntityCommand.Type.a -> Blocks.kH.n();
                    case TileEntityCommand.Type.b -> Blocks.kG.n();
                    default -> Blocks.fN.n();
                }).a(BlockCommand.a, enumdirection)).a(BlockCommand.b, packet.f());
                if (iblockdata2 != iblockdata) {
                    this.e.dL().a(blockposition, iblockdata2, 2);
                    tileentity.b(iblockdata2);
                    this.e.dL().l(blockposition).a(tileentity);
                }
                commandblocklistenerabstract.a(s2);
                commandblocklistenerabstract.a(flag);
                if (!flag) {
                    commandblocklistenerabstract.c(null);
                }
                tileentitycommand.b(packet.g());
                if (tileentitycommand_type != packet.h()) {
                    tileentitycommand.g();
                }
                commandblocklistenerabstract.f();
                if (!UtilColor.b(s2)) {
                    this.e.a(IChatBaseComponent.a("advMode.setCommand.success", new Object[]{s2}));
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCommandMinecart packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (!this.b.o()) {
            this.e.a(IChatBaseComponent.c("advMode.notEnabled"));
        } else if (!(this.e.go() || this.e.f() && this.e.getBukkitEntity().hasPermission("minecraft.commandblock"))) {
            this.e.a(IChatBaseComponent.c("advMode.notAllowed"));
        } else {
            CommandBlockListenerAbstract commandblocklistenerabstract = packet.a(this.e.dL());
            if (commandblocklistenerabstract != null) {
                commandblocklistenerabstract.a(packet.a());
                commandblocklistenerabstract.a(packet.d());
                if (!packet.d()) {
                    commandblocklistenerabstract.c(null);
                }
                commandblocklistenerabstract.f();
                this.e.a(IChatBaseComponent.a("advMode.setCommand.success", new Object[]{packet.a()}));
            }
        }
    }

    @Override
    public void a(PacketPlayInPickItem packet) {
        int sourceSlot;
        int targetSlot;
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (packet.a() < 0 || packet.a() >= this.e.fR().i.size()) {
            g.warn("{} tried to set an invalid carried item", (Object)this.e.ab().getString());
            this.disconnect("Invalid hotbar selection (Hacking?)", PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        CraftPlayer bukkitPlayer = this.e.getBukkitEntity();
        PlayerPickItemEvent event = new PlayerPickItemEvent((Player)bukkitPlayer, targetSlot = this.e.fR().i(), sourceSlot = packet.a());
        if (!event.callEvent()) {
            return;
        }
        this.e.fR().pickSlot(event.getSourceSlot(), event.getTargetSlot());
        this.e.c.b(new PacketPlayOutSetSlot(-2, 0, this.e.fR().l, this.e.fR().a(this.e.fR().l)));
        this.e.c.b(new PacketPlayOutSetSlot(-2, 0, packet.a(), this.e.fR().a(packet.a())));
        this.e.c.b(new PacketPlayOutHeldItemSlot(this.e.fR().l));
    }

    @Override
    public void a(PacketPlayInItemName packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        Container container = this.e.bS;
        if (container instanceof ContainerAnvil) {
            ContainerAnvil containeranvil = (ContainerAnvil)container;
            if (!containeranvil.a(this.e)) {
                g.debug("Player {} interacted with invalid menu {}", (Object)this.e, (Object)containeranvil);
                return;
            }
            containeranvil.a(packet.a());
        }
    }

    @Override
    public void a(PacketPlayInBeacon packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        Container container = this.e.bS;
        if (container instanceof ContainerBeacon) {
            ContainerBeacon containerbeacon = (ContainerBeacon)container;
            if (!this.e.bS.a(this.e)) {
                g.debug("Player {} interacted with invalid menu {}", (Object)this.e, (Object)this.e.bS);
                return;
            }
            containerbeacon.a(packet.a(), packet.d());
        }
    }

    @Override
    public void a(PacketPlayInStruct packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.go()) {
            BlockPosition blockposition = packet.a();
            IBlockData iblockdata = this.e.dL().a_(blockposition);
            TileEntity tileentity = this.e.dL().c_(blockposition);
            if (tileentity instanceof TileEntityStructure) {
                TileEntityStructure tileentitystructure = (TileEntityStructure)tileentity;
                tileentitystructure.a(packet.e());
                tileentitystructure.a(packet.f());
                tileentitystructure.a(packet.g());
                tileentitystructure.a(packet.h());
                tileentitystructure.a(packet.i());
                tileentitystructure.a(packet.j());
                tileentitystructure.b(packet.k());
                tileentitystructure.a(packet.l());
                tileentitystructure.d(packet.m());
                tileentitystructure.e(packet.n());
                tileentitystructure.a(packet.o());
                tileentitystructure.a(packet.p());
                if (tileentitystructure.g()) {
                    String s2 = tileentitystructure.d();
                    if (packet.d() == TileEntityStructure.UpdateType.b) {
                        if (tileentitystructure.D()) {
                            this.e.a(IChatBaseComponent.a("structure_block.save_success", new Object[]{s2}), false);
                        } else {
                            this.e.a(IChatBaseComponent.a("structure_block.save_failure", new Object[]{s2}), false);
                        }
                    } else if (packet.d() == TileEntityStructure.UpdateType.c) {
                        if (!tileentitystructure.F()) {
                            this.e.a(IChatBaseComponent.a("structure_block.load_not_found", new Object[]{s2}), false);
                        } else if (tileentitystructure.a(this.e.x())) {
                            this.e.a(IChatBaseComponent.a("structure_block.load_success", new Object[]{s2}), false);
                        } else {
                            this.e.a(IChatBaseComponent.a("structure_block.load_prepare", new Object[]{s2}), false);
                        }
                    } else if (packet.d() == TileEntityStructure.UpdateType.d) {
                        if (tileentitystructure.C()) {
                            this.e.a(IChatBaseComponent.a("structure_block.size_success", new Object[]{s2}), false);
                        } else {
                            this.e.a(IChatBaseComponent.c("structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.e.a(IChatBaseComponent.a("structure_block.invalid_structure_name", new Object[]{packet.f()}), false);
                }
                tileentitystructure.e();
                this.e.dL().a(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInSetJigsaw packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.go()) {
            BlockPosition blockposition = packet.a();
            IBlockData iblockdata = this.e.dL().a_(blockposition);
            TileEntity tileentity = this.e.dL().c_(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.a(packet.d());
                tileentityjigsaw.b(packet.e());
                tileentityjigsaw.a(ResourceKey.a(Registries.aC, packet.f()));
                tileentityjigsaw.a(packet.g());
                tileentityjigsaw.a(packet.h());
                tileentityjigsaw.e();
                this.e.dL().a(blockposition, iblockdata, iblockdata, 3);
            }
        }
    }

    @Override
    public void a(PacketPlayInJigsawGenerate packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.go()) {
            BlockPosition blockposition = packet.a();
            TileEntity tileentity = this.e.dL().c_(blockposition);
            if (tileentity instanceof TileEntityJigsaw) {
                TileEntityJigsaw tileentityjigsaw = (TileEntityJigsaw)tileentity;
                tileentityjigsaw.a(this.e.x(), packet.d(), packet.e());
            }
        }
    }

    @Override
    public void a(PacketPlayInTrSel packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        int i2 = packet.a();
        Container container = this.e.bS;
        if (container instanceof ContainerMerchant) {
            ContainerMerchant containermerchant = (ContainerMerchant)container;
            TradeSelectEvent tradeSelectEvent = CraftEventFactory.callTradeSelectEvent(this.e, i2, containermerchant);
            if (tradeSelectEvent.isCancelled()) {
                this.e.getBukkitEntity().updateInventory();
                return;
            }
            if (!containermerchant.a(this.e)) {
                g.debug("Player {} interacted with invalid menu {}", (Object)this.e, (Object)containermerchant);
                return;
            }
            containermerchant.e(i2);
            containermerchant.h(i2);
        }
    }

    @Override
    public void a(PacketPlayInBEdit packet) {
        if (!this.cserver.isPrimaryThread()) {
            List<String> pageList = packet.a();
            long byteTotal = 0L;
            int maxBookPageSize = GlobalConfiguration.get().itemValidation.bookSize.pageMax;
            double multiplier = Math.max(0.3, Math.min(1.0, GlobalConfiguration.get().itemValidation.bookSize.totalMultiplier));
            long byteAllowed = maxBookPageSize;
            for (String testString : pageList) {
                int byteLength = testString.getBytes(StandardCharsets.UTF_8).length;
                if (byteLength > 1024) {
                    g.warn(this.e.cx() + " tried to send a book with with a page too large!");
                    this.b.scheduleOnMain(() -> this.disconnect("Book too large!", PlayerKickEvent.Cause.ILLEGAL_ACTION));
                    return;
                }
                byteTotal += (long)byteLength;
                int length = testString.length();
                int multibytes = 0;
                if (byteLength != length) {
                    for (char c2 : testString.toCharArray()) {
                        if (c2 <= '\u007f') continue;
                        ++multibytes;
                    }
                }
                byteAllowed = (long)((double)byteAllowed + (double)maxBookPageSize * Math.min(1.0, Math.max(0.1, (double)length / 255.0)) * multiplier);
                if (multibytes <= 1) continue;
                byteAllowed -= (long)multibytes;
            }
            if (byteTotal > byteAllowed) {
                g.warn(this.e.cx() + " tried to send too large of a book. Book Size: " + byteTotal + " - Allowed:  " + byteAllowed + " - Pages: " + pageList.size());
                this.b.scheduleOnMain(() -> this.disconnect("Book too large!", PlayerKickEvent.Cause.ILLEGAL_ACTION));
                return;
            }
        }
        if (this.lastBookTick + 20 > MinecraftServer.currentTick) {
            this.b.scheduleOnMain(() -> this.disconnect("Book edited too quickly!", PlayerKickEvent.Cause.ILLEGAL_ACTION));
            return;
        }
        this.lastBookTick = MinecraftServer.currentTick;
        int i2 = packet.e();
        if (PlayerInventory.d(i2) || i2 == 40) {
            ArrayList list = Lists.newArrayList();
            Optional<String> optional = packet.d();
            Objects.requireNonNull(list);
            optional.ifPresent(list::add);
            Stream stream = packet.a().stream().limit(100L);
            Objects.requireNonNull(list);
            stream.forEach(list::add);
            Consumer<List> consumer = optional.isPresent() ? list1 -> this.a((FilteredText)list1.get(0), list1.subList(1, list1.size()), i2) : list1 -> this.a((List<FilteredText>)list1, i2);
            this.a(list).thenAcceptAsync(consumer, (Executor)this.b);
        }
    }

    private void a(List<FilteredText> pages, int slotId) {
        ItemStack itemstack = this.e.fR().a(slotId);
        if (itemstack.a(Items.tg)) {
            this.updateBookPages(pages, UnaryOperator.identity(), itemstack.p(), slotId, itemstack);
        }
    }

    private void a(FilteredText title, List<FilteredText> pages, int slotId) {
        ItemStack itemstack = this.e.fR().a(slotId);
        if (itemstack.a(Items.tg)) {
            ItemStack itemstack1 = new ItemStack(Items.th);
            NBTTagCompound nbttagcompound = itemstack.v();
            if (nbttagcompound != null) {
                itemstack1.c(nbttagcompound.h());
            }
            itemstack1.a("author", NBTTagString.a(this.e.ab().getString()));
            if (this.e.W()) {
                itemstack1.a("title", NBTTagString.a(title.b()));
            } else {
                itemstack1.a("filtered_title", NBTTagString.a(title.b()));
                itemstack1.a("title", NBTTagString.a(title.d()));
            }
            this.updateBookPages(pages, s2 -> IChatBaseComponent.ChatSerializer.a(IChatBaseComponent.b(s2)), itemstack1, slotId, itemstack);
            this.e.fR().a(slotId, itemstack);
        }
    }

    private void updateBookPages(List<FilteredText> list, UnaryOperator<String> unaryoperator, ItemStack itemstack, int slot, ItemStack handItem) {
        NBTTagList nbttaglist = new NBTTagList();
        if (this.e.W()) {
            Stream<NBTTagString> stream = list.stream().map(filteredtext -> NBTTagString.a((String)unaryoperator.apply(filteredtext.b())));
            Objects.requireNonNull(nbttaglist);
            stream.forEach(nbttaglist::add);
        } else {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            int j2 = list.size();
            for (int i2 = 0; i2 < j2; ++i2) {
                FilteredText filteredtext2 = list.get(i2);
                String s2 = filteredtext2.d();
                nbttaglist.add(NBTTagString.a((String)unaryoperator.apply(s2)));
                if (!filteredtext2.c()) continue;
                nbttagcompound.a(String.valueOf(i2), (String)unaryoperator.apply(filteredtext2.b()));
            }
            if (!nbttagcompound.g()) {
                itemstack.a("filtered_pages", nbttagcompound);
            }
        }
        itemstack.a("pages", nbttaglist);
        this.e.fR().a(slot, CraftEventFactory.handleEditBookEvent(this.e, slot, handItem, itemstack));
    }

    @Override
    public void a(PacketPlayInEntityNBTQuery packet) {
        net.minecraft.world.entity.Entity entity;
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.l(2) && (entity = this.e.dL().a(packet.d())) != null) {
            NBTTagCompound nbttagcompound = entity.f(new NBTTagCompound());
            this.e.c.b(new PacketPlayOutNBTQuery(packet.a(), nbttagcompound));
        }
    }

    @Override
    public void a(PacketPlayInTileNBTQuery packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.l(2)) {
            TileEntity tileentity = this.e.dL().c_(packet.d());
            NBTTagCompound nbttagcompound = tileentity != null ? tileentity.o() : null;
            this.e.c.b(new PacketPlayOutNBTQuery(packet.a(), nbttagcompound));
        }
    }

    @Override
    public void a(PacketPlayInFlying packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (PlayerConnection.b(packet.a(0.0), packet.b(0.0), packet.c(0.0), packet.a(0.0f), packet.b(0.0f))) {
            this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.invalid_player_movement"), PlayerKickEvent.Cause.INVALID_PLAYER_MOVEMENT);
        } else {
            WorldServer worldserver = this.e.x();
            if (!this.e.f && !this.e.eX()) {
                if (this.k == 0) {
                    this.m();
                }
                if (this.B != null) {
                    this.allowedPlayerTicks = 20;
                } else {
                    float f1;
                    float f2;
                    double d2;
                    double d1;
                    double d0;
                    this.D = this.k;
                    double toX = d0 = PlayerConnection.a(packet.a(this.e.dq()));
                    double toY = d1 = PlayerConnection.b(packet.b(this.e.ds()));
                    double toZ = d2 = PlayerConnection.a(packet.c(this.e.dw()));
                    float toYaw = f2 = MathHelper.g(packet.a(this.e.dB()));
                    float toPitch = f1 = MathHelper.g(packet.b(this.e.dD()));
                    if (this.e.bN()) {
                        this.e.a(this.e.dq(), this.e.ds(), this.e.dw(), f2, f1);
                        this.e.x().k().a(this.e);
                        this.allowedPlayerTicks = 20;
                    } else {
                        double prevX = this.e.dq();
                        double prevY = this.e.ds();
                        double prevZ = this.e.dw();
                        float prevYaw = this.e.dB();
                        float prevPitch = this.e.dD();
                        double d3 = this.e.dq();
                        double d4 = this.e.ds();
                        double d5 = this.e.dw();
                        double d6 = d0 - this.o;
                        double d7 = d1 - this.p;
                        double d8 = d2 - this.q;
                        double d9 = this.e.do().g();
                        double currDeltaX = toX - prevX;
                        double currDeltaY = toY - prevY;
                        double currDeltaZ = toZ - prevZ;
                        double d10 = Math.max(d6 * d6 + d7 * d7 + d8 * d8, currDeltaX * currDeltaX + currDeltaY * currDeltaY + currDeltaZ * currDeltaZ - 1.0);
                        double otherFieldX = d0 - this.r;
                        double otherFieldY = d1 - this.s;
                        double otherFieldZ = d2 - this.t;
                        d10 = Math.max(d10, otherFieldX * otherFieldX + otherFieldY * otherFieldY + otherFieldZ * otherFieldZ - 1.0);
                        if (this.e.fC()) {
                            if (d10 > 1.0) {
                                this.a(this.e.dq(), this.e.ds(), this.e.dw(), f2, f1);
                            }
                        } else {
                            PlayerFailMoveEvent event;
                            boolean didCollide;
                            boolean flag;
                            PlayerFailMoveEvent event2;
                            ++this.I;
                            int i2 = this.I - this.J;
                            this.allowedPlayerTicks = (int)((long)this.allowedPlayerTicks + (System.currentTimeMillis() / 50L - (long)this.lastTick));
                            this.allowedPlayerTicks = Math.max(this.allowedPlayerTicks, 1);
                            this.lastTick = (int)(System.currentTimeMillis() / 50L);
                            if (i2 > Math.max(this.allowedPlayerTicks, 5)) {
                                g.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.e.ab().getString(), (Object)i2);
                                i2 = 1;
                            }
                            this.allowedPlayerTicks = packet.h || d10 > 0.0 ? --this.allowedPlayerTicks : 20;
                            double speed = this.e.fS().b ? (double)(this.e.fS().f * 20.0f) : (double)(this.e.fS().g * 10.0f);
                            if (!(!this.e.dL().paperConfig().chunks.preventMovingIntoUnloadedChunks || this.e.dq() == toX && this.e.dw() == toZ || worldserver.areChunksLoadedForMove(this.e.cG().b(new Vec3D(toX, toY, toZ).d(this.e.dj()))) || (event2 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_INTO_UNLOADED_CHUNK, toX, toY, toZ, toYaw, toPitch, false)).isAllowed())) {
                                this.internalTeleport(this.e.dq(), this.e.ds(), this.e.dw(), this.e.dB(), this.e.dD(), Collections.emptySet());
                                return;
                            }
                            if (!(this.e.M() || this.e.dL().X().b(GameRules.s) && this.e.fv())) {
                                PlayerFailMoveEvent event3;
                                float f22;
                                float f3 = f22 = this.e.fv() ? 300.0f : 100.0f;
                                if (d10 - d9 > Math.max((double)f22, Math.pow(SpigotConfig.movedTooQuicklyMultiplier * (double)i2 * speed, 2.0)) && !this.i() && !(event3 = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_TOO_QUICKLY, toX, toY, toZ, toYaw, toPitch, true)).isAllowed()) {
                                    if (event3.getLogWarning()) {
                                        g.warn("{} moved too quickly! {},{},{}", new Object[]{this.e.ab().getString(), d6, d7, d8});
                                    }
                                    this.a(this.e.dq(), this.e.ds(), this.e.dw(), this.e.dB(), this.e.dD());
                                    return;
                                }
                            }
                            AxisAlignedBB axisalignedbb = this.e.cG();
                            d6 = d0 - this.r;
                            d7 = d1 - this.s;
                            d8 = d2 - this.t;
                            boolean bl = flag = d7 > 0.0;
                            if (this.e.aA() && !packet.a() && flag) {
                                PlayerJumpEvent event4;
                                CraftPlayer player = this.getCraftPlayer();
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (packet.g) {
                                    to.setX(packet.a);
                                    to.setY(packet.b);
                                    to.setZ(packet.c);
                                }
                                if (packet.h) {
                                    to.setYaw(packet.d);
                                    to.setPitch(packet.e);
                                }
                                if ((event4 = new PlayerJumpEvent((Player)player, from, to)).callEvent()) {
                                    this.e.fa();
                                } else {
                                    from = event4.getFrom();
                                    this.internalTeleport(from.getX(), from.getY(), from.getZ(), from.getYaw(), from.getPitch(), Collections.emptySet());
                                    return;
                                }
                            }
                            boolean flag1 = this.e.R;
                            this.e.a(EnumMoveType.b, new Vec3D(d6, d7, d8));
                            ((net.minecraft.world.entity.Entity)this.e).aJ = packet.a();
                            boolean bl2 = didCollide = toX != this.e.dq() || toY != this.e.ds() || toZ != this.e.dw();
                            if (this.B != null) {
                                return;
                            }
                            double d11 = d7;
                            d6 = d0 - this.e.dq();
                            d7 = d1 - this.e.ds();
                            if (d7 > -0.5 || d7 < 0.5) {
                                d7 = 0.0;
                            }
                            d8 = d2 - this.e.dw();
                            d10 = d6 * d6 + d7 * d7 + d8 * d8;
                            boolean flag2 = false;
                            if (!(LeavesConfig.disableMovedWronglyThreshold || this.e.M() || !(d10 > SpigotConfig.movedWronglyThreshold) || this.e.fC() || this.e.e.e() || this.e.e.b() == EnumGamemode.d || (event = this.fireFailMove(PlayerFailMoveEvent.FailReason.MOVED_WRONGLY, toX, toY, toZ, toYaw, toPitch, true)).isAllowed())) {
                                flag2 = true;
                                if (event.getLogWarning()) {
                                    g.warn("{} moved wrongly!", (Object)this.e.ab().getString());
                                }
                            }
                            this.e.a(d0, d1, d2, f2, f1);
                            boolean teleportBack = flag2;
                            if (!(this.e.af || this.e.fC() || teleportBack)) {
                                PlayerFailMoveEvent event5;
                                AxisAlignedBB newBox = this.e.cG();
                                if ((didCollide || !axisalignedbb.equals(newBox)) && (teleportBack = this.hasNewCollision(worldserver, this.e, axisalignedbb, newBox)) && (event5 = this.fireFailMove(PlayerFailMoveEvent.FailReason.CLIPPED_INTO_BLOCK, toX, toY, toZ, toYaw, toPitch, false)).isAllowed()) {
                                    teleportBack = false;
                                }
                            }
                            if (!this.e.af && !this.e.fC() && teleportBack) {
                                this.internalTeleport(d3, d4, d5, f2, f1, Collections.emptySet());
                                this.e.a(this.e.dq() - d3, this.e.ds() - d4, this.e.dw() - d5, packet.a());
                            } else {
                                this.e.a(prevX, prevY, prevZ, prevYaw, prevPitch);
                                CraftPlayer player = this.getCraftPlayer();
                                Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
                                Location to = player.getLocation().clone();
                                if (packet.g) {
                                    to.setX(packet.a);
                                    to.setY(packet.b);
                                    to.setZ(packet.c);
                                }
                                if (packet.h) {
                                    to.setYaw(packet.d);
                                    to.setPitch(packet.e);
                                }
                                double delta = Math.pow(this.lastPosX - to.getX(), 2.0) + Math.pow(this.lastPosY - to.getY(), 2.0) + Math.pow(this.lastPosZ - to.getZ(), 2.0);
                                float deltaAngle = Math.abs(this.lastYaw - to.getYaw()) + Math.abs(this.lastPitch - to.getPitch());
                                if ((delta > 0.00390625 || deltaAngle > 10.0f) && !this.e.eX()) {
                                    this.lastPosX = to.getX();
                                    this.lastPosY = to.getY();
                                    this.lastPosZ = to.getZ();
                                    this.lastYaw = to.getYaw();
                                    this.lastPitch = to.getPitch();
                                    if (from.getX() != Double.MAX_VALUE) {
                                        Location oldTo = to.clone();
                                        PlayerMoveEvent event6 = new PlayerMoveEvent((Player)player, from, to);
                                        this.cserver.getPluginManager().callEvent((Event)event6);
                                        if (event6.isCancelled()) {
                                            this.teleport(from);
                                            return;
                                        }
                                        if (!oldTo.equals((Object)event6.getTo()) && !event6.isCancelled()) {
                                            this.e.getBukkitEntity().teleport(event6.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
                                            return;
                                        }
                                        if (!from.equals((Object)this.getCraftPlayer().getLocation()) && this.justTeleported) {
                                            this.justTeleported = false;
                                            return;
                                        }
                                    }
                                }
                                this.e.a(d0, d1, d2, f2, f1);
                                this.E = d11 >= -0.03125 && !flag1 && this.e.e.b() != EnumGamemode.d && !this.b.Z() && !this.e.fS().c && !this.e.a(MobEffects.y) && !this.e.fv() && !this.e.fi() && this.a(this.e);
                                this.e.x().k().a(this.e);
                                this.e.a(this.e.dq() - d3, this.e.ds() - d4, this.e.dw() - d5, packet.a());
                                this.e.a(packet.a(), new Vec3D(this.e.dq() - d3, this.e.ds() - d4, this.e.dw() - d5));
                                if (flag) {
                                    this.e.n();
                                }
                                this.e.r(this.e.dq() - d3, this.e.ds() - d4, this.e.dw() - d5);
                                this.r = this.e.dq();
                                this.s = this.e.ds();
                                this.t = this.e.dw();
                            }
                        }
                    }
                }
            }
        }
    }

    private PlayerFailMoveEvent fireFailMove(PlayerFailMoveEvent.FailReason failReason, double toX, double toY, double toZ, float toYaw, float toPitch, boolean logWarning) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = new Location(player.getWorld(), this.lastPosX, this.lastPosY, this.lastPosZ, this.lastYaw, this.lastPitch);
        Location to = new Location(player.getWorld(), toX, toY, toZ, toYaw, toPitch);
        PlayerFailMoveEvent event = new PlayerFailMoveEvent((Player)player, failReason, false, logWarning, from, to);
        event.callEvent();
        return event;
    }

    private boolean hasNewCollision(WorldServer world, net.minecraft.world.entity.Entity entity, AxisAlignedBB oldBox, AxisAlignedBB newBox) {
        int i2;
        ArrayList<AxisAlignedBB> collisionsBB = new ArrayList<AxisAlignedBB>();
        ArrayList<VoxelShape> collisionsVoxel = new ArrayList<VoxelShape>();
        CollisionUtil.getCollisions(world, entity, newBox, collisionsVoxel, collisionsBB, 6, null, null);
        int len = collisionsBB.size();
        for (i2 = 0; i2 < len; ++i2) {
            AxisAlignedBB box = (AxisAlignedBB)collisionsBB.get(i2);
            if (CollisionUtil.voxelShapeIntersect(box, oldBox)) continue;
            return true;
        }
        len = collisionsVoxel.size();
        for (i2 = 0; i2 < len; ++i2) {
            VoxelShape voxel = (VoxelShape)collisionsVoxel.get(i2);
            if (CollisionUtil.voxelShapeIntersectNoEmpty(voxel, oldBox)) continue;
            return true;
        }
        return false;
    }

    private boolean a(IWorldReader world, AxisAlignedBB box, double newX, double newY, double newZ) {
        VoxelShape voxelshape1;
        AxisAlignedBB axisalignedbb1 = this.e.cG().d(newX - this.e.dq(), newY - this.e.ds(), newZ - this.e.dw());
        Iterable<VoxelShape> iterable = world.d(this.e, axisalignedbb1.h(1.0E-5f));
        VoxelShape voxelshape = VoxelShapes.a(box.h(1.0E-5f));
        Iterator<VoxelShape> iterator = iterable.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (VoxelShapes.c(voxelshape1 = iterator.next(), voxelshape, OperatorBoolean.i));
        return true;
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch) {
        this.teleport(x2, y2, z2, yaw, pitch, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public void teleport(double d0, double d1, double d2, float f2, float f1, PlayerTeleportEvent.TeleportCause cause) {
        this.teleport(d0, d1, d2, f2, f1, Collections.emptySet(), cause);
    }

    public void a(double x2, double y2, double z2, float yaw, float pitch, Set<RelativeMovement> flags) {
        this.teleport(x2, y2, z2, yaw, pitch, flags, PlayerTeleportEvent.TeleportCause.UNKNOWN);
    }

    public boolean teleport(double d0, double d1, double d2, float f2, float f1, Set<RelativeMovement> set, PlayerTeleportEvent.TeleportCause cause) {
        CraftPlayer player = this.getCraftPlayer();
        Location from = player.getLocation();
        double x2 = d0;
        double y2 = d1;
        double z2 = d2;
        float yaw = f2;
        float pitch = f1;
        Location to = new Location(this.getCraftPlayer().getWorld(), x2, y2, z2, yaw, pitch);
        if (from.equals((Object)to)) {
            this.internalTeleport(d0, d1, d2, f2, f1, set);
            return false;
        }
        EnumSet<TeleportFlag.Relative> relativeFlags = EnumSet.noneOf(TeleportFlag.Relative.class);
        for (RelativeMovement relativeArgument : set) {
            relativeFlags.add(CraftPlayer.toApiRelativeFlag(relativeArgument));
        }
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)player, from.clone(), to.clone(), cause, Set.copyOf(relativeFlags));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() || !to.equals((Object)event.getTo())) {
            to = event.isCancelled() ? event.getFrom() : event.getTo();
            d0 = to.getX();
            d1 = to.getY();
            d2 = to.getZ();
            f2 = to.getYaw();
            f1 = to.getPitch();
        }
        this.internalTeleport(d0, d1, d2, f2, f1, set);
        return event.isCancelled();
    }

    public void teleport(Location dest) {
        this.internalTeleport(dest.getX(), dest.getY(), dest.getZ(), dest.getYaw(), dest.getPitch(), Collections.emptySet());
    }

    public void internalTeleport(double d0, double d1, double d2, float f2, float f1, Set<RelativeMovement> set) {
        AsyncCatcher.catchOp("teleport");
        if (this.e.dG()) {
            g.info("Attempt to teleport removed player {} restricted", (Object)this.e.cx());
            if (this.b.isDebugging()) {
                TraceUtil.dumpTraceForThread("Attempt to teleport removed player");
            }
            return;
        }
        if (Float.isNaN(f2)) {
            f2 = 0.0f;
        }
        if (Float.isNaN(f1)) {
            f1 = 0.0f;
        }
        this.justTeleported = true;
        double d3 = set.contains((Object)RelativeMovement.a) ? this.e.dq() : 0.0;
        double d4 = set.contains((Object)RelativeMovement.b) ? this.e.ds() : 0.0;
        double d5 = set.contains((Object)RelativeMovement.c) ? this.e.dw() : 0.0;
        float f22 = set.contains((Object)RelativeMovement.d) ? this.e.dB() : 0.0f;
        float f3 = set.contains((Object)RelativeMovement.e) ? this.e.dD() : 0.0f;
        this.B = new Vec3D(d0, d1, d2);
        if (++this.C == Integer.MAX_VALUE) {
            this.C = 0;
        }
        this.lastPosX = this.B.c;
        this.lastPosY = this.B.d;
        this.lastPosZ = this.B.e;
        this.lastYaw = f2;
        this.lastPitch = f1;
        this.D = this.k;
        this.e.b(d0, d1, d2, f2, f1);
        this.e.c.b(new PacketPlayOutPosition(d0 - d3, d1 - d4, d2 - d5, f2 - f22, f1 - f3, set, this.C));
    }

    @Override
    public void a(PacketPlayInBlockDig packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.eX()) {
            return;
        }
        BlockPosition blockposition = packet.a();
        this.e.E();
        PacketPlayInBlockDig.EnumPlayerDigType packetplayinblockdig_enumplayerdigtype = packet.e();
        switch (packetplayinblockdig_enumplayerdigtype) {
            case g: {
                if (!this.e.M_()) {
                    ItemStack itemstack = this.e.b(EnumHand.b);
                    CraftItemStack mainHand = CraftItemStack.asCraftMirror(itemstack);
                    CraftItemStack offHand = CraftItemStack.asCraftMirror(this.e.b(EnumHand.a));
                    PlayerSwapHandItemsEvent swapItemsEvent = new PlayerSwapHandItemsEvent((Player)this.getCraftPlayer(), (org.bukkit.inventory.ItemStack)mainHand.clone(), (org.bukkit.inventory.ItemStack)offHand.clone());
                    this.cserver.getPluginManager().callEvent((Event)swapItemsEvent);
                    if (swapItemsEvent.isCancelled()) {
                        return;
                    }
                    if (swapItemsEvent.getOffHandItem().equals((Object)offHand)) {
                        this.e.a(EnumHand.b, this.e.b(EnumHand.a));
                    } else {
                        this.e.a(EnumHand.b, CraftItemStack.asNMSCopy(swapItemsEvent.getOffHandItem()));
                    }
                    if (swapItemsEvent.getMainHandItem().equals((Object)mainHand)) {
                        this.e.a(EnumHand.a, itemstack);
                    } else {
                        this.e.a(EnumHand.a, CraftItemStack.asNMSCopy(swapItemsEvent.getMainHandItem()));
                    }
                    this.e.fs();
                }
                return;
            }
            case e: {
                if (!this.e.M_()) {
                    if (this.lastDropTick != MinecraftServer.currentTick) {
                        this.dropCount = 0;
                        this.lastDropTick = MinecraftServer.currentTick;
                    } else {
                        ++this.dropCount;
                        if (this.dropCount >= 20) {
                            g.warn(this.e.cx() + " dropped their items too quickly!");
                            this.disconnect("You dropped your items too quickly (Hacking?)", PlayerKickEvent.Cause.ILLEGAL_ACTION);
                            return;
                        }
                    }
                    this.e.a(false);
                }
                return;
            }
            case d: {
                if (!this.e.M_()) {
                    this.e.a(true);
                }
                return;
            }
            case f: {
                this.e.fr();
                return;
            }
            case a: 
            case b: 
            case c: {
                if (this.e.dL().getChunkIfLoadedImmediately(blockposition.u() >> 4, blockposition.w() >> 4) == null) {
                    this.e.c.a(packet.f());
                    return;
                }
                this.e.e.capturedBlockEntity = false;
                this.e.e.captureSentBlockEntities = true;
                this.e.e.a(blockposition, packetplayinblockdig_enumplayerdigtype, packet.d(), this.e.dL().aj(), packet.f());
                this.e.c.a(packet.f());
                this.e.e.captureSentBlockEntities = false;
                if (this.e.e.capturedBlockEntity) {
                    this.b(new ClientboundBlockChangedAckPacket(this.l));
                    this.e.c.l = -1;
                    this.e.e.capturedBlockEntity = false;
                    TileEntity tileentity = this.e.dL().c_(blockposition);
                    if (tileentity != null) {
                        this.e.c.b(tileentity.h());
                    }
                }
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean a(EntityPlayer player, ItemStack stack) {
        if (stack.b()) {
            return false;
        }
        Item item = stack.d();
        return (item instanceof ItemBlock || item instanceof ItemBucket) && !player.gm().a(item);
    }

    private static int getSpamThreshold() {
        return GlobalConfiguration.get().spamLimiter.incomingPacketThreshold;
    }

    private boolean checkLimit(long timestamp) {
        if (this.lastLimitedPacket != -1L && timestamp - this.lastLimitedPacket < (long)PlayerConnection.getSpamThreshold() && this.limitedPackets++ >= 8) {
            return false;
        }
        if (this.lastLimitedPacket == -1L || timestamp - this.lastLimitedPacket >= (long)PlayerConnection.getSpamThreshold()) {
            this.lastLimitedPacket = timestamp;
            this.limitedPackets = 0;
            return true;
        }
        return true;
    }

    @Override
    public void a(PacketPlayInUseItem packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.eX()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        this.e.c.a(packet.e());
        WorldServer worldserver = this.e.x();
        EnumHand enumhand = packet.a();
        ItemStack itemstack = this.e.b(enumhand);
        if (itemstack.a(worldserver.G())) {
            MovingObjectPositionBlock movingobjectpositionblock = packet.d();
            Vec3D vec3d = movingobjectpositionblock.e();
            if (!(Double.isFinite(vec3d.c) && Double.isFinite(vec3d.d) && Double.isFinite(vec3d.e))) {
                return;
            }
            BlockPosition blockposition = movingobjectpositionblock.a();
            Vec3D vec3d1 = Vec3D.b(blockposition);
            if (this.e.bp().g(vec3d1) <= d) {
                Vec3D vec3d2 = vec3d.d(vec3d1);
                double d0 = 1.0000001;
                if (LeavesConfig.disableDistanceCheckForUseItem || Math.abs(vec3d2.a()) < 1.0000001 && Math.abs(vec3d2.b()) < 1.0000001 && Math.abs(vec3d2.c()) < 1.0000001) {
                    EnumDirection enumdirection = movingobjectpositionblock.b();
                    this.e.E();
                    int i2 = this.e.dL().aj();
                    if (blockposition.v() < i2) {
                        if (this.B == null && this.e.i((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5) < 64.0 && (worldserver.a((EntityHuman)this.e, blockposition) || worldserver.paperConfig().spawn.allowUsingSignsInsideSpawnProtection && worldserver.a_(blockposition).b() instanceof BlockSign)) {
                            this.e.fs();
                            EnumInteractionResult enuminteractionresult = this.e.e.a(this.e, worldserver, itemstack, enumhand, movingobjectpositionblock);
                            if (enumdirection == EnumDirection.b && !enuminteractionresult.a() && blockposition.v() >= i2 - 1 && PlayerConnection.a(this.e, itemstack)) {
                                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.a("build.tooHigh", i2 - 1).a(EnumChatFormat.m);
                                this.e.b(ichatmutablecomponent, true);
                            } else if (enuminteractionresult.b() && !this.e.e.interactResult) {
                                this.e.a(enumhand, true);
                            }
                        }
                    } else {
                        IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.a("build.tooHigh", i2 - 1).a(EnumChatFormat.m);
                        this.e.b(ichatmutablecomponent1, true);
                    }
                    this.e.c.b(new PacketPlayOutBlockChange(worldserver, blockposition));
                    this.e.c.b(new PacketPlayOutBlockChange(worldserver, blockposition.a(enumdirection)));
                } else {
                    g.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.e.fQ().getName(), vec3d, blockposition});
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInBlockPlace packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.eX()) {
            return;
        }
        if (!this.checkLimit(packet.timestamp)) {
            return;
        }
        this.a(packet.d());
        WorldServer worldserver = this.e.x();
        EnumHand enumhand = packet.a();
        ItemStack itemstack = this.e.b(enumhand);
        this.e.E();
        if (!itemstack.b() && itemstack.a(worldserver.G())) {
            boolean cancelled;
            float f1 = this.e.dD();
            float f2 = this.e.dB();
            double d0 = this.e.dq();
            double d1 = this.e.ds() + (double)this.e.cH();
            double d2 = this.e.dw();
            Vec3D vec3d = new Vec3D(d0, d1, d2);
            float f3 = MathHelper.b(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
            float f4 = MathHelper.a(-f2 * ((float)Math.PI / 180) - (float)Math.PI);
            float f5 = -MathHelper.b(-f1 * ((float)Math.PI / 180));
            float f6 = MathHelper.a(-f1 * ((float)Math.PI / 180));
            float f7 = f4 * f5;
            float f8 = f3 * f5;
            double d3 = this.e.e.b() == EnumGamemode.b ? 5.0 : 4.5;
            Vec3D vec3d1 = vec3d.b((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
            MovingObjectPositionBlock movingobjectposition = this.e.dL().a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.b, RayTrace.FluidCollisionOption.a, this.e));
            if (movingobjectposition == null || ((MovingObjectPosition)movingobjectposition).c() != MovingObjectPosition.EnumMovingObjectType.b) {
                PlayerInteractEvent event = CraftEventFactory.callPlayerInteractEvent(this.e, Action.RIGHT_CLICK_AIR, itemstack, enumhand);
                cancelled = event.useItemInHand() == Event.Result.DENY;
            } else {
                PlayerInteractEvent event;
                MovingObjectPositionBlock movingobjectpositionblock = movingobjectposition;
                cancelled = this.e.e.firedInteract && this.e.e.interactPosition.equals(movingobjectpositionblock.a()) && this.e.e.interactHand == enumhand && ItemStack.c(this.e.e.interactItemStack, itemstack) ? this.e.e.interactResult : (event = CraftEventFactory.callPlayerInteractEvent(this.e, Action.RIGHT_CLICK_BLOCK, movingobjectpositionblock.a(), movingobjectpositionblock.b(), itemstack, true, enumhand, movingobjectpositionblock.e())).useItemInHand() == Event.Result.DENY;
                this.e.e.firedInteract = false;
            }
            if (cancelled) {
                this.e.resyncUsingItem(this.e);
                this.e.getBukkitEntity().updateInventory();
                return;
            }
            itemstack = this.e.b(enumhand);
            if (itemstack.b()) {
                return;
            }
            EnumInteractionResult enuminteractionresult = this.e.e.a(this.e, worldserver, itemstack, enumhand);
            if (enuminteractionresult.b()) {
                this.e.a(enumhand, true);
            }
        }
    }

    @Override
    public void a(PacketPlayInSpectate packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.M_()) {
            for (WorldServer worldserver : this.b.F()) {
                net.minecraft.world.entity.Entity entity = packet.a(worldserver);
                if (entity == null) continue;
                this.e.teleportTo(worldserver, entity.dq(), entity.ds(), entity.dw(), entity.dB(), entity.dD(), PlayerTeleportEvent.TeleportCause.SPECTATE);
                return;
            }
        }
    }

    @Override
    public void a(PacketPlayInBoatMove packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        net.minecraft.world.entity.Entity entity = this.e.cZ();
        if (entity instanceof EntityBoat) {
            EntityBoat entityboat = (EntityBoat)entity;
            entityboat.a(packet.a(), packet.d());
        }
    }

    @Override
    public void a(IChatBaseComponent reason) {
        this.onDisconnect(reason, null);
    }

    @Override
    public void onDisconnect(IChatBaseComponent reason, @Nullable Component quitMessage) {
        if (this.processedDisconnect) {
            return;
        }
        this.processedDisconnect = true;
        g.info("{} lost connection: {}", (Object)this.e.ab().getString(), (Object)reason.getString());
        this.removePlayerFromWorld(quitMessage);
        super.onDisconnect(reason, quitMessage);
    }

    private void q() {
        this.removePlayerFromWorld(null);
    }

    private void removePlayerFromWorld(@Nullable Component quitMessage) {
        this.P.close();
        this.e.s();
        Component component = quitMessage = quitMessage == null ? this.b.ac().remove(this.e) : this.b.ac().remove(this.e, quitMessage);
        if (quitMessage != null && !quitMessage.equals(Component.empty())) {
            this.b.ac().a(PaperAdventure.asVanilla(quitMessage), false);
        }
        this.e.V().b();
    }

    public void a(int sequence) {
        if (sequence < 0) {
            this.disconnect("Expected packet sequence nr >= 0", PlayerKickEvent.Cause.ILLEGAL_ACTION);
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.l = Math.max(sequence, this.l);
    }

    @Override
    public void a(PacketPlayInHeldItemSlot packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.eX()) {
            return;
        }
        if (packet.a() >= 0 && packet.a() < PlayerInventory.g()) {
            if (packet.a() == this.e.fR().l) {
                return;
            }
            PlayerItemHeldEvent event = new PlayerItemHeldEvent((Player)this.getCraftPlayer(), this.e.fR().l, packet.a());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                this.b(new PacketPlayOutHeldItemSlot(this.e.fR().l));
                this.e.E();
                return;
            }
            if (this.e.fR().l != packet.a() && this.e.fn() == EnumHand.a) {
                this.e.fs();
            }
            this.e.fR().l = packet.a();
            this.e.E();
        } else {
            g.warn("{} tried to set an invalid carried item", (Object)this.e.ab().getString());
            this.disconnect("Invalid hotbar selection (Hacking?)", PlayerKickEvent.Cause.ILLEGAL_ACTION);
        }
    }

    @Override
    public void a(PacketPlayInChat packet) {
        if (this.b.ab()) {
            return;
        }
        if (PlayerConnection.c(packet.a())) {
            this.b.scheduleOnMain(() -> this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.illegal_characters"), PlayerKickEvent.Cause.ILLEGAL_CHARACTERS));
        } else {
            Optional<LastSeenMessages> optional = this.a(packet.a(), packet.d(), packet.g());
            if (optional.isPresent()) {
                PlayerChatMessage playerchatmessage;
                try {
                    playerchatmessage = this.a(packet, optional.get());
                }
                catch (SignedMessageChain.a signedmessagechain_a) {
                    this.a(signedmessagechain_a);
                    return;
                }
                CompletableFuture<FilteredText> completablefuture = this.a(playerchatmessage.b());
                CompletableFuture<ChatDecorator.Result> componentFuture = this.b.bd().decorate(this.e, null, playerchatmessage.c());
                this.P.append(executor -> CompletableFuture.allOf(completablefuture, componentFuture).thenAcceptAsync(filtered -> {
                    PlayerChatMessage playerchatmessage1 = playerchatmessage.a(((FilteredText)completablefuture.join()).e()).withResult((ChatDecorator.Result)componentFuture.join());
                    this.b(playerchatmessage1);
                }, (Executor)this.b.chatExecutor));
            }
        }
    }

    @Override
    public void a(ServerboundChatCommandPacket packet) {
        if (PlayerConnection.c(packet.a())) {
            this.b.scheduleOnMain(() -> this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.illegal_characters"), PlayerKickEvent.Cause.ILLEGAL_CHARACTERS));
        } else {
            Optional<LastSeenMessages> optional = this.a(packet.a(), packet.d(), packet.g());
            if (optional.isPresent()) {
                this.b.g(() -> {
                    if (this.e.t()) {
                        return;
                    }
                    this.a(packet, (LastSeenMessages)optional.get());
                    this.detectRateSpam("/" + packet.a());
                });
            }
        }
    }

    private void a(ServerboundChatCommandPacket packet, LastSeenMessages lastSeenMessages) {
        Map<String, PlayerChatMessage> map;
        Object command = "/" + packet.a();
        if (SpigotConfig.logCommands) {
            g.info(this.e.cx() + " issued server command: " + (String)command);
        }
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)this.getCraftPlayer(), (String)command, (Set)new LazyPlayerSet(this.b));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getMessage().substring(1);
        ParseResults<CommandListenerWrapper> parseresults = this.b((String)command);
        try {
            map = packet.a().equals(command) ? this.a(packet, SignableCommand.a(parseresults), lastSeenMessages) : Collections.emptyMap();
        }
        catch (SignedMessageChain.a signedmessagechain_a) {
            this.a(signedmessagechain_a);
            return;
        }
        CommandSigningContext.a commandsigningcontext_a = new CommandSigningContext.a(map);
        parseresults = net.minecraft.commands.CommandDispatcher.a(parseresults, commandlistenerwrapper -> commandlistenerwrapper.a(commandsigningcontext_a, this.P));
        this.b.aC().a(parseresults, (String)command);
    }

    private void a(SignedMessageChain.a exception) {
        if (exception.a()) {
            this.disconnect(exception.b(), exception.kickCause);
        } else {
            this.e.a(exception.b().e().a(EnumChatFormat.m));
        }
    }

    private Map<String, PlayerChatMessage> a(ServerboundChatCommandPacket packet, SignableCommand<?> arguments, LastSeenMessages lastSeenMessages) throws SignedMessageChain.a {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (SignableCommand.a<?> signablecommand_a : arguments.a()) {
            MessageSignature messagesignature = packet.f().a(signablecommand_a.a());
            SignedMessageBody signedmessagebody = new SignedMessageBody(signablecommand_a.c(), packet.d(), packet.e(), lastSeenMessages);
            map.put(signablecommand_a.a(), this.M.unpack(messagesignature, signedmessagebody));
        }
        return map;
    }

    private ParseResults<CommandListenerWrapper> b(String command) {
        CommandDispatcher<CommandListenerWrapper> com_mojang_brigadier_commanddispatcher = this.b.aC().a();
        return com_mojang_brigadier_commanddispatcher.parse(command, this.e.dc());
    }

    private Optional<LastSeenMessages> a(String message, Instant timestamp, LastSeenMessages.b acknowledgment) {
        if (!LeavesConfig.disableCheckOutOfOrderCommand && !this.a(timestamp)) {
            g.warn("{} sent out-of-order chat: '{}': {} > {}", new Object[]{this.e.ab().getString(), message, this.K.get().getEpochSecond(), timestamp.getEpochSecond()});
            this.b.scheduleOnMain(() -> this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.out_of_order_chat"), PlayerKickEvent.Cause.OUT_OF_ORDER_CHAT));
            return Optional.empty();
        }
        Optional<LastSeenMessages> optional = this.a(acknowledgment);
        if (this.e.dG() || this.e.B() == EnumChatVisibility.c) {
            this.b(new ClientboundSystemChatPacket(PaperAdventure.asAdventure(IChatBaseComponent.c("chat.disabled.options").a(EnumChatFormat.m)), false));
            return Optional.empty();
        }
        this.e.E();
        return optional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> a(LastSeenMessages.b acknowledgment) {
        LastSeenMessagesValidator lastseenmessagesvalidator = this.N;
        LastSeenMessagesValidator lastSeenMessagesValidator = this.N;
        synchronized (lastSeenMessagesValidator) {
            Optional<LastSeenMessages> optional = this.N.a(acknowledgment);
            if (optional.isEmpty()) {
                g.warn("Failed to validate message acknowledgements from {}", (Object)this.e.ab().getString());
                this.disconnect(j, PlayerKickEvent.Cause.CHAT_VALIDATION_FAILED);
            }
            return optional;
        }
    }

    private boolean a(Instant timestamp) {
        Instant instant1;
        do {
            if (!timestamp.isBefore(instant1 = this.K.get())) continue;
            return false;
        } while (!this.K.compareAndSet(instant1, timestamp));
        return true;
    }

    public static boolean c(String message) {
        for (int i2 = 0; i2 < message.length(); ++i2) {
            if (SharedConstants.a(message.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public void chat(String s2, PlayerChatMessage original, boolean async) {
        if (s2.isEmpty() || this.e.B() == EnumChatVisibility.c) {
            return;
        }
        OutgoingChatMessage outgoing = OutgoingChatMessage.a(original);
        if (this.e.B() != EnumChatVisibility.b) {
            ChatProcessor cp = new ChatProcessor(this.b, this.e, original, async);
            cp.process();
        }
    }

    public void handleCommand(String s2) {
        AsyncCatcher.catchOp("Command Dispatched Async: " + s2);
        if (SpigotConfig.logCommands) {
            g.info(this.e.cx() + " issued server command: " + s2);
        }
        CraftPlayer player = this.getCraftPlayer();
        PlayerCommandPreprocessEvent event = new PlayerCommandPreprocessEvent((Player)player, s2, (Set)new LazyPlayerSet(this.b));
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        try {
            this.cserver.dispatchCommand((CommandSender)event.getPlayer(), event.getMessage().substring(1));
        }
        catch (CommandException ex) {
            player.sendMessage(ChatColor.RED + "An internal error occurred while attempting to perform this command");
            java.util.logging.Logger.getLogger(PlayerConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private PlayerChatMessage a(PacketPlayInChat packet, LastSeenMessages lastSeenMessages) throws SignedMessageChain.a {
        SignedMessageBody signedmessagebody = new SignedMessageBody(packet.a(), packet.d(), packet.e(), lastSeenMessages);
        return this.M.unpack(packet.f(), signedmessagebody);
    }

    private void b(PlayerChatMessage message) {
        String s2 = message.b();
        if (s2.isEmpty()) {
            g.warn(this.e.cx() + " tried to send an empty message");
        } else if (this.getCraftPlayer().isConversing()) {
            final String conversationInput = s2;
            this.b.processQueue.add(new Runnable(){

                @Override
                public void run() {
                    PlayerConnection.this.getCraftPlayer().acceptConversationInput(conversationInput);
                }
            });
        } else if (this.e.B() == EnumChatVisibility.b) {
            this.b(new ClientboundSystemChatPacket(PaperAdventure.asAdventure(IChatBaseComponent.c("chat.cannotSend").a(EnumChatFormat.m)), false));
        } else {
            this.chat(s2, message, true);
        }
        this.detectRateSpam(s2);
    }

    private void detectRateSpam(String s2) {
        boolean counted = true;
        for (String exclude : SpigotConfig.spamExclusions) {
            if (exclude == null || !s2.startsWith(exclude)) continue;
            counted = false;
            break;
        }
        if (counted && this.chatSpamTickCount.addAndGet(20) > 200 && !this.b.ac().f(this.e.fQ())) {
            this.disconnect(IChatBaseComponent.c("disconnect.spam"), PlayerKickEvent.Cause.SPAM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(ServerboundChatAckPacket packet) {
        LastSeenMessagesValidator lastseenmessagesvalidator = this.N;
        LastSeenMessagesValidator lastSeenMessagesValidator = this.N;
        synchronized (lastSeenMessagesValidator) {
            if (!this.N.a(packet.a())) {
                g.warn("Failed to validate message acknowledgements from {}", (Object)this.e.ab().getString());
                this.disconnect(j, PlayerKickEvent.Cause.CHAT_VALIDATION_FAILED);
            }
        }
    }

    @Override
    public void a(PacketPlayInArmAnimation packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.eX()) {
            return;
        }
        this.e.E();
        float f1 = this.e.dD();
        float f2 = this.e.dB();
        double d0 = this.e.dq();
        double d1 = this.e.ds() + (double)this.e.cH();
        double d2 = this.e.dw();
        Location origin = new Location((World)this.e.dL().getWorld(), d0, d1, d2, f2, f1);
        double d3 = this.e.e.b() == EnumGamemode.b ? 5.0 : 4.5;
        RayTraceResult result = this.e.dL().getWorld().rayTrace(origin, origin.getDirection(), d3, FluidCollisionMode.NEVER, false, 0.0, entity -> {
            net.minecraft.world.entity.Entity handle = ((CraftEntity)entity).getHandle();
            return entity != this.e.getBukkitEntity() && this.e.getBukkitEntity().canSee((Entity)entity) && !handle.M_() && handle.br() && !handle.y(this.e);
        });
        if (result == null) {
            CraftEventFactory.callPlayerInteractEvent(this.e, Action.LEFT_CLICK_AIR, this.e.fR().f(), EnumHand.a);
        } else {
            EnumGamemode gameType = this.e.e.b();
            if (gameType == EnumGamemode.c && result.getHitBlock() != null) {
                CraftEventFactory.callPlayerInteractEvent(this.e, Action.LEFT_CLICK_BLOCK, MCUtil.toBlockPosition(result.getHitPosition()), CraftBlock.blockFaceToNotch(result.getHitBlockFace()), this.e.fR().f(), EnumHand.a);
            } else if (gameType != EnumGamemode.b && result.getHitEntity() != null && origin.toVector().distanceSquared(result.getHitPosition()) > 9.0) {
                CraftEventFactory.callPlayerInteractEvent(this.e, Action.LEFT_CLICK_AIR, this.e.fR().f(), EnumHand.a);
            }
        }
        PlayerArmSwingEvent event = new PlayerArmSwingEvent((Player)this.getCraftPlayer(), packet.a() == EnumHand.a ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
        this.cserver.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.e.a(packet.a());
    }

    @Override
    public void a(PacketPlayInEntityAction packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.dG()) {
            return;
        }
        switch (packet.d()) {
            case a: 
            case b: {
                PlayerToggleSneakEvent event = new PlayerToggleSneakEvent((Player)this.getCraftPlayer(), packet.d() == PacketPlayInEntityAction.EnumPlayerAction.a);
                this.cserver.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) break;
                return;
            }
            case d: 
            case e: {
                PlayerToggleSprintEvent e2 = new PlayerToggleSprintEvent((Player)this.getCraftPlayer(), packet.d() == PacketPlayInEntityAction.EnumPlayerAction.d);
                this.cserver.getPluginManager().callEvent((Event)e2);
                if (!e2.isCancelled()) break;
                return;
            }
        }
        this.e.E();
        switch (packet.d()) {
            case a: {
                this.e.f(true);
                if (!this.e.dL().paperConfig().entities.behavior.parrotsAreUnaffectedByPlayerMovement) break;
                this.e.gf();
                break;
            }
            case b: {
                this.e.f(false);
                break;
            }
            case d: {
                this.e.g(true);
                break;
            }
            case e: {
                this.e.g(false);
                break;
            }
            case c: {
                if (!this.e.fC()) break;
                this.e.a(false, true);
                this.B = this.e.dj();
                break;
            }
            case f: {
                net.minecraft.world.entity.Entity entity = this.e.cZ();
                if (!(entity instanceof IJumpable)) break;
                IJumpable ijumpable = (IJumpable)((Object)entity);
                int i2 = packet.e();
                if (!ijumpable.a() || i2 <= 0) break;
                ijumpable.c(i2);
                break;
            }
            case g: {
                net.minecraft.world.entity.Entity entity = this.e.cZ();
                if (!(entity instanceof IJumpable)) break;
                IJumpable ijumpable = (IJumpable)((Object)entity);
                ijumpable.b();
                break;
            }
            case h: {
                net.minecraft.world.entity.Entity entity = this.e.cY();
                if (!(entity instanceof HasCustomInventoryScreen)) break;
                HasCustomInventoryScreen hascustominventoryscreen = (HasCustomInventoryScreen)((Object)entity);
                hascustominventoryscreen.b(this.e);
                break;
            }
            case i: {
                if (this.e.fW()) break;
                this.e.fY();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(PlayerChatMessage message) {
        MessageSignature messagesignature = message.k();
        if (messagesignature != null) {
            int i2;
            this.O.a(message);
            LastSeenMessagesValidator lastseenmessagesvalidator = this.N;
            LastSeenMessagesValidator lastSeenMessagesValidator = this.N;
            synchronized (lastSeenMessagesValidator) {
                this.N.a(messagesignature);
                i2 = this.N.a();
            }
            if (i2 > 4096) {
                this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.too_many_pending_chats"), PlayerKickEvent.Cause.TOO_MANY_PENDING_CHATS);
            }
        }
    }

    public void a(PlayerChatMessage message, ChatMessageType.a params) {
        if (!this.getCraftPlayer().canSee(message.j().c())) {
            this.a(message.c(), params);
            return;
        }
        this.b(new ClientboundPlayerChatPacket(message.j().c(), message.j().b(), message.k(), message.l().a(this.O), message.m(), message.n(), params.a(this.e.dL().G_())));
        this.a(message);
    }

    public void a(IChatBaseComponent message, ChatMessageType.a params) {
        this.b(new ClientboundDisguisedChatPacket(message, params.a(this.e.dL().G_())));
    }

    public SocketAddress n() {
        return this.c.f();
    }

    public SocketAddress getRawAddress() {
        if (this.c.n.remoteAddress() == null) {
            return new InetSocketAddress(InetAddress.getLoopbackAddress(), 0);
        }
        return this.c.n.remoteAddress();
    }

    public void o() {
        this.Q = true;
        this.q();
        this.b(new ClientboundStartConfigurationPacket());
    }

    @Override
    public void a(PacketStatusInPing packet) {
        this.c.a(new PacketStatusOutPong(packet.a()));
    }

    @Override
    public void a(final PacketPlayInUseEntity packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.eX()) {
            return;
        }
        final WorldServer worldserver = this.e.x();
        final net.minecraft.world.entity.Entity entity = packet.a(worldserver);
        if (entity == this.e && !this.e.M_()) {
            this.disconnect("Cannot interact with self!", PlayerKickEvent.Cause.SELF_INTERACTION);
            return;
        }
        this.e.E();
        this.e.f(packet.a());
        if (entity != null) {
            if (!worldserver.B_().a(entity.dl())) {
                return;
            }
            AxisAlignedBB axisalignedbb = entity.cG();
            if (axisalignedbb.e(this.e.bp()) < d) {
                packet.a(new PacketPlayInUseEntity.c(){

                    private void performInteraction(EnumHand enumhand, a playerconnection_a, PlayerInteractEntityEvent event) {
                        ItemStack itemstack = PlayerConnection.this.e.b(enumhand);
                        if (itemstack.a(worldserver.G())) {
                            ItemStack itemstack1 = itemstack.p();
                            ItemStack itemInHand = PlayerConnection.this.e.b(enumhand);
                            boolean triggerLeashUpdate = itemInHand != null && itemInHand.d() == Items.tQ && entity instanceof EntityInsentient;
                            Item origItem = PlayerConnection.this.e.fR().f() == null ? null : PlayerConnection.this.e.fR().f().d();
                            PlayerConnection.this.cserver.getPluginManager().callEvent((Event)event);
                            if (entity instanceof Bucketable && entity instanceof EntityLiving && origItem != null && origItem.k() == Items.pL && (event.isCancelled() || PlayerConnection.this.e.fR().f() == null || PlayerConnection.this.e.fR().f().d() != origItem)) {
                                entity.al().resendPossiblyDesyncedEntity(PlayerConnection.this.e);
                                PlayerConnection.this.e.bS.b();
                            }
                            if (triggerLeashUpdate && (event.isCancelled() || PlayerConnection.this.e.fR().f() == null || PlayerConnection.this.e.fR().f().d() != origItem)) {
                                PlayerConnection.this.b(new PacketPlayOutAttachEntity(entity, ((EntityInsentient)entity).fS()));
                            }
                            if (event.isCancelled() || PlayerConnection.this.e.fR().f() == null || PlayerConnection.this.e.fR().f().d() != origItem) {
                                entity.al().refresh(PlayerConnection.this.e);
                                if (entity instanceof Allay) {
                                    Allay allay = (Allay)entity;
                                    PlayerConnection.this.b(new PacketPlayOutEntityEquipment(entity.ah(), Arrays.stream(EnumItemSlot.values()).map(slot -> Pair.of((Object)slot, (Object)allay.stripMeta(allay.c((EnumItemSlot)slot), true))).collect(Collectors.toList())));
                                    PlayerConnection.this.e.bS.b();
                                }
                            }
                            if (event.isCancelled()) {
                                PlayerConnection.this.e.bS.b();
                                return;
                            }
                            EnumInteractionResult enuminteractionresult = playerconnection_a.run(PlayerConnection.this.e, entity, enumhand);
                            if (!itemInHand.b() && itemInHand.L() <= -1) {
                                PlayerConnection.this.e.bS.b();
                            }
                            if (enuminteractionresult.a()) {
                                CriterionTriggers.Q.a(PlayerConnection.this.e, itemstack1, entity);
                                if (enuminteractionresult.b()) {
                                    PlayerConnection.this.e.a(enumhand, true);
                                }
                            }
                        }
                    }

                    @Override
                    public void a(EnumHand hand) {
                        this.performInteraction(hand, EntityHuman::a, new PlayerInteractEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), hand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void a(EnumHand hand, Vec3D pos) {
                        this.performInteraction(hand, (entityplayer, entity1, enumhand1) -> entity1.a(entityplayer, pos, enumhand1), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((Player)PlayerConnection.this.getCraftPlayer(), (Entity)entity.getBukkitEntity(), new Vector(pos.c, pos.d, pos.e), hand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
                    }

                    @Override
                    public void a() {
                        if (!(entity instanceof EntityItem || entity instanceof EntityExperienceOrb || entity instanceof EntityArrow || entity == PlayerConnection.this.e && !PlayerConnection.this.e.M_())) {
                            ItemStack itemstack = PlayerConnection.this.e.b(EnumHand.a);
                            if (itemstack.a(worldserver.G())) {
                                PlayerConnection.this.e.d(entity);
                                if (!itemstack.b() && itemstack.L() <= -1) {
                                    PlayerConnection.this.e.bS.b();
                                }
                            }
                        } else {
                            PlayerConnection.this.disconnect(IChatBaseComponent.c("multiplayer.disconnect.invalid_entity_attacked"), PlayerKickEvent.Cause.INVALID_ENTITY_ATTACKED);
                            g.warn("Player {} tried to attack an invalid entity", (Object)PlayerConnection.this.e.ab().getString());
                        }
                    }
                });
            }
        } else {
            packet.a(new PacketPlayInUseEntity.c(){

                @Override
                public void a(EnumHand hand) {
                    PlayerConnection.this.callPlayerUseUnknownEntityEvent(packet, hand, null);
                }

                @Override
                public void a(EnumHand hand, Vec3D pos) {
                    PlayerConnection.this.callPlayerUseUnknownEntityEvent(packet, hand, pos);
                }

                @Override
                public void a() {
                    PlayerConnection.this.callPlayerUseUnknownEntityEvent(packet, EnumHand.a, null);
                }
            });
        }
    }

    private void callPlayerUseUnknownEntityEvent(PacketPlayInUseEntity packet, EnumHand hand, @Nullable Vec3D vector) {
        this.cserver.getPluginManager().callEvent((Event)new PlayerUseUnknownEntityEvent((Player)this.getCraftPlayer(), packet.getEntityId(), packet.isAttack(), hand == EnumHand.a ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND, vector != null ? new Vector(vector.c, vector.d, vector.e) : null));
    }

    @Override
    public void a(PacketPlayInClientCommand packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        this.e.E();
        PacketPlayInClientCommand.EnumClientCommand packetplayinclientcommand_enumclientcommand = packet.a();
        switch (packetplayinclientcommand_enumclientcommand) {
            case a: {
                if (this.e.f) {
                    this.e.f = false;
                    this.e = this.b.ac().respawn(this.e, this.b.a(this.e.R()), true, null, true, PlayerRespawnEvent.RespawnReason.END_PORTAL, PlayerRespawnEvent.RespawnFlag.END_PORTAL);
                    CriterionTriggers.v.a(this.e, net.minecraft.world.level.World.j, net.minecraft.world.level.World.h);
                    break;
                }
                if (this.e.eu() > 0.0f) {
                    return;
                }
                this.e = this.b.ac().respawn(this.e, false, PlayerRespawnEvent.RespawnReason.DEATH);
                if (!this.b.h()) break;
                this.e.setGameMode(EnumGamemode.d, PlayerGameModeChangeEvent.Cause.HARDCORE_DEATH, null);
                this.e.dL().X().a(GameRules.q).set(false, this.e.x());
                break;
            }
            case b: {
                this.e.F().a(this.e);
            }
        }
    }

    @Override
    public void a(PacketPlayInCloseWindow packet) {
        this.handleContainerClose(packet, InventoryCloseEvent.Reason.PLAYER);
    }

    public void handleContainerClose(PacketPlayInCloseWindow packet, InventoryCloseEvent.Reason reason) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.eX()) {
            return;
        }
        CraftEventFactory.handleInventoryCloseEvent(this.e, reason);
        this.e.r();
    }

    @Override
    public void a(PacketPlayInWindowClick packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.eX()) {
            return;
        }
        this.e.E();
        if (this.e.bS.j == packet.a() && this.e.bS.a(this.e)) {
            boolean cancelled = this.e.M_();
            if (!this.e.bS.a(this.e)) {
                g.debug("Player {} interacted with invalid menu {}", (Object)this.e, (Object)this.e.bS);
            } else {
                int i2 = packet.d();
                if (!this.e.bS.a(i2)) {
                    g.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.e.ab(), i2, this.e.bS.i.size()});
                } else {
                    boolean flag = packet.i() != this.e.bS.j();
                    this.e.bS.h();
                    if (packet.d() < -1 && packet.d() != -999) {
                        return;
                    }
                    InventoryView inventory = this.e.bS.getBukkitView();
                    InventoryType.SlotType type = inventory.getSlotType(packet.d());
                    ClickType click = ClickType.UNKNOWN;
                    InventoryAction action = InventoryAction.UNKNOWN;
                    ItemStack itemstack = ItemStack.b;
                    switch (packet.h()) {
                        case a: {
                            if (packet.e() == 0) {
                                click = ClickType.LEFT;
                            } else if (packet.e() == 1) {
                                click = ClickType.RIGHT;
                            }
                            if (packet.e() != 0 && packet.e() != 1) break;
                            action = InventoryAction.NOTHING;
                            if (packet.d() == -999) {
                                if (this.e.bS.g().b()) break;
                                action = packet.e() == 0 ? InventoryAction.DROP_ALL_CURSOR : InventoryAction.DROP_ONE_CURSOR;
                                break;
                            }
                            if (packet.d() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.e.bS.b(packet.d());
                            if (slot == null) break;
                            ItemStack clickedItem = slot.e();
                            ItemStack cursor = this.e.bS.g();
                            if (clickedItem.b()) {
                                if (cursor.b()) break;
                                action = packet.e() == 0 ? InventoryAction.PLACE_ALL : InventoryAction.PLACE_ONE;
                                break;
                            }
                            if (!slot.a(this.e)) break;
                            if (cursor.b()) {
                                action = packet.e() == 0 ? InventoryAction.PICKUP_ALL : InventoryAction.PICKUP_HALF;
                                break;
                            }
                            if (slot.a(cursor)) {
                                if (ItemStack.c(clickedItem, cursor)) {
                                    int toPlace = packet.e() == 0 ? cursor.L() : 1;
                                    toPlace = Math.min(toPlace, clickedItem.g() - clickedItem.L());
                                    if ((toPlace = Math.min(toPlace, slot.d.ag_() - clickedItem.L())) == 1) {
                                        action = InventoryAction.PLACE_ONE;
                                        break;
                                    }
                                    if (toPlace == cursor.L()) {
                                        action = InventoryAction.PLACE_ALL;
                                        break;
                                    }
                                    if (toPlace < 0) {
                                        action = toPlace != -1 ? InventoryAction.PICKUP_SOME : InventoryAction.PICKUP_ONE;
                                        break;
                                    }
                                    if (toPlace == 0) break;
                                    action = InventoryAction.PLACE_SOME;
                                    break;
                                }
                                if (cursor.L() > slot.a()) break;
                                action = InventoryAction.SWAP_WITH_CURSOR;
                                break;
                            }
                            if (!ItemStack.c(cursor, clickedItem) || clickedItem.L() < 0 || clickedItem.L() + cursor.L() > cursor.g()) break;
                            action = InventoryAction.PICKUP_ALL;
                            break;
                        }
                        case b: {
                            if (packet.e() == 0) {
                                click = ClickType.SHIFT_LEFT;
                            } else if (packet.e() == 1) {
                                click = ClickType.SHIFT_RIGHT;
                            }
                            if (packet.e() != 0 && packet.e() != 1) break;
                            if (packet.d() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            Slot slot = this.e.bS.b(packet.d());
                            if (slot != null && slot.a(this.e) && slot.f()) {
                                action = InventoryAction.MOVE_TO_OTHER_INVENTORY;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case c: {
                            if ((packet.e() < 0 || packet.e() >= 9) && packet.e() != 40) break;
                            if (packet.d() < 0) {
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = packet.e() == 40 ? ClickType.SWAP_OFFHAND : ClickType.NUMBER_KEY;
                            Slot clickedSlot = this.e.bS.b(packet.d());
                            if (clickedSlot.a(this.e)) {
                                boolean canCleanSwap;
                                ItemStack hotbar = this.e.fR().a(packet.e());
                                boolean bl = canCleanSwap = hotbar.b() || clickedSlot.d == this.e.fR() && clickedSlot.a(hotbar);
                                if (clickedSlot.f()) {
                                    if (canCleanSwap) {
                                        action = InventoryAction.HOTBAR_SWAP;
                                        break;
                                    }
                                    action = InventoryAction.HOTBAR_MOVE_AND_READD;
                                    break;
                                }
                                if (!clickedSlot.f() && !hotbar.b() && clickedSlot.a(hotbar)) {
                                    action = InventoryAction.HOTBAR_SWAP;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case d: {
                            Slot slot;
                            if (packet.e() == 2) {
                                click = ClickType.MIDDLE;
                                if (packet.d() < 0) {
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                slot = this.e.bS.b(packet.d());
                                if (slot != null && slot.f() && this.e.fS().d && this.e.bS.g().b()) {
                                    action = InventoryAction.CLONE_STACK;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.UNKNOWN;
                            action = InventoryAction.UNKNOWN;
                            break;
                        }
                        case e: {
                            Slot slot;
                            if (packet.d() >= 0) {
                                if (packet.e() == 0) {
                                    click = ClickType.DROP;
                                    slot = this.e.bS.b(packet.d());
                                    if (slot != null && slot.f() && slot.a(this.e) && !slot.e().b() && slot.e().d() != Item.a(Blocks.a)) {
                                        action = InventoryAction.DROP_ONE_SLOT;
                                        break;
                                    }
                                    action = InventoryAction.NOTHING;
                                    break;
                                }
                                if (packet.e() != 1) break;
                                click = ClickType.CONTROL_DROP;
                                slot = this.e.bS.b(packet.d());
                                if (slot != null && slot.f() && slot.a(this.e) && !slot.e().b() && slot.e().d() != Item.a(Blocks.a)) {
                                    action = InventoryAction.DROP_ALL_SLOT;
                                    break;
                                }
                                action = InventoryAction.NOTHING;
                                break;
                            }
                            click = ClickType.LEFT;
                            if (packet.e() == 1) {
                                click = ClickType.RIGHT;
                            }
                            action = InventoryAction.NOTHING;
                            break;
                        }
                        case f: {
                            this.e.bS.a(packet.d(), packet.e(), packet.h(), this.e);
                            break;
                        }
                        case g: {
                            click = ClickType.DOUBLE_CLICK;
                            action = InventoryAction.NOTHING;
                            if (packet.d() < 0 || this.e.bS.g().b()) break;
                            ItemStack cursor = this.e.bS.g();
                            action = InventoryAction.NOTHING;
                            if (!inventory.getTopInventory().contains(CraftMagicNumbers.getMaterial(cursor.d())) && !inventory.getBottomInventory().contains(CraftMagicNumbers.getMaterial(cursor.d()))) break;
                            action = InventoryAction.COLLECT_TO_CURSOR;
                            break;
                        }
                    }
                    if (packet.h() != InventoryClickType.f) {
                        org.bukkit.inventory.ItemStack result;
                        Recipe recipe;
                        InventoryClickEvent event = click == ClickType.NUMBER_KEY ? new InventoryClickEvent(inventory, type, packet.d(), click, action, packet.e()) : new InventoryClickEvent(inventory, type, packet.d(), click, action);
                        Inventory top = inventory.getTopInventory();
                        if (packet.d() == 0 && top instanceof CraftingInventory && (recipe = ((CraftingInventory)top).getRecipe()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new CraftItemEvent(recipe, inventory, type, packet.d(), click, action, packet.e()) : new CraftItemEvent(recipe, inventory, type, packet.d(), click, action);
                        }
                        if (packet.d() == 3 && top instanceof SmithingInventory && (result = ((SmithingInventory)top).getResult()) != null) {
                            event = click == ClickType.NUMBER_KEY ? new SmithItemEvent(inventory, type, packet.d(), click, action, packet.e()) : new SmithItemEvent(inventory, type, packet.d(), click, action);
                        }
                        event.setCancelled(cancelled);
                        Container oldContainer = this.e.bS;
                        this.cserver.getPluginManager().callEvent((Event)event);
                        if (this.e.bS != oldContainer) {
                            return;
                        }
                        block9 : switch (event.getResult()) {
                            case ALLOW: 
                            case DEFAULT: {
                                this.e.bS.a(i2, packet.e(), packet.h(), this.e);
                                break;
                            }
                            case DENY: {
                                switch (action) {
                                    case PICKUP_ALL: 
                                    case MOVE_TO_OTHER_INVENTORY: 
                                    case HOTBAR_MOVE_AND_READD: 
                                    case HOTBAR_SWAP: 
                                    case COLLECT_TO_CURSOR: 
                                    case UNKNOWN: {
                                        this.e.bS.b();
                                        break block9;
                                    }
                                    case PICKUP_SOME: 
                                    case PICKUP_HALF: 
                                    case PICKUP_ONE: 
                                    case PLACE_ALL: 
                                    case PLACE_SOME: 
                                    case PLACE_ONE: 
                                    case SWAP_WITH_CURSOR: {
                                        this.e.c.b(new PacketPlayOutSetSlot(-1, -1, this.e.bR.k(), this.e.bS.g()));
                                        this.e.c.b(new PacketPlayOutSetSlot(this.e.bS.j, this.e.bR.k(), packet.d(), this.e.bS.b(packet.d()).e()));
                                        break block9;
                                    }
                                    case DROP_ALL_SLOT: 
                                    case DROP_ONE_SLOT: {
                                        this.e.c.b(new PacketPlayOutSetSlot(this.e.bS.j, this.e.bR.k(), packet.d(), this.e.bS.b(packet.d()).e()));
                                        break block9;
                                    }
                                    case DROP_ALL_CURSOR: 
                                    case DROP_ONE_CURSOR: 
                                    case CLONE_STACK: {
                                        this.e.c.b(new PacketPlayOutSetSlot(-1, -1, this.e.bR.k(), this.e.bS.g()));
                                        break block9;
                                    }
                                }
                            }
                        }
                        if (event instanceof CraftItemEvent || event instanceof SmithItemEvent) {
                            this.e.bS.b();
                        }
                    }
                    for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(packet.g())) {
                        this.e.bS.b(entry.getIntKey(), (ItemStack)entry.getValue());
                    }
                    this.e.bS.a(packet.f());
                    this.e.bS.i();
                    if (flag) {
                        this.e.bS.e();
                    } else {
                        this.e.bS.d();
                    }
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInAutoRecipe packet) {
        if (!Bukkit.isPrimaryThread() && this.recipeSpamPackets.addAndGet(GlobalConfiguration.get().spamLimiter.recipeSpamIncrement) > GlobalConfiguration.get().spamLimiter.recipeSpamLimit) {
            this.b.scheduleOnMain(() -> this.disconnect(IChatBaseComponent.a("disconnect.spam", ArrayConstants.emptyObjectArray), PlayerKickEvent.Cause.SPAM));
            return;
        }
        PlayerConnectionUtils.a(packet, this, this.e.x());
        this.e.E();
        if (!this.e.M_() && this.e.bS.j == packet.a() && this.e.bS instanceof ContainerRecipeBook) {
            if (!this.e.bS.a(this.e)) {
                g.debug("Player {} interacted with invalid menu {}", (Object)this.e, (Object)this.e.bS);
            } else {
                Container event;
                MinecraftKey recipeName = packet.d();
                boolean makeAll = packet.e();
                PlayerRecipeBookClickEvent paperEvent = new PlayerRecipeBookClickEvent((Player)this.e.getBukkitEntity(), CraftNamespacedKey.fromMinecraft(recipeName), makeAll);
                if (!paperEvent.callEvent()) {
                    return;
                }
                recipeName = CraftNamespacedKey.toMinecraft(paperEvent.getRecipe());
                makeAll = paperEvent.isMakeAll();
                if (org.bukkit.event.player.PlayerRecipeBookClickEvent.getHandlerList().getRegisteredListeners().length > 0) {
                    Recipe recipe = this.cserver.getRecipe(CraftNamespacedKey.fromMinecraft(recipeName));
                    if (recipe == null) {
                        return;
                    }
                    event = CraftEventFactory.callRecipeBookClickEvent(this.e, recipe, makeAll);
                    recipeName = CraftNamespacedKey.toMinecraft(((Keyed)event.getRecipe()).getKey());
                    makeAll = event.isShiftClick();
                }
                if (!((event = this.e.bS) instanceof ContainerRecipeBook)) {
                    return;
                }
                ContainerRecipeBook recipeBookMenu = (ContainerRecipeBook)event;
                boolean finalMakeAll = makeAll;
                this.b.aE().a(recipeName).ifPresent(recipeholder -> recipeBookMenu.a(finalMakeAll, (RecipeHolder<?>)recipeholder, this.e));
            }
        }
    }

    @Override
    public void a(PacketPlayInEnchantItem packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.eX()) {
            return;
        }
        this.e.E();
        if (this.e.bS.j == packet.a() && !this.e.M_()) {
            if (!this.e.bS.a(this.e)) {
                g.debug("Player {} interacted with invalid menu {}", (Object)this.e, (Object)this.e.bS);
            } else {
                boolean flag = this.e.bS.b(this.e, packet.d());
                if (flag) {
                    this.e.bS.d();
                }
            }
        }
    }

    @Override
    public void a(PacketPlayInSetCreativeSlot packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.e.e()) {
            boolean flag2;
            boolean flag = packet.a() < 0;
            ItemStack itemstack = packet.d();
            if (!itemstack.a(this.e.dL().G())) {
                return;
            }
            NBTTagCompound nbttagcompound = ItemBlock.a(itemstack);
            if (!itemstack.b() && nbttagcompound != null && nbttagcompound.e("x") && nbttagcompound.e("y") && nbttagcompound.e("z") && this.e.getBukkitEntity().hasPermission("minecraft.nbt.copy")) {
                BlockPosition blockposition = TileEntity.c(nbttagcompound);
                if (this.e.dL().o(blockposition)) {
                    TileEntity tileentity = null;
                    if (this.e.i(blockposition.u(), blockposition.v(), blockposition.w()) < 1024.0 && this.e.x().isLoadedAndInBounds(blockposition)) {
                        tileentity = this.e.dL().c_(blockposition);
                    }
                    if (tileentity != null) {
                        tileentity.e(itemstack);
                    }
                }
            }
            boolean flag1 = packet.a() >= 1 && packet.a() <= 45;
            boolean bl = flag2 = itemstack.b() || itemstack.k() >= 0 && itemstack.L() <= 64 && !itemstack.b();
            if (flag || flag1 && !ItemStack.a(this.e.bR.b(packet.a()).e(), packet.d())) {
                CraftInventoryView inventory = this.e.bR.getBukkitView();
                org.bukkit.inventory.ItemStack item = CraftItemStack.asBukkitCopy(packet.d());
                InventoryType.SlotType type = InventoryType.SlotType.QUICKBAR;
                if (flag) {
                    type = InventoryType.SlotType.OUTSIDE;
                } else if (packet.a() < 36) {
                    type = packet.a() >= 5 && packet.a() < 9 ? InventoryType.SlotType.ARMOR : InventoryType.SlotType.CONTAINER;
                }
                InventoryCreativeEvent event = new InventoryCreativeEvent((InventoryView)inventory, type, flag ? -999 : packet.a(), item);
                this.cserver.getPluginManager().callEvent((Event)event);
                itemstack = CraftItemStack.asNMSCopy(event.getCursor());
                switch (event.getResult()) {
                    case ALLOW: {
                        flag2 = true;
                        break;
                    }
                    case DEFAULT: {
                        break;
                    }
                    case DENY: {
                        if (packet.a() >= 0) {
                            this.e.c.b(new PacketPlayOutSetSlot(this.e.bR.j, this.e.bR.k(), packet.a(), this.e.bR.b(packet.a()).e()));
                            this.e.c.b(new PacketPlayOutSetSlot(-1, this.e.bR.k(), -1, ItemStack.b));
                        }
                        return;
                    }
                }
            }
            if (flag1 && flag2) {
                this.e.bR.b(packet.a()).d(itemstack);
                this.e.bR.d();
            } else if (flag && flag2 && this.n < 200) {
                this.n += 20;
                this.e.a(itemstack, true);
            }
        }
    }

    @Override
    public void a(PacketPlayInUpdateSign packet) {
        String[] lines = packet.e();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            int offset;
            if (MAX_SIGN_LINE_LENGTH <= 0 || lines[i2].length() <= MAX_SIGN_LINE_LENGTH || (offset = lines[i2].codePoints().limit(MAX_SIGN_LINE_LENGTH).map(Character::charCount).sum()) >= lines[i2].length()) continue;
            lines[i2] = lines[i2].substring(0, offset);
        }
        List<String> list = Stream.of(lines).map(EnumChatFormat::a).collect(Collectors.toList());
        this.a(list).thenAcceptAsync(list1 -> this.a(packet, (List<FilteredText>)list1), (Executor)this.b);
    }

    private void a(PacketPlayInUpdateSign packet, List<FilteredText> signText) {
        if (this.e.eX()) {
            return;
        }
        this.e.E();
        WorldServer worldserver = this.e.x();
        BlockPosition blockposition = packet.a();
        if (worldserver.A(blockposition)) {
            TileEntity tileentity = worldserver.c_(blockposition);
            if (!(tileentity instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign tileentitysign = (TileEntitySign)tileentity;
            tileentitysign.a((EntityHuman)this.e, packet.d(), signText);
        }
    }

    @Override
    public void a(PacketPlayInAbilities packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.fS().c && this.e.fS().b != packet.a()) {
            PlayerToggleFlightEvent event = new PlayerToggleFlightEvent((Player)this.e.getBukkitEntity(), packet.a());
            this.cserver.getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.e.fS().b = packet.a();
            } else {
                this.e.w();
            }
        }
    }

    @Override
    public void a(ServerboundClientInformationPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (packet.a().c() < 0) {
            g.warn("Disconnecting " + this.e.cx() + " for invalid view distance: " + packet.a().c());
            this.disconnect("Invalid client settings", PlayerKickEvent.Cause.ILLEGAL_ACTION);
            return;
        }
        this.e.a(packet.a());
        this.c.n.attr(PaperAdventure.LOCALE_ATTRIBUTE).set((Object)Translator.parseLocale((String)packet.a().b()));
    }

    @Override
    public void a(PacketPlayInDifficultyChange packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.l(2) || this.i()) {
            // empty if block
        }
    }

    @Override
    public void a(PacketPlayInDifficultyLock packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        if (this.e.l(2) || this.i()) {
            this.b.b(packet.a());
        }
    }

    @Override
    public void a(ServerboundChatSessionUpdatePacket packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        RemoteChatSession.a remotechatsession_a = packet.a();
        ProfilePublicKey.a profilepublickey_a = this.L != null ? this.L.d().b() : null;
        ProfilePublicKey.a profilepublickey_a1 = remotechatsession_a.b();
        if (!Objects.equals(profilepublickey_a, profilepublickey_a1)) {
            if (profilepublickey_a != null && profilepublickey_a1.b().isBefore(profilepublickey_a.b())) {
                this.disconnect(ProfilePublicKey.a, PlayerKickEvent.Cause.EXPIRED_PROFILE_PUBLIC_KEY);
            } else {
                try {
                    SignatureValidator signaturevalidator = this.b.an();
                    if (signaturevalidator == null) {
                        g.warn("Ignoring chat session from {} due to missing Services public key", (Object)this.e.fQ().getName());
                        return;
                    }
                    this.a(remotechatsession_a.a(this.e.fQ(), signaturevalidator));
                }
                catch (ProfilePublicKey.b profilepublickey_b) {
                    this.disconnect(profilepublickey_b.b(), profilepublickey_b.kickCause);
                }
            }
        }
    }

    @Override
    public void a(ServerboundConfigurationAcknowledgedPacket packet) {
        if (!this.Q) {
            throw new IllegalStateException("Client acknowledged config, but none was requested");
        }
        this.c.a(new ServerConfigurationPacketListenerImpl(this.b, this.c, this.a(this.e.z()), this.e));
    }

    @Override
    public void a(ServerboundChunkBatchReceivedPacket packet) {
        PlayerConnectionUtils.a(packet, this, this.e.x());
        this.f.a(packet.a());
    }

    private void a(RemoteChatSession session) {
        this.L = session;
        this.hasLoggedExpiry = false;
        this.M = session.a(this.e.cv());
        this.P.append(executor -> {
            this.e.a(session);
            this.b.ac().broadcastAll((Packet)new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.b), (Collection<EntityPlayer>)List.of(this.e)), this.e);
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public EntityPlayer p() {
        return this.e;
    }

    @FunctionalInterface
    private static interface a {
        public EnumInteractionResult run(EntityPlayer var1, net.minecraft.world.entity.Entity var2, EnumHand var3);
    }
}

