/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.util.TraceUtil;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.Nullable;
import net.kyori.adventure.translation.Translator;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundUpdateTagsPacket;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.configuration.ClientboundRegistryDataPacket;
import net.minecraft.network.protocol.configuration.ClientboundUpdateEnabledFeaturesPacket;
import net.minecraft.network.protocol.configuration.ServerConfigurationPacketListener;
import net.minecraft.network.protocol.configuration.ServerboundFinishConfigurationPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.config.JoinWorldTask;
import net.minecraft.server.network.config.ServerResourcePackConfigurationTask;
import net.minecraft.server.players.PlayerList;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.world.flag.FeatureFlags;
import org.slf4j.Logger;

public class ServerConfigurationPacketListenerImpl
extends ServerCommonPacketListenerImpl
implements TickablePacketListener,
ServerConfigurationPacketListener {
    private static final Logger d = LogUtils.getLogger();
    private static final IChatBaseComponent e = IChatBaseComponent.c("multiplayer.disconnect.invalid_player_data");
    private final GameProfile f;
    private final Queue<ConfigurationTask> g = new ConcurrentLinkedQueue<ConfigurationTask>();
    @Nullable
    private ConfigurationTask h;
    private ClientInformation i;

    public ServerConfigurationPacketListenerImpl(MinecraftServer minecraftserver, NetworkManager networkmanager, CommonListenerCookie commonlistenercookie, EntityPlayer player) {
        super(minecraftserver, networkmanager, commonlistenercookie, player);
        this.f = commonlistenercookie.a();
        this.i = commonlistenercookie.c();
    }

    @Override
    protected GameProfile j() {
        return this.f;
    }

    @Override
    public void a(IChatBaseComponent reason) {
        d.info("{} lost connection: {}", (Object)this.f, (Object)reason.getString());
        super.a(reason);
    }

    @Override
    public boolean c() {
        return this.c.k();
    }

    public void m() {
        this.b(new ClientboundCustomPayloadPacket(new BrandPayload(this.b.getServerModName())));
        LayeredRegistryAccess<RegistryLayer> layeredregistryaccess = this.b.aV();
        this.b(new ClientboundUpdateEnabledFeaturesPacket(FeatureFlags.d.b(this.b.aT().M())));
        this.b(new ClientboundRegistryDataPacket(new IRegistryCustom.c(RegistrySynchronization.a(layeredregistryaccess)).c()));
        this.b(new ClientboundUpdateTagsPacket(TagNetworkSerialization.a(layeredregistryaccess)));
        this.o();
        this.g.add(new JoinWorldTask());
        this.p();
    }

    public void n() {
        this.g.add(new JoinWorldTask());
        this.p();
    }

    private void o() {
        this.b.S().ifPresent(minecraftserver_serverresourcepackinfo -> this.g.add(new ServerResourcePackConfigurationTask((MinecraftServer.ServerResourcePackInfo)minecraftserver_serverresourcepackinfo)));
    }

    @Override
    public void a(ServerboundClientInformationPacket packet) {
        this.i = packet.a();
        this.c.n.attr(PaperAdventure.LOCALE_ATTRIBUTE).set((Object)Translator.parseLocale((String)packet.a().b()));
    }

    @Override
    public void a(ServerboundResourcePackPacket packet) {
        super.a(packet);
        if (packet.a() != ServerboundResourcePackPacket.a.d) {
            this.a(ServerResourcePackConfigurationTask.a);
        }
    }

    @Override
    public void a(ServerboundFinishConfigurationPacket packet) {
        this.c.a();
        PlayerConnectionUtils.a(packet, this, this.b);
        this.a(JoinWorldTask.a);
        try {
            PlayerList playerlist = this.b.ac();
            if (playerlist.a(this.f.getId()) != null) {
                this.b(PlayerList.g);
                return;
            }
            IChatBaseComponent ichatbasecomponent = null;
            if (ichatbasecomponent != null) {
                this.b(ichatbasecomponent);
                return;
            }
            EntityPlayer entityplayer = playerlist.getPlayerForLogin(this.f, this.i, this.player);
            playerlist.a(this.c, entityplayer, this.a(this.i));
            this.c.b();
        }
        catch (Exception exception) {
            d.error("Couldn't place player in world", (Throwable)exception);
            if (MinecraftServer.getServer().isDebugging()) {
                TraceUtil.printStackTrace(exception);
            }
            this.c.a(new ClientboundDisconnectPacket(e));
            this.c.a(e);
        }
    }

    @Override
    public void e() {
        this.f();
    }

    private void p() {
        ConfigurationTask configurationtask;
        if (this.h != null) {
            throw new IllegalStateException("Task " + this.h.a().a() + " has not finished yet");
        }
        if (this.c() && (configurationtask = this.g.poll()) != null) {
            this.h = configurationtask;
            configurationtask.a(this::b);
        }
    }

    private void a(ConfigurationTask.a key) {
        ConfigurationTask.a configurationtask_a1;
        ConfigurationTask.a a2 = configurationtask_a1 = this.h != null ? this.h.a() : null;
        if (!key.equals(configurationtask_a1)) {
            throw new IllegalStateException("Unexpected request for task finish, current task: " + configurationtask_a1 + ", requested: " + key);
        }
        this.h = null;
        this.p();
    }
}

