/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.metadata.ResourcePackMetaParser;
import net.minecraft.server.packs.resources.IoSupplier;

public class CompositePackResources
implements IResourcePack {
    private final IResourcePack c;
    private final List<IResourcePack> d;

    public CompositePackResources(IResourcePack base, List<IResourcePack> overlays) {
        this.c = base;
        ArrayList<IResourcePack> list = new ArrayList<IResourcePack>(overlays.size() + 1);
        list.addAll(Lists.reverse(overlays));
        list.add(base);
        this.d = List.copyOf(list);
    }

    @Override
    @Nullable
    @Override
    public IoSupplier<InputStream> a(String ... segments) {
        return this.c.a(segments);
    }

    @Override
    @Nullable
    @Override
    public IoSupplier<InputStream> a(EnumResourcePackType type, MinecraftKey id) {
        for (IResourcePack packResources : this.d) {
            IoSupplier<InputStream> ioSupplier = packResources.a(type, id);
            if (ioSupplier == null) continue;
            return ioSupplier;
        }
        return null;
    }

    @Override
    @Override
    public void a(EnumResourcePackType type, String namespace, String prefix, IResourcePack.a consumer) {
        HashMap<MinecraftKey, IoSupplier<InputStream>> map = new HashMap<MinecraftKey, IoSupplier<InputStream>>();
        for (IResourcePack packResources : this.d) {
            packResources.a(type, namespace, prefix, map::putIfAbsent);
        }
        map.forEach(consumer);
    }

    @Override
    @Override
    public Set<String> a(EnumResourcePackType type) {
        HashSet<String> set = new HashSet<String>();
        for (IResourcePack packResources : this.d) {
            set.addAll(packResources.a(type));
        }
        return set;
    }

    @Override
    @Nullable
    @Override
    public <T> T a(ResourcePackMetaParser<T> metaReader) throws IOException {
        return this.c.a(metaReader);
    }

    @Override
    @Override
    public String a() {
        return this.c.a();
    }

    @Override
    @Override
    public boolean b() {
        return this.c.b();
    }

    @Override
    @Override
    public void close() {
        this.d.forEach(IResourcePack::close);
    }
}

