/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.linkfs;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.server.packs.linkfs.DummyFileAttributes;
import net.minecraft.server.packs.linkfs.LinkFileSystem;
import net.minecraft.server.packs.linkfs.PathContents;

class LinkFSPath
implements Path {
    private static final BasicFileAttributes a = new DummyFileAttributes(){

        @Override
        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        @Override
        public boolean isDirectory() {
            return true;
        }
    };
    private static final BasicFileAttributes b = new DummyFileAttributes(){

        @Override
        @Override
        public boolean isRegularFile() {
            return true;
        }

        @Override
        @Override
        public boolean isDirectory() {
            return false;
        }
    };
    private static final Comparator<LinkFSPath> c = Comparator.comparing(LinkFSPath::n);
    private final String d;
    private final LinkFileSystem e;
    @Nullable
    private final LinkFSPath f;
    @Nullable
    private List<String> g;
    @Nullable
    private String h;
    private final PathContents i;

    public LinkFSPath(LinkFileSystem fileSystem, String name, @Nullable LinkFSPath parent, PathContents file) {
        this.e = fileSystem;
        this.d = name;
        this.f = parent;
        this.i = file;
    }

    private LinkFSPath a(@Nullable LinkFSPath path, String name) {
        return new LinkFSPath(this.e, name, path, PathContents.b);
    }

    @Override
    public LinkFileSystem a() {
        return this.e;
    }

    @Override
    @Override
    public boolean isAbsolute() {
        return this.i != PathContents.b;
    }

    @Override
    @Override
    public File toFile() {
        PathContents pathContents = this.i;
        if (pathContents instanceof PathContents.b) {
            PathContents.b fileContents = (PathContents.b)pathContents;
            return fileContents.a().toFile();
        }
        throw new UnsupportedOperationException("Path " + this.n() + " does not represent file");
    }

    @Nullable
    @Override
    public LinkFSPath b() {
        if (this.isAbsolute()) {
            return this.e.b();
        }
        return null;
    }

    @Override
    public LinkFSPath c() {
        return this.a(null, this.d);
    }

    @Nullable
    @Override
    public LinkFSPath d() {
        return this.f;
    }

    @Override
    @Override
    public int getNameCount() {
        return this.l().size();
    }

    private List<String> l() {
        if (this.d.isEmpty()) {
            return List.of();
        }
        if (this.g == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            if (this.f != null) {
                builder.addAll(this.f.l());
            }
            builder.add((Object)this.d);
            this.g = builder.build();
        }
        return this.g;
    }

    @Override
    public LinkFSPath a(int i2) {
        List<String> list = this.l();
        if (i2 < 0 || i2 >= list.size()) {
            throw new IllegalArgumentException("Invalid index: " + i2);
        }
        return this.a(null, list.get(i2));
    }

    @Override
    public LinkFSPath a(int i2, int j2) {
        List<String> list = this.l();
        if (i2 < 0 || j2 > list.size() || i2 >= j2) {
            throw new IllegalArgumentException();
        }
        LinkFSPath linkFSPath = null;
        for (int k2 = i2; k2 < j2; ++k2) {
            linkFSPath = this.a(linkFSPath, list.get(k2));
        }
        return linkFSPath;
    }

    @Override
    @Override
    public boolean startsWith(Path path) {
        if (path.isAbsolute() != this.isAbsolute()) {
            return false;
        }
        if (path instanceof LinkFSPath) {
            LinkFSPath linkFSPath = (LinkFSPath)path;
            if (linkFSPath.e != this.e) {
                return false;
            }
            List<String> list = this.l();
            List<String> list2 = linkFSPath.l();
            int i2 = list2.size();
            if (i2 > list.size()) {
                return false;
            }
            for (int j2 = 0; j2 < i2; ++j2) {
                if (list2.get(j2).equals(list.get(j2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @Override
    public boolean endsWith(Path path) {
        if (path.isAbsolute() && !this.isAbsolute()) {
            return false;
        }
        if (path instanceof LinkFSPath) {
            LinkFSPath linkFSPath = (LinkFSPath)path;
            if (linkFSPath.e != this.e) {
                return false;
            }
            List<String> list = this.l();
            List<String> list2 = linkFSPath.l();
            int i2 = list2.size();
            int j2 = list.size() - i2;
            if (j2 < 0) {
                return false;
            }
            for (int k2 = i2 - 1; k2 >= 0; --k2) {
                if (list2.get(k2).equals(list.get(j2 + k2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public LinkFSPath e() {
        return this;
    }

    @Override
    public LinkFSPath a(Path path) {
        LinkFSPath linkFSPath = this.c(path);
        if (path.isAbsolute()) {
            return linkFSPath;
        }
        return this.a(linkFSPath.l());
    }

    private LinkFSPath a(List<String> paths) {
        LinkFSPath linkFSPath = this;
        for (String string : paths) {
            linkFSPath = linkFSPath.a(string);
        }
        return linkFSPath;
    }

    LinkFSPath a(String name) {
        if (LinkFSPath.a(this.i)) {
            return new LinkFSPath(this.e, name, this, this.i);
        }
        PathContents pathContents = this.i;
        if (pathContents instanceof PathContents.a) {
            PathContents.a directoryContents = (PathContents.a)pathContents;
            LinkFSPath linkFSPath = directoryContents.a().get(name);
            return linkFSPath != null ? linkFSPath : new LinkFSPath(this.e, name, this, PathContents.a);
        }
        if (this.i instanceof PathContents.b) {
            return new LinkFSPath(this.e, name, this, PathContents.a);
        }
        throw new AssertionError((Object)"All content types should be already handled");
    }

    private static boolean a(PathContents file) {
        return file == PathContents.a || file == PathContents.b;
    }

    @Override
    public LinkFSPath b(Path path) {
        LinkFSPath linkFSPath = this.c(path);
        if (this.isAbsolute() != linkFSPath.isAbsolute()) {
            throw new IllegalArgumentException("absolute mismatch");
        }
        List<String> list = this.l();
        List<String> list2 = linkFSPath.l();
        if (list.size() >= list2.size()) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get(i2).equals(list2.get(i2))) continue;
            throw new IllegalArgumentException();
        }
        return linkFSPath.a(list.size(), list2.size());
    }

    @Override
    @Override
    public URI toUri() {
        try {
            return new URI("x-mc-link", this.e.a().name(), this.n(), null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new AssertionError("Failed to create URI", uRISyntaxException);
        }
    }

    @Override
    public LinkFSPath f() {
        if (this.isAbsolute()) {
            return this;
        }
        return this.e.b().a(this);
    }

    @Override
    public LinkFSPath a(LinkOption ... linkOptions) {
        return this.f();
    }

    @Override
    @Override
    public WatchKey register(WatchService watchService, WatchEvent.Kind<?>[] kinds, WatchEvent.Modifier ... modifiers) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Override
    public int compareTo(Path path) {
        LinkFSPath linkFSPath = this.c(path);
        return c.compare(this, linkFSPath);
    }

    @Override
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof LinkFSPath) {
            LinkFSPath linkFSPath = (LinkFSPath)object;
            if (this.e != linkFSPath.e) {
                return false;
            }
            boolean bl = this.m();
            if (bl != linkFSPath.m()) {
                return false;
            }
            if (bl) {
                return this.i == linkFSPath.i;
            }
            return Objects.equals(this.f, linkFSPath.f) && Objects.equals(this.d, linkFSPath.d);
        }
        return false;
    }

    private boolean m() {
        return !LinkFSPath.a(this.i);
    }

    @Override
    @Override
    public int hashCode() {
        return this.m() ? this.i.hashCode() : this.d.hashCode();
    }

    @Override
    @Override
    public String toString() {
        return this.n();
    }

    private String n() {
        if (this.h == null) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.isAbsolute()) {
                stringBuilder.append("/");
            }
            Joiner.on((String)"/").appendTo(stringBuilder, this.l());
            this.h = stringBuilder.toString();
        }
        return this.h;
    }

    private LinkFSPath c(@Nullable Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (path instanceof LinkFSPath) {
            LinkFSPath linkFSPath = (LinkFSPath)path;
            if (linkFSPath.e == this.e) {
                return linkFSPath;
            }
        }
        throw new ProviderMismatchException();
    }

    public boolean g() {
        return this.m();
    }

    @Nullable
    public Path h() {
        Path path;
        PathContents pathContents = this.i;
        if (pathContents instanceof PathContents.b) {
            PathContents.b fileContents = (PathContents.b)pathContents;
            path = fileContents.a();
        } else {
            path = null;
        }
        return path;
    }

    @Nullable
    public PathContents.a i() {
        PathContents.a directoryContents;
        PathContents pathContents = this.i;
        return pathContents instanceof PathContents.a ? (directoryContents = (PathContents.a)pathContents) : null;
    }

    public BasicFileAttributeView j() {
        return new BasicFileAttributeView(){

            @Override
            @Override
            public String name() {
                return "basic";
            }

            @Override
            @Override
            public BasicFileAttributes readAttributes() throws IOException {
                return LinkFSPath.this.k();
            }

            @Override
            @Override
            public void setTimes(FileTime fileTime, FileTime fileTime2, FileTime fileTime3) {
                throw new ReadOnlyFileSystemException();
            }
        };
    }

    public BasicFileAttributes k() throws IOException {
        if (this.i instanceof PathContents.a) {
            return a;
        }
        if (this.i instanceof PathContents.b) {
            return b;
        }
        throw new NoSuchFileException(this.n());
    }

    @Override
    public /* synthetic */ Path toRealPath(LinkOption[] linkOptions) throws IOException {
        return this.a(linkOptions);
    }

    @Override
    public /* synthetic */ Path toAbsolutePath() {
        return this.f();
    }

    @Override
    public /* synthetic */ Path relativize(Path path) {
        return this.b(path);
    }

    @Override
    public /* synthetic */ Path resolve(Path path) {
        return this.a(path);
    }

    @Override
    public /* synthetic */ Path normalize() {
        return this.e();
    }

    @Override
    public /* synthetic */ Path subpath(int i2, int j2) {
        return this.a(i2, j2);
    }

    @Override
    public /* synthetic */ Path getName(int i2) {
        return this.a(i2);
    }

    @Override
    @Nullable
    public /* synthetic */ Path getParent() {
        return this.d();
    }

    @Override
    public /* synthetic */ Path getFileName() {
        return this.c();
    }

    @Override
    @Nullable
    public /* synthetic */ Path getRoot() {
        return this.b();
    }

    @Override
    public /* synthetic */ FileSystem getFileSystem() {
        return this.a();
    }
}

