/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.OverlayMetadataSection;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.EnumResourcePackVersion;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.flag.FeatureFlagSet;
import org.slf4j.Logger;

public class ResourcePackLoader {
    private static final Logger a = LogUtils.getLogger();
    private final String b;
    public final c c;
    private final IChatBaseComponent d;
    private final a e;
    private final Position f;
    private final boolean g;
    private final boolean h;
    private final PackSource i;

    @Nullable
    public static ResourcePackLoader a(String name, IChatBaseComponent displayName, boolean alwaysEnabled, c packFactory, EnumResourcePackType type, Position position, PackSource source) {
        int i2 = SharedConstants.b().a(type);
        a info = ResourcePackLoader.a(name, packFactory, i2);
        return info != null ? ResourcePackLoader.a(name, displayName, alwaysEnabled, packFactory, info, position, false, source) : null;
    }

    public static ResourcePackLoader a(String name, IChatBaseComponent displayName, boolean alwaysEnabled, c packFactory, a metadata, Position position, boolean pinned, PackSource source) {
        return new ResourcePackLoader(name, alwaysEnabled, packFactory, displayName, metadata, position, pinned, source);
    }

    private ResourcePackLoader(String name, boolean alwaysEnabled, c packFactory, IChatBaseComponent displayName, a metadata, Position position, boolean pinned, PackSource source) {
        this.b = name;
        this.c = packFactory;
        this.d = displayName;
        this.e = metadata;
        this.g = alwaysEnabled;
        this.f = position;
        this.h = pinned;
        this.i = source;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static a a(String name, c packFactory, int currentPackFormat) {
        try (IResourcePack packResources = packFactory.a(name);){
            ResourcePackInfo packMetadataSection = packResources.a(ResourcePackInfo.b);
            if (packMetadataSection == null) {
                a.warn("Missing metadata in pack {}", (Object)name);
                a a2 = null;
                return a2;
            }
            FeatureFlagsMetadataSection featureFlagsMetadataSection = packResources.a(FeatureFlagsMetadataSection.a);
            FeatureFlagSet featureFlagSet = featureFlagsMetadataSection != null ? featureFlagsMetadataSection.a() : FeatureFlagSet.a();
            InclusiveRange<Integer> inclusiveRange = ResourcePackLoader.a(name, packMetadataSection);
            EnumResourcePackVersion packCompatibility = EnumResourcePackVersion.a(inclusiveRange, currentPackFormat);
            OverlayMetadataSection overlayMetadataSection = packResources.a(OverlayMetadataSection.a);
            List<String> list = overlayMetadataSection != null ? overlayMetadataSection.a(currentPackFormat) : List.of();
            a a3 = new a(packMetadataSection.a(), packCompatibility, featureFlagSet, list);
            return a3;
        }
        catch (Exception exception) {
            a.warn("Failed to read pack {} metadata", (Object)name, (Object)exception);
            return null;
        }
    }

    private static InclusiveRange<Integer> a(String packName, ResourcePackInfo metadata) {
        int i2 = metadata.b();
        if (metadata.c().isEmpty()) {
            return new InclusiveRange<Integer>(i2);
        }
        InclusiveRange<Integer> inclusiveRange = metadata.c().get();
        if (!inclusiveRange.a(i2)) {
            a.warn("Pack {} declared support for versions {} but declared main format is {}, defaulting to {}", new Object[]{packName, inclusiveRange, i2, i2});
            return new InclusiveRange<Integer>(i2);
        }
        return inclusiveRange;
    }

    public IChatBaseComponent a() {
        return this.d;
    }

    public IChatBaseComponent b() {
        return this.e.a();
    }

    public IChatBaseComponent a(boolean enabled) {
        return ChatComponentUtils.a(this.i.a(IChatBaseComponent.b(this.b))).a(style -> style.a(enabled ? EnumChatFormat.k : EnumChatFormat.m).a(StringArgumentType.escapeIfRequired((String)this.b)).a(new ChatHoverable(ChatHoverable.EnumHoverAction.a, IChatBaseComponent.h().b(this.d).f("\n").b(this.e.a))));
    }

    public EnumResourcePackVersion c() {
        return this.e.b();
    }

    public FeatureFlagSet d() {
        return this.e.c();
    }

    public IResourcePack e() {
        return this.c.a(this.b, this.e);
    }

    public String f() {
        return this.b;
    }

    public boolean g() {
        return this.g;
    }

    public boolean h() {
        return this.h;
    }

    public Position i() {
        return this.f;
    }

    public PackSource j() {
        return this.i;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ResourcePackLoader)) {
            return false;
        }
        ResourcePackLoader pack = (ResourcePackLoader)object;
        return this.b.equals(pack.b);
    }

    @Override
    public int hashCode() {
        return this.b.hashCode();
    }

    public static interface c {
        public IResourcePack a(String var1);

        public IResourcePack a(String var1, a var2);
    }

    public record a(IChatBaseComponent a, EnumResourcePackVersion b, FeatureFlagSet c, List<String> d) {
        @Override
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "description;compatibility;requestedFeatures;overlays", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "description;compatibility;requestedFeatures;overlays", "a", "b", "c", "d"}, this);
        }

        @Override
        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "description;compatibility;requestedFeatures;overlays", "a", "b", "c", "d"}, this, object);
        }
    }

    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position a = new Position();
        public static final /* enum */ Position b = new Position();
        private static final /* synthetic */ Position[] c;

        public static Position[] values() {
            return (Position[])c.clone();
        }

        public static Position valueOf(String string) {
            return Enum.valueOf(Position.class, string);
        }

        public <T> int a(List<T> items, T item, Function<T, ResourcePackLoader> profileGetter, boolean listInverted) {
            ResourcePackLoader pack2;
            int j2;
            Position position;
            Position position2 = position = listInverted ? this.a() : this;
            if (position == b) {
                ResourcePackLoader pack;
                int i2;
                for (i2 = 0; i2 < items.size() && (pack = profileGetter.apply(items.get(i2))).h() && pack.i() == this; ++i2) {
                }
                items.add(i2, item);
                return i2;
            }
            for (j2 = items.size() - 1; j2 >= 0 && (pack2 = profileGetter.apply(items.get(j2))).h() && pack2.i() == this; --j2) {
            }
            items.add(j2 + 1, item);
            return j2 + 1;
        }

        public Position a() {
            return this == a ? b : a;
        }

        private static /* synthetic */ Position[] b() {
            return new Position[]{a, b};
        }

        static {
            c = Position.b();
        }
    }
}

