/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceFilterSection;
import net.minecraft.server.packs.resources.ResourceManagerFallback;
import org.slf4j.Logger;

public class ResourceManager
implements IReloadableResourceManager {
    private static final Logger a = LogUtils.getLogger();
    private final Map<String, ResourceManagerFallback> b;
    private final List<IResourcePack> c;

    public ResourceManager(EnumResourcePackType type, List<IResourcePack> packs) {
        this.c = List.copyOf(packs);
        HashMap<String, ResourceManagerFallback> map = new HashMap<String, ResourceManagerFallback>();
        List list = packs.stream().flatMap(pack -> pack.a(type).stream()).distinct().toList();
        for (IResourcePack packResources : packs) {
            ResourceFilterSection resourceFilterSection = this.a(packResources);
            Set<String> set = packResources.a(type);
            Predicate<MinecraftKey> predicate = resourceFilterSection != null ? id -> resourceFilterSection.b(id.a()) : null;
            for (String string : list) {
                boolean bl2;
                boolean bl = set.contains(string);
                boolean bl3 = bl2 = resourceFilterSection != null && resourceFilterSection.a(string);
                if (!bl && !bl2) continue;
                ResourceManagerFallback fallbackResourceManager = (ResourceManagerFallback)map.get(string);
                if (fallbackResourceManager == null) {
                    fallbackResourceManager = new ResourceManagerFallback(type, string);
                    map.put(string, fallbackResourceManager);
                }
                if (bl && bl2) {
                    fallbackResourceManager.a(packResources, predicate);
                    continue;
                }
                if (bl) {
                    fallbackResourceManager.a(packResources);
                    continue;
                }
                fallbackResourceManager.a(packResources.a(), predicate);
            }
        }
        this.b = map;
    }

    @Nullable
    private ResourceFilterSection a(IResourcePack pack) {
        try {
            return pack.a(ResourceFilterSection.a);
        }
        catch (IOException iOException) {
            a.error("Failed to get filter section from pack {}", (Object)pack.a());
            return null;
        }
    }

    @Override
    @Override
    public Set<String> a() {
        return this.b.keySet();
    }

    @Override
    @Override
    public Optional<IResource> getResource(MinecraftKey id) {
        IResourceManager resourceManager = this.b.get(id.b());
        if (resourceManager != null) {
            return resourceManager.getResource(id);
        }
        return Optional.empty();
    }

    @Override
    @Override
    public List<IResource> a(MinecraftKey id) {
        IResourceManager resourceManager = this.b.get(id.b());
        if (resourceManager != null) {
            return resourceManager.a(id);
        }
        return List.of();
    }

    @Override
    @Override
    public Map<MinecraftKey, IResource> b(String startingPath, Predicate<MinecraftKey> allowedPathPredicate) {
        ResourceManager.a(startingPath);
        TreeMap<MinecraftKey, IResource> map = new TreeMap<MinecraftKey, IResource>();
        for (ResourceManagerFallback fallbackResourceManager : this.b.values()) {
            map.putAll(fallbackResourceManager.b(startingPath, allowedPathPredicate));
        }
        return map;
    }

    @Override
    @Override
    public Map<MinecraftKey, List<IResource>> c(String startingPath, Predicate<MinecraftKey> allowedPathPredicate) {
        ResourceManager.a(startingPath);
        TreeMap<MinecraftKey, List<IResource>> map = new TreeMap<MinecraftKey, List<IResource>>();
        for (ResourceManagerFallback fallbackResourceManager : this.b.values()) {
            map.putAll(fallbackResourceManager.c(startingPath, allowedPathPredicate));
        }
        return map;
    }

    private static void a(String startingPath) {
        if (startingPath.endsWith("/")) {
            throw new IllegalArgumentException("Trailing slash in path " + startingPath);
        }
    }

    @Override
    @Override
    public Stream<IResourcePack> b() {
        return this.c.stream();
    }

    @Override
    @Override
    public void close() {
        this.c.forEach(IResourcePack::close);
    }
}

