/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.stats.Counter;
import net.minecraft.stats.StatisticWrapper;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;

public class Statistic<T>
extends IScoreboardCriteria {
    private final Counter n;
    private final T o;
    private final StatisticWrapper<T> p;

    protected Statistic(StatisticWrapper<T> type, T value, Counter formatter) {
        super(Statistic.a(type, value));
        this.p = type;
        this.n = formatter;
        this.o = value;
    }

    public static <T> String a(StatisticWrapper<T> type, T value) {
        return Statistic.a(BuiltInRegistries.y.b(type)) + ":" + Statistic.a(type.a().b(value));
    }

    private static <T> String a(@Nullable MinecraftKey id) {
        return id.toString().replace(':', '.');
    }

    public StatisticWrapper<T> a() {
        return this.p;
    }

    public T b() {
        return this.o;
    }

    public String a(int value) {
        return this.n.format(value);
    }

    @Override
    public boolean equals(Object object) {
        return this == object || object instanceof Statistic && Objects.equals(this.d(), ((Statistic)object).d());
    }

    @Override
    public int hashCode() {
        return this.d().hashCode();
    }

    @Override
    public String toString() {
        return "Stat{name=" + this.d() + ", formatter=" + this.n + "}";
    }
}

