/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.ServicesKeyType;
import com.mojang.logging.LogUtils;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.util.SignatureUpdater;
import org.slf4j.Logger;

public interface SignatureValidator {
    public static final SignatureValidator a = (updatable, signatureData) -> true;
    public static final Logger b = LogUtils.getLogger();

    public boolean validate(SignatureUpdater var1, byte[] var2);

    default public boolean a(byte[] signedData, byte[] signatureData) {
        return this.validate(updater -> updater.update(signedData), signatureData);
    }

    private static boolean a(SignatureUpdater updatable, byte[] signatureData, Signature signature) throws SignatureException {
        updatable.update(signature::update);
        return signature.verify(signatureData);
    }

    public static SignatureValidator a(PublicKey publicKey, String algorithm) {
        return (updatable, signatureData) -> {
            try {
                Signature signature = Signature.getInstance(algorithm);
                signature.initVerify(publicKey);
                return SignatureValidator.a(updatable, signatureData, signature);
            }
            catch (Exception exception) {
                b.error("Failed to verify signature", (Throwable)exception);
                return false;
            }
        };
    }

    @Nullable
    public static SignatureValidator a(ServicesKeySet servicesKeySet, ServicesKeyType servicesKeyType) {
        Collection collection = servicesKeySet.keys(servicesKeyType);
        if (collection.isEmpty()) {
            return null;
        }
        return (updatable, signatureData) -> collection.stream().anyMatch(keyInfo -> {
            Signature signature = keyInfo.signature();
            try {
                return SignatureValidator.a(updatable, signatureData, signature);
            }
            catch (SignatureException signatureException) {
                b.error("Failed to verify Services signature", (Throwable)signatureException);
                return false;
            }
        });
    }
}

