/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.util.DataBits;
import net.minecraft.world.level.chunk.DataPalette;
import org.apache.commons.lang3.Validate;

public class SimpleBitStorage
implements DataBits {
    private static final int[] a = new int[]{-1, -1, 0, Integer.MIN_VALUE, 0, 0, 0x55555555, 0x55555555, 0, Integer.MIN_VALUE, 0, 1, 0x33333333, 0x33333333, 0, 0x2AAAAAAA, 0x2AAAAAAA, 0, 0x24924924, 0x24924924, 0, Integer.MIN_VALUE, 0, 2, 0x1C71C71C, 0x1C71C71C, 0, 0x19999999, 0x19999999, 0, 390451572, 390451572, 0, 0x15555555, 0x15555555, 0, 0x13B13B13, 0x13B13B13, 0, 306783378, 306783378, 0, 0x11111111, 0x11111111, 0, Integer.MIN_VALUE, 0, 3, 0xF0F0F0F, 0xF0F0F0F, 0, 0xE38E38E, 0xE38E38E, 0, 226050910, 226050910, 0, 0xCCCCCCC, 0xCCCCCCC, 0, 0xC30C30C, 0xC30C30C, 0, 195225786, 195225786, 0, 186737708, 186737708, 0, 0xAAAAAAA, 0xAAAAAAA, 0, 171798691, 171798691, 0, 0x9D89D89, 0x9D89D89, 0, 159072862, 159072862, 0, 0x9249249, 0x9249249, 0, 148102320, 148102320, 0, 0x8888888, 0x8888888, 0, 138547332, 138547332, 0, Integer.MIN_VALUE, 0, 4, 130150524, 130150524, 0, 0x7878787, 0x7878787, 0, 0x7507507, 0x7507507, 0, 0x71C71C7, 0x71C71C7, 0, 116080197, 116080197, 0, 113025455, 113025455, 0, 0x6906906, 0x6906906, 0, 0x6666666, 0x6666666, 0, 104755299, 104755299, 0, 0x6186186, 0x6186186, 0, 99882960, 99882960, 0, 97612893, 97612893, 0, 0x5B05B05, 0x5B05B05, 0, 93368854, 93368854, 0, 91382282, 91382282, 0, 0x5555555, 0x5555555, 0, 87652393, 87652393, 0, 85899345, 85899345, 0, 0x5050505, 0x5050505, 0, 0x4EC4EC4, 0x4EC4EC4, 0, 81037118, 81037118, 0, 79536431, 79536431, 0, 78090314, 78090314, 0, 0x4924924, 0x4924924, 0, 75350303, 75350303, 0, 74051160, 74051160, 0, 72796055, 72796055, 0, 0x4444444, 0x4444444, 0, 70409299, 70409299, 0, 69273666, 69273666, 0, 0x4104104, 0x4104104, 0, Integer.MIN_VALUE, 0, 5};
    private final long[] b;
    private final int c;
    private final long d;
    private final int e;
    private final int f;
    private final int g;
    private final long divideMulUnsigned;
    private final int h;
    private final long divideAddUnsigned;
    private final int i;

    public SimpleBitStorage(int elementBits, int size, int[] data) {
        this(elementBits, size);
        int j2;
        int i2 = 0;
        for (j2 = 0; j2 <= size - this.f; j2 += this.f) {
            long l2 = 0L;
            for (int k2 = this.f - 1; k2 >= 0; --k2) {
                l2 <<= elementBits;
                l2 |= (long)data[j2 + k2] & this.d;
            }
            this.b[i2++] = l2;
        }
        int m2 = size - j2;
        if (m2 > 0) {
            long n2 = 0L;
            for (int o2 = m2 - 1; o2 >= 0; --o2) {
                n2 <<= elementBits;
                n2 |= (long)data[j2 + o2] & this.d;
            }
            this.b[i2] = n2;
        }
    }

    public SimpleBitStorage(int elementBits, int size) {
        this(elementBits, size, (long[])null);
    }

    public SimpleBitStorage(int elementBits, int size, @Nullable long[] data) {
        Validate.inclusiveBetween((long)1L, (long)32L, (long)elementBits);
        this.e = size;
        this.c = elementBits;
        this.d = (1L << elementBits) - 1L;
        this.f = (char)(64 / elementBits);
        int i2 = 3 * (this.f - 1);
        this.g = a[i2 + 0];
        this.divideMulUnsigned = Integer.toUnsignedLong(this.g);
        this.h = a[i2 + 1];
        this.divideAddUnsigned = Integer.toUnsignedLong(this.h);
        this.i = a[i2 + 2];
        int j2 = (size + this.f - 1) / this.f;
        if (data != null) {
            if (data.length != j2) {
                throw new a("Invalid length given for storage, got: " + data.length + " but expected: " + j2);
            }
            this.b = data;
        } else {
            this.b = new long[j2];
        }
    }

    private int b(int index) {
        return (int)((long)index * this.divideMulUnsigned + this.divideAddUnsigned >> 32 >> this.i);
    }

    @Override
    public final int a(int index, int value) {
        int i2 = this.b(index);
        long l2 = this.b[i2];
        int j2 = (index - i2 * this.f) * this.c;
        int k2 = (int)(l2 >> j2 & this.d);
        this.b[i2] = l2 & (this.d << j2 ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.d) << j2;
        return k2;
    }

    @Override
    public final void b(int index, int value) {
        int i2 = this.b(index);
        long l2 = this.b[i2];
        int j2 = (index - i2 * this.f) * this.c;
        this.b[i2] = l2 & (this.d << j2 ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.d) << j2;
    }

    @Override
    public final int a(int index) {
        int i2 = this.b(index);
        long l2 = this.b[i2];
        int j2 = (index - i2 * this.f) * this.c;
        return (int)(l2 >> j2 & this.d);
    }

    @Override
    public long[] a() {
        return this.b;
    }

    @Override
    public int b() {
        return this.e;
    }

    @Override
    public int c() {
        return this.c;
    }

    @Override
    public final void forEach(DataBits.DataBitConsumer consumer) {
        int i2 = 0;
        for (long l2 : this.b) {
            for (int i1 = 0; i1 < this.f; ++i1) {
                consumer.accept(i2, (int)(l2 & this.d));
                l2 >>= this.c;
                if (++i2 < this.e) continue;
                return;
            }
        }
    }

    @Override
    public void a(IntConsumer action) {
        int i2 = 0;
        for (long l2 : this.b) {
            for (int j2 = 0; j2 < this.f; ++j2) {
                action.accept((int)(l2 & this.d));
                l2 >>= this.c;
                if (++i2 < this.e) continue;
                return;
            }
        }
    }

    @Override
    public void a(int[] out) {
        int i2 = this.b.length;
        int j2 = 0;
        for (int k2 = 0; k2 < i2 - 1; ++k2) {
            long l2 = this.b[k2];
            for (int m2 = 0; m2 < this.f; ++m2) {
                out[j2 + m2] = (int)(l2 & this.d);
                l2 >>= this.c;
            }
            j2 += this.f;
        }
        int n2 = this.e - j2;
        if (n2 > 0) {
            long o2 = this.b[i2 - 1];
            for (int p2 = 0; p2 < n2; ++p2) {
                out[j2 + p2] = (int)(o2 & this.d);
                o2 >>= this.c;
            }
        }
    }

    @Override
    public DataBits d() {
        return new SimpleBitStorage(this.c, this.e, (long[])this.b.clone());
    }

    @Override
    public <T> void compact(DataPalette<T> srcPalette, DataPalette<T> dstPalette, short[] out) {
        if (this.e >= Short.MAX_VALUE) {
            throw new IllegalStateException("Array too large");
        }
        if (this.e != out.length) {
            throw new IllegalStateException("Array size mismatch");
        }
        short[] mappings = new short[(int)(this.d + 1L)];
        int idx = 0;
        long[] lArray = this.b;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long word;
            long bits = word = lArray[i2];
            for (int elementIdx = 0; elementIdx < this.f; ++elementIdx) {
                int value = (int)(bits & this.d);
                int remappedId = mappings[value];
                if (remappedId == 0) {
                    remappedId = dstPalette.a(srcPalette.a(value)) + 1;
                    mappings[value] = (short)remappedId;
                }
                out[idx] = (short)(remappedId - 1);
                bits >>= this.c;
                if (++idx < this.e) continue;
                return;
            }
        }
    }

    public static class a
    extends RuntimeException {
        a(String message) {
            super(message);
        }
    }
}

