/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DataConverterBedBlock
extends DataFix {
    public DataConverterBedBlock(Schema outputSchema, boolean changesType) {
        super(outputSchema, changesType);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(DataConverterTypes.c);
        Type type2 = type.findFieldType("Level");
        Type type3 = type2.findFieldType("TileEntities");
        if (!(type3 instanceof List.ListType)) {
            throw new IllegalStateException("Tile entity type is not a list type.");
        }
        List.ListType listType = (List.ListType)type3;
        return this.a(type2, listType);
    }

    private <TE> TypeRewriteRule a(Type<?> level, List.ListType<TE> blockEntities) {
        Type type = blockEntities.getElement();
        OpticFinder opticFinder = DSL.fieldFinder((String)"Level", level);
        OpticFinder opticFinder2 = DSL.fieldFinder((String)"TileEntities", blockEntities);
        int i2 = 416;
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhere("InjectBedBlockEntityType", (Type)this.getInputSchema().findChoiceType(DataConverterTypes.s), (Type)this.getOutputSchema().findChoiceType(DataConverterTypes.s), dynamicOps -> pair -> pair), (TypeRewriteRule)this.fixTypeEverywhereTyped("BedBlockEntityInjecter", this.getOutputSchema().getType(DataConverterTypes.c), typed -> {
            Typed typed2 = typed.getTyped(opticFinder);
            Dynamic dynamic = (Dynamic)((Object)((Object)typed2.get(DSL.remainderFinder())));
            int i2 = dynamic.get("xPos").asInt(0);
            int j2 = dynamic.get("zPos").asInt(0);
            ArrayList list = Lists.newArrayList((Iterable)((Iterable)typed2.getOrCreate(opticFinder2)));
            List list2 = dynamic.get("Sections").asList(Function.identity());
            for (Dynamic dynamic2 : list2) {
                int k2 = dynamic2.get("Y").asInt(0);
                Streams.mapWithIndex((IntStream)dynamic2.get("Blocks").asIntStream(), (l2, m2) -> {
                    if (416 == (l2 & 0xFF) << 4) {
                        int n2 = (int)m2;
                        int o2 = n2 & 0xF;
                        int p2 = n2 >> 8 & 0xF;
                        int q2 = n2 >> 4 & 0xF;
                        HashMap map = Maps.newHashMap();
                        map.put(dynamic2.createString("id"), dynamic2.createString("minecraft:bed"));
                        map.put(dynamic2.createString("x"), dynamic2.createInt(o2 + (i2 << 4)));
                        map.put(dynamic2.createString("y"), dynamic2.createInt(p2 + (k2 << 4)));
                        map.put(dynamic2.createString("z"), dynamic2.createInt(q2 + (j2 << 4)));
                        map.put(dynamic2.createString("color"), dynamic2.createShort((short)14));
                        return map;
                    }
                    return null;
                }).forEachOrdered(map -> {
                    if (map != null) {
                        list.add(((Pair)type.read(dynamic2.createMap((Map)map)).result().orElseThrow(() -> new IllegalStateException("Could not parse newly created bed block entity."))).getFirst());
                    }
                });
            }
            if (!list.isEmpty()) {
                return typed.set(opticFinder, typed2.set(opticFinder2, (Object)list));
            }
            return typed;
        }));
    }
}

