/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

public abstract class DataConverterUUIDBase
extends DataFix {
    protected DSL.TypeReference a;

    public DataConverterUUIDBase(Schema outputSchema, DSL.TypeReference typeReference) {
        super(outputSchema, false);
        this.a = typeReference;
    }

    protected Typed<?> a(Typed<?> typed2, String name, Function<Dynamic<?>, Dynamic<?>> updater) {
        Type type = this.getInputSchema().getChoiceType(this.a, name);
        Type type2 = this.getOutputSchema().getChoiceType(this.a, name);
        return typed2.updateTyped(DSL.namedChoice((String)name, (Type)type), type2, typed -> typed.update(DSL.remainderFinder(), updater));
    }

    protected static Optional<Dynamic<?>> a(Dynamic<?> dynamic, String oldKey, String newKey) {
        return DataConverterUUIDBase.a(dynamic, oldKey).map(dynamic2 -> dynamic.remove(oldKey).set(newKey, (Dynamic<?>)((Object)dynamic2)));
    }

    protected static Optional<Dynamic<?>> b(Dynamic<?> dynamic, String oldKey, String newKey) {
        return dynamic.get(oldKey).result().flatMap(DataConverterUUIDBase::a).map(dynamic2 -> dynamic.remove(oldKey).set(newKey, (Dynamic<?>)((Object)dynamic2)));
    }

    protected static Optional<Dynamic<?>> c(Dynamic<?> dynamic, String oldKey, String newKey) {
        String string = oldKey + "Most";
        String string2 = oldKey + "Least";
        return DataConverterUUIDBase.d(dynamic, string, string2).map(dynamic2 -> dynamic.remove(string).remove(string2).set(newKey, (Dynamic<?>)((Object)dynamic2)));
    }

    protected static Optional<Dynamic<?>> a(Dynamic<?> dynamic, String key) {
        return dynamic.get(key).result().flatMap(dynamic2 -> {
            String string = dynamic2.asString(null);
            if (string != null) {
                try {
                    UUID uUID = UUID.fromString(string);
                    return DataConverterUUIDBase.a(dynamic, uUID.getMostSignificantBits(), uUID.getLeastSignificantBits());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return Optional.empty();
        });
    }

    protected static Optional<Dynamic<?>> a(Dynamic<?> dynamic) {
        return DataConverterUUIDBase.d(dynamic, "M", "L");
    }

    protected static Optional<Dynamic<?>> d(Dynamic<?> dynamic, String mostBitsKey, String leastBitsKey) {
        long l2 = dynamic.get(mostBitsKey).asLong(0L);
        long m2 = dynamic.get(leastBitsKey).asLong(0L);
        if (l2 == 0L || m2 == 0L) {
            return Optional.empty();
        }
        return DataConverterUUIDBase.a(dynamic, l2, m2);
    }

    protected static Optional<Dynamic<?>> a(Dynamic<?> dynamic, long mostBits, long leastBits) {
        return Optional.of(dynamic.createIntList(Arrays.stream(new int[]{(int)(mostBits >> 32), (int)mostBits, (int)(leastBits >> 32), (int)leastBits})));
    }
}

