/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Streams;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.datafix.fixes.DataConverterNamedEntity;
import net.minecraft.util.datafix.fixes.DataConverterTypes;

public class DropInvalidSignDataFix
extends DataConverterNamedEntity {
    private static final String a = IChatBaseComponent.ChatSerializer.a(CommonComponents.a);
    private static final String[] b = new String[]{"Text1", "Text2", "Text3", "Text4", "FilteredText1", "FilteredText2", "FilteredText3", "FilteredText4", "Color", "GlowingText"};

    public DropInvalidSignDataFix(Schema outputSchema, String name, String blockEntityId) {
        super(outputSchema, false, name, DataConverterTypes.s, blockEntityId);
    }

    private static <T> Dynamic<T> a(Dynamic<T> blockEntityData) {
        blockEntityData = blockEntityData.update("front_text", DropInvalidSignDataFix::b);
        blockEntityData = blockEntityData.update("back_text", DropInvalidSignDataFix::b);
        for (String string : b) {
            blockEntityData = blockEntityData.remove(string);
        }
        return blockEntityData;
    }

    private static <T> Dynamic<T> b(Dynamic<T> textData) {
        boolean bl = textData.get("_filtered_correct").asBoolean(false);
        if (bl) {
            return textData.remove("_filtered_correct");
        }
        Optional optional = textData.get("filtered_messages").asStreamOpt().result();
        if (optional.isEmpty()) {
            return textData;
        }
        Dynamic dynamic = textData.createString(a);
        List<Dynamic> list = textData.get("messages").asStreamOpt().result().orElse(Stream.of(new Dynamic[0])).toList();
        List list2 = Streams.mapWithIndex((Stream)((Stream)optional.get()), (message, index) -> {
            Dynamic dynamic2 = index < (long)list.size() ? (Dynamic)((Object)((Object)list.get((int)index))) : dynamic;
            return message.equals((Object)dynamic) ? dynamic2 : message;
        }).toList();
        if (list2.stream().allMatch(message -> message.equals((Object)dynamic))) {
            return textData.remove("filtered_messages");
        }
        return textData.set("filtered_messages", textData.createList(list2.stream()));
    }

    @Override
    @Override
    protected Typed<?> a(Typed<?> inputType) {
        return inputType.update(DSL.remainderFinder(), DropInvalidSignDataFix::a);
    }
}

