/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.eventlog;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.util.eventlog.JsonEventLogReader;

public class JsonEventLog<T>
implements Closeable {
    private static final Gson a = new Gson();
    private final Codec<T> b;
    final FileChannel c;
    private final AtomicInteger d = new AtomicInteger(1);

    public JsonEventLog(Codec<T> codec, FileChannel channel) {
        this.b = codec;
        this.c = channel;
    }

    public static <T> JsonEventLog<T> a(Codec<T> codec, Path path) throws IOException {
        FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE);
        return new JsonEventLog<T>(codec, fileChannel);
    }

    public void a(T object) throws IOException, JsonIOException {
        JsonElement jsonElement = (JsonElement)SystemUtils.a(this.b.encodeStart((DynamicOps)JsonOps.INSTANCE, object), IOException::new);
        this.c.position(this.c.size());
        Writer writer = Channels.newWriter((WritableByteChannel)this.c, StandardCharsets.UTF_8);
        a.toJson(jsonElement, (Appendable)writer);
        writer.write(10);
        writer.flush();
    }

    public JsonEventLogReader<T> a() throws IOException {
        if (this.d.get() <= 0) {
            throw new IOException("Event log has already been closed");
        }
        this.d.incrementAndGet();
        final JsonEventLogReader<T> jsonEventLogReader = JsonEventLogReader.a(this.b, Channels.newReader((ReadableByteChannel)this.c, StandardCharsets.UTF_8));
        return new JsonEventLogReader<T>(){
            private volatile long c;

            @Override
            @Nullable
            @Override
            public T a() throws IOException {
                try {
                    JsonEventLog.this.c.position(this.c);
                    Object t2 = jsonEventLogReader.a();
                    return t2;
                }
                finally {
                    this.c = JsonEventLog.this.c.position();
                }
            }

            @Override
            @Override
            public void close() throws IOException {
                JsonEventLog.this.b();
            }
        };
    }

    @Override
    @Override
    public void close() throws IOException {
        this.b();
    }

    void b() throws IOException {
        if (this.d.decrementAndGet() <= 0) {
            this.c.close();
        }
    }
}

