/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling.jfr.parse;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordingFile;
import net.minecraft.util.profiling.jfr.parse.JfrStatsResult;
import net.minecraft.util.profiling.jfr.stats.ChunkGenStat;
import net.minecraft.util.profiling.jfr.stats.CpuLoadStat;
import net.minecraft.util.profiling.jfr.stats.FileIOStat;
import net.minecraft.util.profiling.jfr.stats.GcHeapStat;
import net.minecraft.util.profiling.jfr.stats.NetworkPacketSummary;
import net.minecraft.util.profiling.jfr.stats.ThreadAllocationStat;
import net.minecraft.util.profiling.jfr.stats.TickTimeStat;

public class JfrStatsParser {
    private Instant a = Instant.EPOCH;
    private Instant b = Instant.EPOCH;
    private final List<ChunkGenStat> c = Lists.newArrayList();
    private final List<CpuLoadStat> d = Lists.newArrayList();
    private final Map<NetworkPacketSummary.b, a> e = Maps.newHashMap();
    private final Map<NetworkPacketSummary.b, a> f = Maps.newHashMap();
    private final List<FileIOStat> g = Lists.newArrayList();
    private final List<FileIOStat> h = Lists.newArrayList();
    private int i;
    private Duration j = Duration.ZERO;
    private final List<GcHeapStat> k = Lists.newArrayList();
    private final List<ThreadAllocationStat> l = Lists.newArrayList();
    private final List<TickTimeStat> m = Lists.newArrayList();
    @Nullable
    private Duration n = null;

    private JfrStatsParser(Stream<RecordedEvent> events) {
        this.a(events);
    }

    public static JfrStatsResult a(Path path) {
        JfrStatsResult jfrStatsResult;
        final RecordingFile recordingFile = new RecordingFile(path);
        try {
            Iterator<RecordedEvent> iterator = new Iterator<RecordedEvent>(){

                @Override
                @Override
                public boolean hasNext() {
                    return recordingFile.hasMoreEvents();
                }

                @Override
                public RecordedEvent a() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    try {
                        return recordingFile.readEvent();
                    }
                    catch (IOException iOException) {
                        throw new UncheckedIOException(iOException);
                    }
                }

                @Override
                public /* synthetic */ Object next() {
                    return this.a();
                }
            };
            Stream<RecordedEvent> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1297), false);
            jfrStatsResult = new JfrStatsParser(stream).a();
        }
        catch (Throwable throwable) {
            try {
                try {
                    recordingFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        }
        recordingFile.close();
        return jfrStatsResult;
    }

    private JfrStatsResult a() {
        Duration duration = Duration.between(this.a, this.b);
        return new JfrStatsResult(this.a, this.b, duration, this.n, this.m, this.d, GcHeapStat.a(duration, this.k, this.j, this.i), ThreadAllocationStat.a(this.l), JfrStatsParser.a(duration, this.e), JfrStatsParser.a(duration, this.f), FileIOStat.a(duration, this.g), FileIOStat.a(duration, this.h), this.c);
    }

    private void a(Stream<RecordedEvent> events) {
        events.forEach(event -> {
            if (event.getEndTime().isAfter(this.b) || this.b.equals(Instant.EPOCH)) {
                this.b = event.getEndTime();
            }
            if (event.getStartTime().isBefore(this.a) || this.a.equals(Instant.EPOCH)) {
                this.a = event.getStartTime();
            }
            switch (event.getEventType().getName()) {
                case "minecraft.ChunkGeneration": {
                    this.c.add(ChunkGenStat.a(event));
                    break;
                }
                case "minecraft.LoadWorld": {
                    this.n = event.getDuration();
                    break;
                }
                case "minecraft.ServerTickTime": {
                    this.m.add(TickTimeStat.a(event));
                    break;
                }
                case "minecraft.PacketReceived": {
                    this.a((RecordedEvent)event, event.getInt("bytes"), this.e);
                    break;
                }
                case "minecraft.PacketSent": {
                    this.a((RecordedEvent)event, event.getInt("bytes"), this.f);
                    break;
                }
                case "jdk.ThreadAllocationStatistics": {
                    this.l.add(ThreadAllocationStat.a(event));
                    break;
                }
                case "jdk.GCHeapSummary": {
                    this.k.add(GcHeapStat.a(event));
                    break;
                }
                case "jdk.CPULoad": {
                    this.d.add(CpuLoadStat.a(event));
                    break;
                }
                case "jdk.FileWrite": {
                    this.a((RecordedEvent)event, this.g, "bytesWritten");
                    break;
                }
                case "jdk.FileRead": {
                    this.a((RecordedEvent)event, this.h, "bytesRead");
                    break;
                }
                case "jdk.GarbageCollection": {
                    ++this.i;
                    this.j = this.j.plus(event.getDuration());
                    break;
                }
            }
        });
    }

    private void a(RecordedEvent event, int bytes, Map<NetworkPacketSummary.b, a> packetsToCounter) {
        packetsToCounter.computeIfAbsent(NetworkPacketSummary.b.a(event), packet -> new a()).a(bytes);
    }

    private void a(RecordedEvent event, List<FileIOStat> samples, String bytesKey) {
        samples.add(new FileIOStat(event.getDuration(), event.getString("path"), event.getLong(bytesKey)));
    }

    private static NetworkPacketSummary a(Duration duration, Map<NetworkPacketSummary.b, a> packetsToCounter) {
        List<Pair<NetworkPacketSummary.b, NetworkPacketSummary.a>> list = packetsToCounter.entrySet().stream().map(entry -> Pair.of((Object)((NetworkPacketSummary.b)entry.getKey()), (Object)((a)entry.getValue()).a())).toList();
        return new NetworkPacketSummary(duration, list);
    }

    public static final class a {
        private long a;
        private long b;

        public void a(int bytes) {
            this.b += (long)bytes;
            ++this.a;
        }

        public NetworkPacketSummary.a a() {
            return new NetworkPacketSummary.a(this.a, this.b);
        }
    }
}

