/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.FloatProviderType;

public class ClampedNormalFloat
extends FloatProvider {
    public static final Codec<ClampedNormalFloat> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("mean").forGetter(provider -> Float.valueOf(provider.b)), (App)Codec.FLOAT.fieldOf("deviation").forGetter(provider -> Float.valueOf(provider.d)), (App)Codec.FLOAT.fieldOf("min").forGetter(provider -> Float.valueOf(provider.e)), (App)Codec.FLOAT.fieldOf("max").forGetter(provider -> Float.valueOf(provider.f))).apply((Applicative)instance, ClampedNormalFloat::new)).comapFlatMap(provider -> {
        if (provider.f < provider.e) {
            return DataResult.error(() -> "Max must be larger than min: [" + clampedNormalFloat.e + ", " + clampedNormalFloat.f + "]");
        }
        return DataResult.success((Object)provider);
    }, Function.identity());
    private final float b;
    private final float d;
    private final float e;
    private final float f;

    public static ClampedNormalFloat a(float mean, float deviation, float min, float max) {
        return new ClampedNormalFloat(mean, deviation, min, max);
    }

    private ClampedNormalFloat(float mean, float deviation, float min, float max) {
        this.b = mean;
        this.d = deviation;
        this.e = min;
        this.f = max;
    }

    @Override
    @Override
    public float a(RandomSource random) {
        return ClampedNormalFloat.a(random, this.b, this.d, this.e, this.f);
    }

    public static float a(RandomSource random, float mean, float deviation, float min, float max) {
        return MathHelper.a(MathHelper.c(random, mean, deviation), min, max);
    }

    @Override
    @Override
    public float a() {
        return this.e;
    }

    @Override
    @Override
    public float b() {
        return this.f;
    }

    @Override
    @Override
    public FloatProviderType<?> c() {
        return FloatProviderType.c;
    }

    @Override
    public String toString() {
        return "normal(" + this.b + ", " + this.d + ") in [" + this.e + "-" + this.f + "]";
    }
}

