/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.ComparisonChain;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityLiving;
import org.slf4j.Logger;

public class MobEffect
implements Comparable<MobEffect> {
    private static final Logger b = LogUtils.getLogger();
    public static final int a = -1;
    private static final String c = "id";
    private static final String d = "ambient";
    private static final String e = "hidden_effect";
    private static final String f = "amplifier";
    private static final String g = "duration";
    private static final String h = "show_particles";
    private static final String i = "show_icon";
    private static final String j = "factor_calculation_data";
    private final MobEffectList k;
    private int l;
    private int m;
    private boolean n;
    private boolean o;
    private boolean p;
    @Nullable
    private MobEffect q;
    private final Optional<a> r;

    public MobEffect(MobEffectList type) {
        this(type, 0, 0);
    }

    public MobEffect(MobEffectList type, int duration) {
        this(type, duration, 0);
    }

    public MobEffect(MobEffectList type, int duration, int amplifier) {
        this(type, duration, amplifier, false, true);
    }

    public MobEffect(MobEffectList type, int duration, int amplifier, boolean ambient, boolean visible) {
        this(type, duration, amplifier, ambient, visible, visible);
    }

    public MobEffect(MobEffectList type, int duration, int amplifier, boolean ambient, boolean showParticles, boolean showIcon) {
        this(type, duration, amplifier, ambient, showParticles, showIcon, null, type.b());
    }

    public MobEffect(MobEffectList type, int duration, int amplifier, boolean ambient, boolean showParticles, boolean showIcon, @Nullable MobEffect hiddenEffect, Optional<a> factorCalculationData) {
        this.k = type;
        this.l = duration;
        this.m = amplifier;
        this.n = ambient;
        this.o = showParticles;
        this.p = showIcon;
        this.q = hiddenEffect;
        this.r = factorCalculationData;
    }

    public MobEffect(MobEffect instance) {
        this.k = instance.k;
        this.r = this.k.b();
        this.a(instance);
    }

    public Optional<a> a() {
        return this.r;
    }

    void a(MobEffect that) {
        this.l = that.l;
        this.m = that.m;
        this.n = that.n;
        this.o = that.o;
        this.p = that.p;
    }

    public boolean b(MobEffect that) {
        if (this.k != that.k) {
            b.warn("This method should only be called for matching effects!");
        }
        boolean bl = false;
        if (that.m > this.m) {
            if (that.d(this)) {
                MobEffect mobEffectInstance = this.q;
                this.q = new MobEffect(this);
                this.q.q = mobEffectInstance;
            }
            this.m = that.m;
            this.l = that.l;
            bl = true;
        } else if (this.d(that)) {
            if (that.m == this.m) {
                this.l = that.l;
                bl = true;
            } else if (this.q == null) {
                this.q = new MobEffect(that);
            } else {
                this.q.b(that);
            }
        }
        if (!that.n && this.n || bl) {
            this.n = that.n;
            bl = true;
        }
        if (that.o != this.o) {
            this.o = that.o;
            bl = true;
        }
        if (that.p != this.p) {
            this.p = that.p;
            bl = true;
        }
        return bl;
    }

    private boolean d(MobEffect effect) {
        return !this.b() && (this.l < effect.l || effect.b());
    }

    public boolean b() {
        return this.l == -1;
    }

    public boolean a(int duration) {
        return !this.b() && this.l <= duration;
    }

    public int a(Int2IntFunction mapper) {
        return !this.b() && this.l != 0 ? mapper.applyAsInt(this.l) : this.l;
    }

    public MobEffectList c() {
        return this.k;
    }

    public int d() {
        return this.l;
    }

    public int e() {
        return this.m;
    }

    public boolean f() {
        return this.n;
    }

    public boolean g() {
        return this.o;
    }

    public boolean h() {
        return this.p;
    }

    public boolean a(EntityLiving entity, Runnable overwriteCallback) {
        if (this.j()) {
            int i2;
            int n2 = i2 = this.b() ? entity.ah : this.l;
            if (this.k.a(i2, this.m)) {
                this.k.a(entity, this.m);
            }
            this.k();
            if (this.l == 0 && this.q != null) {
                this.a(this.q);
                this.q = this.q.q;
                overwriteCallback.run();
            }
        }
        this.r.ifPresent(factorCalculationData -> factorCalculationData.a(this));
        return this.j();
    }

    private boolean j() {
        return this.b() || this.l > 0;
    }

    private int k() {
        if (this.q != null) {
            this.q.k();
        }
        this.l = this.a(duration -> duration - 1);
        return this.l;
    }

    public void a(EntityLiving entity) {
        this.k.b(entity, this.m);
    }

    public String i() {
        return this.k.d();
    }

    public String toString() {
        String string = this.m > 0 ? this.i() + " x " + (this.m + 1) + ", Duration: " + this.l() : this.i() + ", Duration: " + this.l();
        if (!this.o) {
            string = string + ", Particles: false";
        }
        if (!this.p) {
            string = string + ", Show Icon: false";
        }
        return string;
    }

    private String l() {
        return this.b() ? "infinite" : Integer.toString(this.l);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MobEffect)) {
            return false;
        }
        MobEffect mobEffectInstance = (MobEffect)object;
        return this.l == mobEffectInstance.l && this.m == mobEffectInstance.m && this.n == mobEffectInstance.n && this.k.equals(mobEffectInstance.k);
    }

    public int hashCode() {
        int i2 = this.k.hashCode();
        i2 = 31 * i2 + this.l;
        i2 = 31 * i2 + this.m;
        return 31 * i2 + (this.n ? 1 : 0);
    }

    public NBTTagCompound a(NBTTagCompound nbt) {
        MinecraftKey resourceLocation = BuiltInRegistries.e.b(this.k);
        nbt.a(c, resourceLocation.toString());
        this.c(nbt);
        return nbt;
    }

    private void c(NBTTagCompound nbt) {
        nbt.a(f, (byte)this.e());
        nbt.a(g, this.d());
        nbt.a(d, this.f());
        nbt.a(h, this.g());
        nbt.a(i, this.h());
        if (this.q != null) {
            NBTTagCompound compoundTag = new NBTTagCompound();
            this.q.a(compoundTag);
            nbt.a(e, compoundTag);
        }
        this.r.ifPresent(factorCalculationData -> net.minecraft.world.effect.MobEffect$a.a.encodeStart((DynamicOps)DynamicOpsNBT.a, factorCalculationData).resultOrPartial(arg_0 -> ((Logger)b).error(arg_0)).ifPresent(factorCalculationDataNbt -> nbt.a(j, (NBTBase)factorCalculationDataNbt)));
    }

    @Nullable
    public static MobEffect b(NBTTagCompound nbt) {
        String string = nbt.l(c);
        MobEffectList mobEffect = BuiltInRegistries.e.a(MinecraftKey.a(string));
        return mobEffect == null ? null : MobEffect.a(mobEffect, nbt);
    }

    private static MobEffect a(MobEffectList type, NBTTagCompound nbt) {
        int i2 = Byte.toUnsignedInt(nbt.f(f));
        int j2 = nbt.h(g);
        boolean bl = nbt.q(d);
        boolean bl2 = true;
        if (nbt.b(h, 1)) {
            bl2 = nbt.q(h);
        }
        boolean bl3 = bl2;
        if (nbt.b(i, 1)) {
            bl3 = nbt.q(i);
        }
        MobEffect mobEffectInstance = null;
        if (nbt.b(e, 10)) {
            mobEffectInstance = MobEffect.a(type, nbt.p(e));
        }
        Optional optional = nbt.b(j, 10) ? net.minecraft.world.effect.MobEffect$a.a.parse(new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbt.p(j))).resultOrPartial(arg_0 -> ((Logger)b).error(arg_0)) : Optional.empty();
        return new MobEffect(type, j2, Math.max(i2, 0), bl, bl2, bl3, mobEffectInstance, optional);
    }

    public int c(MobEffect mobEffectInstance) {
        int i2 = 32147;
        return !(this.d() > 32147 && mobEffectInstance.d() > 32147 || this.f() && mobEffectInstance.f()) ? ComparisonChain.start().compareFalseFirst(this.f(), mobEffectInstance.f()).compareFalseFirst(this.b(), mobEffectInstance.b()).compare(this.d(), mobEffectInstance.d()).compare(this.c().g(), mobEffectInstance.c().g()).result() : ComparisonChain.start().compare(Boolean.valueOf(this.f()), Boolean.valueOf(mobEffectInstance.f())).compare(this.c().g(), mobEffectInstance.c().g()).result();
    }

    public static class a {
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.i.fieldOf("padding_duration").forGetter(data -> data.b), (App)Codec.FLOAT.fieldOf("factor_start").orElse((Object)Float.valueOf(0.0f)).forGetter(data -> Float.valueOf(data.c)), (App)Codec.FLOAT.fieldOf("factor_target").orElse((Object)Float.valueOf(1.0f)).forGetter(data -> Float.valueOf(data.d)), (App)Codec.FLOAT.fieldOf("factor_current").orElse((Object)Float.valueOf(0.0f)).forGetter(data -> Float.valueOf(data.e)), (App)ExtraCodecs.i.fieldOf("ticks_active").orElse((Object)0).forGetter(data -> data.f), (App)Codec.FLOAT.fieldOf("factor_previous_frame").orElse((Object)Float.valueOf(0.0f)).forGetter(data -> Float.valueOf(data.g)), (App)Codec.BOOL.fieldOf("had_effect_last_tick").orElse((Object)false).forGetter(data -> data.h)).apply((Applicative)instance, a::new));
        private final int b;
        private float c;
        private float d;
        private float e;
        private int f;
        private float g;
        private boolean h;

        public a(int paddingDuration, float factorStart, float factorTarget, float factorCurrent, int effectChangedTimestamp, float factorPreviousFrame, boolean hadEffectLastTick) {
            this.b = paddingDuration;
            this.c = factorStart;
            this.d = factorTarget;
            this.e = factorCurrent;
            this.f = effectChangedTimestamp;
            this.g = factorPreviousFrame;
            this.h = hadEffectLastTick;
        }

        public a(int paddingDuration) {
            this(paddingDuration, 0.0f, 1.0f, 0.0f, 0, 0.0f, false);
        }

        public void a(MobEffect effect) {
            this.g = this.e;
            boolean bl = !effect.a(this.b);
            ++this.f;
            if (this.h != bl) {
                this.h = bl;
                this.f = 0;
                this.c = this.e;
                this.d = bl ? 1.0f : 0.0f;
            }
            float f2 = MathHelper.a((float)this.f / (float)this.b, 0.0f, 1.0f);
            this.e = MathHelper.i(f2, this.c, this.d);
        }

        public float a(EntityLiving entity, float tickDelta) {
            if (entity.dG()) {
                this.g = this.e;
            }
            return MathHelper.i(tickDelta, this.g, this.e);
        }
    }
}

