/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.util.Brightness;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.ColorUtil;
import net.minecraft.util.FormattedString;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.slf4j.Logger;

public abstract class Display
extends Entity {
    static final Logger p = LogUtils.getLogger();
    public static final int b = -1;
    private static final DataWatcherObject<Integer> q = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> r = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Integer> s = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Vector3f> t = DataWatcher.a(Display.class, DataWatcherRegistry.A);
    private static final DataWatcherObject<Vector3f> u = DataWatcher.a(Display.class, DataWatcherRegistry.A);
    private static final DataWatcherObject<Quaternionf> v = DataWatcher.a(Display.class, DataWatcherRegistry.B);
    private static final DataWatcherObject<Quaternionf> aE = DataWatcher.a(Display.class, DataWatcherRegistry.B);
    private static final DataWatcherObject<Byte> aF = DataWatcher.a(Display.class, DataWatcherRegistry.a);
    private static final DataWatcherObject<Integer> aG = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Float> aH = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aI = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aJ = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aK = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Float> aL = DataWatcher.a(Display.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> aM = DataWatcher.a(Display.class, DataWatcherRegistry.b);
    private static final IntSet aN = IntSet.of((int[])new int[]{t.a(), u.a(), v.a(), aE.a(), aF.a(), aG.a(), aI.a(), aJ.a()});
    private static final float aO = 0.0f;
    private static final float aP = 1.0f;
    private static final int aQ = -1;
    public static final String c = "teleport_duration";
    public static final String d = "interpolation_duration";
    public static final String e = "start_interpolation";
    public static final String f = "transformation";
    public static final String g = "billboard";
    public static final String h = "brightness";
    public static final String i = "view_range";
    public static final String j = "shadow_radius";
    public static final String k = "shadow_strength";
    public static final String l = "width";
    public static final String m = "height";
    public static final String n = "glow_color_override";
    private long aR = Integer.MIN_VALUE;
    private int aS;
    private float aT;
    private AxisAlignedBB aU;
    protected boolean o;
    private boolean aV;
    private boolean aW;
    @Nullable
    private k aX;
    @Nullable
    private j aY;

    public Display(EntityTypes<?> type, World world) {
        super(type, world);
        this.af = true;
        this.at = true;
        this.aU = this.cG();
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (aL.equals(data) || aK.equals(data)) {
            this.G();
        }
        if (q.equals(data)) {
            this.aV = true;
        }
        if (r.equals(data)) {
            this.aW = true;
        }
        if (aN.contains(data.a())) {
            this.o = true;
        }
    }

    public static Transformation a(DataWatcher dataTracker) {
        Vector3f vector3f = dataTracker.b(t);
        Quaternionf quaternionf = dataTracker.b(v);
        Vector3f vector3f2 = dataTracker.b(u);
        Quaternionf quaternionf2 = dataTracker.b(aE);
        return new Transformation(vector3f, quaternionf, vector3f2, quaternionf2);
    }

    @Override
    public void l() {
        Entity entity = this.cY();
        if (entity != null && entity.dG()) {
            this.aa();
        }
        if (this.dL().B) {
            if (this.aV) {
                this.aV = false;
                int i2 = this.t();
                this.aR = this.ah + i2;
            }
            if (this.aW) {
                this.aW = false;
                this.aS = this.s();
            }
            if (this.o) {
                this.o = false;
                boolean bl = this.aS != 0;
                this.aX = bl && this.aX != null ? this.a(this.aX, this.aT) : this.H();
                this.a(bl, this.aT);
            }
            if (this.aY != null) {
                if (this.aY.a == 0) {
                    this.aY.a(this);
                    this.bn();
                    this.aY = null;
                } else {
                    this.aY.b(this);
                    --this.aY.a;
                    if (this.aY.a == 0) {
                        this.aY = null;
                    }
                }
            }
        }
    }

    protected abstract void a(boolean var1, float var2);

    @Override
    protected void a_() {
        this.an.a(s, 0);
        this.an.a(q, 0);
        this.an.a(r, 0);
        this.an.a(t, new Vector3f());
        this.an.a(u, new Vector3f(1.0f, 1.0f, 1.0f));
        this.an.a(aE, new Quaternionf());
        this.an.a(v, new Quaternionf());
        this.an.a(aF, BillboardConstraints.a.a());
        this.an.a(aG, -1);
        this.an.a(aH, Float.valueOf(1.0f));
        this.an.a(aI, Float.valueOf(0.0f));
        this.an.a(aJ, Float.valueOf(1.0f));
        this.an.a(aK, Float.valueOf(0.0f));
        this.an.a(aL, Float.valueOf(0.0f));
        this.an.a(aM, -1);
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.e(f)) {
            Transformation.b.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(f)).resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)p).error(arg_0))).ifPresent(pair -> this.a((Transformation)pair.getFirst()));
        }
        if (nbt.b(d, 99)) {
            int i2 = nbt.h(d);
            this.b(i2);
        }
        if (nbt.b(e, 99)) {
            int j2 = nbt.h(e);
            this.c(j2);
        }
        if (nbt.b(c, 99)) {
            int k2 = nbt.h(c);
            this.d(MathHelper.a(k2, 0, 59));
        }
        if (nbt.b(g, 8)) {
            BillboardConstraints.e.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(g)).resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)p).error(arg_0))).ifPresent(pair -> this.a((BillboardConstraints)pair.getFirst()));
        }
        if (nbt.b(i, 99)) {
            this.b(nbt.j(i));
        }
        if (nbt.b(j, 99)) {
            this.c(nbt.j(j));
        }
        if (nbt.b(k, 99)) {
            this.u(nbt.j(k));
        }
        if (nbt.b(l, 99)) {
            this.v(nbt.j(l));
        }
        if (nbt.b(m, 99)) {
            this.w(nbt.j(m));
        }
        if (nbt.b(n, 99)) {
            this.m(nbt.h(n));
        }
        if (nbt.b(h, 10)) {
            Brightness.b.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(h)).resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)p).error(arg_0))).ifPresent(pair -> this.a((Brightness)pair.getFirst()));
        } else {
            this.a((Brightness)null);
        }
    }

    public void a(Transformation transformation) {
        this.an.b(t, transformation.d());
        this.an.b(v, transformation.e());
        this.an.b(u, transformation.f());
        this.an.b(aE, transformation.g());
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        Transformation.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)Display.a(this.an)).result().ifPresent(transformations -> nbt.a(f, (NBTBase)transformations));
        BillboardConstraints.e.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.w()).result().ifPresent(billboard -> nbt.a(g, (NBTBase)billboard));
        nbt.a(d, this.s());
        nbt.a(c, this.v());
        nbt.a(i, this.z());
        nbt.a(j, this.A());
        nbt.a(k, this.B());
        nbt.a(l, this.C());
        nbt.a(m, this.F());
        nbt.a(n, this.E());
        Brightness brightness = this.x();
        if (brightness != null) {
            Brightness.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)brightness).result().ifPresent(brightnessx -> nbt.a(h, (NBTBase)brightnessx));
        }
    }

    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
        int i2 = this.v();
        this.aY = new j(i2, x2, y2, z2, yaw, pitch);
    }

    @Override
    public double n_() {
        return this.aY != null ? this.aY.b : this.dq();
    }

    @Override
    public double K_() {
        return this.aY != null ? this.aY.c : this.ds();
    }

    @Override
    public double L_() {
        return this.aY != null ? this.aY.d : this.dw();
    }

    @Override
    public float d_() {
        return this.aY != null ? (float)this.aY.f : this.dD();
    }

    @Override
    public float o_() {
        return this.aY != null ? (float)this.aY.e : this.dB();
    }

    @Override
    public AxisAlignedBB g_() {
        return this.aU;
    }

    @Override
    public EnumPistonReaction q_() {
        return EnumPistonReaction.d;
    }

    @Override
    public boolean p_() {
        return true;
    }

    @Nullable
    public k q() {
        return this.aX;
    }

    public void b(int interpolationDuration) {
        this.an.b(r, interpolationDuration);
    }

    public int s() {
        return this.an.b(r);
    }

    public void c(int startInterpolation) {
        this.an.a(q, startInterpolation, true);
    }

    public int t() {
        return this.an.b(q);
    }

    private void d(int teleportDuration) {
        this.an.b(s, teleportDuration);
    }

    private int v() {
        return this.an.b(s);
    }

    public void a(BillboardConstraints billboardMode) {
        this.an.b(aF, billboardMode.a());
    }

    public BillboardConstraints w() {
        return BillboardConstraints.f.apply(this.an.b(aF).byteValue());
    }

    public void a(@Nullable Brightness brightness) {
        this.an.b(aG, brightness != null ? brightness.a() : -1);
    }

    @Nullable
    public Brightness x() {
        int i2 = this.an.b(aG);
        return i2 != -1 ? Brightness.a(i2) : null;
    }

    private int y() {
        return this.an.b(aG);
    }

    public void b(float viewRange) {
        this.an.b(aH, Float.valueOf(viewRange));
    }

    public float z() {
        return this.an.b(aH).floatValue();
    }

    public void c(float shadowRadius) {
        this.an.b(aI, Float.valueOf(shadowRadius));
    }

    public float A() {
        return this.an.b(aI).floatValue();
    }

    public void u(float shadowStrength) {
        this.an.b(aJ, Float.valueOf(shadowStrength));
    }

    public float B() {
        return this.an.b(aJ).floatValue();
    }

    public void v(float width) {
        this.an.b(aK, Float.valueOf(width));
    }

    public float C() {
        return this.an.b(aK).floatValue();
    }

    public void w(float height) {
        this.an.b(aL, Float.valueOf(height));
    }

    public int E() {
        return this.an.b(aM);
    }

    public void m(int glowColorOverride) {
        this.an.b(aM, glowColorOverride);
    }

    public float a(float delta) {
        float h2;
        int i2 = this.aS;
        if (i2 <= 0) {
            return 1.0f;
        }
        float f2 = (long)this.ah - this.aR;
        float g2 = f2 + delta;
        this.aT = h2 = MathHelper.a(MathHelper.g(g2, 0.0f, i2), 0.0f, 1.0f);
        return h2;
    }

    public float F() {
        return this.an.b(aL).floatValue();
    }

    @Override
    public void e(double x2, double y2, double z2) {
        super.e(x2, y2, z2);
        this.G();
    }

    private void G() {
        float f2 = this.C();
        float g2 = this.F();
        if (f2 != 0.0f && g2 != 0.0f) {
            this.at = false;
            float h2 = f2 / 2.0f;
            double d2 = this.dq();
            double e2 = this.ds();
            double i2 = this.dw();
            this.aU = new AxisAlignedBB(d2 - (double)h2, e2, i2 - (double)h2, d2 + (double)h2, e2 + (double)g2, i2 + (double)h2);
        } else {
            this.at = true;
        }
    }

    @Override
    public boolean a(double distance) {
        return distance < MathHelper.k((double)this.z() * 64.0 * Display.cz());
    }

    @Override
    public int h_() {
        int i2 = this.E();
        return i2 != -1 ? i2 : super.h_();
    }

    private k H() {
        return new k(GenericInterpolator.constant(Display.a(this.an)), this.w(), this.y(), FloatInterpolator.constant(this.A()), FloatInterpolator.constant(this.B()), this.E());
    }

    private k a(k state, float lerpProgress) {
        Transformation transformation = state.a.get(lerpProgress);
        float f2 = state.d.get(lerpProgress);
        float g2 = state.e.get(lerpProgress);
        return new k(new m(transformation, Display.a(this.an)), this.w(), this.y(), new h(f2, this.A()), new h(g2, this.B()), this.E());
    }

    public record k(GenericInterpolator<Transformation> a, BillboardConstraints b, int c, FloatInterpolator d, FloatInterpolator e, int f) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{k.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{k.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{k.class, "transformation;billboardConstraints;brightnessOverride;shadowRadius;shadowStrength;glowColorOverride", "a", "b", "c", "d", "e", "f"}, this, o2);
        }
    }

    static class j {
        int a;
        final double b;
        final double c;
        final double d;
        final double e;
        final double f;

        j(int step, double x2, double y2, double z2, double yaw, double pitch) {
            this.a = step;
            this.b = x2;
            this.c = y2;
            this.d = z2;
            this.e = yaw;
            this.f = pitch;
        }

        void a(Entity entity) {
            entity.e(this.b, this.c, this.d);
            entity.a((float)this.e, (float)this.f);
        }

        void b(Entity entity) {
            entity.a(this.a, this.b, this.c, this.d, this.e, this.f);
        }
    }

    public static final class BillboardConstraints
    extends Enum<BillboardConstraints>
    implements INamable {
        public static final /* enum */ BillboardConstraints a = new BillboardConstraints(0, "fixed");
        public static final /* enum */ BillboardConstraints b = new BillboardConstraints(1, "vertical");
        public static final /* enum */ BillboardConstraints c = new BillboardConstraints(2, "horizontal");
        public static final /* enum */ BillboardConstraints d = new BillboardConstraints(3, "center");
        public static final Codec<BillboardConstraints> e;
        public static final IntFunction<BillboardConstraints> f;
        private final byte g;
        private final String h;
        private static final /* synthetic */ BillboardConstraints[] i;

        public static BillboardConstraints[] values() {
            return (BillboardConstraints[])i.clone();
        }

        public static BillboardConstraints valueOf(String name) {
            return Enum.valueOf(BillboardConstraints.class, name);
        }

        private BillboardConstraints(byte index, String name) {
            this.h = name;
            this.g = index;
        }

        @Override
        public String c() {
            return this.h;
        }

        byte a() {
            return this.g;
        }

        private static /* synthetic */ BillboardConstraints[] b() {
            return new BillboardConstraints[]{a, b, c, d};
        }

        static {
            i = BillboardConstraints.b();
            e = INamable.a(BillboardConstraints::values);
            f = ByIdMap.a(BillboardConstraints::a, BillboardConstraints.values(), ByIdMap.a.a);
        }
    }

    @FunctionalInterface
    public static interface GenericInterpolator<T> {
        public static <T> GenericInterpolator<T> constant(T value) {
            return delta -> value;
        }

        public T get(float var1);
    }

    @FunctionalInterface
    public static interface FloatInterpolator {
        public static FloatInterpolator constant(float value) {
            return delta -> value;
        }

        public float get(float var1);
    }

    record m(Transformation a, Transformation b) implements GenericInterpolator<Transformation>
    {
        public Transformation a(float f2) {
            return (double)f2 >= 1.0 ? this.b : this.a.a(this.b, f2);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{m.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{m.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{m.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    record h(float a, float b) implements FloatInterpolator
    {
        @Override
        public float get(float delta) {
            return MathHelper.i(delta, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{h.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    public static class TextDisplay
    extends Display {
        public static final String p = "text";
        private static final String aE = "line_width";
        private static final String aF = "text_opacity";
        private static final String aG = "background";
        private static final String aH = "shadow";
        private static final String aI = "see_through";
        private static final String aJ = "default_background";
        private static final String aK = "alignment";
        public static final byte q = 1;
        public static final byte r = 2;
        public static final byte s = 4;
        public static final byte t = 8;
        public static final byte u = 16;
        private static final byte aL = -1;
        public static final int v = 0x40000000;
        private static final DataWatcherObject<IChatBaseComponent> aM = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.f);
        public static final DataWatcherObject<Integer> aN = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.b);
        public static final DataWatcherObject<Integer> aO = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.b);
        private static final DataWatcherObject<Byte> aP = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.a);
        private static final DataWatcherObject<Byte> aQ = DataWatcher.a(TextDisplay.class, DataWatcherRegistry.a);
        private static final IntSet aR = IntSet.of((int[])new int[]{aM.a(), aN.a(), aO.a(), aP.a(), aQ.a()});
        @Nullable
        private CachedInfo aS;
        @Nullable
        private e aT;

        public TextDisplay(EntityTypes<?> type, World world) {
            super(type, world);
        }

        @Override
        protected void a_() {
            super.a_();
            this.an.a(aM, IChatBaseComponent.h());
            this.an.a(aN, 200);
            this.an.a(aO, 0x40000000);
            this.an.a(aP, (byte)-1);
            this.an.a(aQ, (byte)0);
        }

        @Override
        public void a(DataWatcherObject<?> data) {
            super.a(data);
            if (aR.contains(data.a())) {
                this.o = true;
            }
        }

        public IChatBaseComponent t() {
            return this.an.b(aM);
        }

        public void c(IChatBaseComponent text) {
            this.an.b(aM, text);
        }

        @Override
        public int v() {
            return this.an.b(aN);
        }

        @Override
        private void b(int lineWidth) {
            this.an.b(aN, lineWidth);
        }

        public byte w() {
            return this.an.b(aP);
        }

        public void c(byte textOpacity) {
            this.an.b(aP, textOpacity);
        }

        public int x() {
            return this.an.b(aO);
        }

        @Override
        private void c(int background) {
            this.an.b(aO, background);
        }

        public byte y() {
            return this.an.b(aQ);
        }

        public void d(byte flags) {
            this.an.b(aQ, flags);
        }

        private static byte a(byte flags, NBTTagCompound nbt, String nbtKey, byte flag) {
            return nbt.q(nbtKey) ? (byte)(flags | flag) : flags;
        }

        @Override
        protected void a(NBTTagCompound nbt) {
            super.a(nbt);
            if (nbt.b(aE, 99)) {
                this.b(nbt.h(aE));
            }
            if (nbt.b(aF, 99)) {
                this.c(nbt.f(aF));
            }
            if (nbt.b(aG, 99)) {
                this.c(nbt.h(aG));
            }
            byte b2 = TextDisplay.a((byte)0, nbt, aH, (byte)1);
            b2 = TextDisplay.a(b2, nbt, aI, (byte)2);
            b2 = TextDisplay.a(b2, nbt, aJ, (byte)4);
            Optional<Align> optional = Align.d.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(aK)).result().map(Pair::getFirst);
            if (optional.isPresent()) {
                b2 = switch (optional.get()) {
                    case Align.a -> b2;
                    case Align.b -> (byte)(b2 | 8);
                    case Align.c -> (byte)(b2 | 0x10);
                    default -> throw new IncompatibleClassChangeError();
                };
            }
            this.d(b2);
            if (nbt.b(p, 8)) {
                String string = nbt.l(p);
                try {
                    IChatMutableComponent component = IChatBaseComponent.ChatSerializer.a(string);
                    if (component != null) {
                        CommandListenerWrapper commandSourceStack = this.dc().a(2);
                        IChatMutableComponent component2 = ChatComponentUtils.a(commandSourceStack, component, (Entity)this, 0);
                        this.c(component2);
                    } else {
                        this.c(IChatBaseComponent.h());
                    }
                }
                catch (Exception var8) {
                    p.warn("Failed to parse display entity text {}", (Object)string, (Object)var8);
                }
            }
        }

        private static void b(byte flags, NBTTagCompound nbt, String nbtKey, byte flag) {
            nbt.a(nbtKey, (flags & flag) != 0);
        }

        @Override
        protected void b(NBTTagCompound nbt) {
            super.b(nbt);
            nbt.a(p, IChatBaseComponent.ChatSerializer.a(this.t()));
            nbt.a(aE, this.v());
            nbt.a(aG, this.x());
            nbt.a(aF, this.w());
            byte b2 = this.y();
            TextDisplay.b(b2, nbt, aH, (byte)1);
            TextDisplay.b(b2, nbt, aI, (byte)2);
            TextDisplay.b(b2, nbt, aJ, (byte)4);
            Align.d.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)TextDisplay.a(b2)).result().ifPresent(tag -> nbt.a(aK, (NBTBase)tag));
        }

        @Override
        protected void a(boolean shouldLerp, float lerpProgress) {
            this.aT = shouldLerp && this.aT != null ? this.a(this.aT, lerpProgress) : this.z();
            this.aS = null;
        }

        @Nullable
        public e s() {
            return this.aT;
        }

        private e z() {
            return new e(this.t(), this.v(), IntInterpolator.constant(this.w()), IntInterpolator.constant(this.x()), this.y());
        }

        private e a(e data, float lerpProgress) {
            int i2 = data.d.get(lerpProgress);
            int j2 = data.c.get(lerpProgress);
            return new e(this.t(), this.v(), new i(j2, this.w()), new ColorInterpolator(i2, this.x()), this.y());
        }

        public CachedInfo a(LineSplitter splitter) {
            if (this.aS == null) {
                this.aS = this.aT != null ? splitter.split(this.aT.a(), this.aT.b()) : new CachedInfo(List.of(), 0);
            }
            return this.aS;
        }

        public static Align a(byte flags) {
            if ((flags & 8) != 0) {
                return Align.b;
            }
            return (flags & 0x10) != 0 ? Align.c : Align.a;
        }

        public static final class Align
        extends Enum<Align>
        implements INamable {
            public static final /* enum */ Align a = new Align("center");
            public static final /* enum */ Align b = new Align("left");
            public static final /* enum */ Align c = new Align("right");
            public static final Codec<Align> d;
            private final String e;
            private static final /* synthetic */ Align[] f;

            public static Align[] values() {
                return (Align[])f.clone();
            }

            public static Align valueOf(String name) {
                return Enum.valueOf(Align.class, name);
            }

            private Align(String name) {
                this.e = name;
            }

            @Override
            public String c() {
                return this.e;
            }

            private static /* synthetic */ Align[] a() {
                return new Align[]{a, b, c};
            }

            static {
                f = Align.a();
                d = INamable.a(Align::values);
            }
        }

        public record e(IChatBaseComponent a, int b, IntInterpolator c, IntInterpolator d, byte e) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{e.class, "text;lineWidth;textOpacity;backgroundColor;flags", "a", "b", "c", "d", "e"}, this, o2);
            }
        }

        public record CachedInfo(List<CachedLine> a, int b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedInfo.class, "lines;width", "a", "b"}, this, o2);
            }
        }

        @FunctionalInterface
        public static interface LineSplitter {
            public CachedInfo split(IChatBaseComponent var1, int var2);
        }

        public record CachedLine(FormattedString a, int b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CachedLine.class, "contents;width", "a", "b"}, this, o2);
            }
        }
    }

    record i(int a, int b) implements IntInterpolator
    {
        @Override
        public int get(float delta) {
            return MathHelper.a(delta, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{i.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    public static class ItemDisplay
    extends Display {
        private static final String p = "item";
        private static final String q = "item_display";
        private static final DataWatcherObject<ItemStack> r = DataWatcher.a(ItemDisplay.class, DataWatcherRegistry.h);
        private static final DataWatcherObject<Byte> s = DataWatcher.a(ItemDisplay.class, DataWatcherRegistry.a);
        private final SlotAccess t = new SlotAccess(){

            @Override
            public ItemStack a() {
                return this.t();
            }

            @Override
            public boolean a(ItemStack stack) {
                this.a(stack);
                return true;
            }
        };
        @Nullable
        private a u;

        public ItemDisplay(EntityTypes<?> type, World world) {
            super(type, world);
        }

        @Override
        protected void a_() {
            super.a_();
            this.an.a(r, ItemStack.b);
            this.an.a(s, ItemDisplayContext.a.a());
        }

        @Override
        public void a(DataWatcherObject<?> data) {
            super.a(data);
            if (r.equals(data) || s.equals(data)) {
                this.o = true;
            }
        }

        public ItemStack t() {
            return this.an.b(r);
        }

        public void a(ItemStack stack) {
            this.an.b(r, stack);
        }

        public void a(ItemDisplayContext transformationMode) {
            this.an.b(s, transformationMode.a());
        }

        public ItemDisplayContext v() {
            return ItemDisplayContext.k.apply(this.an.b(s).byteValue());
        }

        @Override
        protected void a(NBTTagCompound nbt) {
            super.a(nbt);
            this.a(ItemStack.a(nbt.p(p)));
            if (nbt.b(q, 8)) {
                ItemDisplayContext.j.decode((DynamicOps)DynamicOpsNBT.a, (Object)nbt.c(q)).resultOrPartial(SystemUtils.a("Display entity", arg_0 -> ((Logger)p).error(arg_0))).ifPresent(mode -> this.a((ItemDisplayContext)mode.getFirst()));
            }
        }

        @Override
        protected void b(NBTTagCompound nbt) {
            super.b(nbt);
            nbt.a(p, this.t().b(new NBTTagCompound()));
            ItemDisplayContext.j.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.v()).result().ifPresent(nbtx -> nbt.a(q, (NBTBase)nbtx));
        }

        @Override
        public SlotAccess a_(int mappedIndex) {
            return mappedIndex == 0 ? this.t : SlotAccess.b;
        }

        @Nullable
        public a s() {
            return this.u;
        }

        @Override
        protected void a(boolean shouldLerp, float lerpProgress) {
            this.u = new a(this.t(), this.v());
        }

        public record a(ItemStack a, ItemDisplayContext b) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "itemStack;itemTransform", "a", "b"}, this, o2);
            }
        }
    }

    @FunctionalInterface
    public static interface IntInterpolator {
        public static IntInterpolator constant(int value) {
            return delta -> value;
        }

        public int get(float var1);
    }

    record ColorInterpolator(int a, int b) implements IntInterpolator
    {
        @Override
        public int get(float delta) {
            return ColorUtil.b.a(delta, this.a, this.b);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ColorInterpolator.class, "previous;current", "a", "b"}, this, o2);
        }
    }

    public static class BlockDisplay
    extends Display {
        public static final String p = "block_state";
        private static final DataWatcherObject<IBlockData> q = DataWatcher.a(BlockDisplay.class, DataWatcherRegistry.i);
        @Nullable
        private a r;

        public BlockDisplay(EntityTypes<?> type, World world) {
            super(type, world);
        }

        @Override
        protected void a_() {
            super.a_();
            this.an.a(q, Blocks.a.n());
        }

        @Override
        public void a(DataWatcherObject<?> data) {
            super.a(data);
            if (data.equals(q)) {
                this.o = true;
            }
        }

        public IBlockData t() {
            return this.an.b(q);
        }

        public void c(IBlockData state) {
            this.an.b(q, state);
        }

        @Override
        protected void a(NBTTagCompound nbt) {
            super.a(nbt);
            this.c(GameProfileSerializer.a(this.dL().a(Registries.e), nbt.p(p)));
        }

        @Override
        protected void b(NBTTagCompound nbt) {
            super.b(nbt);
            nbt.a(p, GameProfileSerializer.a(this.t()));
        }

        @Nullable
        public a s() {
            return this.r;
        }

        @Override
        protected void a(boolean shouldLerp, float lerpProgress) {
            this.r = new a(this.t());
        }

        public record a(IBlockData a) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blockState", "a"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blockState", "a"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blockState", "a"}, this, o2);
            }
        }
    }
}

