/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import io.papermc.paper.event.entity.TameableDeathMessageEvent;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.bukkit.entity.Tameable;

public abstract class EntityTameableAnimal
extends EntityAnimal
implements OwnableEntity {
    protected static final DataWatcherObject<Byte> bT = DataWatcher.a(EntityTameableAnimal.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Optional<UUID>> bU = DataWatcher.a(EntityTameableAnimal.class, DataWatcherRegistry.q);
    private boolean bW;

    protected EntityTameableAnimal(EntityTypes<? extends EntityTameableAnimal> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.t();
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(bT, (byte)0);
        this.an.a(bU, Optional.empty());
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.d() != null) {
            nbt.a("Owner", this.d());
        }
        nbt.a("Sitting", this.bW);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        UUID uUID;
        super.a(nbt);
        if (nbt.b("Owner")) {
            uUID = nbt.a("Owner");
        } else {
            String string = nbt.l("Owner");
            uUID = NameReferencingFileConverter.a(this.cK(), string);
        }
        if (uUID != null) {
            try {
                this.b(uUID);
                this.x(true);
            }
            catch (Throwable var4) {
                this.x(false);
            }
        }
        this.bW = nbt.q("Sitting");
        this.setInSittingPose(this.bW, false);
    }

    @Override
    public boolean a(EntityHuman player) {
        return !this.fR();
    }

    protected void w(boolean positive) {
        ParticleType particleOptions = Particles.M;
        if (!positive) {
            particleOptions = Particles.Z;
        }
        for (int i2 = 0; i2 < 7; ++i2) {
            double d2 = this.ag.k() * 0.02;
            double e2 = this.ag.k() * 0.02;
            double f2 = this.ag.k() * 0.02;
            this.dL().a(particleOptions, this.d(1.0), this.dt() + 0.5, this.g(1.0), d2, e2, f2);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 7) {
            this.w(true);
        } else if (status == 6) {
            this.w(false);
        } else {
            super.b(status);
        }
    }

    public boolean s() {
        return (this.an.b(bT) & 4) != 0;
    }

    public void x(boolean tamed) {
        byte b2 = this.an.b(bT);
        if (tamed) {
            this.an.b(bT, (byte)(b2 | 4));
        } else {
            this.an.b(bT, (byte)(b2 & 0xFFFFFFFB));
        }
        this.t();
    }

    protected void t() {
    }

    public boolean y() {
        return (this.an.b(bT) & 1) != 0;
    }

    public void y(boolean inSittingPose) {
        this.setInSittingPose(inSittingPose, true);
    }

    public void setInSittingPose(boolean inSittingPose, boolean callEvent) {
        if (callEvent && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), inSittingPose).callEvent()) {
            return;
        }
        byte b2 = this.an.b(bT);
        if (inSittingPose) {
            this.an.b(bT, (byte)(b2 | 1));
        } else {
            this.an.b(bT, (byte)(b2 & 0xFFFFFFFE));
        }
    }

    @Override
    @Nullable
    public UUID d() {
        return this.an.b(bU).orElse(null);
    }

    public void b(@Nullable UUID uuid) {
        this.an.b(bU, Optional.ofNullable(uuid));
    }

    public void f(EntityHuman player) {
        this.x(true);
        this.b(player.cv());
        if (player instanceof EntityPlayer) {
            CriterionTriggers.x.a((EntityPlayer)player, this);
        }
    }

    @Override
    public boolean c(EntityLiving target) {
        return this.j(target) ? false : super.c(target);
    }

    public boolean j(EntityLiving entity) {
        return entity == this.O_();
    }

    public boolean a(EntityLiving target, EntityLiving owner) {
        return true;
    }

    @Override
    public ScoreboardTeamBase cf() {
        EntityLiving livingEntity;
        if (this.s() && (livingEntity = this.O_()) != null) {
            return livingEntity.cf();
        }
        return super.cf();
    }

    @Override
    public boolean s(Entity other) {
        if (this.s()) {
            EntityLiving livingEntity = this.O_();
            if (other == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.s(other);
            }
        }
        return super.s(other);
    }

    @Override
    public void a(DamageSource damageSource) {
        TameableDeathMessageEvent event;
        if (!this.dL().B && this.dL().X().b(GameRules.m) && this.O_() instanceof EntityPlayer && (event = new TameableDeathMessageEvent((Tameable)this.getBukkitEntity(), PaperAdventure.asAdventure(this.eJ().a()))).callEvent()) {
            this.O_().a(PaperAdventure.asVanilla(event.deathMessage()));
        }
        super.a(damageSource);
    }

    public boolean gd() {
        return this.bW;
    }

    public void z(boolean sitting) {
        this.bW = sitting;
    }
}

