/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import org.slf4j.Logger;

public class AttributeModifier {
    private static final Logger a = LogUtils.getLogger();
    private final double b;
    private final Operation c;
    private final Supplier<String> d;
    private final UUID e;

    public AttributeModifier(String name, double value, Operation operation) {
        this(MathHelper.a(RandomSource.c()), () -> name, value, operation);
    }

    public AttributeModifier(UUID uuid, String name, double value, Operation operation) {
        this(uuid, () -> name, value, operation);
    }

    public AttributeModifier(UUID uuid, Supplier<String> nameGetter, double value, Operation operation) {
        this.e = uuid;
        this.d = nameGetter;
        this.b = value;
        this.c = operation;
    }

    public UUID a() {
        return this.e;
    }

    public String b() {
        return this.d.get();
    }

    public Operation c() {
        return this.c;
    }

    public double d() {
        return this.b;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AttributeModifier attributeModifier = (AttributeModifier)object;
        return Objects.equals(this.e, attributeModifier.e);
    }

    @Override
    public int hashCode() {
        return this.e.hashCode();
    }

    @Override
    public String toString() {
        return "AttributeModifier{amount=" + this.b + ", operation=" + this.c + ", name='" + this.d.get() + "', id=" + this.e + "}";
    }

    public NBTTagCompound e() {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("Name", this.b());
        compoundTag.a("Amount", this.b);
        compoundTag.a("Operation", this.c.a());
        compoundTag.a("UUID", this.e);
        return compoundTag;
    }

    @Nullable
    public static AttributeModifier a(NBTTagCompound nbt) {
        try {
            UUID uUID = nbt.a("UUID");
            Operation operation = Operation.a(nbt.h("Operation"));
            return new AttributeModifier(uUID, nbt.l("Name"), nbt.k("Amount"), operation);
        }
        catch (Exception exception) {
            a.warn("Unable to create attribute: {}", (Object)exception.getMessage());
            return null;
        }
    }

    public static final class Operation
    extends Enum<Operation>
    implements INamable {
        public static final /* enum */ Operation a = new Operation("addition", 0);
        public static final /* enum */ Operation b = new Operation("multiply_base", 1);
        public static final /* enum */ Operation c = new Operation("multiply_total", 2);
        private static final Operation[] e;
        public static final Codec<Operation> d;
        private final String f;
        private final int g;
        private static final /* synthetic */ Operation[] h;

        public static Operation[] values() {
            return (Operation[])h.clone();
        }

        public static Operation valueOf(String string) {
            return Enum.valueOf(Operation.class, string);
        }

        private Operation(String name, int id) {
            this.f = name;
            this.g = id;
        }

        public int a() {
            return this.g;
        }

        public static Operation a(int id) {
            if (id < 0 || id >= e.length) {
                throw new IllegalArgumentException("No operation with value " + id);
            }
            return e[id];
        }

        @Override
        @Override
        public String c() {
            return this.f;
        }

        private static /* synthetic */ Operation[] b() {
            return new Operation[]{a, b, c};
        }

        static {
            h = Operation.b();
            e = new Operation[]{a, b, c};
            d = INamable.a(Operation::values);
        }
    }
}

