/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom2;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;

public class LongJumpToRandomPos<E extends EntityInsentient>
extends Behavior<E> {
    protected static final int c = 20;
    private static final int m = 40;
    protected static final int d = 8;
    private static final int n = 200;
    private static final List<Integer> o = Lists.newArrayList((Object[])new Integer[]{65, 70, 75, 80});
    private final UniformInt p;
    protected final int e;
    protected final int f;
    protected final float g;
    protected List<a> h = Lists.newArrayList();
    protected Optional<Vec3D> i = Optional.empty();
    @Nullable
    protected Vec3D j;
    protected int k;
    protected long l;
    private final Function<E, SoundEffect> q;
    private final BiPredicate<E, BlockPosition> r;

    public LongJumpToRandomPos(UniformInt cooldownRange, int verticalRange, int horizontalRange, float maxRange, Function<E, SoundEffect> entityToSound) {
        this(cooldownRange, verticalRange, horizontalRange, maxRange, entityToSound, LongJumpToRandomPos::a);
    }

    public static <E extends EntityInsentient> boolean a(E entity, BlockPosition pos) {
        BlockPosition blockPos;
        World level = entity.dL();
        return level.a_(blockPos = pos.d()).i(level, blockPos) && entity.a(PathfinderNormal.a((IBlockAccess)level, pos.j())) == 0.0f;
    }

    public LongJumpToRandomPos(UniformInt cooldownRange, int verticalRange, int horizontalRange, float maxRange, Function<E, SoundEffect> entityToSound, BiPredicate<E, BlockPosition> jumpToPredicate) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.n, (Object)((Object)MemoryStatus.c), MemoryModuleType.R, (Object)((Object)MemoryStatus.b), MemoryModuleType.S, (Object)((Object)MemoryStatus.b)), 200);
        this.p = cooldownRange;
        this.e = verticalRange;
        this.f = horizontalRange;
        this.g = maxRange;
        this.q = entityToSound;
        this.r = jumpToPredicate;
    }

    @Override
    @Override
    protected boolean a(WorldServer world, EntityInsentient entity) {
        boolean bl;
        boolean bl2 = bl = entity.aA() && !entity.aX() && !entity.bl() && !world.a_(entity.dl()).a(Blocks.pg);
        if (!bl) {
            entity.dN().a(MemoryModuleType.R, Integer.valueOf(this.p.a(world.z) / 2));
        }
        return bl;
    }

    @Override
    protected boolean b(WorldServer serverLevel, EntityInsentient mob, long l2) {
        boolean bl;
        boolean bl2 = bl = this.i.isPresent() && this.i.get().equals(mob.dj()) && this.k > 0 && !mob.ba() && (this.j != null || !this.h.isEmpty());
        if (!bl && mob.dN().c(MemoryModuleType.S).isEmpty()) {
            mob.dN().a(MemoryModuleType.R, Integer.valueOf(this.p.a(serverLevel.z) / 2));
            mob.dN().b(MemoryModuleType.n);
        }
        return bl;
    }

    @Override
    protected void a(WorldServer serverLevel, E mob, long l2) {
        this.j = null;
        this.k = 20;
        this.i = Optional.of(((Entity)mob).dj());
        BlockPosition blockPos = ((Entity)mob).dl();
        int i2 = blockPos.u();
        int j2 = blockPos.v();
        int k2 = blockPos.w();
        this.h = BlockPosition.a(i2 - this.f, j2 - this.e, k2 - this.f, i2 + this.f, j2 + this.e, k2 + this.f).filter(blockPos2 -> !blockPos2.equals(blockPos)).map(blockPos2 -> new a(blockPos2.i(), MathHelper.c(blockPos.j((BaseBlockPosition)blockPos2)))).collect(Collectors.toCollection(Lists::newArrayList));
    }

    @Override
    @Override
    protected void c(WorldServer world, E entity, long time) {
        if (this.j != null) {
            if (time - this.l >= 40L) {
                ((Entity)entity).r(((EntityLiving)entity).aU);
                ((EntityLiving)entity).p(true);
                double d2 = this.j.f();
                double e2 = d2 + (double)((EntityLiving)entity).eZ();
                ((Entity)entity).f(this.j.a(e2 / d2));
                ((EntityLiving)entity).dN().a(MemoryModuleType.S, true);
                world.a(null, (Entity)entity, this.q.apply(entity), SoundCategory.g, 1.0f, 1.0f);
            }
        } else {
            --this.k;
            this.d(world, entity, time);
        }
    }

    @Override
    protected void d(WorldServer world, E entity, long time) {
        while (!this.h.isEmpty()) {
            Vec3D vec3;
            Vec3D vec32;
            a possibleJump;
            BlockPosition blockPos;
            Optional<a> optional = this.a(world);
            if (optional.isEmpty() || !this.a(world, entity, blockPos = (possibleJump = optional.get()).b()) || (vec32 = this.a((EntityInsentient)entity, vec3 = Vec3D.b(blockPos))) == null) continue;
            ((EntityLiving)entity).dN().a(MemoryModuleType.n, new BehaviorTarget(blockPos));
            NavigationAbstract pathNavigation = ((EntityInsentient)entity).L();
            PathEntity path = pathNavigation.a(blockPos, 0, 8);
            if (path != null && path.j()) continue;
            this.j = vec32;
            this.l = time;
            return;
        }
    }

    protected Optional<a> a(WorldServer world) {
        Optional<a> optional = WeightedRandom2.a(world.z, this.h);
        optional.ifPresent(this.h::remove);
        return optional;
    }

    private boolean a(WorldServer world, E entity, BlockPosition pos) {
        BlockPosition blockPos = ((Entity)entity).dl();
        int i2 = blockPos.u();
        int j2 = blockPos.w();
        if (i2 == pos.u() && j2 == pos.w()) {
            return false;
        }
        return this.r.test(entity, pos);
    }

    @Nullable
    protected Vec3D a(EntityInsentient entity, Vec3D pos) {
        ArrayList list = Lists.newArrayList(o);
        Collections.shuffle(list);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int i2 = (Integer)iterator.next();
            Vec3D vec3 = this.a(entity, pos, i2);
            if (vec3 == null) continue;
            return vec3;
        }
        return null;
    }

    @Nullable
    private Vec3D a(EntityInsentient entity, Vec3D pos, int range) {
        Vec3D vec3 = entity.dj();
        Vec3D vec32 = new Vec3D(pos.c - vec3.c, 0.0, pos.e - vec3.e).d().a(0.5);
        pos = pos.d(vec32);
        Vec3D vec33 = pos.d(vec3);
        float f2 = (float)range * (float)Math.PI / 180.0f;
        double d2 = Math.atan2(vec33.e, vec33.c);
        double e2 = vec33.a(0.0, vec33.d, 0.0).g();
        double g2 = Math.sqrt(e2);
        double h2 = vec33.d;
        double i2 = Math.sin(2.0f * f2);
        double j2 = 0.08;
        double k2 = Math.pow(Math.cos(f2), 2.0);
        double l2 = Math.sin(f2);
        double m2 = Math.cos(f2);
        double n2 = Math.sin(d2);
        double o2 = Math.cos(d2);
        double p2 = e2 * 0.08 / (g2 * i2 - 2.0 * h2 * k2);
        if (p2 < 0.0) {
            return null;
        }
        double q2 = Math.sqrt(p2);
        if (q2 > (double)this.g) {
            return null;
        }
        double r2 = q2 * m2;
        double s2 = q2 * l2;
        int t2 = MathHelper.c(g2 / r2) * 2;
        double u2 = 0.0;
        Vec3D vec34 = null;
        EntitySize entityDimensions = entity.a(EntityPose.g);
        for (int v2 = 0; v2 < t2 - 1; ++v2) {
            double w2 = l2 / m2 * (u2 += g2 / (double)t2) - Math.pow(u2, 2.0) * 0.08 / (2.0 * p2 * Math.pow(m2, 2.0));
            double x2 = u2 * o2;
            double y2 = u2 * n2;
            Vec3D vec35 = new Vec3D(vec3.c + x2, vec3.d + w2, vec3.e + y2);
            if (vec34 != null && !this.a(entity, entityDimensions, vec34, vec35)) {
                return null;
            }
            vec34 = vec35;
        }
        return new Vec3D(r2 * o2, s2, r2 * n2).a((double)0.95f);
    }

    private boolean a(EntityInsentient entity, EntitySize dimensions, Vec3D vec3, Vec3D vec32) {
        Vec3D vec33 = vec32.d(vec3);
        double d2 = Math.min(dimensions.a, dimensions.b);
        int i2 = MathHelper.c(vec33.f() / d2);
        Vec3D vec34 = vec33.d();
        Vec3D vec35 = vec3;
        for (int j2 = 0; j2 < i2; ++j2) {
            Vec3D vec3D = vec35 = j2 == i2 - 1 ? vec32 : vec35.e(vec34.a(d2 * (double)0.9f));
            if (entity.dL().a((Entity)entity, dimensions.a(vec35))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected /* synthetic */ boolean a(WorldServer world, EntityLiving entity, long time) {
        return this.b(world, (EntityInsentient)entity, time);
    }

    @Override
    protected /* synthetic */ void d(WorldServer world, EntityLiving entity, long time) {
        this.a(world, (E)((EntityInsentient)entity), time);
    }

    public static class a
    extends WeightedEntry.a {
        private final BlockPosition a;

        public a(BlockPosition pos, int weight) {
            super(weight);
            this.a = pos;
        }

        public BlockPosition b() {
            return this.a;
        }
    }
}

