/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.phys.Vec3D;

public class RamTarget
extends Behavior<Goat> {
    public static final int c = 200;
    public static final float d = 1.65f;
    private final Function<Goat, UniformInt> e;
    private final PathfinderTargetCondition f;
    private final float g;
    private final ToDoubleFunction<Goat> h;
    private Vec3D i;
    private final Function<Goat, SoundEffect> j;
    private final Function<Goat, SoundEffect> k;

    public RamTarget(Function<Goat, UniformInt> cooldownRangeFactory, PathfinderTargetCondition targetPredicate, float speed, ToDoubleFunction<Goat> strengthMultiplierFactory, Function<Goat, SoundEffect> impactSoundFactory, Function<Goat, SoundEffect> hornBreakSoundFactory) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.U, (Object)((Object)MemoryStatus.b), MemoryModuleType.V, (Object)((Object)MemoryStatus.a)), 200);
        this.e = cooldownRangeFactory;
        this.f = targetPredicate;
        this.g = speed;
        this.h = strengthMultiplierFactory;
        this.j = impactSoundFactory;
        this.k = hornBreakSoundFactory;
        this.i = Vec3D.b;
    }

    @Override
    protected boolean a(WorldServer world, Goat entity) {
        return entity.dN().a(MemoryModuleType.V);
    }

    @Override
    protected boolean a(WorldServer world, Goat entity, long time) {
        return entity.dN().a(MemoryModuleType.V);
    }

    @Override
    protected void b(WorldServer serverLevel, Goat goat, long l2) {
        BlockPosition blockPos = goat.dl();
        BehaviorController<Goat> brain = goat.dN();
        Vec3D vec3 = brain.c(MemoryModuleType.V).get();
        this.i = new Vec3D((double)blockPos.u() - vec3.a(), 0.0, (double)blockPos.w() - vec3.c()).d();
        brain.a(MemoryModuleType.m, new MemoryTarget(vec3, this.g, 0));
    }

    @Override
    protected void c(WorldServer world, Goat entity, long time) {
        List<EntityLiving> list = world.a(EntityLiving.class, this.f, entity, entity.cG());
        BehaviorController<Goat> brain = entity.dN();
        if (!list.isEmpty()) {
            EntityLiving livingEntity = list.get(0);
            livingEntity.a(world.ag().c(entity), (float)entity.b(GenericAttributes.f));
            int i2 = entity.a(MobEffects.a) ? entity.b(MobEffects.a).e() + 1 : 0;
            int j2 = entity.a(MobEffects.b) ? entity.b(MobEffects.b).e() + 1 : 0;
            float f2 = 0.25f * (float)(i2 - j2);
            float g2 = MathHelper.a(entity.fe() * 1.65f, 0.2f, 3.0f) + f2;
            float h2 = livingEntity.f(world.ag().b(entity)) ? 0.5f : 1.0f;
            livingEntity.knockback((double)(h2 * g2) * this.h.applyAsDouble(entity), this.i.a(), this.i.c(), entity);
            this.b(world, entity);
            world.a((EntityHuman)null, entity, this.j.apply(entity), SoundCategory.g, 1.0f, 1.0f);
        } else if (this.c(world, entity)) {
            world.a((EntityHuman)null, entity, this.j.apply(entity), SoundCategory.g, 1.0f, 1.0f);
            boolean bl = entity.gk();
            if (bl) {
                world.a((EntityHuman)null, entity, this.k.apply(entity), SoundCategory.g, 1.0f, 1.0f);
            }
            this.b(world, entity);
        } else {
            boolean bl2;
            Optional<MemoryTarget> optional = brain.c(MemoryModuleType.m);
            Optional<Vec3D> optional2 = brain.c(MemoryModuleType.V);
            boolean bl = bl2 = optional.isEmpty() || optional2.isEmpty() || optional.get().a().a().a((IPosition)optional2.get(), 0.25);
            if (bl2) {
                this.b(world, entity);
            }
        }
    }

    private boolean c(WorldServer world, Goat goat) {
        Vec3D vec3 = goat.do().d(1.0, 0.0, 1.0).d();
        BlockPosition blockPos = BlockPosition.a(goat.dj().e(vec3));
        return world.a_(blockPos).a(TagsBlock.ce) || world.a_(blockPos.c()).a(TagsBlock.ce);
    }

    protected void b(WorldServer world, Goat goat) {
        world.a((Entity)goat, (byte)59);
        goat.dN().a(MemoryModuleType.U, Integer.valueOf(this.e.apply(goat).a(world.z)));
        goat.dN().b(MemoryModuleType.V);
    }
}

