/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.navigation;

import com.destroystokyo.paper.event.entity.EntityPathfindEvent;
import com.google.common.collect.ImmutableSet;
import io.papermc.paper.util.MCUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;

public abstract class NavigationAbstract {
    private static final int p = 20;
    private static final int q = 100;
    private static final float r = 0.25f;
    protected final EntityInsentient a;
    protected final World b;
    @Nullable
    protected PathEntity c;
    protected double d;
    protected int e;
    protected int f;
    protected Vec3D g = Vec3D.b;
    protected BaseBlockPosition h = BaseBlockPosition.g;
    protected long i;
    protected long j;
    protected double k;
    protected float l = 0.5f;
    protected boolean m;
    protected long n;
    protected PathfinderAbstract o;
    @Nullable
    private BlockPosition s;
    private int t;
    private float u = 1.0f;
    public final Pathfinder v;
    private boolean w;
    private int lastFailure = 0;
    private int pathfindFailures = 0;

    public NavigationAbstract(EntityInsentient entity, World world) {
        this.a = entity;
        this.b = world;
        int i2 = MathHelper.a(entity.b(GenericAttributes.b) * 16.0);
        this.v = this.a(i2);
    }

    public void g() {
        this.u = 1.0f;
    }

    public void a(float rangeMultiplier) {
        this.u = rangeMultiplier;
    }

    @Nullable
    public BlockPosition h() {
        return this.s;
    }

    protected abstract Pathfinder a(int var1);

    public void a(double speed) {
        this.d = speed;
    }

    public void i() {
        if (this.b.V() - this.n > 20L) {
            if (this.s != null) {
                this.c = null;
                this.c = this.a(this.s, this.t);
                this.n = this.b.V();
                this.m = false;
            }
        } else {
            this.m = true;
        }
    }

    @Nullable
    public final PathEntity a(double x2, double y2, double z2, int distance) {
        return this.a(BlockPosition.a(x2, y2, z2), distance);
    }

    @Nullable
    public PathEntity a(Stream<BlockPosition> positions, int distance) {
        return this.a(positions.collect(Collectors.toSet()), 8, false, distance);
    }

    @Nullable
    public PathEntity a(Set<BlockPosition> positions, int distance) {
        return this.a(positions, 8, false, distance);
    }

    @Nullable
    public PathEntity a(BlockPosition target, int distance) {
        return this.createPath(target, null, distance);
    }

    @Nullable
    public PathEntity createPath(BlockPosition target, @Nullable Entity entity, int distance) {
        return this.createPath((Set<BlockPosition>)ImmutableSet.of((Object)target), entity, 8, false, distance);
    }

    @Nullable
    public PathEntity a(BlockPosition target, int minDistance, int maxDistance) {
        return this.a((Set<BlockPosition>)ImmutableSet.of((Object)target), 8, false, minDistance, maxDistance);
    }

    @Nullable
    public PathEntity a(Entity entity, int distance) {
        return this.createPath((Set<BlockPosition>)ImmutableSet.of((Object)entity.dl()), entity, 16, true, distance);
    }

    @Nullable
    protected PathEntity a(Set<BlockPosition> positions, int range, boolean useHeadPos, int distance) {
        return this.a(positions, range, useHeadPos, distance, (float)this.a.b(GenericAttributes.b));
    }

    @Nullable
    protected PathEntity a(Set<BlockPosition> positions, int range, boolean useHeadPos, int distance, float followRange) {
        return this.createPath(positions, null, range, useHeadPos, distance, followRange);
    }

    @Nullable
    protected PathEntity createPath(Set<BlockPosition> positions, @Nullable Entity target, int range, boolean useHeadPos, int distance) {
        return this.createPath(positions, target, range, useHeadPos, distance, (float)this.a.b(GenericAttributes.b));
    }

    @Nullable
    protected PathEntity createPath(Set<BlockPosition> positions, @Nullable Entity target, int range, boolean useHeadPos, int distance, float followRange) {
        if (positions.isEmpty()) {
            return null;
        }
        if (this.a.ds() < (double)this.b.H_()) {
            return null;
        }
        if (!this.a()) {
            return null;
        }
        if (this.c != null && !this.c.c() && positions.contains(this.s)) {
            return this.c;
        }
        boolean copiedSet = false;
        for (BlockPosition possibleTarget : positions) {
            if (this.a.cJ().B_().a(possibleTarget) && new EntityPathfindEvent((org.bukkit.entity.Entity)this.a.getBukkitEntity(), MCUtil.toLocation(this.a.dL(), possibleTarget), (org.bukkit.entity.Entity)(target == null ? null : target.getBukkitEntity())).callEvent()) continue;
            if (!copiedSet) {
                copiedSet = true;
                positions = new HashSet<BlockPosition>(positions);
            }
            positions.remove(possibleTarget);
            if (!positions.isEmpty()) continue;
            return null;
        }
        this.b.ad().a("pathfind");
        BlockPosition blockPos = useHeadPos ? this.a.dl().c() : this.a.dl();
        int i2 = (int)(followRange + (float)range);
        ChunkCache pathNavigationRegion = new ChunkCache(this.b, blockPos.b(-i2, -i2, -i2), blockPos.b(i2, i2, i2));
        PathEntity path = this.v.a(pathNavigationRegion, this.a, positions, followRange, distance, this.u);
        this.b.ad().c();
        if (path != null && path.l() != null) {
            this.s = path.l();
            this.t = distance;
            this.f();
        }
        return path;
    }

    public boolean a(double x2, double y2, double z2, double speed) {
        return this.a(this.a(x2, y2, z2, 1), speed);
    }

    public boolean a(Entity entity, double speed) {
        if (this.pathfindFailures > 10 && this.c == null && MinecraftServer.currentTick < this.lastFailure + 40) {
            return false;
        }
        PathEntity path = this.a(entity, 1);
        if (path != null && this.a(path, speed)) {
            this.lastFailure = 0;
            this.pathfindFailures = 0;
            return true;
        }
        ++this.pathfindFailures;
        this.lastFailure = MinecraftServer.currentTick;
        return false;
    }

    public boolean a(@Nullable PathEntity path, double speed) {
        if (path == null) {
            this.c = null;
            return false;
        }
        if (!path.a(this.c)) {
            this.c = path;
        }
        if (this.l()) {
            return false;
        }
        this.R_();
        if (this.c.e() <= 0) {
            return false;
        }
        this.d = speed;
        Vec3D vec3 = this.b();
        this.f = this.e;
        this.g = vec3;
        return true;
    }

    @Nullable
    public PathEntity j() {
        return this.c;
    }

    public void c() {
        ++this.e;
        if (this.m) {
            this.i();
        }
        if (!this.l()) {
            if (this.a()) {
                this.k();
            } else if (this.c != null && !this.c.c()) {
                Vec3D vec3 = this.b();
                Vec3D vec32 = this.c.a(this.a);
                if (vec3.d > vec32.d && !this.a.aA() && MathHelper.a(vec3.c) == MathHelper.a(vec32.c) && MathHelper.a(vec3.e) == MathHelper.a(vec32.e)) {
                    this.c.a();
                }
            }
            PacketDebug.a(this.b, this.a, this.c, this.l);
            if (!this.l()) {
                Vec3D vec33 = this.c.a(this.a);
                this.a.I().a(vec33.c, this.a(vec33), vec33.e, this.d);
            }
        }
    }

    protected double a(Vec3D pos) {
        BlockPosition blockPos = BlockPosition.a(pos);
        return this.b.a_(blockPos.d()).i() ? pos.d : PathfinderNormal.a((IBlockAccess)this.b, blockPos);
    }

    protected void k() {
        boolean bl;
        Vec3D vec3 = this.b();
        this.l = this.a.df() > 0.75f ? this.a.df() / 2.0f : 0.75f - this.a.df() / 2.0f;
        BlockPosition vec3i = this.c.g();
        double d2 = Math.abs(this.a.dq() - ((double)vec3i.u() + 0.5));
        double e2 = Math.abs(this.a.ds() - (double)vec3i.v());
        double f2 = Math.abs(this.a.dw() - ((double)vec3i.w() + 0.5));
        boolean bl2 = bl = d2 < (double)this.l && f2 < (double)this.l && e2 < 1.0;
        if (bl || this.b(this.c.h().l) && this.c(vec3)) {
            this.c.a();
        }
        this.b(vec3);
    }

    private boolean c(Vec3D currentPos) {
        boolean bl2;
        if (this.c.f() + 1 >= this.c.e()) {
            return false;
        }
        Vec3D vec3 = Vec3D.c(this.c.g());
        if (!currentPos.a((IPosition)vec3, 2.0)) {
            return false;
        }
        if (this.a(currentPos, this.c.a(this.a))) {
            return true;
        }
        Vec3D vec32 = Vec3D.c(this.c.d(this.c.f() + 1));
        Vec3D vec33 = vec3.d(currentPos);
        Vec3D vec34 = vec32.d(currentPos);
        double d2 = vec33.g();
        double e2 = vec34.g();
        boolean bl = e2 < d2;
        boolean bl3 = bl2 = d2 < 0.5;
        if (!bl && !bl2) {
            return false;
        }
        Vec3D vec35 = vec33.d();
        Vec3D vec36 = vec34.d();
        return vec36.b(vec35) < 0.0;
    }

    protected void b(Vec3D currentPos) {
        if (this.e - this.f > 100) {
            float f2 = this.a.fe() >= 1.0f ? this.a.fe() : this.a.fe() * this.a.fe();
            float g2 = f2 * 100.0f * 0.25f;
            if (currentPos.g(this.g) < (double)(g2 * g2)) {
                this.w = true;
                this.n();
            } else {
                this.w = false;
            }
            this.f = this.e;
            this.g = currentPos;
        }
        if (this.c != null && !this.c.c()) {
            BlockPosition vec3i = this.c.g();
            long l2 = this.b.V();
            if (vec3i.equals(this.h)) {
                this.i += l2 - this.j;
            } else {
                this.h = vec3i;
                double d2 = currentPos.f(Vec3D.c(this.h));
                double d3 = this.k = this.a.fe() > 0.0f ? d2 / (double)this.a.fe() * 20.0 : 0.0;
            }
            if (this.k > 0.0 && (double)this.i > this.k * 3.0) {
                this.e();
            }
            this.j = l2;
        }
    }

    private void e() {
        this.f();
        this.n();
    }

    private void f() {
        this.h = BaseBlockPosition.g;
        this.i = 0L;
        this.k = 0.0;
        this.w = false;
    }

    public boolean l() {
        return this.c == null || this.c.c();
    }

    public boolean m() {
        return !this.l();
    }

    public void n() {
        this.c = null;
    }

    protected abstract Vec3D b();

    protected abstract boolean a();

    protected void R_() {
        if (this.c != null) {
            for (int i2 = 0; i2 < this.c.e(); ++i2) {
                PathPoint node = this.c.a(i2);
                PathPoint node2 = i2 + 1 < this.c.e() ? this.c.a(i2 + 1) : null;
                IBlockData blockState = this.b.a_(new BlockPosition(node.a, node.b, node.c));
                if (!blockState.a(TagsBlock.bk)) continue;
                this.c.a(i2, node.a(node.a, node.b + 1, node.c));
                if (node2 == null || node.b < node2.b) continue;
                this.c.a(i2 + 1, node.a(node2.a, node.b + 1, node2.c));
            }
        }
    }

    protected boolean a(Vec3D origin, Vec3D target) {
        return false;
    }

    public boolean b(PathType nodeType) {
        return nodeType != PathType.n && nodeType != PathType.p && nodeType != PathType.d;
    }

    protected static boolean a(EntityInsentient entity, Vec3D startPos, Vec3D entityPos, boolean includeFluids) {
        Vec3D vec3 = new Vec3D(entityPos.c, entityPos.d + (double)entity.dg() * 0.5, entityPos.e);
        return entity.dL().a(new RayTrace(startPos, vec3, RayTrace.BlockCollisionOption.a, includeFluids ? RayTrace.FluidCollisionOption.c : RayTrace.FluidCollisionOption.a, entity)).c() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public boolean a(BlockPosition pos) {
        BlockPosition blockPos = pos.d();
        return this.b.a_(blockPos).i(this.b, blockPos);
    }

    public PathfinderAbstract o() {
        return this.o;
    }

    public void a(boolean canSwim) {
        this.o.c(canSwim);
    }

    public boolean p() {
        return this.o.f();
    }

    public boolean b(BlockPosition pos) {
        if (this.m) {
            return false;
        }
        if (this.c != null && !this.c.c() && this.c.e() != 0) {
            PathPoint node = this.c.d();
            Vec3D vec3 = new Vec3D(((double)node.a + this.a.dq()) / 2.0, ((double)node.b + this.a.ds()) / 2.0, ((double)node.c + this.a.dw()) / 2.0);
            return pos.a(vec3, (double)(this.c.e() - this.c.f()));
        }
        return false;
    }

    public float q() {
        return this.l;
    }

    public boolean r() {
        return this.w;
    }
}

