/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.destroystokyo.paper.util.maplist.ReferenceList;
import com.google.common.collect.ImmutableSet;
import io.papermc.paper.util.player.NearbyPlayers;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.phys.Vec3D;

public class SensorNearestPlayers
extends Sensor<EntityLiving> {
    @Override
    public Set<MemoryModuleType<?>> a() {
        return ImmutableSet.of(MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l);
    }

    @Override
    protected void a(WorldServer world, EntityLiving entity) {
        NearbyPlayers nearbyPlayers = world.I.a.getNearbyPlayers();
        Vec3D entityPos = entity.dj();
        ReferenceList<EntityPlayer> nearby = nearbyPlayers.getPlayersByChunk(entity.dn().e, entity.dn().f, NearbyPlayers.NearbyMapType.GENERAL_REALLY_SMALL);
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>(nearby == null ? 0 : nearby.size());
        if (nearby != null) {
            Object[] rawData = nearby.getRawData();
            int len = nearby.size();
            for (int index = 0; index < len; ++index) {
                EntityPlayer player = (EntityPlayer)rawData[index];
                if (player.M_() || player.i(entityPos.c, entityPos.d, entityPos.e) >= 256.0) continue;
                players.add(player);
            }
        }
        players.sort((e1, e2) -> Double.compare(entity.f((Entity)e1), entity.f((Entity)e2)));
        BehaviorController<?> brain = entity.dN();
        brain.a(MemoryModuleType.j, players);
        EntityHuman firstTargetable = null;
        EntityHuman firstAttackable = null;
        int len = players.size();
        for (int index = 0; index < len; ++index) {
            EntityHuman player = (EntityHuman)players.get(index);
            if (firstTargetable == null && SensorNearestPlayers.b(entity, player)) {
                firstTargetable = player;
            }
            if (firstAttackable == null && SensorNearestPlayers.c(entity, player)) {
                firstAttackable = player;
            }
            if (firstAttackable != null && firstTargetable != null) break;
        }
        brain.a(MemoryModuleType.k, firstTargetable);
        brain.a(MemoryModuleType.l, Optional.ofNullable(firstAttackable));
    }
}

