/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyBedPart;

public class PoiTypes {
    public static final ResourceKey<VillagePlaceType> a = PoiTypes.a("armorer");
    public static final ResourceKey<VillagePlaceType> b = PoiTypes.a("butcher");
    public static final ResourceKey<VillagePlaceType> c = PoiTypes.a("cartographer");
    public static final ResourceKey<VillagePlaceType> d = PoiTypes.a("cleric");
    public static final ResourceKey<VillagePlaceType> e = PoiTypes.a("farmer");
    public static final ResourceKey<VillagePlaceType> f = PoiTypes.a("fisherman");
    public static final ResourceKey<VillagePlaceType> g = PoiTypes.a("fletcher");
    public static final ResourceKey<VillagePlaceType> h = PoiTypes.a("leatherworker");
    public static final ResourceKey<VillagePlaceType> i = PoiTypes.a("librarian");
    public static final ResourceKey<VillagePlaceType> j = PoiTypes.a("mason");
    public static final ResourceKey<VillagePlaceType> k = PoiTypes.a("shepherd");
    public static final ResourceKey<VillagePlaceType> l = PoiTypes.a("toolsmith");
    public static final ResourceKey<VillagePlaceType> m = PoiTypes.a("weaponsmith");
    public static final ResourceKey<VillagePlaceType> n = PoiTypes.a("home");
    public static final ResourceKey<VillagePlaceType> o = PoiTypes.a("meeting");
    public static final ResourceKey<VillagePlaceType> p = PoiTypes.a("beehive");
    public static final ResourceKey<VillagePlaceType> q = PoiTypes.a("bee_nest");
    public static final ResourceKey<VillagePlaceType> r = PoiTypes.a("nether_portal");
    public static final ResourceKey<VillagePlaceType> s = PoiTypes.a("lodestone");
    public static final ResourceKey<VillagePlaceType> t = PoiTypes.a("lightning_rod");
    private static final Set<IBlockData> u = (Set)ImmutableList.of((Object)Blocks.bn, (Object)Blocks.bo, (Object)Blocks.bk, (Object)Blocks.bl, (Object)Blocks.bi, (Object)Blocks.bg, (Object)Blocks.bm, (Object)Blocks.bc, (Object)Blocks.bh, (Object)Blocks.be, (Object)Blocks.bb, (Object)Blocks.ba, (Object[])new Block[]{Blocks.bf, Blocks.bj, Blocks.aZ, Blocks.bd}).stream().flatMap(block -> block.l().a().stream()).filter(blockState -> blockState.c(BlockBed.a) == BlockPropertyBedPart.a).collect(ImmutableSet.toImmutableSet());
    private static final Set<IBlockData> v = (Set)ImmutableList.of((Object)Blocks.ft, (Object)Blocks.fv, (Object)Blocks.fu, (Object)Blocks.fw).stream().flatMap(block -> block.l().a().stream()).collect(ImmutableSet.toImmutableSet());
    private static final Map<IBlockData, Holder<VillagePlaceType>> w = Maps.newHashMap();

    private static Set<IBlockData> a(Block block) {
        return ImmutableSet.copyOf(block.l().a());
    }

    private static ResourceKey<VillagePlaceType> a(String id) {
        return ResourceKey.a(Registries.S, new MinecraftKey(id));
    }

    private static VillagePlaceType a(IRegistry<VillagePlaceType> registry, ResourceKey<VillagePlaceType> key, Set<IBlockData> states, int ticketCount, int searchDistance) {
        VillagePlaceType poiType = new VillagePlaceType(states, ticketCount, searchDistance);
        IRegistry.a(registry, key, poiType);
        PoiTypes.a(registry.f(key), states);
        return poiType;
    }

    private static void a(Holder<VillagePlaceType> poiTypeEntry, Set<IBlockData> states) {
        states.forEach(state -> {
            Holder<VillagePlaceType> holder2 = w.put((IBlockData)state, poiTypeEntry);
            if (holder2 != null) {
                throw SystemUtils.b(new IllegalStateException(String.format(Locale.ROOT, "%s is defined in more than one PoI type", state)));
            }
        });
    }

    public static Optional<Holder<VillagePlaceType>> a(IBlockData state) {
        return Optional.ofNullable(w.get(state));
    }

    public static boolean b(IBlockData state) {
        return w.containsKey(state);
    }

    public static VillagePlaceType a(IRegistry<VillagePlaceType> registry) {
        PoiTypes.a(registry, a, PoiTypes.a(Blocks.nW), 1, 1);
        PoiTypes.a(registry, b, PoiTypes.a(Blocks.nV), 1, 1);
        PoiTypes.a(registry, c, PoiTypes.a(Blocks.nX), 1, 1);
        PoiTypes.a(registry, d, PoiTypes.a(Blocks.fs), 1, 1);
        PoiTypes.a(registry, e, PoiTypes.a(Blocks.pc), 1, 1);
        PoiTypes.a(registry, f, PoiTypes.a(Blocks.nU), 1, 1);
        PoiTypes.a(registry, g, PoiTypes.a(Blocks.nY), 1, 1);
        PoiTypes.a(registry, h, v, 1, 1);
        PoiTypes.a(registry, i, PoiTypes.a(Blocks.oa), 1, 1);
        PoiTypes.a(registry, j, PoiTypes.a(Blocks.oc), 1, 1);
        PoiTypes.a(registry, k, PoiTypes.a(Blocks.nT), 1, 1);
        PoiTypes.a(registry, l, PoiTypes.a(Blocks.ob), 1, 1);
        PoiTypes.a(registry, m, PoiTypes.a(Blocks.nZ), 1, 1);
        PoiTypes.a(registry, n, u, 1, 1);
        PoiTypes.a(registry, o, PoiTypes.a(Blocks.od), 32, 6);
        PoiTypes.a(registry, p, PoiTypes.a(Blocks.pf), 0, 1);
        PoiTypes.a(registry, q, PoiTypes.a(Blocks.pe), 0, 1);
        PoiTypes.a(registry, r, PoiTypes.a(Blocks.ee), 0, 1);
        PoiTypes.a(registry, s, PoiTypes.a(Blocks.pq), 0, 1);
        return PoiTypes.a(registry, t, PoiTypes.a(Blocks.rr), 0, 1);
    }
}

