/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import io.papermc.paper.event.entity.EntityToggleSitEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalNearestVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJumpAbstract;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.joml.Vector3f;

public class EntityFox
extends EntityAnimal
implements VariantHolder<Type> {
    private static final DataWatcherObject<Integer> bX = DataWatcher.a(EntityFox.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Byte> bY = DataWatcher.a(EntityFox.class, DataWatcherRegistry.a);
    private static final int bZ = 1;
    public static final int bT = 4;
    public static final int bU = 8;
    public static final int bW = 16;
    private static final int ca = 32;
    private static final int cb = 64;
    private static final int cc = 128;
    public static final DataWatcherObject<Optional<UUID>> cd = DataWatcher.a(EntityFox.class, DataWatcherRegistry.q);
    public static final DataWatcherObject<Optional<UUID>> ce = DataWatcher.a(EntityFox.class, DataWatcherRegistry.q);
    static final Predicate<EntityItem> cf = entityitem -> !entityitem.y() && entityitem.bv();
    private static final Predicate<Entity> cg = entity -> {
        if (!(entity instanceof EntityLiving)) {
            return false;
        }
        EntityLiving entityliving = (EntityLiving)entity;
        return entityliving.ei() != null && entityliving.ej() < entityliving.ah + 600;
    };
    static final Predicate<Entity> ch = entity -> entity instanceof EntityChicken || entity instanceof EntityRabbit;
    private static final Predicate<Entity> ci = entity -> !entity.bU() && IEntitySelector.e.test((Entity)entity);
    private static final int cj = 600;
    private PathfinderGoal ck;
    private PathfinderGoal cl;
    private PathfinderGoal cm;
    private float cn;
    private float co;
    float cp;
    float cq;
    private int cr;

    public EntityFox(EntityTypes<? extends EntityFox> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.bK = new k();
        this.bL = new m();
        this.a(PathType.p, 0.0f);
        this.a(PathType.q, 0.0f);
        this.s(true);
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(cd, Optional.empty());
        this.an.a(ce, Optional.empty());
        this.an.a(bX, 0);
        this.an.a(bY, (byte)0);
    }

    @Override
    protected void z() {
        this.ck = new PathfinderGoalNearestAttackableTarget<EntityAnimal>(this, EntityAnimal.class, 10, false, false, entityliving -> entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit);
        this.cl = new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, false, false, EntityTurtle.bU);
        this.cm = new PathfinderGoalNearestAttackableTarget<EntityFish>(this, EntityFish.class, 20, false, false, entityliving -> entityliving instanceof EntityFishSchool);
        this.bO.a(0, new g());
        this.bO.a(0, new ClimbOnTopOfPowderSnowGoal(this, this.dL()));
        this.bO.a(1, new b());
        this.bO.a(2, new n(2.2));
        this.bO.a(3, new e(1.0));
        this.bO.a(4, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 16.0f, 1.6, 1.4, entityliving -> ci.test((Entity)entityliving) && !this.c(entityliving.cv()) && !this.gp()));
        this.bO.a(4, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 8.0f, 1.6, 1.4, entityliving -> !((EntityWolf)entityliving).s() && !this.gp()));
        this.bO.a(4, new PathfinderGoalAvoidTarget<EntityPolarBear>(this, EntityPolarBear.class, 8.0f, 1.6, 1.4, entityliving -> !this.gp()));
        this.bO.a(5, new u());
        this.bO.a(6, new o());
        this.bO.a(6, new s(1.25));
        this.bO.a(7, new l((double)1.2f, true));
        this.bO.a(7, new t());
        this.bO.a(8, new h(this, 1.25));
        this.bO.a(9, new q(32, 200));
        this.bO.a(10, new f((double)1.2f, 12, 1));
        this.bO.a(10, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bO.a(11, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bO.a(11, new p());
        this.bO.a(12, new j(this, EntityHuman.class, 24.0f));
        this.bO.a(13, new r());
        this.bP.a(3, new a(EntityLiving.class, false, false, entityliving -> cg.test((Entity)entityliving) && !this.c(entityliving.cv())));
    }

    @Override
    public SoundEffect d(ItemStack stack) {
        return SoundEffects.ic;
    }

    @Override
    public void b_() {
        if (!this.dL().B && this.bv() && this.cX()) {
            EntityLiving entityliving;
            ++this.cr;
            ItemStack itemstack = this.c(EnumItemSlot.a);
            if (this.l(itemstack)) {
                if (this.cr > 600) {
                    ItemStack itemstack1 = itemstack.a(this.dL(), this);
                    if (!itemstack1.b()) {
                        this.a(EnumItemSlot.a, itemstack1);
                    }
                    this.cr = 0;
                } else if (this.cr > 560 && this.ag.i() < 0.1f) {
                    this.a(this.d(itemstack), 1.0f, 1.0f);
                    this.dL().a((Entity)this, (byte)45);
                }
            }
            if ((entityliving = this.q()) == null || !entityliving.bv()) {
                this.y(false);
                this.z(false);
            }
        }
        if (this.fC() || this.eX()) {
            this.bj = false;
            this.bk = 0.0f;
            this.bm = 0.0f;
        }
        super.b_();
        if (this.gp() && this.ag.i() < 0.05f) {
            this.a(SoundEffects.hY, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean eX() {
        return this.ev();
    }

    private boolean l(ItemStack stack) {
        return stack.d().u() && this.q() == null && this.aA() && !this.fC();
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        if (random.i() < 0.2f) {
            float f2 = random.i();
            ItemStack itemstack = f2 < 0.05f ? new ItemStack(Items.nL) : (f2 < 0.2f ? new ItemStack(Items.qd) : (f2 < 0.4f ? (random.h() ? new ItemStack(Items.tJ) : new ItemStack(Items.tK)) : (f2 < 0.6f ? new ItemStack(Items.oI) : (f2 < 0.8f ? new ItemStack(Items.pP) : new ItemStack(Items.oF)))));
            this.a(EnumItemSlot.a, itemstack);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 45) {
            ItemStack itemstack = this.c(EnumItemSlot.a);
            if (!itemstack.b()) {
                for (int i2 = 0; i2 < 8; ++i2) {
                    Vec3D vec3d = new Vec3D(((double)this.ag.i() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).a(-this.dD() * ((float)Math.PI / 180)).b(-this.dB() * ((float)Math.PI / 180));
                    this.dL().a(new ParticleParamItem(Particles.O, itemstack), this.dq() + this.bE().c / 2.0, this.ds(), this.dw() + this.bE().e / 2.0, vec3d.c, vec3d.d + 0.05, vec3d.e);
                }
            }
        } else {
            super.b(status);
        }
    }

    public static AttributeProvider.Builder s() {
        return EntityInsentient.A().a(GenericAttributes.d, 0.3f).a(GenericAttributes.a, 10.0).a(GenericAttributes.b, 32.0).a(GenericAttributes.f, 2.0);
    }

    @Nullable
    public EntityFox b(WorldServer world, EntityAgeable entity) {
        EntityFox entityfox = EntityTypes.N.a(world);
        if (entityfox != null) {
            entityfox.a(this.ag.h() ? this.t() : ((EntityFox)entity).t());
        }
        return entityfox;
    }

    public static boolean c(EntityTypes<EntityFox> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.d()).a(TagsBlock.bW) && EntityFox.a(world, pos);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        Holder<BiomeBase> holder = world.s(this.dl());
        Type entityfox_type = Type.a(holder);
        boolean flag = false;
        if (entityData instanceof i) {
            i entityfox_i = (i)entityData;
            entityfox_type = entityfox_i.a;
            if (entityfox_i.a() >= 2) {
                flag = true;
            }
        } else {
            entityData = new i(entityfox_type);
        }
        this.a(entityfox_type);
        if (flag) {
            this.c_(-24000);
        }
        if (world instanceof WorldServer) {
            this.gn();
        }
        this.a(world.D_(), difficulty);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    private void gn() {
        if (this.t() == Type.a) {
            this.bP.a(4, this.ck);
            this.bP.a(4, this.cl);
            this.bP.a(6, this.cm);
        } else {
            this.bP.a(4, this.cm);
            this.bP.a(6, this.ck);
            this.bP.a(6, this.cl);
        }
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (this.m(stack)) {
            this.a(this.d(stack), 1.0f, 1.0f);
        }
        super.a(player, hand, stack);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.m_() ? dimensions.b * 0.85f : 0.4f;
    }

    public Type t() {
        return Type.a(this.an.b(bX));
    }

    @Override
    public void a(Type variant) {
        this.an.b(bX, variant.a());
    }

    List<UUID> go() {
        ArrayList list = Lists.newArrayList();
        list.add(this.an.b(cd).orElse(null));
        list.add(this.an.b(ce).orElse(null));
        return list;
    }

    void b(@Nullable UUID uuid) {
        if (this.an.b(cd).isPresent()) {
            this.an.b(ce, Optional.ofNullable(uuid));
        } else {
            this.an.b(cd, Optional.ofNullable(uuid));
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        List<UUID> list = this.go();
        NBTTagList nbttaglist = new NBTTagList();
        for (UUID uuid : list) {
            if (uuid == null) continue;
            nbttaglist.add(GameProfileSerializer.a(uuid));
        }
        nbt.a("Trusted", nbttaglist);
        nbt.a("Sleeping", this.fC());
        nbt.a("Type", this.t().c());
        nbt.a("Sitting", this.y());
        nbt.a("Crouching", this.bW());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        NBTTagList nbttaglist = nbt.c("Trusted", 11);
        for (NBTBase nbtbase : nbttaglist) {
            this.b(GameProfileSerializer.a(nbtbase));
        }
        this.C(nbt.q("Sleeping"));
        this.a(Type.a(nbt.l("Type")));
        this.setSitting(nbt.q("Sitting"), false);
        this.y(nbt.q("Crouching"));
        if (this.dL() instanceof WorldServer) {
            this.gn();
        }
    }

    public boolean y() {
        return this.t(1);
    }

    public void w(boolean sitting) {
        this.setSitting(sitting, true);
    }

    public void setSitting(boolean sitting, boolean fireEvent) {
        if (fireEvent && !new EntityToggleSitEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), sitting).callEvent()) {
            return;
        }
        this.d(1, sitting);
    }

    public boolean gd() {
        return this.t(64);
    }

    public void A(boolean walking) {
        this.d(64, walking);
    }

    public boolean gp() {
        return this.t(128);
    }

    public void B(boolean aggressive) {
        this.d(128, aggressive);
    }

    @Override
    public boolean fC() {
        return this.t(32);
    }

    public void C(boolean sleeping) {
        this.d(32, sleeping);
    }

    private void d(int mask, boolean value) {
        if (value) {
            this.an.b(bY, (byte)(this.an.b(bY) | mask));
        } else {
            this.an.b(bY, (byte)(this.an.b(bY) & ~mask));
        }
    }

    private boolean t(int bitmask) {
        return (this.an.b(bY) & bitmask) != 0;
    }

    @Override
    public boolean f(ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(stack);
        return !this.c(enumitemslot).b() ? false : enumitemslot == EnumItemSlot.a && super.f(stack);
    }

    @Override
    public boolean j(ItemStack stack) {
        Item item = stack.d();
        ItemStack itemstack1 = this.c(EnumItemSlot.a);
        return itemstack1.b() || this.cr > 0 && item.u() && !itemstack1.d().u();
    }

    private void n(ItemStack stack) {
        if (!stack.b() && !this.dL().B) {
            EntityItem entityitem = new EntityItem(this.dL(), this.dq() + this.bE().c, this.ds() + 1.0, this.dw() + this.bE().e, stack);
            entityitem.b(40);
            entityitem.c(this.cv());
            this.a(SoundEffects.ih, 1.0f, 1.0f);
            this.spawnAtLocation(entityitem);
        }
    }

    private void o(ItemStack stack) {
        EntityItem entityitem = new EntityItem(this.dL(), this.dq(), this.ds(), this.dw(), stack);
        this.spawnAtLocation(entityitem);
    }

    @Override
    protected void b(EntityItem item) {
        ItemStack itemstack = item.q();
        if (!CraftEventFactory.callEntityPickupItemEvent(this, item, itemstack.L() - 1, !this.j(itemstack)).isCancelled()) {
            itemstack = item.q();
            int i2 = itemstack.L();
            if (i2 > 1) {
                this.o(itemstack.a(i2 - 1));
            }
            this.n(this.c(EnumItemSlot.a));
            this.a(item);
            this.a(EnumItemSlot.a, itemstack.a(1));
            this.e(EnumItemSlot.a);
            this.a((Entity)item, itemstack.L());
            item.ak();
            this.cr = 0;
        }
    }

    @Override
    public void l() {
        super.l();
        if (this.cX()) {
            boolean flag = this.aX();
            if (flag || this.q() != null || this.dL().Y()) {
                this.gq();
            }
            if (flag || this.fC()) {
                this.w(false);
            }
            if (this.gd() && this.dL().z.i() < 0.2f) {
                BlockPosition blockposition = this.dl();
                IBlockData iblockdata = this.dL().a_(blockposition);
                this.dL().c(2001, blockposition, Block.i(iblockdata));
            }
        }
        this.co = this.cn;
        this.cn = this.gm() ? (this.cn += (1.0f - this.cn) * 0.4f) : (this.cn += (0.0f - this.cn) * 0.4f);
        this.cq = this.cp;
        if (this.bW()) {
            this.cp += 0.2f;
            if (this.cp > 3.0f) {
                this.cp = 3.0f;
            }
        } else {
            this.cp = 0.0f;
        }
    }

    @Override
    public boolean m(ItemStack stack) {
        return stack.a(TagsItem.X);
    }

    @Override
    protected void a(EntityHuman player, EntityInsentient child) {
        ((EntityFox)child).b(player.cv());
    }

    public boolean gj() {
        return this.t(16);
    }

    public void x(boolean chasing) {
        this.d(16, chasing);
    }

    public boolean gk() {
        return this.bj;
    }

    public boolean gl() {
        return this.cp == 3.0f;
    }

    public void y(boolean crouching) {
        this.d(4, crouching);
    }

    @Override
    public boolean bW() {
        return this.t(4);
    }

    public void z(boolean rollingHead) {
        this.d(8, rollingHead);
    }

    public boolean gm() {
        return this.t(8);
    }

    public float E(float tickDelta) {
        return MathHelper.i(tickDelta, this.co, this.cn) * 0.11f * (float)Math.PI;
    }

    public float F(float tickDelta) {
        return MathHelper.i(tickDelta, this.cq, this.cp);
    }

    @Override
    public void h(@Nullable EntityLiving target) {
        if (this.gp() && target == null) {
            this.B(false);
        }
        super.h(target);
    }

    @Override
    protected int d(float fallDistance, float damageMultiplier) {
        return MathHelper.f((fallDistance - 5.0f) * damageMultiplier);
    }

    void gq() {
        this.C(false);
    }

    void gr() {
        this.z(false);
        this.y(false);
        this.w(false);
        this.C(false);
        this.B(false);
        this.A(false);
    }

    boolean gs() {
        return !this.fC() && !this.y() && !this.gd();
    }

    @Override
    public void P() {
        SoundEffect soundeffect = this.w();
        if (soundeffect == SoundEffects.ie) {
            this.a(soundeffect, 2.0f, this.eW());
        } else {
            super.P();
        }
    }

    @Override
    @Nullable
    protected SoundEffect w() {
        List<Entity> list;
        if (this.fC()) {
            return SoundEffects.if;
        }
        if (!this.dL().N() && this.ag.i() < 0.1f && (list = this.dL().a(EntityHuman.class, this.cG().c(16.0, 16.0, 16.0), IEntitySelector.f)).isEmpty()) {
            return SoundEffects.ie;
        }
        return SoundEffects.hZ;
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.id;
    }

    @Override
    @Nullable
    public SoundEffect l_() {
        return SoundEffects.ib;
    }

    boolean c(UUID uuid) {
        return this.go().contains(uuid);
    }

    @Override
    protected EntityDeathEvent dropAllDeathLoot(DamageSource source) {
        ItemStack itemstack = this.c(EnumItemSlot.a).p();
        EntityDeathEvent deathEvent = super.dropAllDeathLoot(source);
        if (deathEvent == null || deathEvent.isCancelled()) {
            return deathEvent;
        }
        if (!itemstack.b()) {
            this.b(itemstack);
            this.a(EnumItemSlot.a, ItemStack.b);
        }
        return deathEvent;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + -0.0625f * scaleFactor, -0.25f * scaleFactor);
    }

    public static boolean a(EntityFox fox, EntityLiving chasedEntity) {
        double d0 = chasedEntity.dw() - fox.dw();
        double d1 = chasedEntity.dq() - fox.dq();
        double d2 = d0 / d1;
        boolean flag = true;
        for (int i2 = 0; i2 < 6; ++i2) {
            double d3 = d2 == 0.0 ? 0.0 : d0 * (double)((float)i2 / 6.0f);
            double d4 = d2 == 0.0 ? d1 * (double)((float)i2 / 6.0f) : d3 / d2;
            for (int j2 = 1; j2 < 4; ++j2) {
                if (fox.dL().a_(BlockPosition.a(fox.dq() + d4, fox.ds() + (double)j2, fox.dw() + d3)).r()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Vec3D cI() {
        return new Vec3D(0.0, 0.55f * this.cH(), this.df() * 0.4f);
    }

    public class k
    extends ControllerLook {
        public k() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (!EntityFox.this.fC()) {
                super.a();
            }
        }

        @Override
        protected boolean c() {
            return !EntityFox.this.gj() && !EntityFox.this.bW() && !EntityFox.this.gm() && !EntityFox.this.gd();
        }
    }

    private class m
    extends ControllerMove {
        public m() {
            super(EntityFox.this);
        }

        @Override
        public void a() {
            if (EntityFox.this.gs()) {
                super.a();
            }
        }
    }

    private class g
    extends PathfinderGoalFloat {
        public g() {
            super(EntityFox.this);
        }

        @Override
        public void c() {
            super.c();
            EntityFox.this.gr();
        }

        @Override
        public boolean a() {
            return EntityFox.this.aX() && EntityFox.this.b(TagsFluid.a) > 0.25 || EntityFox.this.bl();
        }
    }

    private class b
    extends PathfinderGoal {
        int a;

        public b() {
            this.a(EnumSet.of(PathfinderGoal.Type.b, PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            return EntityFox.this.gd();
        }

        @Override
        public boolean b() {
            return this.a() && this.a > 0;
        }

        @Override
        public void c() {
            this.a = this.a(40);
        }

        @Override
        public void d() {
            EntityFox.this.A(false);
        }

        @Override
        public void e() {
            --this.a;
        }
    }

    private class n
    extends PathfinderGoalPanic {
        public n(double d0) {
            super(EntityFox.this, d0);
        }

        @Override
        public boolean h() {
            return !EntityFox.this.gp() && super.h();
        }
    }

    private class e
    extends PathfinderGoalBreed {
        public e(double d0) {
            super(EntityFox.this, d0);
        }

        @Override
        public void c() {
            ((EntityFox)this.a).gr();
            ((EntityFox)this.c).gr();
            super.c();
        }

        @Override
        protected void g() {
            WorldServer worldserver = (WorldServer)this.b;
            EntityFox entityfox = (EntityFox)this.a.a(worldserver, (EntityAgeable)this.c);
            if (entityfox != null) {
                EntityPlayer entityplayer = this.a.gg();
                EntityPlayer entityplayer1 = this.c.gg();
                EntityPlayer entityplayer2 = entityplayer;
                if (entityplayer != null) {
                    entityfox.b(entityplayer.cv());
                } else {
                    entityplayer2 = entityplayer1;
                }
                if (entityplayer1 != null && entityplayer != entityplayer1) {
                    entityfox.b(entityplayer1.cv());
                }
                entityfox.c_(-24000);
                entityfox.b(this.a.dq(), this.a.ds(), this.a.dw(), 0.0f, 0.0f);
                int experience = this.a.ef().a(7) + 1;
                EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent(entityfox, this.a, this.c, entityplayer, this.a.breedItem, experience);
                if (entityBreedEvent.isCancelled()) {
                    return;
                }
                experience = entityBreedEvent.getExperience();
                if (entityplayer2 != null) {
                    entityplayer2.a(StatisticList.P);
                    CriterionTriggers.o.a(entityplayer2, this.a, this.c, entityfox);
                }
                this.a.c_(6000);
                this.c.c_(6000);
                this.a.gi();
                this.c.gi();
                worldserver.addFreshEntityWithPassengers(entityfox, CreatureSpawnEvent.SpawnReason.BREEDING);
                this.b.a((Entity)this.a, (byte)18);
                if (this.b.X().b(GameRules.f) && experience > 0) {
                    this.b.b(new EntityExperienceOrb(this.b, this.a.dq(), this.a.ds(), this.a.dw(), experience, ExperienceOrb.SpawnReason.BREED, entityplayer, entityfox));
                }
            }
        }
    }

    private class u
    extends PathfinderGoal {
        public u() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            if (EntityFox.this.fC()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.q();
            return entityliving != null && entityliving.bv() && ch.test(entityliving) && EntityFox.this.f((Entity)entityliving) > 36.0 && !EntityFox.this.bW() && !EntityFox.this.gm() && !EntityFox.this.bj;
        }

        @Override
        public void c() {
            EntityFox.this.w(false);
            EntityFox.this.A(false);
        }

        @Override
        public void d() {
            EntityLiving entityliving = EntityFox.this.q();
            if (entityliving != null && EntityFox.a(EntityFox.this, entityliving)) {
                EntityFox.this.z(true);
                EntityFox.this.y(true);
                EntityFox.this.L().n();
                EntityFox.this.G().a(entityliving, (float)EntityFox.this.Z(), (float)EntityFox.this.Y());
            } else {
                EntityFox.this.z(false);
                EntityFox.this.y(false);
            }
        }

        @Override
        public void e() {
            EntityLiving entityliving = EntityFox.this.q();
            if (entityliving != null) {
                EntityFox.this.G().a(entityliving, (float)EntityFox.this.Z(), (float)EntityFox.this.Y());
                if (EntityFox.this.f((Entity)entityliving) <= 36.0) {
                    EntityFox.this.z(true);
                    EntityFox.this.y(true);
                    EntityFox.this.L().n();
                } else {
                    EntityFox.this.L().a((Entity)entityliving, 1.5);
                }
            }
        }
    }

    public class o
    extends PathfinderGoalWaterJumpAbstract {
        @Override
        public boolean a() {
            if (!EntityFox.this.gl()) {
                return false;
            }
            EntityLiving entityliving = EntityFox.this.q();
            if (entityliving != null && entityliving.bv()) {
                if (entityliving.cE() != entityliving.cD()) {
                    return false;
                }
                boolean flag = EntityFox.a(EntityFox.this, entityliving);
                if (!flag) {
                    EntityFox.this.L().a((Entity)entityliving, 0);
                    EntityFox.this.y(false);
                    EntityFox.this.z(false);
                }
                return flag;
            }
            return false;
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = EntityFox.this.q();
            if (entityliving != null && entityliving.bv()) {
                double d0 = EntityFox.this.do().d;
                return (d0 * d0 >= (double)0.05f || Math.abs(EntityFox.this.dD()) >= 15.0f || !EntityFox.this.aA()) && !EntityFox.this.gd();
            }
            return false;
        }

        @Override
        public boolean P_() {
            return false;
        }

        @Override
        public void c() {
            EntityFox.this.r(true);
            EntityFox.this.x(true);
            EntityFox.this.z(false);
            EntityLiving entityliving = EntityFox.this.q();
            if (entityliving != null) {
                EntityFox.this.G().a(entityliving, 60.0f, 30.0f);
                Vec3D vec3d = new Vec3D(entityliving.dq() - EntityFox.this.dq(), entityliving.ds() - EntityFox.this.ds(), entityliving.dw() - EntityFox.this.dw()).d();
                EntityFox.this.f(EntityFox.this.do().b(vec3d.c * 0.8, 0.9, vec3d.e * 0.8));
            }
            EntityFox.this.L().n();
        }

        @Override
        public void d() {
            EntityFox.this.y(false);
            EntityFox.this.cp = 0.0f;
            EntityFox.this.cq = 0.0f;
            EntityFox.this.z(false);
            EntityFox.this.x(false);
        }

        @Override
        public void e() {
            EntityLiving entityliving = EntityFox.this.q();
            if (entityliving != null) {
                EntityFox.this.G().a(entityliving, 60.0f, 30.0f);
            }
            if (!EntityFox.this.gd()) {
                Vec3D vec3d = EntityFox.this.do();
                if (vec3d.d * vec3d.d < (double)0.03f && EntityFox.this.dD() != 0.0f) {
                    EntityFox.this.s(MathHelper.j(0.2f, EntityFox.this.dD(), 0.0f));
                } else {
                    double d0 = vec3d.h();
                    double d1 = Math.signum(-vec3d.d) * Math.acos(d0 / vec3d.f()) * 57.2957763671875;
                    EntityFox.this.s((float)d1);
                }
            }
            if (entityliving != null && EntityFox.this.e((Entity)entityliving) <= 2.0f) {
                EntityFox.this.C(entityliving);
            } else if (EntityFox.this.dD() > 0.0f && EntityFox.this.aA() && (float)EntityFox.this.do().d != 0.0f && EntityFox.this.dL().a_(EntityFox.this.dl()).a(Blocks.dN)) {
                EntityFox.this.s(60.0f);
                EntityFox.this.h((EntityLiving)null);
                EntityFox.this.A(true);
            }
        }
    }

    private class s
    extends PathfinderGoalFleeSun {
        private int c;

        public s(double d0) {
            super(EntityFox.this, d0);
            this.c = net.minecraft.world.entity.animal.EntityFox$s.b(100);
        }

        @Override
        public boolean a() {
            if (!EntityFox.this.fC() && this.a.q() == null) {
                if (EntityFox.this.dL().Y() && EntityFox.this.dL().g(this.a.dl())) {
                    return this.h();
                }
                if (this.c > 0) {
                    --this.c;
                    return false;
                }
                this.c = 100;
                BlockPosition blockposition = this.a.dl();
                return EntityFox.this.dL().N() && EntityFox.this.dL().g(blockposition) && !((WorldServer)EntityFox.this.dL()).b(blockposition) && this.h();
            }
            return false;
        }

        @Override
        public void c() {
            EntityFox.this.gr();
            super.c();
        }
    }

    private class l
    extends PathfinderGoalMeleeAttack {
        public l(double d0, boolean flag) {
            super(EntityFox.this, d0, flag);
        }

        @Override
        protected void a(EntityLiving target) {
            if (this.b(target)) {
                this.h();
                this.a.C(target);
                EntityFox.this.a(SoundEffects.ia, 1.0f, 1.0f);
            }
        }

        @Override
        public void c() {
            EntityFox.this.z(false);
            super.c();
        }

        @Override
        public boolean a() {
            return !EntityFox.this.y() && !EntityFox.this.fC() && !EntityFox.this.bW() && !EntityFox.this.gd() && super.a();
        }
    }

    private class t
    extends d {
        private static final int c = net.minecraft.world.entity.animal.EntityFox$t.b(140);
        private int d;

        public t() {
            this.d = EntityFox.this.ag.a(c);
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b, PathfinderGoal.Type.c));
        }

        @Override
        public boolean a() {
            return EntityFox.this.bk == 0.0f && EntityFox.this.bl == 0.0f && EntityFox.this.bm == 0.0f ? this.k() || EntityFox.this.fC() : false;
        }

        @Override
        public boolean b() {
            return this.k();
        }

        private boolean k() {
            if (this.d > 0) {
                --this.d;
                return false;
            }
            return EntityFox.this.dL().N() && this.h() && !this.i() && !EntityFox.this.aA;
        }

        @Override
        public void d() {
            this.d = EntityFox.this.ag.a(c);
            EntityFox.this.gr();
        }

        @Override
        public void c() {
            EntityFox.this.w(false);
            EntityFox.this.y(false);
            EntityFox.this.z(false);
            EntityFox.this.r(false);
            EntityFox.this.C(true);
            EntityFox.this.L().n();
            EntityFox.this.I().a(EntityFox.this.dq(), EntityFox.this.ds(), EntityFox.this.dw(), 0.0);
        }
    }

    private class h
    extends PathfinderGoalFollowParent {
        private final EntityFox e;

        public h(EntityFox entityfox, double d0) {
            super(entityfox, d0);
            this.e = entityfox;
        }

        @Override
        public boolean a() {
            return !this.e.gp() && super.a();
        }

        @Override
        public boolean b() {
            return !this.e.gp() && super.b();
        }

        @Override
        public void c() {
            this.e.gr();
            super.c();
        }
    }

    private class q
    extends PathfinderGoalNearestVillage {
        public q(int i2, int j2) {
            super(EntityFox.this, j2);
        }

        @Override
        public void c() {
            EntityFox.this.gr();
            super.c();
        }

        @Override
        public boolean a() {
            return super.a() && this.h();
        }

        @Override
        public boolean b() {
            return super.b() && this.h();
        }

        private boolean h() {
            return !EntityFox.this.fC() && !EntityFox.this.y() && !EntityFox.this.gp() && EntityFox.this.q() == null;
        }
    }

    public class f
    extends PathfinderGoalGotoTarget {
        private static final int i = 40;
        protected int g;

        public f(double d0, int i2, int j2) {
            super(EntityFox.this, d0, i2, j2);
        }

        @Override
        public double i() {
            return 2.0;
        }

        @Override
        public boolean l() {
            return this.d % 100 == 0;
        }

        @Override
        protected boolean a(IWorldReader world, BlockPosition pos) {
            IBlockData iblockdata = world.a_(pos);
            return iblockdata.a(Blocks.oi) && iblockdata.c(BlockSweetBerryBush.b) >= 2 || CaveVines.h_(iblockdata);
        }

        @Override
        public void e() {
            if (this.m()) {
                if (this.g >= 40) {
                    this.o();
                } else {
                    ++this.g;
                }
            } else if (!this.m() && EntityFox.this.ag.i() < 0.05f) {
                EntityFox.this.a(SoundEffects.ig, 1.0f, 1.0f);
            }
            super.e();
        }

        protected void o() {
            if (EntityFox.this.dL().X().b(GameRules.c)) {
                IBlockData iblockdata = EntityFox.this.dL().a_(this.e);
                if (iblockdata.a(Blocks.oi)) {
                    this.b(iblockdata);
                } else if (CaveVines.h_(iblockdata)) {
                    this.a(iblockdata);
                }
            }
        }

        private void a(IBlockData state) {
            CaveVines.a(EntityFox.this, state, EntityFox.this.dL(), this.e);
        }

        private void b(IBlockData state) {
            int i2 = state.c(BlockSweetBerryBush.b);
            state.a(BlockSweetBerryBush.b, 1);
            if (!CraftEventFactory.callEntityChangeBlockEvent(EntityFox.this, this.e, (IBlockData)state.a(BlockSweetBerryBush.b, 1))) {
                return;
            }
            int j2 = 1 + EntityFox.this.dL().z.a(2) + (i2 == 3 ? 1 : 0);
            ItemStack itemstack = EntityFox.this.c(EnumItemSlot.a);
            if (itemstack.b()) {
                EntityFox.this.a(EnumItemSlot.a, new ItemStack(Items.vv));
                --j2;
            }
            if (j2 > 0) {
                Block.a(EntityFox.this.dL(), this.e, new ItemStack(Items.vv, j2));
            }
            EntityFox.this.a(SoundEffects.xF, 1.0f, 1.0f);
            EntityFox.this.dL().a(this.e, (IBlockData)state.a(BlockSweetBerryBush.b, 1), 2);
            EntityFox.this.dL().a(GameEvent.c, this.e, GameEvent.a.a(EntityFox.this));
        }

        @Override
        public boolean a() {
            return !EntityFox.this.fC() && super.a();
        }

        @Override
        public void c() {
            this.g = 0;
            EntityFox.this.w(false);
            super.c();
        }
    }

    private class p
    extends PathfinderGoal {
        public p() {
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            if (!EntityFox.this.c(EnumItemSlot.a).b()) {
                return false;
            }
            if (EntityFox.this.q() == null && EntityFox.this.eg() == null) {
                if (!EntityFox.this.gs()) {
                    return false;
                }
                if (EntityFox.this.ef().a(net.minecraft.world.entity.animal.EntityFox$p.b(10)) != 0) {
                    return false;
                }
                List<EntityItem> list = EntityFox.this.dL().a(EntityItem.class, EntityFox.this.cG().c(8.0, 8.0, 8.0), cf);
                return !list.isEmpty() && EntityFox.this.c(EnumItemSlot.a).b();
            }
            return false;
        }

        @Override
        public void e() {
            List<EntityItem> list = EntityFox.this.dL().a(EntityItem.class, EntityFox.this.cG().c(8.0, 8.0, 8.0), cf);
            ItemStack itemstack = EntityFox.this.c(EnumItemSlot.a);
            if (itemstack.b() && !list.isEmpty()) {
                EntityFox.this.L().a((Entity)list.get(0), (double)1.2f);
            }
        }

        @Override
        public void c() {
            List<EntityItem> list = EntityFox.this.dL().a(EntityItem.class, EntityFox.this.cG().c(8.0, 8.0, 8.0), cf);
            if (!list.isEmpty()) {
                EntityFox.this.L().a((Entity)list.get(0), (double)1.2f);
            }
        }
    }

    private class j
    extends PathfinderGoalLookAtPlayer {
        public j(EntityInsentient mob, Class targetType, float range) {
            super(mob, targetType, range);
        }

        @Override
        public boolean a() {
            return super.a() && !EntityFox.this.gd() && !EntityFox.this.gm();
        }

        @Override
        public boolean b() {
            return super.b() && !EntityFox.this.gd() && !EntityFox.this.gm();
        }
    }

    private class r
    extends d {
        private double c;
        private double d;
        private int e;
        private int f;

        public r() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            return EntityFox.this.eg() == null && EntityFox.this.ef().i() < 0.02f && !EntityFox.this.fC() && EntityFox.this.q() == null && EntityFox.this.L().l() && !this.i() && !EntityFox.this.gj() && !EntityFox.this.bW();
        }

        @Override
        public boolean b() {
            return this.f > 0;
        }

        @Override
        public void c() {
            this.k();
            this.f = 2 + EntityFox.this.ef().a(3);
            EntityFox.this.w(true);
            EntityFox.this.L().n();
        }

        @Override
        public void d() {
            EntityFox.this.w(false);
        }

        @Override
        public void e() {
            --this.e;
            if (this.e <= 0) {
                --this.f;
                this.k();
            }
            EntityFox.this.G().a(EntityFox.this.dq() + this.c, EntityFox.this.du(), EntityFox.this.dw() + this.d, EntityFox.this.Z(), EntityFox.this.Y());
        }

        private void k() {
            double d0 = Math.PI * 2 * EntityFox.this.ef().j();
            this.c = Math.cos(d0);
            this.d = Math.sin(d0);
            this.e = this.a(80 + EntityFox.this.ef().a(20));
        }
    }

    private class a
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        @Nullable
        private EntityLiving j;
        @Nullable
        private EntityLiving k;
        private int l;

        public a(Class oclass, boolean flag, @Nullable boolean flag1, Predicate<EntityLiving> predicate) {
            super(EntityFox.this, oclass, 10, flag, flag1, predicate);
        }

        @Override
        public boolean a() {
            if (this.b > 0 && this.e.ef().a(this.b) != 0) {
                return false;
            }
            for (UUID uuid : EntityFox.this.go()) {
                EntityLiving entityliving;
                Entity entity;
                if (uuid == null || !(EntityFox.this.dL() instanceof WorldServer) || !((entity = ((WorldServer)EntityFox.this.dL()).a(uuid)) instanceof EntityLiving)) continue;
                this.k = entityliving = (EntityLiving)entity;
                this.j = entityliving.eg();
                int i2 = entityliving.eh();
                return i2 != this.l && this.a(this.j, this.d);
            }
            return false;
        }

        @Override
        public void c() {
            this.a(this.j);
            this.c = this.j;
            if (this.k != null) {
                this.l = this.k.eh();
            }
            EntityFox.this.a(SoundEffects.hY, 1.0f, 1.0f);
            EntityFox.this.B(true);
            EntityFox.this.gq();
            super.c();
        }
    }

    public static enum Type implements INamable
    {
        a(0, "red"),
        b(1, "snow");

        public static final INamable.a<Type> c;
        private static final IntFunction<Type> d;
        private final int e;
        private final String f;

        private Type(int i2, String s2) {
            this.e = i2;
            this.f = s2;
        }

        @Override
        public String c() {
            return this.f;
        }

        public int a() {
            return this.e;
        }

        public static Type a(String name) {
            return c.a(name, a);
        }

        public static Type a(int id) {
            return d.apply(id);
        }

        public static Type a(Holder<BiomeBase> biome) {
            return biome.a(BiomeTags.aq) ? b : a;
        }

        static {
            c = INamable.a(Type::values);
            d = ByIdMap.a(Type::a, Type.values(), ByIdMap.a.a);
        }
    }

    public static class i
    extends EntityAgeable.a {
        public final Type a;

        public i(Type type) {
            super(false);
            this.a = type;
        }
    }

    public class c
    implements Predicate<EntityLiving> {
        public boolean a(EntityLiving entityliving) {
            return entityliving instanceof EntityFox ? false : (!(entityliving instanceof EntityChicken || entityliving instanceof EntityRabbit || entityliving instanceof EntityMonster) ? (entityliving instanceof EntityTameableAnimal ? !((EntityTameableAnimal)entityliving).s() : (entityliving instanceof EntityHuman && (entityliving.M_() || ((EntityHuman)entityliving).f()) ? false : (EntityFox.this.c(entityliving.cv()) ? false : !entityliving.fC() && !entityliving.bU()))) : true);
        }
    }

    private abstract class d
    extends PathfinderGoal {
        private final PathfinderTargetCondition b;

        d() {
            this.b = PathfinderTargetCondition.a().a(12.0).d().a(new c());
        }

        protected boolean h() {
            BlockPosition blockposition = BlockPosition.a(EntityFox.this.dq(), EntityFox.this.cG().e, EntityFox.this.dw());
            return !EntityFox.this.dL().g(blockposition) && EntityFox.this.h(blockposition) >= 0.0f;
        }

        protected boolean i() {
            return !EntityFox.this.dL().a(EntityLiving.class, this.b, EntityFox.this, EntityFox.this.cG().c(12.0, 6.0, 12.0)).isEmpty();
        }
    }
}

