/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.ISteerable;
import net.minecraft.world.entity.SaddleStorage;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.joml.Vector3f;

public class EntityPig
extends EntityAnimal
implements ISteerable,
ISaddleable {
    private static final DataWatcherObject<Boolean> bT = DataWatcher.a(EntityPig.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bU = DataWatcher.a(EntityPig.class, DataWatcherRegistry.b);
    private static final RecipeItemStack bW = RecipeItemStack.a(Items.tl, Items.tm, Items.uq);
    public final SaddleStorage bX;

    public EntityPig(EntityTypes<? extends EntityPig> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.bX = new SaddleStorage(this.an, bU, bT);
    }

    @Override
    protected void z() {
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(1, new PathfinderGoalPanic(this, 1.25));
        this.bO.a(3, new PathfinderGoalBreed(this, 1.0));
        this.bO.a(4, new PathfinderGoalTempt(this, 1.2, RecipeItemStack.a(Items.nf), false));
        this.bO.a(4, new PathfinderGoalTempt(this, 1.2, bW, false));
        this.bO.a(5, new PathfinderGoalFollowParent(this, 1.1));
        this.bO.a(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bO.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(8, new PathfinderGoalRandomLookaround(this));
    }

    public static AttributeProvider.Builder s() {
        return EntityInsentient.A().a(GenericAttributes.a, 10.0).a(GenericAttributes.d, 0.25);
    }

    @Override
    @Nullable
    public EntityLiving cN() {
        EntityHuman entityhuman;
        Entity entity;
        if (this.i() && (entity = this.cQ()) instanceof EntityHuman && (entityhuman = (EntityHuman)entity).b(Items.nf)) {
            return entityhuman;
        }
        return super.cN();
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bU.equals(data) && this.dL().B) {
            this.bX.a();
        }
        super.a(data);
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(bT, false);
        this.an.a(bU, 0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        this.bX.a(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.bX.b(nbt);
    }

    @Override
    protected SoundEffect w() {
        return SoundEffects.rO;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.rQ;
    }

    @Override
    public SoundEffect l_() {
        return SoundEffects.rP;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.rS, 0.15f, 1.0f);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        boolean flag = this.m(player.b(hand));
        if (!flag && this.i() && !this.bO() && !player.fH()) {
            if (!this.dL().B) {
                player.n(this);
            }
            return EnumInteractionResult.a(this.dL().B);
        }
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (!enuminteractionresult.a()) {
            ItemStack itemstack = player.b(hand);
            return itemstack.a(Items.mZ) ? itemstack.a(player, (EntityLiving)this, hand) : EnumInteractionResult.d;
        }
        return enuminteractionresult;
    }

    @Override
    public boolean g() {
        return this.bv() && !this.m_();
    }

    @Override
    protected void ex() {
        super.ex();
        if (this.i()) {
            this.a((IMaterial)Items.mZ);
        }
    }

    @Override
    public boolean i() {
        return this.bX.d();
    }

    @Override
    public void a(@Nullable SoundCategory sound) {
        this.bX.a(true);
        if (sound != null) {
            this.dL().a((EntityHuman)null, this, SoundEffects.rR, sound, 0.5f, 1.0f);
        }
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        EnumDirection enumdirection = this.cE();
        if (enumdirection.o() == EnumDirection.EnumAxis.b) {
            return super.b(passenger);
        }
        int[][] aint = DismountUtil.a(enumdirection);
        BlockPosition blockposition = this.dl();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (EntityPose entitypose : passenger.fz()) {
            AxisAlignedBB axisalignedbb = passenger.e(entitypose);
            int[][] aint1 = aint;
            int i2 = aint.length;
            for (int j2 = 0; j2 < i2; ++j2) {
                int[] aint2 = aint1[j2];
                blockposition_mutableblockposition.d(blockposition.u() + aint2[0], blockposition.v(), blockposition.w() + aint2[1]);
                double d0 = this.dL().i(blockposition_mutableblockposition);
                if (!DismountUtil.a(d0)) continue;
                Vec3D vec3d = Vec3D.a(blockposition_mutableblockposition, d0);
                if (!DismountUtil.a(this.dL(), passenger, axisalignedbb.c(vec3d))) continue;
                passenger.b(entitypose);
                return vec3d;
            }
        }
        return super.b(passenger);
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
        if (world.ai() != EnumDifficulty.a) {
            EntityPigZombie entitypigzombie = EntityTypes.bs.a(world);
            if (entitypigzombie != null) {
                entitypigzombie.a(EnumItemSlot.a, new ItemStack(Items.oh));
                entitypigzombie.b(this.dq(), this.ds(), this.dw(), this.dB(), this.dD());
                entitypigzombie.t(this.fT());
                entitypigzombie.a(this.m_());
                if (this.ac()) {
                    entitypigzombie.b(this.ad());
                    entitypigzombie.n(this.cA());
                }
                entitypigzombie.fI();
                if (CraftEventFactory.callPigZapEvent(this, lightning, entitypigzombie).isCancelled()) {
                    return;
                }
                world.addFreshEntity(entitypigzombie, CreatureSpawnEvent.SpawnReason.LIGHTNING);
                this.ak();
            } else {
                super.a(world, lightning);
            }
        } else {
            super.a(world, lightning);
        }
    }

    @Override
    protected void a(EntityHuman controllingPlayer, Vec3D movementInput) {
        super.a(controllingPlayer, movementInput);
        this.a(controllingPlayer.dB(), controllingPlayer.dD() * 0.5f);
        this.aU = this.aW = this.dB();
        this.N = this.aW;
        this.bX.b();
    }

    @Override
    protected Vec3D b(EntityHuman controllingPlayer, Vec3D movementInput) {
        return new Vec3D(0.0, 0.0, 1.0);
    }

    @Override
    protected float e(EntityHuman controllingPlayer) {
        return (float)(this.b(GenericAttributes.d) * 0.225 * (double)this.bX.c());
    }

    @Override
    public boolean a() {
        return this.bX.a(this.ef());
    }

    @Nullable
    public EntityPig b(WorldServer world, EntityAgeable entity) {
        return EntityTypes.av.a(world);
    }

    @Override
    public boolean m(ItemStack stack) {
        return bW.a(stack);
    }

    @Override
    public Vec3D cI() {
        return new Vec3D(0.0, 0.6f * this.cH(), this.df() * 0.4f);
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b - 0.03125f * scaleFactor, 0.0f);
    }
}

