/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;

public class EntitySnowman
extends EntityGolem
implements IShearable,
IRangedEntity {
    private static final DataWatcherObject<Byte> b = DataWatcher.a(EntitySnowman.class, DataWatcherRegistry.a);
    private static final byte c = 16;
    private static final float d = 1.7f;

    public EntitySnowman(EntityTypes<? extends EntitySnowman> type, World world) {
        super((EntityTypes<? extends EntityGolem>)type, world);
    }

    @Override
    protected void z() {
        this.bO.a(1, new PathfinderGoalArrowAttack(this, 1.25, 20, 10.0f));
        this.bO.a(2, new PathfinderGoalRandomStrollLand((EntityCreature)this, 1.0, 1.0000001E-5f));
        this.bO.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(4, new PathfinderGoalRandomLookaround(this));
        this.bP.a(1, new PathfinderGoalNearestAttackableTarget<EntityInsentient>(this, EntityInsentient.class, 10, true, false, entityliving -> entityliving instanceof IMonster));
    }

    public static AttributeProvider.Builder s() {
        return EntityInsentient.A().a(GenericAttributes.a, 4.0).a(GenericAttributes.d, 0.2f);
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(b, (byte)16);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Pumpkin", this.t());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.e("Pumpkin")) {
            this.w(nbt.q("Pumpkin"));
        }
    }

    @Override
    public boolean ff() {
        return true;
    }

    @Override
    public void b_() {
        super.b_();
        if (!this.dL().B) {
            if (this.dL().s(this.dl()).a(BiomeTags.ad)) {
                this.a(this.dM().melting, 1.0f);
            }
            if (!this.dL().X().b(GameRules.c)) {
                return;
            }
            IBlockData iblockdata = Blocks.dN.n();
            for (int i2 = 0; i2 < 4; ++i2) {
                int j2 = MathHelper.a(this.dq() + (double)((float)(i2 % 2 * 2 - 1) * 0.25f));
                int k2 = MathHelper.a(this.ds());
                int l2 = MathHelper.a(this.dw() + (double)((float)(i2 / 2 % 2 * 2 - 1) * 0.25f));
                BlockPosition blockposition = new BlockPosition(j2, k2, l2);
                if (!this.dL().a_(blockposition).i() || !iblockdata.a((IWorldReader)this.dL(), blockposition) || !CraftEventFactory.handleBlockFormEvent(this.dL(), blockposition, iblockdata, this)) continue;
                this.dL().a(GameEvent.i, blockposition, GameEvent.a.a(this, iblockdata));
            }
        }
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        EntitySnowball entitysnowball = new EntitySnowball(this.dL(), this);
        double d0 = target.du() - (double)1.1f;
        double d1 = target.dq() - this.dq();
        double d2 = d0 - entitysnowball.ds();
        double d3 = target.dw() - this.dw();
        double d4 = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
        entitysnowball.c(d1, d2 + d4, d3, 1.6f, 12.0f);
        this.a(SoundEffects.wT, 1.0f, 0.4f / (this.ef().i() * 0.4f + 0.8f));
        this.dL().b(entitysnowball);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 1.7f;
    }

    @Override
    protected EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.rg) && this.a()) {
            if (!CraftEventFactory.handlePlayerShearEntityEvent(player, this, itemstack, hand)) {
                return EnumInteractionResult.d;
            }
            this.a(SoundCategory.h);
            this.a(GameEvent.M, (Entity)player);
            if (!this.dL().B) {
                itemstack.a(1, player, (T entityhuman1) -> entityhuman1.d(hand));
            }
            return EnumInteractionResult.a(this.dL().B);
        }
        return EnumInteractionResult.d;
    }

    @Override
    public void a(SoundCategory shearedSoundCategory) {
        this.dL().a((EntityHuman)null, this, SoundEffects.wU, shearedSoundCategory, 1.0f, 1.0f);
        if (!this.dL().w_()) {
            this.w(false);
            this.forceDrops = true;
            this.a(new ItemStack(Items.eP), 1.7f);
            this.forceDrops = false;
        }
    }

    @Override
    public boolean a() {
        return this.bv() && this.t();
    }

    public boolean t() {
        return (this.an.b(b) & 0x10) != 0;
    }

    public void w(boolean hasPumpkin) {
        byte b0 = this.an.b(b);
        if (hasPumpkin) {
            this.an.b(b, (byte)(b0 | 0x10));
        } else {
            this.an.b(b, (byte)(b0 & 0xFFFFFFEF));
        }
    }

    @Override
    @Nullable
    protected SoundEffect w() {
        return SoundEffects.wQ;
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.wS;
    }

    @Override
    @Nullable
    public SoundEffect l_() {
        return SoundEffects.wR;
    }

    @Override
    public Vec3D cI() {
        return new Vec3D(0.0, 0.75f * this.cH(), this.df() * 0.4f);
    }
}

