/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import io.papermc.paper.event.entity.EntityDyeEvent;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.IEntityAngerable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBeg;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowOwner;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSit;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalOwnerHurtTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalRandomTargetNonTamed;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalUniversalAngerReset;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityGhast;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.DyeColor;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.joml.Vector3f;

public class EntityWolf
extends EntityTameableAnimal
implements IEntityAngerable {
    private static final DataWatcherObject<Boolean> bX = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bY = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> bZ = DataWatcher.a(EntityWolf.class, DataWatcherRegistry.b);
    public static final Predicate<EntityLiving> bW = entityliving -> {
        EntityTypes<?> entitytypes = entityliving.ag();
        return entitytypes == EntityTypes.aF || entitytypes == EntityTypes.aC || entitytypes == EntityTypes.N;
    };
    private static final float ca = 8.0f;
    private static final float cb = 20.0f;
    private float cc;
    private float cd;
    private boolean ce;
    private boolean cf;
    private float cg;
    private float ch;
    private static final UniformInt ci = TimeRange.a(20, 39);
    @Nullable
    private UUID cj;

    public EntityWolf(EntityTypes<? extends EntityWolf> type, World world) {
        super((EntityTypes<? extends EntityTameableAnimal>)type, world);
        this.x(false);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    @Override
    protected void z() {
        this.bO.a(1, new PathfinderGoalFloat(this));
        this.bO.a(1, new b(1.5));
        this.bO.a(2, new PathfinderGoalSit(this));
        this.bO.a(3, new a(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.bO.a(4, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.bO.a(5, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bO.a(6, new PathfinderGoalFollowOwner(this, 1.0, 10.0f, 2.0f, false));
        this.bO.a(7, new PathfinderGoalBreed(this, 1.0));
        this.bO.a(8, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bO.a(9, new PathfinderGoalBeg(this, 8.0f));
        this.bO.a(10, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(10, new PathfinderGoalRandomLookaround(this));
        this.bP.a(1, new PathfinderGoalOwnerHurtByTarget(this));
        this.bP.a(2, new PathfinderGoalOwnerHurtTarget(this));
        this.bP.a(3, new PathfinderGoalHurtByTarget(this, new Class[0]).a(new Class[0]));
        this.bP.a(4, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, this::a_));
        this.bP.a(5, new PathfinderGoalRandomTargetNonTamed<EntityAnimal>(this, EntityAnimal.class, false, bW));
        this.bP.a(6, new PathfinderGoalRandomTargetNonTamed<EntityTurtle>(this, EntityTurtle.class, false, EntityTurtle.bU));
        this.bP.a(7, new PathfinderGoalNearestAttackableTarget<EntitySkeletonAbstract>((EntityInsentient)this, EntitySkeletonAbstract.class, false));
        this.bP.a(8, new PathfinderGoalUniversalAngerReset<EntityWolf>(this, true));
    }

    public static AttributeProvider.Builder gj() {
        return EntityInsentient.A().a(GenericAttributes.d, 0.3f).a(GenericAttributes.a, 8.0).a(GenericAttributes.f, 2.0);
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(bX, false);
        this.an.a(bY, EnumColor.o.a());
        this.an.a(bZ, 0);
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.AA, 0.15f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("CollarColor", (byte)this.gm().a());
        this.c(nbt);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("CollarColor", 99)) {
            this.a(EnumColor.a(nbt.h("CollarColor")));
        }
        this.a(this.dL(), nbt);
    }

    @Override
    protected SoundEffect w() {
        return this.X_() ? SoundEffects.Av : (this.ag.a(3) == 0 ? (this.s() && this.eu() < 10.0f ? SoundEffects.AB : SoundEffects.Ay) : SoundEffects.At);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.Ax;
    }

    @Override
    public SoundEffect l_() {
        return SoundEffects.Au;
    }

    @Override
    public float eV() {
        return 0.4f;
    }

    @Override
    public void b_() {
        super.b_();
        if (!this.dL().B && this.ce && !this.cf && !this.fZ() && this.aA()) {
            this.cf = true;
            this.cg = 0.0f;
            this.ch = 0.0f;
            this.dL().a((Entity)this, (byte)8);
        }
        if (!this.dL().B) {
            this.a((WorldServer)this.dL(), true);
        }
    }

    @Override
    public void l() {
        super.l();
        if (this.bv()) {
            this.cd = this.cc;
            this.cc = this.gn() ? (this.cc += (1.0f - this.cc) * 0.4f) : (this.cc += (0.0f - this.cc) * 0.4f);
            if (this.aZ()) {
                this.ce = true;
                if (this.cf && !this.dL().B) {
                    this.dL().a((Entity)this, (byte)56);
                    this.go();
                }
            } else if ((this.ce || this.cf) && this.cf) {
                if (this.cg == 0.0f) {
                    this.a(SoundEffects.Az, this.eV(), (this.ag.i() - this.ag.i()) * 0.2f + 1.0f);
                    this.a(GameEvent.u);
                }
                this.ch = this.cg;
                this.cg += 0.05f;
                if (this.ch >= 2.0f) {
                    this.ce = false;
                    this.cf = false;
                    this.ch = 0.0f;
                    this.cg = 0.0f;
                }
                if (this.cg > 0.4f) {
                    float f2 = (float)this.ds();
                    int i2 = (int)(MathHelper.a((this.cg - 0.4f) * (float)Math.PI) * 7.0f);
                    Vec3D vec3d = this.do();
                    for (int j2 = 0; j2 < i2; ++j2) {
                        float f1 = (this.ag.i() * 2.0f - 1.0f) * this.df() * 0.5f;
                        float f22 = (this.ag.i() * 2.0f - 1.0f) * this.df() * 0.5f;
                        this.dL().a(Particles.ag, this.dq() + (double)f1, (double)(f2 + 0.8f), this.dw() + (double)f22, vec3d.c, vec3d.d, vec3d.e);
                    }
                }
            }
        }
    }

    private void go() {
        this.cf = false;
        this.cg = 0.0f;
        this.ch = 0.0f;
    }

    @Override
    public void a(DamageSource damageSource) {
        this.ce = false;
        this.cf = false;
        this.ch = 0.0f;
        this.cg = 0.0f;
        super.a(damageSource);
    }

    public boolean gk() {
        return this.ce;
    }

    public float E(float tickDelta) {
        return Math.min(0.5f + MathHelper.i(tickDelta, this.ch, this.cg) / 2.0f * 0.5f, 1.0f);
    }

    public float f(float tickDelta, float f1) {
        float f2 = (MathHelper.i(tickDelta, this.ch, this.cg) + f1) / 1.8f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return MathHelper.a(f2 * (float)Math.PI) * MathHelper.a(f2 * (float)Math.PI * 11.0f) * 0.15f * (float)Math.PI;
    }

    public float F(float tickDelta) {
        return MathHelper.i(tickDelta, this.cd, this.cc) * 0.15f * (float)Math.PI;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.8f;
    }

    @Override
    public int Y() {
        return this.y() ? 20 : super.Y();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        Entity entity = source.d();
        if (entity != null && !(entity instanceof EntityHuman) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        boolean result = super.a(source, amount);
        if (!this.dL().B && result) {
            this.z(false);
        }
        return result;
    }

    @Override
    public boolean C(Entity target) {
        boolean flag = target.a(this.dM().b(this), (float)((int)this.b(GenericAttributes.f)));
        if (flag) {
            this.a((EntityLiving)this, target);
        }
        return flag;
    }

    @Override
    public void x(boolean tamed) {
        super.x(tamed);
        if (tamed) {
            this.a(GenericAttributes.a).a(20.0);
            this.c(this.eL());
        } else {
            this.a(GenericAttributes.a).a(8.0);
        }
        this.a(GenericAttributes.f).a(4.0);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        Item item = itemstack.d();
        if (this.dL().B) {
            boolean flag = this.j(player) || this.s() || itemstack.a(Items.qL) && !this.s() && !this.X_();
            return flag ? EnumInteractionResult.b : EnumInteractionResult.d;
        }
        if (this.s()) {
            EnumInteractionResult enuminteractionresult;
            if (this.m(itemstack) && this.eu() < this.eL()) {
                if (!player.fS().d) {
                    itemstack.h(1);
                }
                this.heal(item.v().a(), EntityRegainHealthEvent.RegainReason.EATING);
                return EnumInteractionResult.a;
            }
            if (item instanceof ItemDye) {
                ItemDye itemdye = (ItemDye)item;
                if (this.j(player)) {
                    EnumColor enumcolor = itemdye.d();
                    if (enumcolor != this.gm()) {
                        EntityDyeEvent event = new EntityDyeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), DyeColor.getByWoolData((byte)((byte)enumcolor.a())), (Player)((EntityPlayer)player).getBukkitEntity());
                        if (!event.callEvent()) {
                            return EnumInteractionResult.e;
                        }
                        enumcolor = EnumColor.a(event.getColor().getWoolData());
                        this.a(enumcolor);
                        if (!player.fS().d) {
                            itemstack.h(1);
                        }
                        return EnumInteractionResult.a;
                    }
                    return super.b(player, hand);
                }
            }
            if ((!(enuminteractionresult = super.b(player, hand)).a() || this.m_()) && this.j(player)) {
                this.z(!this.gd());
                this.bj = false;
                this.bN.n();
                this.setTarget(null, EntityTargetEvent.TargetReason.FORGOT_TARGET, true);
                return EnumInteractionResult.a;
            }
            return enuminteractionresult;
        }
        if (itemstack.a(Items.qL) && !this.X_()) {
            if (!player.fS().d) {
                itemstack.h(1);
            }
            if (this.ag.a(3) == 0 && !CraftEventFactory.callEntityTameEvent(this, player).isCancelled()) {
                this.f(player);
                this.bN.n();
                this.h((EntityLiving)null);
                this.z(true);
                this.dL().a((Entity)this, (byte)7);
            } else {
                this.dL().a((Entity)this, (byte)6);
            }
            return EnumInteractionResult.a;
        }
        return super.b(player, hand);
    }

    @Override
    public void b(byte status) {
        if (status == 8) {
            this.cf = true;
            this.cg = 0.0f;
            this.ch = 0.0f;
        } else if (status == 56) {
            this.go();
        } else {
            super.b(status);
        }
    }

    public float gl() {
        return this.X_() ? 1.5393804f : (this.s() ? (0.55f - (this.eL() - this.eu()) * 0.02f) * (float)Math.PI : 0.62831855f);
    }

    @Override
    public boolean m(ItemStack stack) {
        Item item = stack.d();
        return item.u() && item.v().c();
    }

    @Override
    public int fH() {
        return 8;
    }

    @Override
    public int a() {
        return this.an.b(bZ);
    }

    @Override
    public void a(int angerTime) {
        this.an.b(bZ, angerTime);
    }

    @Override
    public void c() {
        this.a(ci.a(this.ag));
    }

    @Override
    @Nullable
    public UUID b() {
        return this.cj;
    }

    @Override
    public void a(@Nullable UUID angryAt) {
        this.cj = angryAt;
    }

    public EnumColor gm() {
        return EnumColor.a(this.an.b(bY));
    }

    public void a(EnumColor color) {
        this.an.b(bY, color.a());
    }

    @Nullable
    public EntityWolf b(WorldServer world, EntityAgeable entity) {
        UUID uuid;
        EntityWolf entitywolf = EntityTypes.bn.a(world);
        if (entitywolf != null && (uuid = this.d()) != null) {
            entitywolf.b(uuid);
            entitywolf.x(true);
        }
        return entitywolf;
    }

    public void A(boolean begging) {
        this.an.b(bX, begging);
    }

    @Override
    public boolean a(EntityAnimal other) {
        if (other == this) {
            return false;
        }
        if (!this.s()) {
            return false;
        }
        if (!(other instanceof EntityWolf)) {
            return false;
        }
        EntityWolf entitywolf = (EntityWolf)other;
        return !entitywolf.s() ? false : (entitywolf.y() ? false : this.gh() && entitywolf.gh());
    }

    public boolean gn() {
        return this.an.b(bX);
    }

    @Override
    public boolean a(EntityLiving target, EntityLiving owner) {
        if (!(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            if (target instanceof EntityWolf) {
                EntityWolf entitywolf = (EntityWolf)target;
                return !entitywolf.s() || entitywolf.O_() != owner;
            }
            return target instanceof EntityHuman && owner instanceof EntityHuman && !((EntityHuman)owner).a((EntityHuman)target) ? false : (target instanceof EntityHorseAbstract && ((EntityHorseAbstract)target).gs() ? false : !(target instanceof EntityTameableAnimal) || !((EntityTameableAnimal)target).s());
        }
        return false;
    }

    @Override
    public boolean a(EntityHuman player) {
        return !this.X_() && super.a(player);
    }

    @Override
    public Vec3D cI() {
        return new Vec3D(0.0, 0.6f * this.cH(), this.df() * 0.4f);
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b - 0.03125f * scaleFactor, -0.0625f * scaleFactor);
    }

    public static boolean c(EntityTypes<EntityWolf> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.d()).a(TagsBlock.bX) && EntityWolf.a(world, pos);
    }

    private class b
    extends PathfinderGoalPanic {
        public b(double d0) {
            super(EntityWolf.this, d0);
        }

        @Override
        protected boolean h() {
            return this.b.dA() || this.b.bM();
        }
    }

    private class a<T extends EntityLiving>
    extends PathfinderGoalAvoidTarget<T> {
        private final EntityWolf j;

        public a(EntityWolf entitywolf, Class oclass, float f2, double d0, double d1) {
            super(entitywolf, oclass, f2, d0, d1);
            this.j = entitywolf;
        }

        @Override
        public boolean a() {
            return super.a() && this.b instanceof EntityLlama ? !this.j.s() && this.a((EntityLlama)this.b) : false;
        }

        private boolean a(EntityLlama llama) {
            return llama.gn() >= EntityWolf.this.ag.a(5);
        }

        @Override
        public void c() {
            EntityWolf.this.h((EntityLiving)null);
            super.c();
        }

        @Override
        public void e() {
            EntityWolf.this.h((EntityLiving)null);
            super.e();
        }
    }
}

