/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.axolotl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.LerpingModel;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.joml.Vector3f;

public class Axolotl
extends EntityAnimal
implements LerpingModel,
VariantHolder<Variant>,
Bucketable {
    public static final int bT = 200;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Axolotl>>> bU = ImmutableList.of(SensorType.c, SensorType.n, SensorType.f, SensorType.o, SensorType.p);
    protected static final ImmutableList<? extends MemoryModuleType<?>> bW = ImmutableList.of(MemoryModuleType.r, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.n, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.o, MemoryModuleType.p, MemoryModuleType.J, (Object[])new MemoryModuleType[]{MemoryModuleType.y, MemoryModuleType.M, MemoryModuleType.B, MemoryModuleType.N, MemoryModuleType.O, MemoryModuleType.Q, MemoryModuleType.T, MemoryModuleType.Y});
    private static final DataWatcherObject<Integer> ca = DataWatcher.a(Axolotl.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> cb = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> cc = DataWatcher.a(Axolotl.class, DataWatcherRegistry.k);
    public static final double bX = 20.0;
    public static final int bY = 1200;
    private static final int cd = 6000;
    public static final String bZ = "Variant";
    private static final int ce = 1800;
    private static final int cf = 2400;
    private final Map<String, Vector3f> cg = Maps.newHashMap();
    private static final int ch = 100;

    @Override
    public int getDefaultMaxAirSupply() {
        return 6000;
    }

    public Axolotl(EntityTypes<? extends Axolotl> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.a(PathType.j, 0.0f);
        this.bL = new c(this);
        this.bK = new b(this, 20);
        this.t(1.0f);
    }

    @Override
    public Map<String, Vector3f> a() {
        return this.cg;
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return 0.0f;
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(ca, 0);
        this.an.a(cb, false);
        this.an.a(cc, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a(bZ, this.gd().a());
        nbt.a("FromBucket", this.t());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(Variant.a(nbt.h(bZ)));
        this.w(nbt.q("FromBucket"));
    }

    @Override
    public void P() {
        if (!this.gj()) {
            super.P();
        }
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        boolean flag = false;
        if (spawnReason == EnumMobSpawn.l) {
            return entityData;
        }
        RandomSource randomsource = world.D_();
        if (entityData instanceof a) {
            if (((a)entityData).a() >= 2) {
                flag = true;
            }
        } else {
            entityData = new a(Variant.a(randomsource), Variant.a(randomsource));
        }
        this.a(((a)entityData).a(randomsource));
        if (flag) {
            this.c_(-24000);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public void aq() {
        int i2 = this.ch();
        super.aq();
        if (!this.fT()) {
            this.t(i2);
        }
    }

    protected void t(int air) {
        if (this.bv() && !this.aZ()) {
            this.j(air - 1);
            if (this.ch() == -20) {
                this.j(0);
                this.a(this.dM().r(), 2.0f);
            }
        } else {
            this.j(this.cg());
        }
    }

    public void s() {
        int i2 = this.ch() + 1800;
        this.j(Math.min(i2, this.cg()));
    }

    @Override
    public int cg() {
        return this.maxAirTicks;
    }

    public Variant gd() {
        return Variant.a(this.an.b(ca));
    }

    @Override
    public void a(Variant variant) {
        this.an.b(ca, variant.a());
    }

    private static boolean a(RandomSource random) {
        return random.a(1200) == 0;
    }

    @Override
    public boolean a(IWorldReader world) {
        return world.f(this);
    }

    @Override
    public boolean dQ() {
        return true;
    }

    @Override
    public boolean cy() {
        return false;
    }

    @Override
    public EnumMonsterType eR() {
        return EnumMonsterType.e;
    }

    public void x(boolean playingDead) {
        this.an.b(cb, playingDead);
    }

    public boolean gj() {
        return this.an.b(cb);
    }

    @Override
    public boolean t() {
        return this.an.b(cc);
    }

    @Override
    public void w(boolean fromBucket) {
        this.an.b(cc, fromBucket);
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        Axolotl axolotl = EntityTypes.f.a(world);
        if (axolotl != null) {
            Variant axolotl_variant = Axolotl.a(this.ag) ? Variant.b(this.ag) : (this.ag.h() ? this.gd() : ((Axolotl)entity).gd());
            axolotl.a(axolotl_variant);
            axolotl.fI();
        }
        return axolotl;
    }

    @Override
    public boolean m(ItemStack stack) {
        return stack.a(TagsItem.aA);
    }

    @Override
    public boolean a(EntityHuman player) {
        return true;
    }

    @Override
    protected void X() {
        this.dL().ad().a("axolotlBrain");
        this.dN().a((WorldServer)this.dL(), this);
        this.dL().ad().c();
        this.dL().ad().a("axolotlActivityUpdate");
        AxolotlAi.a(this);
        this.dL().ad().c();
        if (!this.fT()) {
            Optional<Integer> optional = this.dN().c(MemoryModuleType.M);
            this.x(optional.isPresent() && optional.get() > 0);
        }
    }

    public static AttributeProvider.Builder gk() {
        return EntityInsentient.A().a(GenericAttributes.a, 14.0).a(GenericAttributes.d, 1.0).a(GenericAttributes.f, 2.0);
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new AmphibiousPathNavigation(this, world);
    }

    @Override
    public boolean C(Entity target) {
        boolean flag = target.a(this.dM().b(this), (float)((int)this.b(GenericAttributes.f)));
        if (flag) {
            this.a((EntityLiving)this, target);
            this.a(SoundEffects.av, 1.0f, 1.0f);
        }
        return flag;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        float f1 = this.eu();
        if (!(this.dL().B || this.fT() || this.dL().z.a(3) != 0 || !((float)this.dL().z.a(3) < amount) && !(f1 / this.eL() < 0.5f) || !(amount < f1) || !this.aX() || source.d() == null && source.c() == null || this.gj())) {
            this.bz.a(MemoryModuleType.M, Integer.valueOf(200));
        }
        return super.a(source, amount);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.655f;
    }

    @Override
    public int Y() {
        return 1;
    }

    @Override
    public int Z() {
        return 1;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        return Bucketable.a(player, hand, this).orElse(super.b(player, hand));
    }

    @Override
    public void l(ItemStack stack) {
        Bucketable.a((EntityInsentient)this, stack);
        NBTTagCompound nbttagcompound = stack.w();
        nbttagcompound.a(bZ, this.gd().a());
        nbttagcompound.a("Age", this.h());
        BehaviorController<Axolotl> behaviorcontroller = this.dN();
        if (behaviorcontroller.a(MemoryModuleType.T)) {
            nbttagcompound.a("HuntingCooldown", behaviorcontroller.e(MemoryModuleType.T));
        }
    }

    @Override
    public void c(NBTTagCompound nbt) {
        Bucketable.a((EntityInsentient)this, nbt);
        this.a(Variant.a(nbt.h(bZ)));
        if (nbt.e("Age")) {
            this.c_(nbt.h("Age"));
        }
        if (nbt.e("HuntingCooldown")) {
            this.dN().a(MemoryModuleType.T, true, nbt.i("HuntingCooldown"));
        }
    }

    @Override
    public ItemStack b() {
        return new ItemStack(Items.pV);
    }

    @Override
    public SoundEffect y() {
        return SoundEffects.cC;
    }

    @Override
    public boolean en() {
        return !this.gj() && super.en();
    }

    public static void a(Axolotl axolotl, EntityLiving entity) {
        Entity entity1;
        DamageSource damagesource;
        World world = axolotl.dL();
        if (entity.ev() && (damagesource = entity.ew()) != null && (entity1 = damagesource.d()) != null && entity1.ag() == EntityTypes.bt) {
            EntityHuman entityhuman = (EntityHuman)entity1;
            List<EntityHuman> list = world.a(EntityHuman.class, axolotl.cG().g(20.0));
            if (list.contains(entityhuman)) {
                axolotl.f(entityhuman);
            }
        }
    }

    public void f(EntityHuman player) {
        MobEffect mobeffect = player.b(MobEffects.j);
        if (mobeffect == null || mobeffect.a(2399)) {
            int i2 = mobeffect != null ? mobeffect.d() : 0;
            int j2 = Math.min(2400, 100 + i2);
            player.addEffect(new MobEffect(MobEffects.j, j2, 0), this, EntityPotionEffectEvent.Cause.AXOLOTL);
        }
        player.removeEffect(MobEffects.d, EntityPotionEffectEvent.Cause.AXOLOTL);
    }

    @Override
    public boolean U() {
        return super.U() || this.t();
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.ax;
    }

    @Override
    @Nullable
    public SoundEffect l_() {
        return SoundEffects.aw;
    }

    @Override
    @Nullable
    protected SoundEffect w() {
        return this.aX() ? SoundEffects.az : SoundEffects.ay;
    }

    @Override
    protected SoundEffect aM() {
        return SoundEffects.aA;
    }

    @Override
    protected SoundEffect aL() {
        return SoundEffects.aB;
    }

    protected BehaviorController.b<Axolotl> dO() {
        return BehaviorController.a(bW, bU);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return AxolotlAi.a(this.dO().a(dynamic));
    }

    public BehaviorController<Axolotl> dN() {
        return super.dN();
    }

    @Override
    protected void W() {
        super.W();
        PacketDebug.a(this);
    }

    @Override
    public void h(Vec3D movementInput) {
        if (this.cW() && this.aX()) {
            this.a(this.fe(), movementInput);
            this.a(EnumMoveType.a, this.do());
            this.f(this.do().a(0.9));
        } else {
            super.h(movementInput);
        }
    }

    @Override
    protected void a(EntityHuman player, EnumHand hand, ItemStack stack) {
        if (stack.a(Items.pU)) {
            player.a(hand, new ItemStack(Items.pL));
        } else {
            super.a(player, hand, stack);
        }
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.t() && !this.ac();
    }

    public static boolean a(EntityTypes<? extends EntityLiving> type, WorldAccess world, EnumMobSpawn reason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.d()).a(TagsBlock.bQ);
    }

    private static class c
    extends SmoothSwimmingMoveControl {
        private final Axolotl l;

        public c(Axolotl axolotl) {
            super(axolotl, 85, 10, 0.1f, 0.5f, false);
            this.l = axolotl;
        }

        @Override
        public void a() {
            if (!this.l.gj()) {
                super.a();
            }
        }
    }

    private class b
    extends SmoothSwimmingLookControl {
        public b(Axolotl axolotl, int i2) {
            super(axolotl, i2);
        }

        @Override
        public void a() {
            if (!Axolotl.this.gj()) {
                super.a();
            }
        }
    }

    public static enum Variant implements INamable
    {
        a(0, "lucy", true),
        b(1, "wild", true),
        c(2, "gold", true),
        d(3, "cyan", true),
        e(4, "blue", false);

        private static final IntFunction<Variant> g;
        public static final Codec<Variant> f;
        private final int h;
        private final String i;
        private final boolean j;

        private Variant(int i2, String s2, boolean flag) {
            this.h = i2;
            this.i = s2;
            this.j = flag;
        }

        public int a() {
            return this.h;
        }

        public String b() {
            return this.i;
        }

        @Override
        public String c() {
            return this.i;
        }

        public static Variant a(int id) {
            return g.apply(id);
        }

        public static Variant a(RandomSource random) {
            return Variant.a(random, true);
        }

        public static Variant b(RandomSource random) {
            return Variant.a(random, false);
        }

        private static Variant a(RandomSource random, boolean natural) {
            Variant[] aaxolotl_variant = (Variant[])Arrays.stream(Variant.values()).filter(axolotl_variant -> axolotl_variant.j == natural).toArray(Variant[]::new);
            return (Variant)SystemUtils.a((Object[])aaxolotl_variant, random);
        }

        static {
            g = ByIdMap.a(Variant::a, Variant.values(), ByIdMap.a.a);
            f = INamable.a(Variant::values);
        }
    }

    public static class a
    extends EntityAgeable.a {
        public final Variant[] a;

        public a(Variant ... variants) {
            super(false);
            this.a = variants;
        }

        public Variant a(RandomSource random) {
            return this.a[random.a(this.a.length)];
        }
    }
}

