/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.TadpoleAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;

public class Tadpole
extends EntityFish {
    @VisibleForTesting
    public static int b = Math.abs(-24000);
    public static float c = 0.4f;
    public static float d = 0.3f;
    public int bU;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Tadpole>>> e = ImmutableList.of(SensorType.c, SensorType.d, SensorType.f, SensorType.r);
    protected static final ImmutableList<MemoryModuleType<?>> bT = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.J, MemoryModuleType.O, MemoryModuleType.Q, MemoryModuleType.N, MemoryModuleType.r, MemoryModuleType.Y);
    public boolean ageLocked;

    public Tadpole(EntityTypes<? extends EntityFish> type, World world) {
        super(type, world);
        this.bL = new SmoothSwimmingMoveControl(this, 85, 10, 0.02f, 0.1f, true);
        this.bK = new SmoothSwimmingLookControl(this, 10);
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new NavigationGuardian(this, world);
    }

    protected BehaviorController.b<Tadpole> dO() {
        return BehaviorController.a(bT, e);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return TadpoleAi.a(this.dO().a(dynamic));
    }

    public BehaviorController<Tadpole> dN() {
        return super.dN();
    }

    @Override
    protected SoundEffect ge() {
        return SoundEffects.xH;
    }

    @Override
    protected void X() {
        this.dL().ad().a("tadpoleBrain");
        this.dN().a((WorldServer)this.dL(), this);
        this.dL().ad().c();
        this.dL().ad().a("tadpoleActivityUpdate");
        TadpoleAi.a(this);
        this.dL().ad().c();
        super.X();
    }

    public static AttributeProvider.Builder gf() {
        return EntityInsentient.A().a(GenericAttributes.d, 1.0).a(GenericAttributes.a, 6.0);
    }

    @Override
    public void b_() {
        super.b_();
        if (!this.dL().B && !this.ageLocked) {
            this.s(this.bU + 1);
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Age", this.bU);
        nbt.a("AgeLocked", this.ageLocked);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.s(nbt.h("Age"));
        this.ageLocked = nbt.q("AgeLocked");
    }

    @Override
    @Nullable
    protected SoundEffect w() {
        return null;
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.xJ;
    }

    @Override
    @Nullable
    public SoundEffect l_() {
        return SoundEffects.xG;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (this.m(itemstack)) {
            this.a(player, itemstack);
            return EnumInteractionResult.a(this.dL().B);
        }
        return Bucketable.a(player, hand, this).orElse(super.b(player, hand));
    }

    @Override
    protected void W() {
        super.W();
        PacketDebug.a(this);
    }

    @Override
    public boolean t() {
        return true;
    }

    @Override
    public void w(boolean fromBucket) {
    }

    @Override
    public void l(ItemStack stack) {
        Bucketable.a((EntityInsentient)this, stack);
        NBTTagCompound nbttagcompound = stack.w();
        nbttagcompound.a("Age", this.gg());
        nbttagcompound.a("AgeLocked", this.ageLocked);
    }

    @Override
    public void c(NBTTagCompound nbt) {
        Bucketable.a((EntityInsentient)this, nbt);
        if (nbt.e("Age")) {
            this.s(nbt.h("Age"));
        }
        this.ageLocked = nbt.q("AgeLocked");
    }

    @Override
    public ItemStack b() {
        return new ItemStack(Items.pW);
    }

    @Override
    public SoundEffect y() {
        return SoundEffects.cG;
    }

    private boolean m(ItemStack stack) {
        return Frog.bT.a(stack);
    }

    private void a(EntityHuman player, ItemStack stack) {
        this.b(player, stack);
        this.c(EntityAgeable.d_(this.gi()));
        this.dL().a(Particles.K, this.d(1.0), this.dt() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
    }

    private void b(EntityHuman player, ItemStack stack) {
        if (!player.fS().d) {
            stack.h(1);
        }
    }

    private int gg() {
        return this.bU;
    }

    private void c(int seconds) {
        if (this.ageLocked) {
            return;
        }
        this.s(this.bU + seconds * 20);
    }

    private void s(int tadpoleAge) {
        this.bU = tadpoleAge;
        if (this.bU >= b) {
            this.gh();
        }
    }

    private void gh() {
        World world = this.dL();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Frog frog = EntityTypes.O.a(this.dL());
            if (frog != null) {
                frog.b(this.dq(), this.ds(), this.dw(), this.dB(), this.dD());
                frog.a(worldserver, this.dL().d_(frog.dl()), EnumMobSpawn.i, (GroupDataEntity)null, null);
                frog.t(this.fT());
                if (this.ac()) {
                    frog.b(this.ad());
                    frog.n(this.cA());
                }
                frog.fI();
                if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, frog, EntityTransformEvent.TransformReason.METAMORPHOSIS).isCancelled()) {
                    this.s(0);
                    return;
                }
                this.a(SoundEffects.xI, 0.15f, 1.0f);
                worldserver.addFreshEntityWithPassengers(frog, CreatureSpawnEvent.SpawnReason.METAMORPHOSIS);
                this.ak();
            }
        }
    }

    public int gi() {
        return Math.max(0, b - this.bU);
    }

    @Override
    public boolean eb() {
        return false;
    }
}

