/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.goat;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.InstrumentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.joml.Vector3f;

public class Goat
extends EntityAnimal {
    public static final EntitySize bT = EntitySize.b(0.9f, 1.3f).a(0.7f);
    private static final int ca = 2;
    private static final int cb = 1;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Goat>>> bU = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.n, SensorType.f, SensorType.q);
    protected static final ImmutableList<MemoryModuleType<?>> bW = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.h, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.au, MemoryModuleType.r, MemoryModuleType.R, MemoryModuleType.S, MemoryModuleType.N, MemoryModuleType.J, MemoryModuleType.O, (Object[])new MemoryModuleType[]{MemoryModuleType.Q, MemoryModuleType.U, MemoryModuleType.V, MemoryModuleType.Y});
    public static final int bX = 10;
    public static final double bY = 0.02;
    public static final double bZ = (double)0.1f;
    private static final DataWatcherObject<Boolean> cc = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> cd = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> ce = DataWatcher.a(Goat.class, DataWatcherRegistry.k);
    private boolean cf;
    private int cg;

    public Goat(EntityTypes<? extends Goat> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.L().a(true);
        this.a(PathType.f, -1.0f);
        this.a(PathType.g, -1.0f);
    }

    public ItemStack s() {
        RandomSource randomsource = RandomSource.a(this.cv().hashCode());
        TagKey<Instrument> tagkey = this.gn() ? InstrumentTags.b : InstrumentTags.a;
        HolderSet.Named<Instrument> holderset = BuiltInRegistries.am.a(tagkey);
        return InstrumentItem.a(Items.vi, holderset.a(randomsource).get());
    }

    protected BehaviorController.b<Goat> dO() {
        return BehaviorController.a(bW, bU);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return GoatAi.a(this.dO().a(dynamic));
    }

    public static AttributeProvider.Builder t() {
        return EntityInsentient.A().a(GenericAttributes.a, 10.0).a(GenericAttributes.d, 0.2f).a(GenericAttributes.f, 2.0);
    }

    @Override
    protected void m() {
        if (this.m_()) {
            this.a(GenericAttributes.f).a(1.0);
            this.gm();
        } else {
            this.a(GenericAttributes.f).a(2.0);
            this.gl();
        }
    }

    @Override
    protected int d(float fallDistance, float damageMultiplier) {
        return super.d(fallDistance, damageMultiplier) - 10;
    }

    @Override
    protected SoundEffect w() {
        return this.gn() ? SoundEffects.jN : SoundEffects.jD;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return this.gn() ? SoundEffects.jQ : SoundEffects.jG;
    }

    @Override
    public SoundEffect l_() {
        return this.gn() ? SoundEffects.jO : SoundEffects.jE;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.jW, 0.15f, 1.0f);
    }

    protected SoundEffect y() {
        return this.gn() ? SoundEffects.jS : SoundEffects.jI;
    }

    @Nullable
    public Goat b(WorldServer world, EntityAgeable entity) {
        Goat goat = EntityTypes.U.a(world);
        if (goat != null) {
            EntityAgeable goat1;
            GoatAi.a(goat, world.D_());
            EntityAgeable object = world.D_().h() ? this : entity;
            boolean flag = object instanceof Goat && ((Goat)(goat1 = object)).gn() || !(world.D_().j() >= 0.02);
            boolean flag1 = flag;
            goat.w(flag1);
        }
        return goat;
    }

    public BehaviorController<Goat> dN() {
        return super.dN();
    }

    @Override
    protected void X() {
        this.dL().ad().a("goatBrain");
        this.dN().a((WorldServer)this.dL(), this);
        this.dL().ad().c();
        this.dL().ad().a("goatActivityUpdate");
        GoatAi.a(this);
        this.dL().ad().c();
        super.X();
    }

    @Override
    public int Z() {
        return 15;
    }

    @Override
    public void n(float headYaw) {
        int i2 = this.Z();
        float f1 = MathHelper.c(this.aU, headYaw);
        float f2 = MathHelper.a(f1, (float)(-i2), (float)i2);
        super.n(this.aU + f2);
    }

    @Override
    public SoundEffect d(ItemStack stack) {
        return this.gn() ? SoundEffects.jP : SoundEffects.jF;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.pK) && !this.m_()) {
            PlayerBucketFillEvent event = CraftEventFactory.callPlayerBucketFillEvent((WorldServer)player.dL(), player, this.dl(), this.dl(), null, itemstack, Items.pQ, hand);
            if (event.isCancelled()) {
                return EnumInteractionResult.d;
            }
            player.a(this.y(), 1.0f, 1.0f);
            ItemStack itemstack1 = ItemLiquidUtil.a(itemstack, player, CraftItemStack.asNMSCopy(event.getItemStack()));
            player.a(hand, itemstack1);
            return EnumInteractionResult.a(this.dL().B);
        }
        boolean isFood = this.m(itemstack);
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (enuminteractionresult.a() && isFood) {
            this.dL().a((EntityHuman)null, this, this.d(itemstack), SoundCategory.g, 1.0f, MathHelper.b(this.dL().z, 0.8f, 1.2f));
        }
        return enuminteractionresult;
    }

    @Override
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomsource = world.D_();
        GoatAi.a(this, randomsource);
        this.w(randomsource.j() < 0.02);
        this.m();
        if (!this.m_() && (double)randomsource.i() < (double)0.1f) {
            DataWatcherObject<Boolean> datawatcherobject = randomsource.h() ? cd : ce;
            this.an.b(datawatcherobject, false);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected void W() {
        super.W();
        PacketDebug.a(this);
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return pose == EntityPose.g ? bT.a(this.dY()) : super.a(pose);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("IsScreamingGoat", this.gn());
        nbt.a("HasLeftHorn", this.gd());
        nbt.a("HasRightHorn", this.gj());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.w(nbt.q("IsScreamingGoat"));
        this.an.b(cd, nbt.q("HasLeftHorn"));
        this.an.b(ce, nbt.q("HasRightHorn"));
    }

    @Override
    public void b(byte status) {
        if (status == 58) {
            this.cf = true;
        } else if (status == 59) {
            this.cf = false;
        } else {
            super.b(status);
        }
    }

    @Override
    public void b_() {
        this.cg = this.cf ? ++this.cg : (this.cg -= 2);
        this.cg = MathHelper.a(this.cg, 0, 20);
        super.b_();
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(cc, false);
        this.an.a(cd, true);
        this.an.a(ce, true);
    }

    public boolean gd() {
        return this.an.b(cd);
    }

    public boolean gj() {
        return this.an.b(ce);
    }

    public boolean gk() {
        boolean flag = this.gd();
        boolean flag1 = this.gj();
        if (!flag && !flag1) {
            return false;
        }
        DataWatcherObject<Boolean> datawatcherobject = !flag ? ce : (!flag1 ? cd : (this.ag.h() ? cd : ce));
        this.an.b(datawatcherobject, false);
        Vec3D vec3d = this.dj();
        ItemStack itemstack = this.s();
        double d0 = MathHelper.b(this.ag, -0.2f, 0.2f);
        double d1 = MathHelper.b(this.ag, 0.3f, 0.7f);
        double d2 = MathHelper.b(this.ag, -0.2f, 0.2f);
        EntityItem entityitem = new EntityItem(this.dL(), vec3d.a(), vec3d.b(), vec3d.c(), itemstack, d0, d1, d2);
        return this.spawnAtLocation(entityitem) != null;
    }

    public void gl() {
        this.an.b(cd, true);
        this.an.b(ce, true);
    }

    public void gm() {
        this.an.b(cd, false);
        this.an.b(ce, false);
    }

    public boolean gn() {
        return this.an.b(cc);
    }

    public void w(boolean screaming) {
        this.an.b(cc, screaming);
    }

    public float go() {
        return (float)this.cg / 20.0f * 30.0f * ((float)Math.PI / 180);
    }

    public static boolean c(EntityTypes<? extends EntityAnimal> entityType, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.a_(pos.d()).a(TagsBlock.bR) && Goat.a(world, pos);
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b - 0.1875f * scaleFactor, 0.0f);
    }

    public void ram(EntityLiving entity) {
        BehaviorController<Goat> brain = this.dN();
        brain.a(MemoryModuleType.V, entity.dj());
        brain.b(MemoryModuleType.U);
        brain.b(MemoryModuleType.r);
        brain.b(MemoryModuleType.N);
        brain.a(Activity.r);
    }
}

