/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.UUID;
import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameReferencingFileConverter;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.IInventoryListener;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTame;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.DismountUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.inventory.InventoryHolder;
import org.joml.Vector3f;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.protocol.PcaSyncProtocol;

public abstract class EntityHorseAbstract
extends EntityAnimal
implements IInventoryListener,
HasCustomInventoryScreen,
OwnableEntity,
IJumpable,
ISaddleable {
    public static final int cf = 400;
    public static final int cg = 499;
    public static final int ch = 500;
    public static final double ci = 0.15;
    private static final float bT = (float)EntityHorseAbstract.b(() -> 0.0);
    private static final float bU = (float)EntityHorseAbstract.b(() -> 1.0);
    private static final float bW = (float)EntityHorseAbstract.a(() -> 0.0);
    private static final float bX = (float)EntityHorseAbstract.a(() -> 1.0);
    private static final float bY = EntityHorseAbstract.a((int i2) -> 0);
    private static final float bZ = EntityHorseAbstract.a((int i2) -> i2 - 1);
    private static final float ca = 0.25f;
    private static final float cb = 0.5f;
    private static final Predicate<EntityLiving> cc = entityliving -> entityliving instanceof EntityHorseAbstract && ((EntityHorseAbstract)entityliving).gx();
    private static final PathfinderTargetCondition cd = PathfinderTargetCondition.b().a(16.0).d().a(cc);
    private static final RecipeItemStack ce = RecipeItemStack.a(Items.oI, Items.qM, Blocks.ij.k(), Items.nF, Items.tq, Items.pm, Items.pn);
    private static final DataWatcherObject<Byte> cv = DataWatcher.a(EntityHorseAbstract.class, DataWatcherRegistry.a);
    private static final int cw = 2;
    private static final int cx = 4;
    private static final int cy = 8;
    private static final int cz = 16;
    private static final int cA = 32;
    private static final int cB = 64;
    public static final int cj = 0;
    public static final int ck = 1;
    public static final int cl = 2;
    private int cC;
    private int cD;
    private int cE;
    public int cm;
    public int cn;
    protected boolean co;
    public InventorySubcontainer cp;
    protected int cq;
    protected float cr;
    protected boolean cs;
    private float cF;
    private float cG;
    private float cH;
    private float cI;
    private float cJ;
    private float cK;
    protected boolean ct = true;
    protected int cu;
    @Nullable
    private UUID cL;
    public int maxDomestication = 100;

    protected EntityHorseAbstract(EntityTypes<? extends EntityHorseAbstract> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.t(1.0f);
        this.gz();
    }

    @Override
    protected void z() {
        this.bO.a(1, new PathfinderGoalPanic(this, 1.2));
        this.bO.a(1, new PathfinderGoalTame(this, 1.2));
        this.bO.a(2, new PathfinderGoalBreed(this, 1.0, EntityHorseAbstract.class));
        this.bO.a(4, new PathfinderGoalFollowParent(this, 1.0));
        this.bO.a(6, new PathfinderGoalRandomStrollLand(this, 0.7));
        this.bO.a(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(8, new PathfinderGoalRandomLookaround(this));
        if (this.gj()) {
            this.bO.a(9, new RandomStandGoal(this));
        }
        this.gt();
    }

    protected void gt() {
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(3, new PathfinderGoalTempt(this, 1.25, RecipeItemStack.a(Items.tq, Items.pm, Items.pn), false));
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(cv, (byte)0);
    }

    protected boolean t(int bitmask) {
        return (this.an.b(cv) & bitmask) != 0;
    }

    protected void d(int bitmask, boolean flag) {
        byte b0 = this.an.b(cv);
        if (flag) {
            this.an.b(cv, (byte)(b0 | bitmask));
        } else {
            this.an.b(cv, (byte)(b0 & ~bitmask));
        }
    }

    public boolean gs() {
        return this.t(2);
    }

    @Override
    @Nullable
    public UUID d() {
        return this.cL;
    }

    public void b(@Nullable UUID ownerUuid) {
        this.cL = ownerUuid;
    }

    public boolean gu() {
        return this.co;
    }

    public void x(boolean tame) {
        this.d(2, tame);
    }

    public void y(boolean inAir) {
        this.co = inAir;
    }

    @Override
    protected void D(float leashLength) {
        if (leashLength > 6.0f && this.gv()) {
            this.A(false);
        }
    }

    public boolean gv() {
        return this.t(16);
    }

    public boolean gw() {
        return this.t(32);
    }

    public boolean gx() {
        return this.t(8);
    }

    public void z(boolean bred) {
        this.d(8, bred);
    }

    @Override
    public boolean g() {
        return this.bv() && !this.m_() && this.gs();
    }

    @Override
    public void a(@Nullable SoundCategory sound) {
        this.equipSaddle(sound, null);
    }

    @Override
    public void equipSaddle(@Nullable SoundCategory sound, @Nullable ItemStack stack) {
        this.cp.a(0, stack != null ? stack : new ItemStack(Items.mZ));
    }

    public void b(EntityHuman player, ItemStack stack) {
        if (this.l(stack)) {
            this.cp.a(1, stack.c(1));
            if (!player.fS().d) {
                stack.h(1);
            }
        }
    }

    @Override
    public boolean i() {
        return this.t(4);
    }

    public int gy() {
        return this.cq;
    }

    public void u(int temper) {
        this.cq = temper;
    }

    public int v(int difference) {
        int j2 = MathHelper.a(this.gy() + difference, 0, this.gE());
        this.u(j2);
        return j2;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return !this.bO();
    }

    private void s() {
        SoundEffect soundeffect;
        this.gd();
        if (!this.aS() && (soundeffect = this.gk()) != null) {
            this.dL().a((EntityHuman)null, this.dq(), this.ds(), this.dw(), soundeffect, this.da(), 1.0f, 1.0f + (this.ag.i() - this.ag.i()) * 0.2f);
        }
    }

    @Override
    public boolean a(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        int i2;
        if (fallDistance > 1.0f) {
            this.a(SoundEffects.ln, 0.4f, 1.0f);
        }
        if ((i2 = this.d(fallDistance, damageMultiplier)) <= 0) {
            return false;
        }
        this.a(damageSource, (float)i2);
        if (this.bO()) {
            for (Entity entity : this.cT()) {
                entity.a(damageSource, (float)i2);
            }
        }
        this.eH();
        return true;
    }

    @Override
    protected int d(float fallDistance, float damageMultiplier) {
        return MathHelper.f((fallDistance * 0.5f - 3.0f) * damageMultiplier);
    }

    protected int Z_() {
        return 2;
    }

    public void gz() {
        InventorySubcontainer inventorysubcontainer = this.cp;
        this.cp = new InventorySubcontainer(this.Z_(), (InventoryHolder)((AbstractHorse)this.getBukkitEntity()));
        if (inventorysubcontainer != null) {
            inventorysubcontainer.b(this);
            int i2 = Math.min(inventorysubcontainer.b(), this.cp.b());
            for (int j2 = 0; j2 < i2; ++j2) {
                ItemStack itemstack = inventorysubcontainer.a(j2);
                if (itemstack.b()) continue;
                this.cp.a(j2, itemstack.p());
            }
        }
        this.cp.a(this);
        this.gA();
    }

    protected void gA() {
        if (!this.dL().B) {
            this.d(4, !this.cp.a(0).b());
        }
    }

    @Override
    public void a(IInventory sender) {
        if (LeavesConfig.pcaSyncProtocol) {
            PcaSyncProtocol.syncEntityToClient(this);
        }
        boolean flag = this.i();
        this.gA();
        if (this.ah > 20 && !flag && this.i()) {
            this.a(this.W_(), 0.5f, 1.0f);
        }
    }

    public double gB() {
        return this.b(GenericAttributes.n);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag = super.a(source, amount);
        if (flag && this.ag.a(3) == 0) {
            this.gI();
        }
        return flag;
    }

    protected boolean gj() {
        return true;
    }

    @Nullable
    protected SoundEffect gk() {
        return null;
    }

    @Nullable
    protected SoundEffect gC() {
        return null;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        if (!state.k()) {
            IBlockData iblockdata1 = this.dL().a_(pos.c());
            SoundEffectType soundeffecttype = state.w();
            if (iblockdata1.a(Blocks.dN)) {
                soundeffecttype = iblockdata1.w();
            }
            if (this.bO() && this.ct) {
                ++this.cu;
                if (this.cu > 5 && this.cu % 3 == 0) {
                    this.a(soundeffecttype);
                } else if (this.cu <= 5) {
                    this.a(SoundEffects.lq, soundeffecttype.a() * 0.15f, soundeffecttype.b());
                }
            } else if (this.b(soundeffecttype)) {
                this.a(SoundEffects.lq, soundeffecttype.a() * 0.15f, soundeffecttype.b());
            } else {
                this.a(SoundEffects.lp, soundeffecttype.a() * 0.15f, soundeffecttype.b());
            }
        }
    }

    private boolean b(SoundEffectType soundGroup) {
        return soundGroup == SoundEffectType.b || soundGroup == SoundEffectType.aP || soundGroup == SoundEffectType.B || soundGroup == SoundEffectType.aQ || soundGroup == SoundEffectType.aO;
    }

    protected void a(SoundEffectType group) {
        this.a(SoundEffects.lk, group.a() * 0.15f, group.b());
    }

    public static AttributeProvider.Builder gD() {
        return EntityInsentient.A().a(GenericAttributes.n).a(GenericAttributes.a, 53.0).a(GenericAttributes.d, 0.225f);
    }

    @Override
    public int fH() {
        return 6;
    }

    public int gE() {
        return this.maxDomestication;
    }

    @Override
    public float eV() {
        return 0.8f;
    }

    @Override
    public int O() {
        return 400;
    }

    @Override
    public void b(EntityHuman player) {
        if (!this.dL().B && (!this.bO() || this.x(player)) && this.gs()) {
            player.a(this, this.cp);
        }
    }

    public EnumInteractionResult c(EntityHuman player, ItemStack stack) {
        boolean flag = this.a(player, stack);
        if (!player.fS().d) {
            stack.h(1);
        }
        return this.dL().B ? EnumInteractionResult.b : (flag ? EnumInteractionResult.a : EnumInteractionResult.d);
    }

    protected boolean a(EntityHuman player, ItemStack item) {
        boolean flag = false;
        float f2 = 0.0f;
        int short0 = 0;
        int b0 = 0;
        if (item.a(Items.oI)) {
            f2 = 2.0f;
            short0 = 20;
            b0 = 3;
        } else if (item.a(Items.qM)) {
            f2 = 1.0f;
            short0 = 30;
            b0 = 3;
        } else if (item.a(Blocks.ij.k())) {
            f2 = 20.0f;
            short0 = 180;
        } else if (item.a(Items.nF)) {
            f2 = 3.0f;
            short0 = 60;
            b0 = 3;
        } else if (item.a(Items.tq)) {
            f2 = 4.0f;
            short0 = 60;
            b0 = 5;
            if (!this.dL().B && this.gs() && this.h() == 0 && !this.gh()) {
                flag = true;
                this.setInLove(player, item.p());
            }
        } else if (item.a(Items.pm) || item.a(Items.pn)) {
            f2 = 10.0f;
            short0 = 240;
            b0 = 10;
            if (!this.dL().B && this.gs() && this.h() == 0 && !this.gh()) {
                flag = true;
                this.setInLove(player, item.p());
            }
        }
        if (this.eu() < this.eL() && f2 > 0.0f) {
            this.heal(f2, EntityRegainHealthEvent.RegainReason.EATING);
            flag = true;
        }
        if (this.m_() && short0 > 0) {
            this.dL().a(Particles.K, this.d(1.0), this.dt() + 0.5, this.g(1.0), 0.0, 0.0, 0.0);
            if (!this.dL().B) {
                this.b_(short0);
            }
            flag = true;
        }
        if (b0 > 0 && (flag || !this.gs()) && this.gy() < this.gE()) {
            flag = true;
            if (!this.dL().B) {
                this.v(b0);
            }
        }
        if (flag) {
            this.s();
            this.a(GameEvent.m);
        }
        return flag;
    }

    protected void f(EntityHuman player) {
        this.A(false);
        this.B(false);
        if (!this.dL().B) {
            player.r(this.dB());
            player.s(this.dD());
            player.n(this);
        }
    }

    @Override
    public boolean eX() {
        return super.eX() && this.bO() && this.i() || this.gv() || this.gw();
    }

    @Override
    public boolean m(ItemStack stack) {
        return ce.a(stack);
    }

    private void t() {
        this.cm = 1;
    }

    @Override
    protected void ex() {
        super.ex();
        if (this.cp != null) {
            for (int i2 = 0; i2 < this.cp.b(); ++i2) {
                ItemStack itemstack = this.cp.a(i2);
                if (itemstack.b() || EnchantmentManager.e(itemstack)) continue;
                this.b(itemstack);
            }
        }
    }

    @Override
    public void b_() {
        if (this.ag.a(200) == 0) {
            this.t();
        }
        super.b_();
        if (!this.dL().B && this.bv()) {
            if (this.ag.a(900) == 0 && this.aM == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            if (this.gG()) {
                if (!this.gv() && !this.bO() && this.ag.a(300) == 0 && this.dL().a_(this.dl().d()).a(Blocks.i)) {
                    this.A(true);
                }
                if (this.gv() && ++this.cC > 50) {
                    this.cC = 0;
                    this.A(false);
                }
            }
            this.gF();
        }
    }

    protected void gF() {
        EntityHorseAbstract entityliving;
        if (this.gx() && this.m_() && !this.gv() && (entityliving = this.dL().a(EntityHorseAbstract.class, cd, this, this.dq(), this.ds(), this.dw(), this.cG().g(16.0))) != null && this.f((Entity)entityliving) > 4.0) {
            this.bN.a((Entity)entityliving, 0);
        }
    }

    public boolean gG() {
        return true;
    }

    @Override
    public void l() {
        super.l();
        if (this.cD > 0 && ++this.cD > 30) {
            this.cD = 0;
            this.d(64, false);
        }
        if (this.cX() && this.cE > 0 && ++this.cE > 20) {
            this.cE = 0;
            this.B(false);
        }
        if (this.cm > 0 && ++this.cm > 8) {
            this.cm = 0;
        }
        if (this.cn > 0) {
            ++this.cn;
            if (this.cn > 300) {
                this.cn = 0;
            }
        }
        this.cG = this.cF;
        if (this.gv()) {
            this.cF += (1.0f - this.cF) * 0.4f + 0.05f;
            if (this.cF > 1.0f) {
                this.cF = 1.0f;
            }
        } else {
            this.cF += (0.0f - this.cF) * 0.4f - 0.05f;
            if (this.cF < 0.0f) {
                this.cF = 0.0f;
            }
        }
        this.cI = this.cH;
        if (this.gw()) {
            this.cG = this.cF = 0.0f;
            this.cH += (1.0f - this.cH) * 0.4f + 0.05f;
            if (this.cH > 1.0f) {
                this.cH = 1.0f;
            }
        } else {
            this.cs = false;
            this.cH += (0.8f * this.cH * this.cH * this.cH - this.cH) * 0.6f - 0.05f;
            if (this.cH < 0.0f) {
                this.cH = 0.0f;
            }
        }
        this.cK = this.cJ;
        if (this.t(64)) {
            this.cJ += (1.0f - this.cJ) * 0.7f + 0.05f;
            if (this.cJ > 1.0f) {
                this.cJ = 1.0f;
            }
        } else {
            this.cJ += (0.0f - this.cJ) * 0.7f - 0.05f;
            if (this.cJ < 0.0f) {
                this.cJ = 0.0f;
            }
        }
    }

    public void setMouthOpen(boolean open) {
        this.d(64, open);
    }

    public boolean isMouthOpen() {
        return this.t(64);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        if (!this.bO() && !this.m_()) {
            if (this.gs() && player.fH()) {
                this.b(player);
                return EnumInteractionResult.a(this.dL().B);
            }
            ItemStack itemstack = player.b(hand);
            if (!itemstack.b()) {
                EnumInteractionResult enuminteractionresult = itemstack.a(player, (EntityLiving)this, hand);
                if (enuminteractionresult.a()) {
                    return enuminteractionresult;
                }
                if (this.gM() && this.l(itemstack) && !this.gN()) {
                    this.b(player, itemstack);
                    return EnumInteractionResult.a(this.dL().B);
                }
            }
            this.f(player);
            return EnumInteractionResult.a(this.dL().B);
        }
        return super.b(player, hand);
    }

    private void gd() {
        if (!this.dL().B) {
            this.cD = 1;
            this.d(64, true);
        }
    }

    public void A(boolean eatingGrass) {
        this.d(16, eatingGrass);
    }

    public void setForceStanding(boolean standing) {
        this.d(32, standing);
    }

    public void B(boolean angry) {
        if (angry) {
            this.A(false);
        }
        this.d(32, angry);
    }

    @Nullable
    public SoundEffect gH() {
        return this.w();
    }

    public void gI() {
        if (this.gj() && this.cX()) {
            this.cE = 1;
            this.B(true);
        }
    }

    public void gJ() {
        if (!this.gw()) {
            this.gI();
            SoundEffect soundeffect = this.gC();
            if (soundeffect != null) {
                this.a(soundeffect, this.eV(), this.eW());
            }
        }
    }

    public boolean h(EntityHuman player) {
        this.b(player.cv());
        this.x(true);
        if (player instanceof EntityPlayer) {
            CriterionTriggers.x.a((EntityPlayer)player, this);
        }
        this.dL().a((Entity)this, (byte)7);
        return true;
    }

    @Override
    protected void a(EntityHuman controllingPlayer, Vec3D movementInput) {
        super.a(controllingPlayer, movementInput);
        Vec2F vec2f = this.j(controllingPlayer);
        this.a(vec2f.j, vec2f.i);
        this.aU = this.aW = this.dB();
        this.N = this.aW;
        if (this.cW()) {
            if (movementInput.e <= 0.0) {
                this.cu = 0;
            }
            if (this.aA()) {
                this.y(false);
                if (this.cr > 0.0f && !this.gu()) {
                    this.b(this.cr, movementInput);
                }
                this.cr = 0.0f;
            }
        }
    }

    protected Vec2F j(EntityLiving controllingPassenger) {
        return new Vec2F(controllingPassenger.dD() * 0.5f, controllingPassenger.dB());
    }

    @Override
    protected Vec3D b(EntityHuman controllingPlayer, Vec3D movementInput) {
        if (this.aA() && this.cr == 0.0f && this.gw() && !this.cs) {
            return Vec3D.b;
        }
        float f2 = controllingPlayer.bk * 0.5f;
        float f1 = controllingPlayer.bm;
        if (f1 <= 0.0f) {
            f1 *= 0.25f;
        }
        return new Vec3D(f2, 0.0, f1);
    }

    @Override
    protected float e(EntityHuman controllingPlayer) {
        return (float)this.b(GenericAttributes.d);
    }

    protected void b(float strength, Vec3D movementInput) {
        double d0 = this.gB() * (double)strength * (double)this.aI();
        double d1 = d0 + (double)this.eZ();
        Vec3D vec3d1 = this.do();
        this.o(vec3d1.c, d1, vec3d1.e);
        this.y(true);
        this.au = true;
        if (movementInput.e > 0.0) {
            float f1 = MathHelper.a(this.dB() * ((float)Math.PI / 180));
            float f2 = MathHelper.b(this.dB() * ((float)Math.PI / 180));
            this.f(this.do().b(-0.4f * f1 * strength, 0.0, 0.4f * f2 * strength));
        }
    }

    protected void gK() {
        this.a(SoundEffects.lm, 0.4f, 1.0f);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("EatingHaystack", this.gv());
        nbt.a("Bred", this.gx());
        nbt.a("Temper", this.gy());
        nbt.a("Tame", this.gs());
        if (this.d() != null) {
            nbt.a("Owner", this.d());
        }
        nbt.a("Bukkit.MaxDomestication", this.maxDomestication);
        if (!this.cp.a(0).b()) {
            nbt.a("SaddleItem", this.cp.a(0).b(new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        ItemStack itemstack;
        UUID uuid;
        super.a(nbt);
        this.A(nbt.q("EatingHaystack"));
        this.z(nbt.q("Bred"));
        this.u(nbt.h("Temper"));
        this.x(nbt.q("Tame"));
        if (nbt.b("Owner")) {
            uuid = nbt.a("Owner");
        } else {
            String s2 = nbt.l("Owner");
            uuid = NameReferencingFileConverter.a(this.cK(), s2);
        }
        if (uuid != null) {
            this.b(uuid);
        }
        if (nbt.e("Bukkit.MaxDomestication")) {
            this.maxDomestication = nbt.h("Bukkit.MaxDomestication");
        }
        if (nbt.b("SaddleItem", 10) && (itemstack = ItemStack.a(nbt.p("SaddleItem"))).a(Items.mZ)) {
            this.cp.a(0, itemstack);
        }
        this.gA();
    }

    @Override
    public boolean a(EntityAnimal other) {
        return false;
    }

    protected boolean gL() {
        return !this.bO() && !this.bN() && this.gs() && !this.m_() && this.eu() >= this.eL() && this.gh();
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return null;
    }

    protected void a(EntityAgeable other, EntityHorseAbstract child) {
        this.a(other, child, GenericAttributes.a, (double)bY, (double)bZ);
        this.a(other, child, GenericAttributes.n, (double)bW, (double)bX);
        this.a(other, child, GenericAttributes.d, (double)bT, (double)bU);
    }

    private void a(EntityAgeable other, EntityHorseAbstract child, AttributeBase attribute, double min, double max) {
        double d2 = EntityHorseAbstract.a(this.c(attribute), other.c(attribute), min, max, this.ag);
        child.a(attribute).a(d2);
    }

    static double a(double parentBase, double otherParentBase, double min, double max, RandomSource random) {
        double d7;
        if (max <= min) {
            throw new IllegalArgumentException("Incorrect range for an attribute");
        }
        parentBase = MathHelper.a(parentBase, min, max);
        otherParentBase = MathHelper.a(otherParentBase, min, max);
        double d4 = 0.15 * (max - min);
        double d6 = (parentBase + otherParentBase) / 2.0;
        double d5 = Math.abs(parentBase - otherParentBase) + d4 * 2.0;
        double d8 = d6 + d5 * (d7 = (random.j() + random.j() + random.j()) / 3.0 - 0.5);
        if (d8 > max) {
            double d9 = d8 - max;
            return max - d9;
        }
        if (d8 < min) {
            double d9 = min - d8;
            return min + d9;
        }
        return d8;
    }

    public float E(float tickDelta) {
        return MathHelper.i(tickDelta, this.cG, this.cF);
    }

    public float F(float tickDelta) {
        return MathHelper.i(tickDelta, this.cI, this.cH);
    }

    public float G(float tickDelta) {
        return MathHelper.i(tickDelta, this.cK, this.cJ);
    }

    @Override
    public void b(int strength) {
        if (this.i()) {
            if (strength < 0) {
                strength = 0;
            } else {
                this.cs = true;
                this.gI();
            }
            this.cr = strength >= 90 ? 1.0f : 0.4f + 0.4f * (float)strength / 90.0f;
        }
    }

    @Override
    public boolean a() {
        return this.i();
    }

    @Override
    public void c(int height) {
        float power = height >= 90 ? 1.0f : 0.4f + 0.4f * (float)height / 90.0f;
        if (!CraftEventFactory.callHorseJumpEvent(this, power)) {
            return;
        }
        this.cs = true;
        this.gI();
        this.gK();
    }

    @Override
    public void b() {
    }

    protected void C(boolean positive) {
        ParticleType particletype = positive ? Particles.M : Particles.Z;
        for (int i2 = 0; i2 < 7; ++i2) {
            double d0 = this.ag.k() * 0.02;
            double d1 = this.ag.k() * 0.02;
            double d2 = this.ag.k() * 0.02;
            this.dL().a(particletype, this.d(1.0), this.dt() + 0.5, this.g(1.0), d0, d1, d2);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 7) {
            this.C(true);
        } else if (status == 6) {
            this.C(false);
        } else {
            super.b(status);
        }
    }

    @Override
    protected void a(Entity passenger, Entity.MoveFunction positionUpdater) {
        super.a(passenger, positionUpdater);
        if (passenger instanceof EntityLiving) {
            ((EntityLiving)passenger).aU = this.aU;
        }
    }

    protected static float a(IntUnaryOperator randomIntGetter) {
        return 15.0f + (float)randomIntGetter.applyAsInt(8) + (float)randomIntGetter.applyAsInt(9);
    }

    protected static double a(DoubleSupplier randomDoubleGetter) {
        return (double)0.4f + randomDoubleGetter.getAsDouble() * 0.2 + randomDoubleGetter.getAsDouble() * 0.2 + randomDoubleGetter.getAsDouble() * 0.2;
    }

    protected static double b(DoubleSupplier randomDoubleGetter) {
        return ((double)0.45f + randomDoubleGetter.getAsDouble() * 0.3 + randomDoubleGetter.getAsDouble() * 0.3 + randomDoubleGetter.getAsDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean c_() {
        return false;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * 0.95f;
    }

    public boolean gM() {
        return false;
    }

    public boolean gN() {
        return !this.c(EnumItemSlot.e).b();
    }

    public boolean l(ItemStack item) {
        return false;
    }

    private SlotAccess a(final int slot, final Predicate<ItemStack> predicate) {
        return new SlotAccess(){

            @Override
            public ItemStack a() {
                return EntityHorseAbstract.this.cp.a(slot);
            }

            @Override
            public boolean a(ItemStack stack) {
                if (!predicate.test(stack)) {
                    return false;
                }
                EntityHorseAbstract.this.cp.a(slot, stack);
                EntityHorseAbstract.this.gA();
                return true;
            }
        };
    }

    @Override
    public SlotAccess a_(int mappedIndex) {
        int k2;
        int j2 = mappedIndex - 400;
        if (j2 >= 0 && j2 < 2 && j2 < this.cp.b()) {
            if (j2 == 0) {
                return this.a(j2, (ItemStack itemstack) -> itemstack.b() || itemstack.a(Items.mZ));
            }
            if (j2 == 1) {
                if (!this.gM()) {
                    return SlotAccess.b;
                }
                return this.a(j2, (ItemStack itemstack) -> itemstack.b() || this.l((ItemStack)itemstack));
            }
        }
        return (k2 = mappedIndex - 500 + 2) >= 2 && k2 < this.cp.b() ? SlotAccess.a(this.cp, k2) : super.a_(mappedIndex);
    }

    @Override
    @Nullable
    public EntityLiving cN() {
        Entity entity;
        if (this.i() && (entity = this.cQ()) instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            return entityhuman;
        }
        return super.cN();
    }

    @Nullable
    private Vec3D a(Vec3D offset, EntityLiving passenger) {
        double d0 = this.dq() + offset.c;
        double d1 = this.cG().b;
        double d2 = this.dw() + offset.e;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        block0: for (EntityPose entitypose : passenger.fz()) {
            blockposition_mutableblockposition.b(d0, d1, d2);
            double d3 = this.cG().e + 0.75;
            do {
                double d4 = this.dL().i(blockposition_mutableblockposition);
                if ((double)blockposition_mutableblockposition.v() + d4 > d3) continue block0;
                if (DismountUtil.a(d4)) {
                    AxisAlignedBB axisalignedbb = passenger.e(entitypose);
                    Vec3D vec3d1 = new Vec3D(d0, (double)blockposition_mutableblockposition.v() + d4, d2);
                    if (DismountUtil.a(this.dL(), passenger, axisalignedbb.c(vec3d1))) {
                        passenger.b(entitypose);
                        return vec3d1;
                    }
                }
                blockposition_mutableblockposition.c(EnumDirection.b);
            } while (!((double)blockposition_mutableblockposition.v() >= d3));
        }
        return null;
    }

    @Override
    public Vec3D b(EntityLiving passenger) {
        Vec3D vec3d = EntityHorseAbstract.a(this.df(), (double)passenger.df(), this.dB() + (passenger.fl() == EnumMainHand.b ? 90.0f : -90.0f));
        Vec3D vec3d1 = this.a(vec3d, passenger);
        if (vec3d1 != null) {
            return vec3d1;
        }
        Vec3D vec3d2 = EntityHorseAbstract.a(this.df(), (double)passenger.df(), this.dB() + (passenger.fl() == EnumMainHand.a ? 90.0f : -90.0f));
        Vec3D vec3d3 = this.a(vec3d2, passenger);
        return vec3d3 != null ? vec3d3 : this.dj();
    }

    protected void a(RandomSource random) {
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (entityData == null) {
            entityData = new EntityAgeable.a(0.2f);
        }
        this.a(world.D_());
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public boolean b(IInventory inventory) {
        return this.cp != inventory;
    }

    public int gO() {
        return this.O();
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, this.a(dimensions, scaleFactor) + 0.15f * this.cI * scaleFactor, -0.7f * this.cI * scaleFactor);
    }

    protected float a(EntitySize dimensions, float scaleFactor) {
        return dimensions.b + (this.m_() ? 0.125f : -0.15625f) * scaleFactor;
    }
}

