/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.mojang.serialization.Dynamic;
import io.papermc.paper.event.entity.EntityFertilizeEggEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.entity.Item;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDropItemEvent;
import org.joml.Vector3f;

public class Sniffer
extends EntityAnimal {
    private static final int bZ = 1700;
    private static final int ca = 6000;
    private static final int cb = 30;
    private static final int cc = 120;
    private static final int cd = 48000;
    private static final float ce = 0.4f;
    private static final EntitySize cf = EntitySize.b(EntityTypes.aN.k(), EntityTypes.aN.l() - 0.4f);
    private static final DataWatcherObject<State> cg = DataWatcher.a(Sniffer.class, DataWatcherRegistry.z);
    private static final DataWatcherObject<Integer> ch = DataWatcher.a(Sniffer.class, DataWatcherRegistry.b);
    public final AnimationState bT = new AnimationState();
    public final AnimationState bU = new AnimationState();
    public final AnimationState bW = new AnimationState();
    public final AnimationState bX = new AnimationState();
    public final AnimationState bY = new AnimationState();

    public static AttributeProvider.Builder s() {
        return EntityInsentient.A().a(GenericAttributes.d, 0.1f).a(GenericAttributes.a, 14.0);
    }

    public Sniffer(EntityTypes<? extends EntityAnimal> type, World world) {
        super(type, world);
        this.L().a(true);
        this.a(PathType.j, -1.0f);
        this.a(PathType.g, -1.0f);
        this.a(PathType.y, -1.0f);
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(cg, State.a);
        this.an.a(ch, 0);
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.a((EntityPose)pose).b * 0.6f;
    }

    @Override
    public void C() {
        super.C();
        if (this.bM() || this.aX()) {
            this.a(PathType.j, 0.0f);
        }
    }

    @Override
    public void E() {
        this.a(PathType.j, -1.0f);
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return this.an.a(cg) && this.go() == State.f ? cf.a(this.dY()) : super.a(pose);
    }

    public boolean t() {
        return this.go() == State.e;
    }

    public boolean y() {
        return this.bz.c(MemoryModuleType.Q).orElse(false);
    }

    public boolean gd() {
        return !this.y() && !this.ga() && !this.aX() && !this.gh() && this.aA() && !this.bN() && !this.fR();
    }

    public boolean gj() {
        return this.go() == State.f || this.go() == State.e;
    }

    private BlockPosition gm() {
        Vec3D vec3d = this.gn();
        return BlockPosition.a(vec3d.a(), this.ds() + (double)0.2f, vec3d.c());
    }

    private Vec3D gn() {
        return this.dj().e(this.bG().a(2.25));
    }

    public State go() {
        return this.an.b(cg);
    }

    private Sniffer b(State state) {
        this.an.b(cg, state);
        return this;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (cg.equals(data)) {
            State sniffer_state = this.go();
            this.gp();
            switch (sniffer_state) {
                case c: {
                    this.bU.b(this.ah);
                    break;
                }
                case d: {
                    this.bW.b(this.ah);
                    break;
                }
                case f: {
                    this.bX.b(this.ah);
                    break;
                }
                case g: {
                    this.bY.b(this.ah);
                    break;
                }
                case b: {
                    this.bT.b(this.ah);
                }
            }
            this.i_();
        }
        super.a(data);
    }

    private void gp() {
        this.bX.a();
        this.bW.a();
        this.bY.a();
        this.bT.a();
        this.bU.a();
    }

    public Sniffer a(State state) {
        switch (state) {
            case c: {
                this.b(State.c).gq();
                break;
            }
            case d: {
                this.a(SoundEffects.wF, 1.0f, 1.0f);
                this.b(State.d);
                break;
            }
            case f: {
                this.b(State.f).gr();
                break;
            }
            case g: {
                this.a(SoundEffects.wI, 1.0f, 1.0f);
                this.b(State.g);
                break;
            }
            case b: {
                this.a(SoundEffects.wJ, 1.0f, 1.0f);
                this.b(State.b);
                break;
            }
            case a: {
                this.b(State.a);
                break;
            }
            case e: {
                this.b(State.e);
            }
        }
        return this;
    }

    private Sniffer gq() {
        this.a(SoundEffects.wE, 1.0f, this.m_() ? 1.3f : 1.0f);
        return this;
    }

    private Sniffer gr() {
        this.an.b(ch, this.ah + 120);
        this.dL().a((Entity)this, (byte)63);
        return this;
    }

    public Sniffer w(boolean explored) {
        if (explored) {
            this.j(this.aH());
        }
        return this;
    }

    public Optional<BlockPosition> gk() {
        return IntStream.range(0, 5).mapToObj(i2 -> LandRandomPos.a(this, 10 + 2 * i2, 3)).filter(Objects::nonNull).map(BlockPosition::a).filter(blockposition -> this.dL().B_().a((BlockPosition)blockposition)).map(BlockPosition::d).filter(this::i).findFirst();
    }

    public boolean gl() {
        return !this.ga() && !this.y() && !this.m_() && !this.aX() && this.aA() && !this.bN() && this.i(this.gm().d());
    }

    private boolean i(BlockPosition pos) {
        return this.dL().a_(pos).a(TagsBlock.cj) && this.gt().noneMatch(globalpos -> GlobalPos.a(this.dL().ac(), pos).equals(globalpos)) && Optional.ofNullable(this.L().a(pos, 1)).map(PathEntity::j).orElse(false) != false;
    }

    private void gs() {
        if (!this.dL().w_() && this.an.b(ch) == this.ah) {
            WorldServer worldserver = (WorldServer)this.dL();
            LootTable loottable = worldserver.n().aH().getLootTable(LootTables.aA);
            LootParams lootparams = new LootParams.a(worldserver).a(LootContextParameters.f, this.gn()).a(LootContextParameters.a, this).a(LootContextParameterSets.i);
            ObjectArrayList<ItemStack> list = loottable.a(lootparams);
            BlockPosition blockposition = this.gm();
            for (ItemStack itemstack : list) {
                EntityItem entityitem = new EntityItem(worldserver, blockposition.u(), blockposition.v(), blockposition.w(), itemstack);
                EntityDropItemEvent event = new EntityDropItemEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (Item)entityitem.getBukkitEntity());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                entityitem.t();
                worldserver.b(entityitem);
            }
            this.a(SoundEffects.wD, 1.0f, 1.0f);
        }
    }

    private Sniffer a(AnimationState diggingAnimationState) {
        boolean flag;
        boolean bl = flag = diggingAnimationState.b() > 1700L && diggingAnimationState.b() < 6000L;
        if (flag) {
            BlockPosition blockposition = this.gm();
            IBlockData iblockdata = this.dL().a_(blockposition.d());
            if (iblockdata.l() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    Vec3D vec3d = Vec3D.b(blockposition).b(0.0, -0.65f, 0.0);
                    this.dL().a(new ParticleParamBlock(Particles.c, iblockdata), vec3d.c, vec3d.d, vec3d.e, 0.0, 0.0, 0.0);
                }
                if (this.ah % 10 == 0) {
                    this.dL().a(this.dq(), this.ds(), this.dw(), iblockdata.w().f(), this.da(), 0.5f, 0.5f, false);
                }
            }
        }
        if (this.ah % 10 == 0) {
            this.dL().a(GameEvent.u, this.gm(), GameEvent.a.a(this));
        }
        return this;
    }

    public Sniffer j(BlockPosition pos) {
        List list = this.gt().limit(20L).collect(Collectors.toList());
        list.add(0, GlobalPos.a(this.dL().ac(), pos));
        this.dN().a(MemoryModuleType.aP, list);
        return this;
    }

    public Stream<GlobalPos> gt() {
        return this.dN().c(MemoryModuleType.aP).stream().flatMap(Collection::stream);
    }

    @Override
    protected void fa() {
        double d1;
        super.fa();
        double d0 = this.bL.c();
        if (d0 > 0.0 && (d1 = this.do().i()) < 0.01) {
            this.a(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
    }

    @Override
    public void a(WorldServer world, EntityAnimal other) {
        EntityFertilizeEggEvent result = CraftEventFactory.callEntityFertilizeEggEvent(this, other);
        if (result.isCancelled()) {
            return;
        }
        ItemStack itemstack = new ItemStack(Items.jU);
        EntityItem entityitem = new EntityItem(world, this.dj().a(), this.dj().b(), this.dj().c(), itemstack);
        entityitem.t();
        this.finalizeSpawnChildFromBreeding(world, other, null, result.getExperience());
        if (this.spawnAtLocation(entityitem) != null) {
            this.a(SoundEffects.wK, 1.0f, (this.ag.i() - this.ag.i()) * 0.2f + 0.5f);
        }
    }

    @Override
    public void a(DamageSource damageSource) {
        this.a(State.a);
        super.a(damageSource);
    }

    @Override
    public void l() {
        switch (this.go()) {
            case f: {
                this.a(this.bX).gs();
                break;
            }
            case e: {
                this.gu();
            }
        }
        super.l();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        boolean flag = this.m(itemstack);
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (enuminteractionresult.a() && flag) {
            this.dL().a((EntityHuman)null, this, this.d(itemstack), SoundCategory.g, 1.0f, MathHelper.b(this.dL().z, 0.8f, 1.2f));
        }
        return enuminteractionresult;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + 0.34375f * scaleFactor, 0.0f);
    }

    @Override
    public float dh() {
        return super.dh() + 0.3f;
    }

    private void gu() {
        if (this.dL().w_() && this.ah % 20 == 0) {
            this.dL().a(this.dq(), this.ds(), this.dw(), SoundEffects.wG, this.da(), 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.wy, 0.15f, 1.0f);
    }

    @Override
    public SoundEffect d(ItemStack stack) {
        return SoundEffects.wz;
    }

    @Override
    protected SoundEffect w() {
        return Set.of(State.f, State.e).contains((Object)this.go()) ? null : SoundEffects.wA;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.wB;
    }

    @Override
    public SoundEffect l_() {
        return SoundEffects.wC;
    }

    @Override
    public int Z() {
        return 50;
    }

    @Override
    public void a(boolean baby) {
        this.c_(baby ? -48000 : 0);
    }

    @Override
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        return EntityTypes.aN.a(world);
    }

    @Override
    public boolean a(EntityAnimal other) {
        if (!(other instanceof Sniffer)) {
            return false;
        }
        Sniffer sniffer = (Sniffer)other;
        Set<State> set = Set.of(State.a, State.c, State.b);
        return set.contains((Object)this.go()) && set.contains((Object)sniffer.go()) && super.a(other);
    }

    @Override
    public AxisAlignedBB g_() {
        return super.g_().g(0.6f);
    }

    @Override
    public boolean m(ItemStack stack) {
        return stack.a(TagsItem.aK);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return SnifferAi.a(this.dO().a(dynamic));
    }

    public BehaviorController<Sniffer> dN() {
        return super.dN();
    }

    protected BehaviorController.b<Sniffer> dO() {
        return BehaviorController.a(SnifferAi.b, SnifferAi.a);
    }

    @Override
    protected void X() {
        this.dL().ad().a("snifferBrain");
        this.dN().a((WorldServer)this.dL(), this);
        this.dL().ad().b("snifferActivityUpdate");
        SnifferAi.a(this);
        this.dL().ad().c();
        super.X();
    }

    @Override
    protected void W() {
        super.W();
        PacketDebug.a(this);
    }

    public static enum State {
        a,
        b,
        c,
        d,
        e,
        f,
        g;

    }
}

