/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import top.leavesmc.leaves.LeavesConfig;

public class EntityEnderCrystal
extends Entity {
    private static final DataWatcherObject<Optional<BlockPosition>> c = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.o);
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityEnderCrystal.class, DataWatcherRegistry.k);
    public int b;
    public boolean generatedByDragonFight = false;

    public EntityEnderCrystal(EntityTypes<? extends EntityEnderCrystal> type, World world) {
        super(type, world);
        this.I = true;
        this.b = this.ag.a(100000);
    }

    public EntityEnderCrystal(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityEnderCrystal>)EntityTypes.B, world);
        this.e(x2, y2, z2);
    }

    @Override
    protected Entity.MovementEmission aU() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a_() {
        this.al().a(c, Optional.empty());
        this.al().a(d, true);
    }

    @Override
    public void l() {
        ++this.b;
        if (this.dL() instanceof WorldServer) {
            BlockPosition blockposition = this.dl();
            if (((WorldServer)this.dL()).B() != null && this.dL().a_(blockposition).i() && !CraftEventFactory.callBlockIgniteEvent(this.dL(), blockposition, this).isCancelled()) {
                this.dL().b(blockposition, BlockFireAbstract.a(this.dL(), blockposition));
            }
            if (!LeavesConfig.mcTechnicalMode && this.dL().paperConfig().unsupportedSettings.fixInvulnerableEndCrystalExploit && this.generatedByDragonFight && this.cq() && (!Objects.equals(((WorldServer)this.dL()).uuid, this.getOriginWorld()) || ((WorldServer)this.dL()).B() == null || ((WorldServer)this.dL()).B().z == null || ((WorldServer)this.dL()).B().z.ordinal() > EnumDragonRespawn.d.ordinal())) {
                this.m(false);
                this.a((BlockPosition)null);
            }
        }
    }

    @Override
    protected void b(NBTTagCompound nbt) {
        if (this.q() != null) {
            nbt.a("BeamTarget", GameProfileSerializer.a(this.q()));
        }
        nbt.a("ShowBottom", this.s());
        if (this.generatedByDragonFight) {
            nbt.a("Paper.GeneratedByDragonFight", this.generatedByDragonFight);
        }
    }

    @Override
    protected void a(NBTTagCompound nbt) {
        if (nbt.b("BeamTarget", 10)) {
            this.a(GameProfileSerializer.b(nbt.p("BeamTarget")));
        }
        if (nbt.b("ShowBottom", 1)) {
            this.a(nbt.q("ShowBottom"));
        }
        if (nbt.b("Paper.GeneratedByDragonFight", 1)) {
            this.generatedByDragonFight = nbt.q("Paper.GeneratedByDragonFight");
        }
    }

    @Override
    public boolean br() {
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (source.d() instanceof EntityEnderDragon) {
            return false;
        }
        if (!this.dG() && !this.dL().B) {
            if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, false)) {
                return false;
            }
            this.a(Entity.RemovalReason.a);
            if (!source.a(DamageTypeTags.l)) {
                DamageSource damagesource1 = source.d() != null ? this.dM().d(this, source.d()) : null;
                ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, 6.0f, false);
                if (event.isCancelled()) {
                    this.dI();
                    return false;
                }
                this.dL().a(this, damagesource1, null, this.dq(), this.ds(), this.dw(), event.getRadius(), event.getFire(), World.a.b);
            }
            this.a(source);
        }
        return true;
    }

    @Override
    public void aj() {
        this.a(this.dM().n());
        super.aj();
    }

    private void a(DamageSource source) {
        EnderDragonBattle enderdragonbattle;
        if (this.dL() instanceof WorldServer && (enderdragonbattle = ((WorldServer)this.dL()).B()) != null) {
            enderdragonbattle.a(this, source);
        }
    }

    public void a(@Nullable BlockPosition beamTarget) {
        this.al().b(c, Optional.ofNullable(beamTarget));
    }

    @Nullable
    public BlockPosition q() {
        return this.al().b(c).orElse(null);
    }

    public void a(boolean showBottom) {
        this.al().b(d, showBottom);
    }

    public boolean s() {
        return this.al().b(d);
    }

    @Override
    public boolean a(double distance) {
        return super.a(distance) || this.q() != null;
    }

    @Override
    public ItemStack dy() {
        return new ItemStack(Items.ul);
    }
}

