/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.wither;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.BossBattle;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMoveFlying;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomFly;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityWither
extends EntityMonster
implements PowerableMob,
IRangedEntity {
    private static final DataWatcherObject<Integer> b = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> c = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> d = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final List<DataWatcherObject<Integer>> e = ImmutableList.of(b, c, d);
    private static final DataWatcherObject<Integer> bT = DataWatcher.a(EntityWither.class, DataWatcherRegistry.b);
    private static final int bU = 220;
    private final float[] bV = new float[2];
    private final float[] bW = new float[2];
    private final float[] bX = new float[2];
    private final float[] bY = new float[2];
    private final int[] bZ = new int[2];
    private final int[] ca = new int[2];
    private int cb;
    public final BossBattleServer cc = (BossBattleServer)new BossBattleServer(this.N_(), BossBattle.BarColor.f, BossBattle.BarStyle.a).a(true);
    private static final Predicate<EntityLiving> cd = entityliving -> entityliving.eR() != EnumMonsterType.b && entityliving.fy();
    private static final PathfinderTargetCondition ce = PathfinderTargetCondition.a().a(20.0).a(cd);
    private boolean canPortal = false;

    public void setCanTravelThroughPortals(boolean canPortal) {
        this.canPortal = canPortal;
    }

    public EntityWither(EntityTypes<? extends EntityWither> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.bL = new ControllerMoveFlying(this, 10, false);
        this.c(this.eL());
        this.bJ = 50;
    }

    @Override
    protected NavigationAbstract b(World world) {
        NavigationFlying navigationflying = new NavigationFlying(this, world);
        navigationflying.b(false);
        navigationflying.a(true);
        navigationflying.c(true);
        return navigationflying;
    }

    @Override
    protected void z() {
        this.bO.a(0, new a());
        this.bO.a(2, new PathfinderGoalArrowAttack(this, 1.0, 40, 20.0f));
        this.bO.a(5, new PathfinderGoalRandomFly(this, 1.0));
        this.bO.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(7, new PathfinderGoalRandomLookaround(this));
        this.bP.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bP.a(2, new PathfinderGoalNearestAttackableTarget<EntityLiving>(this, EntityLiving.class, 0, false, false, cd));
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(b, 0);
        this.an.a(c, 0);
        this.an.a(d, 0);
        this.an.a(bT, 0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Invul", this.y());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.s(nbt.h("Invul"));
        if (this.ac()) {
            this.cc.a(this.N_());
        }
    }

    @Override
    public void b(@Nullable IChatBaseComponent name) {
        super.b(name);
        this.cc.a(this.N_());
    }

    @Override
    protected SoundEffect w() {
        return SoundEffects.Aj;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.Am;
    }

    @Override
    public SoundEffect l_() {
        return SoundEffects.Al;
    }

    @Override
    public void b_() {
        int j2;
        int i2;
        Entity entity;
        Vec3D vec3d = this.do().d(1.0, 0.6, 1.0);
        if (!this.dL().B && this.t(0) > 0 && (entity = this.dL().a(this.t(0))) != null) {
            double d0 = vec3d.d;
            if (this.ds() < entity.ds() || !this.a() && this.ds() < entity.ds() + 5.0) {
                d0 = Math.max(0.0, d0);
                d0 += 0.3 - d0 * (double)0.6f;
            }
            vec3d = new Vec3D(vec3d.c, d0, vec3d.e);
            Vec3D vec3d1 = new Vec3D(entity.dq() - this.dq(), 0.0, entity.dw() - this.dw());
            if (vec3d1.i() > 9.0) {
                Vec3D vec3d2 = vec3d1.d();
                vec3d = vec3d.b(vec3d2.c * 0.3 - vec3d.c * 0.6, 0.0, vec3d2.e * 0.3 - vec3d.e * 0.6);
            }
        }
        this.f(vec3d);
        if (vec3d.i() > 0.05) {
            this.r((float)MathHelper.d(vec3d.e, vec3d.c) * 57.295776f - 90.0f);
        }
        super.b_();
        for (i2 = 0; i2 < 2; ++i2) {
            this.bY[i2] = this.bW[i2];
            this.bX[i2] = this.bV[i2];
        }
        for (i2 = 0; i2 < 2; ++i2) {
            int j3 = this.t(i2 + 1);
            Entity entity1 = null;
            if (j3 > 0) {
                entity1 = this.dL().a(j3);
            }
            if (entity1 != null) {
                double d1 = this.u(i2 + 1);
                double d2 = this.v(i2 + 1);
                double d3 = this.w(i2 + 1);
                double d4 = entity1.dq() - d1;
                double d5 = entity1.du() - d2;
                double d6 = entity1.dw() - d3;
                double d7 = Math.sqrt(d4 * d4 + d6 * d6);
                float f2 = (float)(MathHelper.d(d6, d4) * 57.2957763671875) - 90.0f;
                float f1 = (float)(-(MathHelper.d(d5, d7) * 57.2957763671875));
                this.bV[i2] = this.a(this.bV[i2], f1, 40.0f);
                this.bW[i2] = this.a(this.bW[i2], f2, 10.0f);
                continue;
            }
            this.bW[i2] = this.a(this.bW[i2], this.aU, 10.0f);
        }
        boolean flag = this.a();
        for (j2 = 0; j2 < 3; ++j2) {
            double d8 = this.u(j2);
            double d9 = this.v(j2);
            double d10 = this.w(j2);
            this.dL().a(Particles.Z, d8 + this.ag.k() * (double)0.3f, d9 + this.ag.k() * (double)0.3f, d10 + this.ag.k() * (double)0.3f, 0.0, 0.0, 0.0);
            if (!flag || this.dL().z.a(4) != 0) continue;
            this.dL().a(Particles.v, d8 + this.ag.k() * (double)0.3f, d9 + this.ag.k() * (double)0.3f, d10 + this.ag.k() * (double)0.3f, (double)0.7f, (double)0.7f, 0.5);
        }
        if (this.y() > 0) {
            for (j2 = 0; j2 < 3; ++j2) {
                this.dL().a(Particles.v, this.dq() + this.ag.k(), this.ds() + (double)(this.ag.i() * 3.3f), this.dw() + this.ag.k(), (double)0.7f, (double)0.7f, 0.9f);
            }
        }
    }

    @Override
    protected void X() {
        if (this.y() > 0) {
            int i2 = this.y() - 1;
            this.cc.a(1.0f - (float)i2 / 220.0f);
            if (i2 <= 0) {
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), 7.0f, false);
                this.dL().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    this.dL().a((Entity)this, this.dq(), this.du(), this.dw(), event.getRadius(), event.getFire(), World.a.c);
                }
                if (!this.aS()) {
                    int viewDistance = ((WorldServer)this.dL()).getCraftServer().getViewDistance() * 16;
                    for (EntityPlayer player : this.dL().spigotConfig.witherSpawnSoundRadius > 0 ? ((WorldServer)this.dL()).v() : this.dL().n().ac().l) {
                        double deltaX = this.dq() - player.dq();
                        double deltaZ = this.dw() - player.dw();
                        double distanceSquared = deltaX * deltaX + deltaZ * deltaZ;
                        if (this.dL().spigotConfig.witherSpawnSoundRadius > 0 && distanceSquared > (double)(this.dL().spigotConfig.witherSpawnSoundRadius * this.dL().spigotConfig.witherSpawnSoundRadius)) continue;
                        if (distanceSquared > (double)(viewDistance * viewDistance)) {
                            double deltaLength = Math.sqrt(distanceSquared);
                            double relativeX = player.dq() + deltaX / deltaLength * (double)viewDistance;
                            double relativeZ = player.dw() + deltaZ / deltaLength * (double)viewDistance;
                            player.c.b(new PacketPlayOutWorldEvent(1023, new BlockPosition((int)relativeX, (int)this.ds(), (int)relativeZ), 0, true));
                            continue;
                        }
                        player.c.b(new PacketPlayOutWorldEvent(1023, this.dl(), 0, true));
                    }
                }
            }
            this.s(i2);
            if (this.ah % 10 == 0) {
                this.heal(10.0f, EntityRegainHealthEvent.RegainReason.WITHER_SPAWN);
            }
        } else {
            int j2;
            int i3;
            super.X();
            for (i3 = 1; i3 < 3; ++i3) {
                EntityLiving entityliving1;
                if (this.ah < this.bZ[i3 - 1]) continue;
                this.bZ[i3 - 1] = this.ah + 10 + this.ag.a(10);
                if (this.dL().ai() == EnumDifficulty.c || this.dL().ai() == EnumDifficulty.d) {
                    int k2 = i3 - 1;
                    int l2 = this.ca[i3 - 1];
                    this.ca[k2] = this.ca[i3 - 1] + 1;
                    if (l2 > 15) {
                        float f2 = 10.0f;
                        float f1 = 5.0f;
                        double d0 = MathHelper.a(this.ag, this.dq() - 10.0, this.dq() + 10.0);
                        double d1 = MathHelper.a(this.ag, this.ds() - 5.0, this.ds() + 5.0);
                        double d2 = MathHelper.a(this.ag, this.dw() - 10.0, this.dw() + 10.0);
                        this.a(i3 + 1, d0, d1, d2, true);
                        this.ca[i3 - 1] = 0;
                    }
                }
                if ((j2 = this.t(i3)) > 0) {
                    EntityLiving entityliving = (EntityLiving)this.dL().a(j2);
                    if (entityliving != null && this.c(entityliving) && this.f((Entity)entityliving) <= 900.0 && this.E(entityliving)) {
                        this.a(i3 + 1, entityliving);
                        this.bZ[i3 - 1] = this.ah + 40 + this.ag.a(20);
                        this.ca[i3 - 1] = 0;
                        continue;
                    }
                    this.a(i3, 0);
                    continue;
                }
                List<EntityLiving> list = this.dL().a(EntityLiving.class, ce, this, this.cG().c(20.0, 8.0, 20.0));
                if (list.isEmpty() || CraftEventFactory.callEntityTargetLivingEvent(this, entityliving1 = list.get(this.ag.a(list.size())), EntityTargetEvent.TargetReason.CLOSEST_ENTITY).isCancelled()) continue;
                this.a(i3, entityliving1.ah());
            }
            if (this.q() != null) {
                this.a(0, this.q().ah());
            } else {
                this.a(0, 0);
            }
            if (this.cb > 0) {
                --this.cb;
                if (this.cb == 0 && this.dL().X().b(GameRules.c)) {
                    i3 = MathHelper.a(this.ds());
                    j2 = MathHelper.a(this.dq());
                    int i1 = MathHelper.a(this.dw());
                    boolean flag = false;
                    for (int j1 = -1; j1 <= 1; ++j1) {
                        for (int k1 = -1; k1 <= 1; ++k1) {
                            for (int l1 = 0; l1 <= 3; ++l1) {
                                int i2 = j2 + j1;
                                int j22 = i3 + l1;
                                int k2 = i1 + k1;
                                BlockPosition blockposition = new BlockPosition(i2, j22, k2);
                                IBlockData iblockdata = this.dL().a_(blockposition);
                                if (!EntityWither.d(iblockdata) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, iblockdata.u().g())) continue;
                                flag = this.dL().a(blockposition, true, this) || flag;
                            }
                        }
                    }
                    if (flag) {
                        this.dL().a((EntityHuman)null, 1022, this.dl(), 0);
                    }
                }
            }
            if (this.ah % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            this.cc.a(this.eu() / this.eL());
        }
    }

    public static boolean d(IBlockData block) {
        return !block.i() && !block.a(TagsBlock.aD);
    }

    public void s() {
        this.s(220);
        this.cc.a(0.0f);
        this.c(this.eL() / 3.0f);
    }

    @Override
    public void a(IBlockData state, Vec3D multiplier) {
    }

    @Override
    public void c(EntityPlayer player) {
        super.c(player);
        this.cc.a(player);
    }

    @Override
    public void d(EntityPlayer player) {
        super.d(player);
        this.cc.b(player);
    }

    private double u(int headIndex) {
        if (headIndex <= 0) {
            return this.dq();
        }
        float f2 = (this.aU + (float)(180 * (headIndex - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.b(f2);
        return this.dq() + (double)f1 * 1.3;
    }

    private double v(int headIndex) {
        return headIndex <= 0 ? this.ds() + 3.0 : this.ds() + 2.2;
    }

    private double w(int headIndex) {
        if (headIndex <= 0) {
            return this.dw();
        }
        float f2 = (this.aU + (float)(180 * (headIndex - 1))) * ((float)Math.PI / 180);
        float f1 = MathHelper.a(f2);
        return this.dw() + (double)f1 * 1.3;
    }

    private float a(float prevAngle, float desiredAngle, float maxDifference) {
        float f3 = MathHelper.g(desiredAngle - prevAngle);
        if (f3 > maxDifference) {
            f3 = maxDifference;
        }
        if (f3 < -maxDifference) {
            f3 = -maxDifference;
        }
        return prevAngle + f3;
    }

    private void a(int headIndex, EntityLiving target) {
        this.a(headIndex, target.dq(), target.ds() + (double)target.cH() * 0.5, target.dw(), headIndex == 0 && this.ag.i() < 0.001f);
    }

    private void a(int headIndex, double targetX, double targetY, double targetZ, boolean charged) {
        if (!this.aS()) {
            this.dL().a((EntityHuman)null, 1024, this.dl(), 0);
        }
        double d3 = this.u(headIndex);
        double d4 = this.v(headIndex);
        double d5 = this.w(headIndex);
        double d6 = targetX - d3;
        double d7 = targetY - d4;
        double d8 = targetZ - d5;
        EntityWitherSkull entitywitherskull = new EntityWitherSkull(this.dL(), this, d6, d7, d8);
        entitywitherskull.b((Entity)this);
        if (charged) {
            entitywitherskull.a(true);
        }
        entitywitherskull.p(d3, d4, d5);
        this.dL().b(entitywitherskull);
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.a(0, target);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (!source.a(DamageTypeTags.t) && !(source.d() instanceof EntityWither)) {
            Entity entity;
            if (this.y() > 0 && !source.a(DamageTypeTags.d)) {
                return false;
            }
            if (this.a() && (entity = source.c()) instanceof EntityArrow) {
                return false;
            }
            entity = source.d();
            if (entity != null && !(entity instanceof EntityHuman) && entity instanceof EntityLiving && ((EntityLiving)entity).eR() == this.eR()) {
                return false;
            }
            if (this.cb <= 0) {
                this.cb = 20;
            }
            int i2 = 0;
            while (i2 < this.ca.length) {
                int n2 = i2++;
                this.ca[n2] = this.ca[n2] + 3;
            }
            return super.a(source, amount);
        }
        return false;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        super.a(source, lootingMultiplier, allowDrops);
        EntityItem entityitem = this.spawnAtLocation(new ItemStack(Items.ty), 0.0f, EntityItem::A);
        if (entityitem != null) {
            entityitem.A();
        }
    }

    @Override
    public void dx() {
        if (this.dL().ai() == EnumDifficulty.a && this.V()) {
            this.ak();
        } else {
            this.bb = 0;
        }
    }

    @Override
    public boolean b(MobEffect effect, @Nullable Entity source) {
        return false;
    }

    public static AttributeProvider.Builder t() {
        return EntityMonster.gj().a(GenericAttributes.a, 300.0).a(GenericAttributes.d, 0.6f).a(GenericAttributes.e, 0.6f).a(GenericAttributes.b, 40.0).a(GenericAttributes.i, 4.0);
    }

    public float b(int headIndex) {
        return this.bW[headIndex];
    }

    public float c(int headIndex) {
        return this.bV[headIndex];
    }

    public int y() {
        return this.an.b(bT);
    }

    public void s(int ticks) {
        this.an.b(bT, ticks);
    }

    public int t(int headIndex) {
        return this.an.b(e.get(headIndex));
    }

    public void a(int headIndex, int id) {
        this.an.b(e.get(headIndex), id);
    }

    @Override
    public boolean a() {
        return this.eu() <= this.eL() / 2.0f;
    }

    @Override
    public EnumMonsterType eR() {
        return EnumMonsterType.b;
    }

    @Override
    protected boolean o(Entity entity) {
        return false;
    }

    @Override
    public boolean cs() {
        return super.cs() && this.canPortal;
    }

    @Override
    public boolean c(MobEffect effect) {
        return effect.c() == MobEffects.t && this.dL().paperConfig().entities.mobEffects.immuneToWitherEffect.wither ? false : super.c(effect);
    }

    private class a
    extends PathfinderGoal {
        public a() {
            this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.c, PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            return EntityWither.this.y() > 0;
        }
    }
}

