/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vector3f;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R2.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import top.leavesmc.leaves.LeavesConfig;

public class EntityArmorStand
extends EntityLiving {
    public static final int b = 5;
    private static final boolean bK = true;
    private static final Vector3f bL = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f bM = new Vector3f(0.0f, 0.0f, 0.0f);
    private static final Vector3f bN = new Vector3f(-10.0f, 0.0f, -10.0f);
    private static final Vector3f bO = new Vector3f(-15.0f, 0.0f, 10.0f);
    private static final Vector3f bP = new Vector3f(-1.0f, 0.0f, -1.0f);
    private static final Vector3f bQ = new Vector3f(1.0f, 0.0f, 1.0f);
    private static final EntitySize bR = new EntitySize(0.0f, 0.0f, true);
    private static final EntitySize bS = EntityTypes.d.n().a(0.5f);
    private static final double bT = 0.1;
    private static final double bU = 0.9;
    private static final double bV = 0.4;
    private static final double bW = 1.6;
    public static final int c = 8;
    public static final int d = 16;
    public static final int e = 1;
    public static final int f = 4;
    public static final int bA = 8;
    public static final int bB = 16;
    public static final DataWatcherObject<Byte> bC = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.a);
    public static final DataWatcherObject<Vector3f> bD = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    public static final DataWatcherObject<Vector3f> bE = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    public static final DataWatcherObject<Vector3f> bF = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    public static final DataWatcherObject<Vector3f> bG = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    public static final DataWatcherObject<Vector3f> bH = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    public static final DataWatcherObject<Vector3f> bI = DataWatcher.a(EntityArmorStand.class, DataWatcherRegistry.m);
    private static final Predicate<Entity> bX = entity -> entity instanceof EntityMinecartAbstract && ((EntityMinecartAbstract)entity).z() == EntityMinecartAbstract.EnumMinecartType.a;
    private final NonNullList<net.minecraft.world.item.ItemStack> bY;
    private final NonNullList<net.minecraft.world.item.ItemStack> bZ;
    private boolean ca;
    public long bJ;
    public int cb;
    public Vector3f cc;
    public Vector3f cd;
    public Vector3f ce;
    public Vector3f cf;
    public Vector3f cg;
    public Vector3f ch;
    public boolean canMove = true;
    public boolean canTick = true;
    public boolean canTickSetByAPI = false;
    private boolean noTickPoseDirty = false;
    private boolean noTickEquipmentDirty = false;

    public EntityArmorStand(EntityTypes<? extends EntityArmorStand> type, World world) {
        super((EntityTypes<? extends EntityLiving>)type, world);
        if (world != null) {
            this.canTick = world.paperConfig().entities.armorStands.tick;
        }
        this.bY = NonNullList.a(2, net.minecraft.world.item.ItemStack.b);
        this.bZ = NonNullList.a(4, net.minecraft.world.item.ItemStack.b);
        this.cc = bL;
        this.cd = bM;
        this.ce = bN;
        this.cf = bO;
        this.cg = bP;
        this.ch = bQ;
        this.t(0.0f);
    }

    public EntityArmorStand(World world, double x2, double y2, double z2) {
        this((EntityTypes<? extends EntityArmorStand>)EntityTypes.d, world);
        this.e(x2, y2, z2);
    }

    @Override
    public float getBukkitYaw() {
        return this.dB();
    }

    @Override
    public void i_() {
        double d0 = this.dq();
        double d1 = this.ds();
        double d2 = this.dw();
        super.i_();
        this.e(d0, d1, d2);
    }

    private boolean G() {
        return !this.y() && !this.aT();
    }

    @Override
    public boolean cX() {
        return super.cX() && this.G();
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(bC, (byte)0);
        this.an.a(bD, bL);
        this.an.a(bE, bM);
        this.an.a(bF, bN);
        this.an.a(bG, bO);
        this.an.a(bH, bP);
        this.an.a(bI, bQ);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bJ() {
        return this.bY;
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> bK() {
        return this.bZ;
    }

    @Override
    public net.minecraft.world.item.ItemStack c(EnumItemSlot slot) {
        switch (slot.a()) {
            case a: {
                return this.bY.get(slot.b());
            }
            case b: {
                return this.bZ.get(slot.b());
            }
        }
        return net.minecraft.world.item.ItemStack.b;
    }

    @Override
    public void a(EnumItemSlot slot, net.minecraft.world.item.ItemStack stack) {
        this.setItemSlot(slot, stack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.e(itemstack);
        switch (enumitemslot.a()) {
            case a: {
                this.onEquipItem(enumitemslot, this.bY.set(enumitemslot.b(), itemstack), itemstack, silent);
                break;
            }
            case b: {
                this.onEquipItem(enumitemslot, this.bZ.set(enumitemslot.b(), itemstack), itemstack, silent);
            }
        }
        this.noTickEquipmentDirty = true;
    }

    @Override
    public boolean f(net.minecraft.world.item.ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(stack);
        return this.c(enumitemslot).b() && !this.e(enumitemslot);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        NBTTagList nbttaglist = new NBTTagList();
        for (net.minecraft.world.item.ItemStack itemstack : this.bZ) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            if (!itemstack.b()) {
                itemstack.b(nbttagcompound1);
            }
            nbttaglist.add(nbttagcompound1);
        }
        nbt.a("ArmorItems", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (net.minecraft.world.item.ItemStack itemstack1 : this.bY) {
            NBTTagCompound nbttagcompound2 = new NBTTagCompound();
            if (!itemstack1.b()) {
                itemstack1.b(nbttagcompound2);
            }
            nbttaglist1.add(nbttagcompound2);
        }
        nbt.a("HandItems", nbttaglist1);
        nbt.a("Invisible", this.cd());
        nbt.a("Small", this.s());
        nbt.a("ShowArms", this.t());
        nbt.a("DisabledSlots", this.cb);
        nbt.a("NoBasePlate", this.w());
        if (this.y()) {
            nbt.a("Marker", this.y());
        }
        nbt.a("Pose", this.I());
        if (this.canTickSetByAPI) {
            nbt.a("Paper.CanTickOverride", this.canTick);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        int i2;
        NBTTagList nbttaglist;
        super.a(nbt);
        if (nbt.b("ArmorItems", 9)) {
            nbttaglist = nbt.c("ArmorItems", 10);
            for (i2 = 0; i2 < this.bZ.size(); ++i2) {
                this.bZ.set(i2, net.minecraft.world.item.ItemStack.a(nbttaglist.a(i2)));
            }
        }
        if (nbt.b("HandItems", 9)) {
            nbttaglist = nbt.c("HandItems", 10);
            for (i2 = 0; i2 < this.bY.size(); ++i2) {
                this.bY.set(i2, net.minecraft.world.item.ItemStack.a(nbttaglist.a(i2)));
            }
        }
        this.j(nbt.q("Invisible"));
        this.t(nbt.q("Small"));
        this.a(nbt.q("ShowArms"));
        this.cb = nbt.h("DisabledSlots");
        this.s(nbt.q("NoBasePlate"));
        this.u(nbt.q("Marker"));
        boolean bl = this.af = !this.G();
        if (nbt.e("Paper.CanTickOverride")) {
            this.canTick = nbt.q("Paper.CanTickOverride");
            this.canTickSetByAPI = true;
        }
        NBTTagCompound nbttagcompound1 = nbt.p("Pose");
        this.c(nbttagcompound1);
    }

    private void c(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.c("Head", 5);
        this.a(nbttaglist.isEmpty() ? bL : new Vector3f(nbttaglist));
        NBTTagList nbttaglist1 = nbt.c("Body", 5);
        this.b(nbttaglist1.isEmpty() ? bM : new Vector3f(nbttaglist1));
        NBTTagList nbttaglist2 = nbt.c("LeftArm", 5);
        this.c(nbttaglist2.isEmpty() ? bN : new Vector3f(nbttaglist2));
        NBTTagList nbttaglist3 = nbt.c("RightArm", 5);
        this.d(nbttaglist3.isEmpty() ? bO : new Vector3f(nbttaglist3));
        NBTTagList nbttaglist4 = nbt.c("LeftLeg", 5);
        this.e(nbttaglist4.isEmpty() ? bP : new Vector3f(nbttaglist4));
        NBTTagList nbttaglist5 = nbt.c("RightLeg", 5);
        this.f(nbttaglist5.isEmpty() ? bQ : new Vector3f(nbttaglist5));
    }

    private NBTTagCompound I() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (!bL.equals(this.cc)) {
            nbttagcompound.a("Head", this.cc.a());
        }
        if (!bM.equals(this.cd)) {
            nbttagcompound.a("Body", this.cd.a());
        }
        if (!bN.equals(this.ce)) {
            nbttagcompound.a("LeftArm", this.ce.a());
        }
        if (!bO.equals(this.cf)) {
            nbttagcompound.a("RightArm", this.cf.a());
        }
        if (!bP.equals(this.cg)) {
            nbttagcompound.a("LeftLeg", this.cg.a());
        }
        if (!bQ.equals(this.ch)) {
            nbttagcompound.a("RightLeg", this.ch.a());
        }
        return nbttagcompound;
    }

    @Override
    public boolean isCollidable(boolean ignoreClimbing) {
        return false;
    }

    @Override
    protected void D(Entity entity) {
    }

    @Override
    protected void fh() {
        if (!this.dL().paperConfig().entities.armorStands.doCollisionEntityLookups) {
            return;
        }
        List<Entity> list = this.dL().a(EntityMinecartAbstract.class, this.cG(), bX);
        for (Entity entity : list) {
            if (!(this.f(entity) <= 0.2)) continue;
            entity.g(this);
        }
    }

    @Override
    public EnumInteractionResult a(EntityHuman player, Vec3D hitPos, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemstack = player.b(hand);
        if (!this.y() && !itemstack.a(Items.tR)) {
            if (player.M_()) {
                return EnumInteractionResult.a;
            }
            if (player.dL().B) {
                return EnumInteractionResult.b;
            }
            EnumItemSlot enumitemslot = EntityInsentient.h(itemstack);
            if (itemstack.b()) {
                EnumItemSlot enumitemslot2;
                EnumItemSlot enumitemslot1 = this.j(hitPos);
                EnumItemSlot enumItemSlot = enumitemslot2 = this.e(enumitemslot1) ? enumitemslot : enumitemslot1;
                if (this.b(enumitemslot2) && this.a(player, enumitemslot2, itemstack, hand)) {
                    return EnumInteractionResult.a;
                }
            } else {
                if (LeavesConfig.stickChangeArmorStandArmStatus && itemstack.a(Items.oB) && player.bR()) {
                    this.a(!this.t());
                }
                if (this.e(enumitemslot)) {
                    return EnumInteractionResult.e;
                }
                if (enumitemslot.a() == EnumItemSlot.Function.a && !this.t()) {
                    return EnumInteractionResult.e;
                }
                if (this.a(player, enumitemslot, itemstack, hand)) {
                    return EnumInteractionResult.a;
                }
            }
            return EnumInteractionResult.d;
        }
        return EnumInteractionResult.d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnumItemSlot j(Vec3D hitPos) {
        EnumItemSlot enumitemslot = EnumItemSlot.a;
        boolean flag = this.s();
        double d0 = flag ? hitPos.d * 2.0 : hitPos.d;
        EnumItemSlot enumitemslot1 = EnumItemSlot.c;
        if (d0 >= 0.1) {
            double d2 = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d2 && this.b(enumitemslot1)) {
                return EnumItemSlot.c;
            }
        }
        double d3 = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d3) {
            double d4 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d4 && this.b(EnumItemSlot.e)) {
                return EnumItemSlot.e;
            }
        }
        if (d0 >= 0.4) {
            double d5 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d5 && this.b(EnumItemSlot.d)) {
                return EnumItemSlot.d;
            }
        }
        if (d0 >= 1.6 && this.b(EnumItemSlot.f)) {
            return EnumItemSlot.f;
        }
        if (this.b(EnumItemSlot.a)) return enumitemslot;
        if (!this.b(EnumItemSlot.b)) return enumitemslot;
        return EnumItemSlot.b;
    }

    public boolean e(EnumItemSlot slot) {
        return (this.cb & 1 << slot.d()) != 0 || slot.a() == EnumItemSlot.Function.a && !this.t();
    }

    private boolean a(EntityHuman player, EnumItemSlot slot, net.minecraft.world.item.ItemStack stack, EnumHand hand) {
        net.minecraft.world.item.ItemStack itemstack1 = this.c(slot);
        if (!itemstack1.b() && (this.cb & 1 << slot.d() + 8) != 0) {
            return false;
        }
        if (itemstack1.b() && (this.cb & 1 << slot.d() + 16) != 0) {
            return false;
        }
        CraftItemStack armorStandItem = CraftItemStack.asCraftMirror(itemstack1);
        CraftItemStack playerHeldItem = CraftItemStack.asCraftMirror(stack);
        Player player1 = (Player)player.getBukkitEntity();
        ArmorStand self = (ArmorStand)this.getBukkitEntity();
        EquipmentSlot slot1 = CraftEquipmentSlot.getSlot(slot);
        EquipmentSlot hand1 = CraftEquipmentSlot.getHand(hand);
        PlayerArmorStandManipulateEvent armorStandManipulateEvent = new PlayerArmorStandManipulateEvent(player1, self, (ItemStack)playerHeldItem, (ItemStack)armorStandItem, slot1, hand1);
        this.dL().getCraftServer().getPluginManager().callEvent((Event)armorStandManipulateEvent);
        if (armorStandManipulateEvent.isCancelled()) {
            return true;
        }
        if (player.fS().d && itemstack1.b() && !stack.b()) {
            this.a(slot, stack.c(1));
            return true;
        }
        if (!stack.b() && stack.L() > 1) {
            if (!itemstack1.b()) {
                return false;
            }
            this.a(slot, stack.a(1));
            return true;
        }
        this.a(slot, stack);
        player.a(hand, itemstack1);
        return true;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (!this.dL().B && !this.dG()) {
            if (source.a(DamageTypeTags.d)) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount)) {
                    return false;
                }
                this.aj();
                return false;
            }
            if (!this.b(source) && !this.y()) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount, true, this.ca)) {
                    return false;
                }
                if (source.a(DamageTypeTags.l)) {
                    EntityDeathEvent event = this.brokenByAnything(source);
                    if (!event.isCancelled()) {
                        this.kill(false);
                    }
                    return false;
                }
                if (source.a(DamageTypeTags.u)) {
                    if (this.bM()) {
                        this.g(source, 0.15f);
                    } else {
                        this.g(5);
                    }
                    return false;
                }
                if (source.a(DamageTypeTags.v) && this.eu() > 0.5f) {
                    this.g(source, 4.0f);
                    return false;
                }
                boolean flag = "player".equals(source.e());
                boolean flag1 = source.a(DamageTypeTags.A);
                if (LeavesConfig.armorStandCantKillByMobProjectile && !flag && !(source.c() instanceof EntityArrow)) {
                    return false;
                }
                if (!flag && !flag1) {
                    return false;
                }
                Entity entity = source.d();
                if (entity instanceof EntityHuman) {
                    EntityHuman entityhuman = (EntityHuman)entity;
                    if (!entityhuman.fS().e) {
                        return false;
                    }
                }
                if (source.g()) {
                    EntityArrow entityarrow;
                    this.L();
                    this.K();
                    this.aj();
                    entity = source.c();
                    if (entity instanceof EntityArrow && (entityarrow = (EntityArrow)entity).B() > 0) {
                        boolean flag2 = true;
                        return flag2;
                    }
                    boolean flag2 = false;
                    return flag2;
                }
                long i2 = this.dL().V();
                if (i2 - this.bJ > 5L && !flag1) {
                    this.dL().a((Entity)this, (byte)32);
                    this.a(GameEvent.o, source.d());
                    this.bJ = i2;
                } else {
                    EntityDeathEvent event = this.brokenByPlayer(source);
                    this.K();
                    if (!event.isCancelled()) {
                        this.kill(false);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void b(byte status) {
        if (status == 32) {
            if (this.dL().B) {
                this.dL().a(this.dq(), this.ds(), this.dw(), SoundEffects.an, this.da(), 0.3f, 1.0f, false);
                this.bJ = this.dL().V();
            }
        } else {
            super.b(status);
        }
    }

    @Override
    public boolean a(double distance) {
        double d1 = this.cG().a() * 4.0;
        if (Double.isNaN(d1) || d1 == 0.0) {
            d1 = 4.0;
        }
        return distance < (d1 *= 64.0) * d1;
    }

    private void K() {
        if (this.dL() instanceof WorldServer) {
            ((WorldServer)this.dL()).a(new ParticleParamBlock(Particles.c, Blocks.n.n()), this.dq(), this.e(0.6666666666666666), this.dw(), 10, (double)(this.df() / 4.0f), (double)(this.dg() / 4.0f), (double)(this.df() / 4.0f), 0.05);
        }
    }

    private void g(DamageSource damageSource, float amount) {
        float f1 = this.eu();
        if ((f1 -= amount) <= 0.5f) {
            EntityDeathEvent event = this.brokenByAnything(damageSource);
            if (!event.isCancelled()) {
                this.kill(false);
            }
        } else {
            this.c(f1);
            this.a(GameEvent.o, damageSource.d());
        }
    }

    private EntityDeathEvent brokenByPlayer(DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemstack = new net.minecraft.world.item.ItemStack(Items.tL);
        if (this.ac()) {
            itemstack.a(this.ad());
        }
        this.drops.add(new Entity.DefaultDrop(itemstack, stack -> Block.a(this.dL(), this.dl(), stack)));
        return this.brokenByAnything(damageSource);
    }

    private EntityDeathEvent brokenByAnything(DamageSource damageSource) {
        net.minecraft.world.item.ItemStack itemstack;
        int i2;
        this.L();
        for (i2 = 0; i2 < this.bY.size(); ++i2) {
            itemstack = this.bY.get(i2);
            if (itemstack.b()) continue;
            this.drops.add(new Entity.DefaultDrop(itemstack, stack -> Block.a(this.dL(), this.dl().c(), stack)));
            this.bY.set(i2, net.minecraft.world.item.ItemStack.b);
        }
        for (i2 = 0; i2 < this.bZ.size(); ++i2) {
            itemstack = this.bZ.get(i2);
            if (itemstack.b()) continue;
            this.drops.add(new Entity.DefaultDrop(itemstack, stack -> Block.a(this.dL(), this.dl().c(), stack)));
            this.bZ.set(i2, net.minecraft.world.item.ItemStack.b);
        }
        return this.dropAllDeathLoot(damageSource);
    }

    private void L() {
        this.dL().a((EntityHuman)null, this.dq(), this.ds(), this.dw(), SoundEffects.al, this.da(), 1.0f, 1.0f);
    }

    @Override
    protected float e(float bodyRotation, float headRotation) {
        this.aV = this.N;
        this.aU = this.dB();
        return 0.0f;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return dimensions.b * (this.m_() ? 0.5f : 0.9f);
    }

    @Override
    public void h(Vec3D movementInput) {
        if (this.G()) {
            super.h(movementInput);
        }
    }

    @Override
    public void o(float bodyYaw) {
        this.aV = this.N = bodyYaw;
        this.aX = this.aW = bodyYaw;
    }

    @Override
    public void n(float headYaw) {
        this.aV = this.N = headYaw;
        this.aX = this.aW = headYaw;
    }

    @Override
    public void l() {
        if (!this.canTick) {
            if (this.noTickPoseDirty) {
                this.noTickPoseDirty = false;
                this.updatePose();
            }
            if (this.noTickEquipmentDirty) {
                this.noTickEquipmentDirty = false;
                this.detectEquipmentUpdatesPublic();
            }
            return;
        }
        super.l();
        this.updatePose();
    }

    public void updatePose() {
        Vector3f vector3f5;
        Vector3f vector3f4;
        Vector3f vector3f3;
        Vector3f vector3f2;
        Vector3f vector3f1;
        Vector3f vector3f = this.an.b(bD);
        if (!this.cc.equals(vector3f)) {
            this.a(vector3f);
        }
        if (!this.cd.equals(vector3f1 = this.an.b(bE))) {
            this.b(vector3f1);
        }
        if (!this.ce.equals(vector3f2 = this.an.b(bF))) {
            this.c(vector3f2);
        }
        if (!this.cf.equals(vector3f3 = this.an.b(bG))) {
            this.d(vector3f3);
        }
        if (!this.cg.equals(vector3f4 = this.an.b(bH))) {
            this.e(vector3f4);
        }
        if (!this.ch.equals(vector3f5 = this.an.b(bI))) {
            this.f(vector3f5);
        }
    }

    @Override
    protected void H() {
        this.j(this.ca);
    }

    @Override
    public void j(boolean invisible) {
        this.ca = invisible;
        super.j(invisible);
    }

    @Override
    public boolean m_() {
        return this.s();
    }

    @Override
    public boolean eb() {
        return true;
    }

    @Override
    public void aj() {
        this.kill(true);
    }

    public void kill(boolean callEvent) {
        EntityDeathEvent event;
        if (callEvent && (event = CraftEventFactory.callEntityDeathEvent(this, this.drops)).isCancelled()) {
            return;
        }
        this.a(Entity.RemovalReason.a);
        this.a(GameEvent.p);
    }

    @Override
    public boolean cL() {
        return this.cd();
    }

    @Override
    public EnumPistonReaction q_() {
        return this.y() ? EnumPistonReaction.d : super.q_();
    }

    @Override
    public boolean p_() {
        return this.y();
    }

    public void t(boolean small) {
        this.an.b(bC, this.a(this.an.b(bC), 1, small));
    }

    public boolean s() {
        return (this.an.b(bC) & 1) != 0;
    }

    public void a(boolean showArms) {
        this.an.b(bC, this.a(this.an.b(bC), 4, showArms));
    }

    public boolean t() {
        return (this.an.b(bC) & 4) != 0;
    }

    public void s(boolean hideBasePlate) {
        this.an.b(bC, this.a(this.an.b(bC), 8, hideBasePlate));
    }

    @Override
    public boolean w() {
        return (this.an.b(bC) & 8) != 0;
    }

    public void u(boolean marker) {
        this.an.b(bC, this.a(this.an.b(bC), 16, marker));
    }

    public boolean y() {
        return (this.an.b(bC) & 0x10) != 0;
    }

    private byte a(byte value, int bitField, boolean set) {
        value = set ? (byte)(value | bitField) : (byte)(value & ~bitField);
        return value;
    }

    public void a(Vector3f angle) {
        this.cc = angle;
        this.an.b(bD, angle);
        this.noTickPoseDirty = true;
    }

    public void b(Vector3f angle) {
        this.cd = angle;
        this.an.b(bE, angle);
        this.noTickPoseDirty = true;
    }

    public void c(Vector3f angle) {
        this.ce = angle;
        this.an.b(bF, angle);
        this.noTickPoseDirty = true;
    }

    public void d(Vector3f angle) {
        this.cf = angle;
        this.an.b(bG, angle);
        this.noTickPoseDirty = true;
    }

    public void e(Vector3f angle) {
        this.cg = angle;
        this.an.b(bH, angle);
        this.noTickPoseDirty = true;
    }

    public void f(Vector3f angle) {
        this.ch = angle;
        this.an.b(bI, angle);
        this.noTickPoseDirty = true;
    }

    public Vector3f z() {
        return this.cc;
    }

    public Vector3f A() {
        return this.cd;
    }

    public Vector3f B() {
        return this.ce;
    }

    public Vector3f C() {
        return this.cf;
    }

    public Vector3f E() {
        return this.cg;
    }

    public Vector3f F() {
        return this.ch;
    }

    @Override
    public boolean br() {
        return super.br() && !this.y();
    }

    @Override
    public boolean u(Entity attacker) {
        return attacker instanceof EntityHuman && !this.dL().a((EntityHuman)attacker, this.dl());
    }

    @Override
    public EnumMainHand fl() {
        return EnumMainHand.b;
    }

    @Override
    public EntityLiving.a eF() {
        return new EntityLiving.a(SoundEffects.am, SoundEffects.am);
    }

    @Override
    @Nullable
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.an;
    }

    @Override
    @Nullable
    public SoundEffect l_() {
        return SoundEffects.al;
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
    }

    @Override
    public boolean fx() {
        return false;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bC.equals(data)) {
            this.i_();
            this.I = !this.y();
        }
        super.a(data);
    }

    @Override
    public boolean fy() {
        return false;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return this.v(this.y());
    }

    private EntitySize v(boolean marker) {
        return marker ? bR : (this.m_() ? bS : this.ag().n());
    }

    @Override
    public Vec3D k(float tickDelta) {
        if (this.y()) {
            AxisAlignedBB axisalignedbb = this.v(false).a(this.dj());
            BlockPosition blockposition = this.dl();
            int i2 = Integer.MIN_VALUE;
            for (BlockPosition blockposition1 : BlockPosition.a(BlockPosition.a(axisalignedbb.a, axisalignedbb.b, axisalignedbb.c), BlockPosition.a(axisalignedbb.d, axisalignedbb.e, axisalignedbb.f))) {
                int j2 = Math.max(this.dL().a(EnumSkyBlock.b, blockposition1), this.dL().a(EnumSkyBlock.a, blockposition1));
                if (j2 == 15) {
                    return Vec3D.b(blockposition1);
                }
                if (j2 <= i2) continue;
                i2 = j2;
                blockposition = blockposition1.i();
            }
            return Vec3D.b(blockposition);
        }
        return super.k(tickDelta);
    }

    @Override
    public net.minecraft.world.item.ItemStack dy() {
        return new net.minecraft.world.item.ItemStack(Items.tL);
    }

    @Override
    public boolean eo() {
        return !this.cd() && !this.y();
    }

    @Override
    public void a(EnumMoveType type, Vec3D movement) {
        if (this.canMove) {
            super.a(type, movement);
        }
    }

    @Override
    public boolean dQ() {
        return true;
    }
}

