/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDiodeAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.Validate;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.slf4j.Logger;

public abstract class EntityHanging
extends Entity {
    private static final Logger e = LogUtils.getLogger();
    protected static final Predicate<Entity> b = entity -> entity instanceof EntityHanging;
    private int f;
    public BlockPosition c;
    protected EnumDirection d;

    protected EntityHanging(EntityTypes<? extends EntityHanging> type, World world) {
        super(type, world);
        this.f = this.ah() % this.dL().spigotConfig.hangingTickFrequency;
        this.d = EnumDirection.d;
    }

    protected EntityHanging(EntityTypes<? extends EntityHanging> type, World world, BlockPosition pos) {
        this(type, world);
        this.c = pos;
    }

    @Override
    protected void a_() {
    }

    public void a(EnumDirection facing) {
        Validate.notNull((Object)facing);
        Validate.isTrue((boolean)facing.o().d());
        this.d = facing;
        this.r(this.d.e() * 90);
        this.N = this.dB();
        this.y();
    }

    protected void y() {
        if (this.d != null) {
            this.a(EntityHanging.calculateBoundingBox(this, this.c, this.d, this.A(), this.B()));
        }
    }

    public static AxisAlignedBB calculateBoundingBox(@Nullable Entity entity, BlockPosition blockPosition, EnumDirection direction, int width, int height) {
        double d0 = (double)blockPosition.u() + 0.5;
        double d1 = (double)blockPosition.v() + 0.5;
        double d2 = (double)blockPosition.w() + 0.5;
        double d3 = 0.46875;
        double d4 = EntityHanging.b(width);
        double d5 = EntityHanging.b(height);
        d0 -= (double)direction.j() * 0.46875;
        d2 -= (double)direction.l() * 0.46875;
        d1 += d5;
        EnumDirection enumdirection = direction.i();
        d0 += d4 * (double)enumdirection.j();
        d2 += d4 * (double)enumdirection.l();
        if (entity != null) {
            entity.p(d0, d1, d2);
        }
        double d6 = width;
        double d7 = height;
        double d8 = width;
        if (direction.o() == EnumDirection.EnumAxis.c) {
            d8 = 1.0;
        } else {
            d6 = 1.0;
        }
        return new AxisAlignedBB(d0 - (d6 /= 32.0), d1 - (d7 /= 32.0), d2 - (d8 /= 32.0), d0 + d6, d1 + d7, d2 + d8);
    }

    private static double b(int i2) {
        return i2 % 32 == 0 ? 0.5 : 0.0;
    }

    @Override
    public void l() {
        if (!this.dL().B) {
            this.ar();
            if (this.f++ == this.dL().spigotConfig.hangingTickFrequency) {
                this.f = 0;
                if (!this.dG() && !this.z()) {
                    IBlockData material = this.dL().a_(this.dl());
                    HangingBreakEvent.RemoveCause cause = !material.i() ? HangingBreakEvent.RemoveCause.OBSTRUCTION : HangingBreakEvent.RemoveCause.PHYSICS;
                    HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), cause);
                    this.dL().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (this.dG() || event.isCancelled()) {
                        return;
                    }
                    this.ak();
                    this.a((Entity)null);
                }
            }
        }
    }

    public boolean z() {
        if (!this.dL().g(this)) {
            return false;
        }
        int i2 = Math.max(1, this.A() / 16);
        int j2 = Math.max(1, this.B() / 16);
        BlockPosition blockposition = this.c.a(this.d.g());
        EnumDirection enumdirection = this.d.i();
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int k2 = 0; k2 < i2; ++k2) {
            for (int l2 = 0; l2 < j2; ++l2) {
                int i1 = (i2 - 1) / -2;
                int j1 = (j2 - 1) / -2;
                blockposition_mutableblockposition.g(blockposition).c(enumdirection, k2 + i1).c(EnumDirection.b, l2 + j1);
                IBlockData iblockdata = this.dL().a_(blockposition_mutableblockposition);
                if (iblockdata.e() || BlockDiodeAbstract.h(iblockdata)) continue;
                return false;
            }
        }
        return this.dL().a((Entity)this, this.cG(), b).isEmpty();
    }

    @Override
    public boolean br() {
        return true;
    }

    @Override
    public boolean u(Entity attacker) {
        if (attacker instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)attacker;
            return !this.dL().a(entityhuman, this.c) ? true : this.a(this.dM().a(entityhuman), 0.0f);
        }
        return false;
    }

    @Override
    public EnumDirection cD() {
        return this.d;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (!this.dG() && !this.dL().B) {
            Entity damager;
            Entity entity = damager = source.b() ? source.d() : source.c();
            Object event = damager != null ? new HangingBreakByEntityEvent((Hanging)this.getBukkitEntity(), (org.bukkit.entity.Entity)damager.getBukkitEntity(), source.a(DamageTypeTags.l) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.ENTITY) : new HangingBreakEvent((Hanging)this.getBukkitEntity(), source.a(DamageTypeTags.l) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.DEFAULT);
            this.dL().getCraftServer().getPluginManager().callEvent((Event)event);
            if (this.dG() || event.isCancelled()) {
                return true;
            }
            this.aj();
            this.bo();
            this.a(source.d());
        }
        return true;
    }

    @Override
    public void a(EnumMoveType movementType, Vec3D movement) {
        if (!this.dL().B && !this.dG() && movement.g() > 0.0) {
            if (this.dG()) {
                return;
            }
            HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), HangingBreakEvent.RemoveCause.PHYSICS);
            this.dL().getCraftServer().getPluginManager().callEvent((Event)event);
            if (this.dG() || event.isCancelled()) {
                return;
            }
            this.aj();
            this.a((Entity)null);
        }
    }

    @Override
    public void j(double deltaX, double deltaY, double deltaZ) {
    }

    @Override
    public void b(NBTTagCompound nbt) {
        BlockPosition blockposition = this.E();
        nbt.a("TileX", blockposition.u());
        nbt.a("TileY", blockposition.v());
        nbt.a("TileZ", blockposition.w());
    }

    @Override
    public void a(NBTTagCompound nbt) {
        BlockPosition blockposition = new BlockPosition(nbt.h("TileX"), nbt.h("TileY"), nbt.h("TileZ"));
        if (!blockposition.a(this.dl(), 16.0)) {
            e.error("Hanging entity at invalid position: {}", (Object)blockposition);
        } else {
            this.c = blockposition;
        }
    }

    public abstract int A();

    public abstract int B();

    public abstract void a(@Nullable Entity var1);

    public abstract void C();

    @Override
    public EntityItem a(ItemStack stack, float yOffset) {
        EntityItem entityitem = new EntityItem(this.dL(), this.dq() + (double)((float)this.d.j() * 0.15f), this.ds() + (double)yOffset, this.dw() + (double)((float)this.d.l() * 0.15f), stack);
        entityitem.t();
        this.dL().b(entityitem);
        return entityitem;
    }

    @Override
    protected boolean bt() {
        return false;
    }

    @Override
    public void e(double x2, double y2, double z2) {
        this.c = BlockPosition.a(x2, y2, z2);
        this.y();
        this.au = true;
    }

    public BlockPosition E() {
        return this.c;
    }

    @Override
    public float a(EnumBlockRotation rotation) {
        if (this.d.o() != EnumDirection.EnumAxis.b) {
            switch (rotation) {
                case c: {
                    this.d = this.d.g();
                    break;
                }
                case d: {
                    this.d = this.d.i();
                    break;
                }
                case b: {
                    this.d = this.d.h();
                }
            }
        }
        float f2 = MathHelper.g(this.dB());
        switch (rotation) {
            case c: {
                return f2 + 180.0f;
            }
            case d: {
                return f2 + 90.0f;
            }
            case b: {
                return f2 + 270.0f;
            }
        }
        return f2;
    }

    @Override
    public float a(EnumBlockMirror mirror) {
        return this.a(mirror.a(this.d));
    }

    @Override
    public void a(WorldServer world, EntityLightning lightning) {
    }

    @Override
    public void i_() {
    }
}

