/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.decoration.EntityHanging;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.decoration.PaintingVariants;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public class EntityPainting
extends EntityHanging
implements VariantHolder<Holder<PaintingVariant>> {
    private static final DataWatcherObject<Holder<PaintingVariant>> f = DataWatcher.a(EntityPainting.class, DataWatcherRegistry.y);
    private static final ResourceKey<PaintingVariant> g = PaintingVariants.a;
    public static final String e = "variant";

    private static Holder<PaintingVariant> s() {
        return BuiltInRegistries.m.f(g);
    }

    public EntityPainting(EntityTypes<? extends EntityPainting> type, World world) {
        super((EntityTypes<? extends EntityHanging>)type, world);
    }

    @Override
    @Override
    protected void a_() {
        this.an.a(f, EntityPainting.s());
    }

    @Override
    @Override
    public void a(DataWatcherObject<?> data) {
        if (f.equals(data)) {
            this.y();
        }
    }

    @Override
    @Override
    public void a(Holder<PaintingVariant> variant) {
        this.an.b(f, variant);
    }

    @Override
    public Holder<PaintingVariant> q() {
        return this.an.b(f);
    }

    public static Optional<EntityPainting> a(World world, BlockPosition pos, EnumDirection facing) {
        EntityPainting painting = new EntityPainting(world, pos);
        ArrayList<Holder> list = new ArrayList<Holder>();
        BuiltInRegistries.m.c(PaintingVariantTags.a).forEach(list::add);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        painting.a(facing);
        list.removeIf(variant -> {
            painting.a((Holder<PaintingVariant>)variant);
            return !painting.z();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int i2 = list.stream().mapToInt(EntityPainting::b).max().orElse(0);
        list.removeIf(variant -> EntityPainting.b(variant) < i2);
        Optional optional = SystemUtils.b(list, painting.ag);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        painting.a((Holder)optional.get());
        painting.a(facing);
        return Optional.of(painting);
    }

    private static int b(Holder<PaintingVariant> variant) {
        return variant.a().a() * variant.a().b();
    }

    private EntityPainting(World world, BlockPosition pos) {
        super(EntityTypes.ar, world, pos);
    }

    public EntityPainting(World world, BlockPosition pos, EnumDirection direction, Holder<PaintingVariant> variant) {
        this(world, pos);
        this.a(variant);
        this.a(direction);
    }

    @Override
    @Override
    public void b(NBTTagCompound nbt) {
        EntityPainting.a(nbt, this.q());
        nbt.a("facing", (byte)this.d.e());
        super.b(nbt);
    }

    @Override
    @Override
    public void a(NBTTagCompound nbt) {
        Holder holder = EntityPainting.c(nbt).orElseGet(EntityPainting::s);
        this.a(holder);
        this.d = EnumDirection.b(nbt.f("facing"));
        super.a(nbt);
        this.a(this.d);
    }

    public static void a(NBTTagCompound nbt, Holder<PaintingVariant> variant) {
        nbt.a(e, variant.e().orElse(g).a().toString());
    }

    public static Optional<Holder<PaintingVariant>> c(NBTTagCompound nbt) {
        return Optional.ofNullable(MinecraftKey.a(nbt.l(e))).map(id -> ResourceKey.a(Registries.P, id)).flatMap(BuiltInRegistries.m::b);
    }

    @Override
    @Override
    public int A() {
        return this.q().a().a();
    }

    @Override
    @Override
    public int B() {
        return this.q().a().b();
    }

    @Override
    @Override
    public void a(@Nullable Entity entity) {
        if (!this.dL().X().b(GameRules.h)) {
            return;
        }
        this.a(SoundEffects.qI, 1.0f, 1.0f);
        if (entity instanceof EntityHuman) {
            EntityHuman player = (EntityHuman)entity;
            if (player.fS().d) {
                return;
            }
        }
        this.a((IMaterial)Items.pl);
    }

    @Override
    @Override
    public void C() {
        this.a(SoundEffects.qJ, 1.0f, 1.0f);
    }

    @Override
    @Override
    public void b(double x2, double y2, double z2, float yaw, float pitch) {
        this.e(x2, y2, z2);
    }

    @Override
    @Override
    public void a(double x2, double y2, double z2, float yaw, float pitch, int interpolationSteps) {
        this.e(x2, y2, z2);
    }

    @Override
    @Override
    public Vec3D dk() {
        return Vec3D.a(this.c);
    }

    @Override
    @Override
    public Packet<PacketListenerPlayOut> di() {
        return new PacketPlayOutSpawnEntity(this, this.d.d(), this.E());
    }

    @Override
    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        this.a(EnumDirection.a(packet.o()));
    }

    @Override
    @Override
    public ItemStack dy() {
        return new ItemStack(Items.pl);
    }

    @Override
    public /* synthetic */ Object c() {
        return this.q();
    }
}

