/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.util.ShulkerBoxUtils;

public class EntityItem
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<ItemStack> c = DataWatcher.a(EntityItem.class, DataWatcherRegistry.h);
    private static final int d = 6000;
    private static final int e = Short.MAX_VALUE;
    private static final int f = Short.MIN_VALUE;
    public int g;
    public int h;
    public int i = 5;
    @Nullable
    public UUID j;
    @Nullable
    public UUID k;
    public final float b;
    private int lastTick = MinecraftServer.currentTick - 1;
    public boolean canMobPickup = true;
    private int despawnRate = -1;
    public TriState frictionState = TriState.NOT_SET;

    public EntityItem(EntityTypes<? extends EntityItem> type, World world) {
        super(type, world);
        this.b = this.ag.i() * (float)Math.PI * 2.0f;
        this.r(this.ag.i() * 360.0f);
    }

    public EntityItem(World world, double x2, double y2, double z2, ItemStack stack) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ad, world);
        ItemBlock bi;
        Item item;
        this.e(x2, y2, z2);
        if (LeavesConfig.useVanillaRandom) {
            this.o(world.z.j() * 0.2 - 0.1, 0.2, world.z.j() * 0.2 - 0.1);
        } else {
            this.o(this.ag.j() * 0.2 - 0.1, 0.2, this.ag.j() * 0.2 - 0.1);
        }
        this.a(stack);
        if (LeavesConfig.shulkerBoxStackSize > 1 && (item = stack.d()) instanceof ItemBlock && (bi = (ItemBlock)item).e() instanceof BlockShulkerBox) {
            ShulkerBoxUtils.cleanUpShulkerBoxTag(stack);
        }
    }

    public EntityItem(World world, double x2, double y2, double z2, ItemStack stack, double velocityX, double velocityY, double velocityZ) {
        this((EntityTypes<? extends EntityItem>)EntityTypes.ad, world);
        this.e(x2, y2, z2);
        this.o(velocityX, velocityY, velocityZ);
        this.a(stack);
    }

    private EntityItem(EntityItem entity) {
        super(entity.ag(), entity.dL());
        this.a(entity.q().p());
        this.v(entity);
        this.g = entity.g;
        this.b = entity.b;
    }

    @Override
    public boolean aV() {
        return this.q().a(TagsItem.aB);
    }

    @Override
    @Nullable
    public Entity v() {
        World world;
        if (this.j != null && (world = this.dL()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            return worldserver.a(this.j);
        }
        return null;
    }

    @Override
    protected Entity.MovementEmission aU() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a_() {
        this.al().a(c, ItemStack.b);
    }

    @Override
    public void l() {
        if (this.q().b()) {
            this.ak();
        } else {
            double d0;
            int i2;
            super.l();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            if (this.h != Short.MAX_VALUE) {
                this.h -= elapsedTicks;
            }
            this.h = Math.max(0, this.h);
            if (this.g != Short.MIN_VALUE) {
                this.g += elapsedTicks;
            }
            this.lastTick = MinecraftServer.currentTick;
            this.K = this.dq();
            this.L = this.ds();
            this.M = this.dw();
            Vec3D vec3d = this.do();
            float f2 = this.cH() - 0.11111111f;
            if (this.aX() && this.b(TagsFluid.a) > (double)f2) {
                this.E();
            } else if (this.bl() && this.b(TagsFluid.b) > (double)f2) {
                this.F();
            } else if (!this.aT()) {
                this.f(this.do().b(0.0, -0.04, 0.0));
            }
            if (this.dL().B) {
                this.af = false;
            } else {
                boolean bl = this.af = !this.dL().a((Entity)this, this.cG().h(1.0E-7));
                if (this.af) {
                    this.m(this.dq(), (this.cG().b + this.cG().e) / 2.0, this.dw());
                }
            }
            if (!this.aA() || this.do().i() > (double)1.0E-5f || (this.ah + this.ah()) % 4 == 0) {
                this.a(EnumMoveType.a, this.do());
                float f1 = 0.98f;
                if (this.frictionState == TriState.FALSE) {
                    f1 = 1.0f;
                } else if (this.aA()) {
                    f1 = this.dL().a_(this.aG()).b().h() * 0.98f;
                }
                this.f(this.do().d(f1, 0.98, f1));
                if (this.aA()) {
                    Vec3D vec3d1 = this.do();
                    if (vec3d1.d < 0.0) {
                        this.f(vec3d1.d(1.0, -0.5, 1.0));
                    }
                }
            }
            boolean flag = MathHelper.a(this.K) != MathHelper.a(this.dq()) || MathHelper.a(this.L) != MathHelper.a(this.ds()) || MathHelper.a(this.M) != MathHelper.a(this.dw());
            int n2 = i2 = flag ? 2 : 40;
            if (this.ah % i2 == 0 && !this.dL().B && this.H()) {
                this.G();
            }
            this.au |= this.be();
            if (!this.dL().B && (d0 = this.do().d(vec3d).g()) > 0.01) {
                this.au = true;
            }
            if (!this.dL().B && this.g >= this.despawnRate) {
                if (CraftEventFactory.callItemDespawnEvent(this).isCancelled()) {
                    this.g = 0;
                    return;
                }
                this.ak();
            }
        }
    }

    @Override
    public void inactiveTick() {
        this.l();
    }

    @Override
    protected BlockPosition aG() {
        return this.d(0.999999f);
    }

    private void E() {
        Vec3D vec3d = this.do();
        this.o(vec3d.c * (double)0.99f, vec3d.d + (double)(vec3d.d < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.e * (double)0.99f);
    }

    private void F() {
        Vec3D vec3d = this.do();
        this.o(vec3d.c * (double)0.95f, vec3d.d + (double)(vec3d.d < (double)0.06f ? 5.0E-4f : 0.0f), vec3d.e * (double)0.95f);
    }

    private void G() {
        if (this.H()) {
            double radius = this.dL().spigotConfig.itemMerge;
            List<EntityItem> list = this.dL().a(EntityItem.class, this.cG().c(radius, radius - 0.5, radius), (? super T entityitem) -> entityitem != this && entityitem.H());
            for (EntityItem entityitem2 : list) {
                if (!entityitem2.H() || this.dL().paperConfig().fixes.fixItemsMergingThroughWalls && this.dL().clipDirect(this.dj(), entityitem2.dj(), VoxelShapeCollision.a(this)) == MovingObjectPosition.EnumMovingObjectType.b) continue;
                this.a(entityitem2);
                if (!this.dG()) continue;
                break;
            }
        }
    }

    private boolean H() {
        ItemStack itemstack = this.q();
        return this.bv() && this.h != Short.MAX_VALUE && this.g != Short.MIN_VALUE && this.g < this.despawnRate && itemstack.L() < ShulkerBoxUtils.getItemStackMaxCount(itemstack);
    }

    private boolean tryStackShulkerBoxes(EntityItem other) {
        ItemBlock bi;
        Item item;
        ItemStack selfStack = this.q();
        if (LeavesConfig.shulkerBoxStackSize == 1 || !((item = selfStack.d()) instanceof ItemBlock) || !((bi = (ItemBlock)item).e() instanceof BlockShulkerBox)) {
            return false;
        }
        ItemStack otherStack = other.q();
        if (selfStack.d() == otherStack.d() && !ShulkerBoxUtils.shulkerBoxHasItems(selfStack) && !ShulkerBoxUtils.shulkerBoxHasItems(otherStack) && Objects.equals(selfStack.v(), otherStack.v()) && selfStack.L() != LeavesConfig.shulkerBoxStackSize) {
            int amount = Math.min(otherStack.L(), LeavesConfig.shulkerBoxStackSize - selfStack.L());
            selfStack.g(amount);
            this.a(selfStack);
            this.h = Math.max(other.h, this.h);
            this.g = Math.min(other.s(), this.g);
            otherStack.h(amount);
            if (otherStack.b()) {
                other.ak();
            } else {
                other.a(otherStack);
            }
            return true;
        }
        return false;
    }

    private void a(EntityItem other) {
        if (this.tryStackShulkerBoxes(other)) {
            return;
        }
        ItemStack itemstack = this.q();
        ItemStack itemstack1 = other.q();
        if (Objects.equals(this.k, other.k) && EntityItem.a(itemstack, itemstack1)) {
            EntityItem.a(this, itemstack, other, itemstack1);
        }
    }

    public static boolean a(ItemStack stack1, ItemStack stack2) {
        return !stack2.a(stack1.d()) ? false : (stack2.L() + stack1.L() > stack2.g() ? false : (stack2.u() ^ stack1.u() ? false : !stack2.u() || stack2.v().equals(stack1.v())));
    }

    public static ItemStack a(ItemStack stack1, ItemStack stack2, int maxCount) {
        int j2 = Math.min(Math.min(stack1.g(), maxCount) - stack1.L(), stack2.L());
        ItemStack itemstack2 = stack1.c(stack1.L() + j2);
        stack2.h(j2);
        return itemstack2;
    }

    private static void a(EntityItem targetEntity, ItemStack stack1, ItemStack stack2) {
        ItemStack itemstack2 = EntityItem.a(stack1, stack2, 64);
        targetEntity.a(itemstack2);
    }

    private static void a(EntityItem targetEntity, ItemStack targetStack, EntityItem sourceEntity, ItemStack sourceStack) {
        if (!CraftEventFactory.callItemMergeEvent(sourceEntity, targetEntity)) {
            return;
        }
        EntityItem.a(targetEntity, targetStack, sourceStack);
        targetEntity.h = Math.max(targetEntity.h, sourceEntity.h);
        targetEntity.g = Math.min(targetEntity.g, sourceEntity.g);
        if (sourceStack.b()) {
            sourceEntity.ak();
        }
    }

    @Override
    public boolean aW() {
        return this.q().d().w() || super.aW();
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (this.b(source)) {
            return false;
        }
        if (!this.q().b() && this.q().a(Items.ty) && source.a(DamageTypeTags.l)) {
            return false;
        }
        if (!this.q().d().a(source)) {
            return false;
        }
        if (this.dL().B) {
            return true;
        }
        if (CraftEventFactory.handleNonLivingEntityDamageEvent(this, source, amount)) {
            return false;
        }
        this.bo();
        this.i = (int)((float)this.i - amount);
        this.a(GameEvent.o, source.d());
        if (this.i <= 0) {
            this.q().a(this);
            this.ak();
        }
        return true;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        if (this.frictionState != TriState.NOT_SET) {
            nbt.a("Paper.FrictionState", this.frictionState.toString());
        }
        nbt.a("Health", (short)this.i);
        nbt.a("Age", (short)this.g);
        nbt.a("PickupDelay", (short)this.h);
        if (this.j != null) {
            nbt.a("Thrower", this.j);
        }
        if (this.k != null) {
            nbt.a("Owner", this.k);
        }
        if (!this.q().b()) {
            nbt.a("Item", this.q().b(new NBTTagCompound()));
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.i = nbt.g("Health");
        this.g = nbt.g("Age");
        if (nbt.e("PickupDelay")) {
            this.h = nbt.g("PickupDelay");
        }
        if (nbt.b("Owner")) {
            this.k = nbt.a("Owner");
        }
        if (nbt.b("Thrower")) {
            this.j = nbt.a("Thrower");
        }
        if (nbt.e("Paper.FrictionState")) {
            String fs = nbt.l("Paper.FrictionState");
            try {
                this.frictionState = TriState.valueOf((String)fs);
            }
            catch (Exception ignored) {
                LogUtils.getLogger().error("Unknown friction state " + fs + " for " + this);
            }
        }
        NBTTagCompound nbttagcompound1 = nbt.p("Item");
        this.a(ItemStack.a(nbttagcompound1));
        if (this.q().b()) {
            this.ak();
        }
    }

    @Override
    public void b_(EntityHuman player) {
        if (!this.dL().B) {
            ItemStack itemstack = this.q();
            Item item = itemstack.d();
            int i2 = itemstack.L();
            int canHold = player.fR().canHold(itemstack);
            int remaining = i2 - canHold;
            boolean flyAtPlayer = false;
            if (this.h <= 0) {
                PlayerAttemptPickupItemEvent attemptEvent = new PlayerAttemptPickupItemEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                this.dL().getCraftServer().getPluginManager().callEvent((Event)attemptEvent);
                flyAtPlayer = attemptEvent.getFlyAtPlayer();
                if (attemptEvent.isCancelled()) {
                    if (flyAtPlayer) {
                        player.a((Entity)this, i2);
                    }
                    return;
                }
            }
            if (this.h <= 0 && canHold > 0) {
                EntityPickupItemEvent entityEvent;
                itemstack.f(canHold);
                PlayerPickupItemEvent playerEvent = new PlayerPickupItemEvent((Player)player.getBukkitEntity(), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining);
                playerEvent.setCancelled(!playerEvent.getPlayer().getCanPickupItems());
                this.dL().getCraftServer().getPluginManager().callEvent((Event)playerEvent);
                flyAtPlayer = playerEvent.getFlyAtPlayer();
                if (playerEvent.isCancelled()) {
                    itemstack.f(i2);
                    if (flyAtPlayer) {
                        player.a((Entity)this, i2);
                    }
                    return;
                }
                entityEvent.setCancelled(!(entityEvent = new EntityPickupItemEvent((LivingEntity)((Player)player.getBukkitEntity()), (org.bukkit.entity.Item)this.getBukkitEntity(), remaining)).getEntity().getCanPickupItems());
                this.dL().getCraftServer().getPluginManager().callEvent((Event)entityEvent);
                if (entityEvent.isCancelled()) {
                    itemstack.f(i2);
                    return;
                }
                ItemStack current = this.q();
                if (!itemstack.equals(current)) {
                    itemstack = current;
                } else {
                    itemstack.f(canHold + remaining);
                }
                this.h = 0;
            } else if (this.h == 0) {
                this.h = -1;
            }
            if (this.h == 0 && (this.k == null || this.k.equals(player.cv())) && player.fR().e(itemstack)) {
                if (flyAtPlayer) {
                    player.a((Entity)this, i2);
                }
                if (itemstack.b()) {
                    this.ak();
                    itemstack.f(i2);
                }
                player.a(StatisticList.e.b(item), i2);
                player.a(this);
            }
        }
    }

    @Override
    public IChatBaseComponent ab() {
        IChatBaseComponent ichatbasecomponent = this.ad();
        return ichatbasecomponent != null ? ichatbasecomponent : IChatBaseComponent.c(this.q().q());
    }

    @Override
    public boolean cp() {
        return false;
    }

    @Override
    @Nullable
    public Entity b(WorldServer destination) {
        Entity entity = super.b(destination);
        if (!this.dL().B && entity instanceof EntityItem) {
            ((EntityItem)entity).G();
        }
        return entity;
    }

    public ItemStack q() {
        return this.al().b(c);
    }

    public void a(ItemStack stack) {
        this.al().b(c, stack);
        this.despawnRate = this.dL().paperConfig().entities.spawning.altItemDespawnRate.enabled ? this.dL().paperConfig().entities.spawning.altItemDespawnRate.items.getOrDefault((Object)stack.d(), this.dL().spigotConfig.itemDespawnRate) : this.dL().spigotConfig.itemDespawnRate;
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (c.equals(data)) {
            this.q().a((Entity)this);
        }
    }

    public void b(@Nullable UUID owner) {
        this.k = owner;
    }

    public void c(@Nullable UUID thrower) {
        this.j = thrower;
    }

    public int s() {
        return this.g;
    }

    public void t() {
        this.h = 10;
    }

    public void w() {
        this.h = 0;
    }

    public void x() {
        this.h = Short.MAX_VALUE;
    }

    public void b(int pickupDelay) {
        this.h = pickupDelay;
    }

    public boolean y() {
        return this.h > 0;
    }

    public void z() {
        this.g = Short.MIN_VALUE;
    }

    public void A() {
        this.g = -6000;
    }

    public void B() {
        this.x();
        this.g = this.despawnRate - 1;
    }

    public float a(float tickDelta) {
        return ((float)this.s() + tickDelta) / 20.0f + this.b;
    }

    public EntityItem C() {
        return new EntityItem(this);
    }

    @Override
    public SoundCategory da() {
        return SoundCategory.i;
    }

    @Override
    public float dC() {
        return 180.0f - this.a(0.5f) / ((float)Math.PI * 2) * 360.0f;
    }
}

