/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityFlying;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.joml.Vector3f;

public class EntityGhast
extends EntityFlying
implements IMonster {
    private static final DataWatcherObject<Boolean> b = DataWatcher.a(EntityGhast.class, DataWatcherRegistry.k);
    private int c = 1;

    public EntityGhast(EntityTypes<? extends EntityGhast> type, World world) {
        super((EntityTypes<? extends EntityFlying>)type, world);
        this.bJ = 5;
        this.bL = new ControllerGhast(this);
    }

    @Override
    protected void z() {
        this.bO.a(5, new PathfinderGoalGhastIdleMove(this));
        this.bO.a(7, new PathfinderGoalGhastMoveTowardsTarget(this));
        this.bO.a(7, new PathfinderGoalGhastAttackTarget(this));
        this.bP.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, entityliving -> Math.abs(entityliving.ds() - this.ds()) <= 4.0));
    }

    public boolean s() {
        return this.an.b(b);
    }

    public void w(boolean shooting) {
        this.an.b(b, shooting);
    }

    public int t() {
        return this.c;
    }

    public void setExplosionPower(int explosionPower) {
        this.c = explosionPower;
    }

    @Override
    protected boolean V() {
        return true;
    }

    private static boolean h(DamageSource damageSource) {
        return damageSource.c() instanceof EntityLargeFireball && damageSource.d() instanceof EntityHuman;
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return !EntityGhast.h(damageSource) && super.b(damageSource);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (EntityGhast.h(source)) {
            super.a(source, 1000.0f);
            return true;
        }
        return this.b(source) ? false : super.a(source, amount);
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(b, false);
    }

    public static AttributeProvider.Builder y() {
        return EntityInsentient.A().a(GenericAttributes.a, 10.0).a(GenericAttributes.b, 100.0);
    }

    @Override
    public SoundCategory da() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect w() {
        return SoundEffects.jd;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.jf;
    }

    @Override
    public SoundEffect l_() {
        return SoundEffects.je;
    }

    @Override
    public float eV() {
        return 5.0f;
    }

    public static boolean b(EntityTypes<EntityGhast> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.ai() != EnumDifficulty.a && random.a(20) == 0 && EntityGhast.a(type, world, spawnReason, pos, random);
    }

    @Override
    public int fH() {
        return 1;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + 0.0625f * scaleFactor, 0.0f);
    }

    @Override
    protected float l(Entity vehicle) {
        return 0.5f;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("ExplosionPower", (byte)this.c);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("ExplosionPower", 99)) {
            this.c = nbt.f("ExplosionPower");
        }
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 2.6f;
    }

    private static class ControllerGhast
    extends ControllerMove {
        private final EntityGhast l;
        private int m;

        public ControllerGhast(EntityGhast ghast) {
            super(ghast);
            this.l = ghast;
        }

        @Override
        public void a() {
            if (this.k == ControllerMove.Operation.b && this.m-- <= 0) {
                this.m += this.l.ef().a(5) + 2;
                Vec3D vec3d = new Vec3D(this.e - this.l.dq(), this.f - this.l.ds(), this.g - this.l.dw());
                double d0 = vec3d.f();
                if (this.a(vec3d = vec3d.d(), MathHelper.c(d0))) {
                    this.l.f(this.l.do().e(vec3d.a(0.1)));
                } else {
                    this.k = ControllerMove.Operation.a;
                }
            }
        }

        private boolean a(Vec3D direction, int steps) {
            AxisAlignedBB axisalignedbb = this.l.cG();
            for (int j2 = 1; j2 < steps; ++j2) {
                axisalignedbb = axisalignedbb.c(direction);
                if (this.l.dL().a((Entity)this.l, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }

    private static class PathfinderGoalGhastIdleMove
    extends PathfinderGoal {
        private final EntityGhast a;

        public PathfinderGoalGhastIdleMove(EntityGhast ghast) {
            this.a = ghast;
            this.a(EnumSet.of(PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            double d2;
            double d1;
            ControllerMove controllermove = this.a.I();
            if (!controllermove.b()) {
                return true;
            }
            double d0 = controllermove.d() - this.a.dq();
            double d3 = d0 * d0 + (d1 = controllermove.e() - this.a.ds()) * d1 + (d2 = controllermove.f() - this.a.dw()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        @Override
        public boolean b() {
            return false;
        }

        @Override
        public void c() {
            RandomSource randomsource = this.a.ef();
            double d0 = this.a.dq() + (double)((randomsource.i() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.a.ds() + (double)((randomsource.i() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.a.dw() + (double)((randomsource.i() * 2.0f - 1.0f) * 16.0f);
            this.a.I().a(d0, d1, d2, 1.0);
        }
    }

    private static class PathfinderGoalGhastMoveTowardsTarget
    extends PathfinderGoal {
        private final EntityGhast a;

        public PathfinderGoalGhastMoveTowardsTarget(EntityGhast ghast) {
            this.a = ghast;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            return true;
        }

        @Override
        public boolean Q_() {
            return true;
        }

        @Override
        public void e() {
            if (this.a.q() == null) {
                Vec3D vec3d = this.a.do();
                this.a.r(-((float)MathHelper.d(vec3d.c, vec3d.e)) * 57.295776f);
                this.a.aU = this.a.dB();
            } else {
                EntityLiving entityliving = this.a.q();
                double d0 = 64.0;
                if (entityliving.f((Entity)this.a) < 4096.0) {
                    double d1 = entityliving.dq() - this.a.dq();
                    double d2 = entityliving.dw() - this.a.dw();
                    this.a.r(-((float)MathHelper.d(d1, d2)) * 57.295776f);
                    this.a.aU = this.a.dB();
                }
            }
        }
    }

    private static class PathfinderGoalGhastAttackTarget
    extends PathfinderGoal {
        private final EntityGhast b;
        public int a;

        public PathfinderGoalGhastAttackTarget(EntityGhast ghast) {
            this.b = ghast;
        }

        @Override
        public boolean a() {
            return this.b.q() != null;
        }

        @Override
        public void c() {
            this.a = 0;
        }

        @Override
        public void d() {
            this.b.w(false);
        }

        @Override
        public boolean Q_() {
            return true;
        }

        @Override
        public void e() {
            EntityLiving entityliving = this.b.q();
            if (entityliving != null) {
                double d0 = 64.0;
                if (entityliving.f((Entity)this.b) < 4096.0 && this.b.E(entityliving)) {
                    World world = this.b.dL();
                    ++this.a;
                    if (this.a == 10 && !this.b.aS()) {
                        world.a((EntityHuman)null, 1015, this.b.dl(), 0);
                    }
                    if (this.a == 20) {
                        double d1 = 4.0;
                        Vec3D vec3d = this.b.f(1.0f);
                        double d2 = entityliving.dq() - (this.b.dq() + vec3d.c * 4.0);
                        double d3 = entityliving.e(0.5) - (0.5 + this.b.e(0.5));
                        double d4 = entityliving.dw() - (this.b.dw() + vec3d.e * 4.0);
                        if (!this.b.aS()) {
                            world.a((EntityHuman)null, 1016, this.b.dl(), 0);
                        }
                        EntityLargeFireball entitylargefireball = new EntityLargeFireball(world, (EntityLiving)this.b, d2, d3, d4, this.b.t());
                        entitylargefireball.e = this.b.t();
                        entitylargefireball.bukkitYield = entitylargefireball.e;
                        entitylargefireball.e(this.b.dq() + vec3d.c * 4.0, this.b.e(0.5) + 0.5, entitylargefireball.dw() + vec3d.e * 4.0);
                        world.b(entitylargefireball);
                        this.a = -40;
                    }
                } else if (this.a > 0) {
                    --this.a;
                }
                this.b.w(this.a > 10);
            }
        }
    }
}

