/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.dimension.DimensionManager;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftMonster;

public abstract class EntityMonster
extends EntityCreature
implements IMonster {
    public CraftMonster getBukkitMonster() {
        return (CraftMonster)super.getBukkitEntity();
    }

    protected EntityMonster(EntityTypes<? extends EntityMonster> type, World world) {
        super((EntityTypes<? extends EntityCreature>)type, world);
        this.bJ = 5;
    }

    @Override
    public SoundCategory da() {
        return SoundCategory.f;
    }

    @Override
    public void b_() {
        this.eP();
        this.gi();
        super.b_();
    }

    protected void gi() {
        float f2 = this.bm();
        if (f2 > 0.5f) {
            this.bb += 2;
        }
    }

    @Override
    protected boolean V() {
        return true;
    }

    @Override
    protected SoundEffect aL() {
        return SoundEffects.lw;
    }

    @Override
    protected SoundEffect aM() {
        return SoundEffects.lv;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.lt;
    }

    @Override
    public SoundEffect l_() {
        return SoundEffects.ls;
    }

    @Override
    public EntityLiving.a eF() {
        return new EntityLiving.a(SoundEffects.lu, SoundEffects.lr);
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return -world.v(pos);
    }

    public static boolean a(WorldAccess world, BlockPosition pos, RandomSource random) {
        if (world.a(EnumSkyBlock.a, pos) > random.a(32)) {
            return false;
        }
        DimensionManager dimensionType = world.C_();
        int i2 = world.C().paperConfig().entities.spawning.monsterSpawnMaxLightLevel.or(dimensionType.e());
        if (i2 < 15 && world.a(EnumSkyBlock.b, pos) > i2) {
            return false;
        }
        int j2 = world.C().Y() ? world.c(pos, 10) : world.z(pos);
        return j2 <= dimensionType.d().a(random);
    }

    public static boolean b(EntityTypes<? extends EntityMonster> type, WorldAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.ai() != EnumDifficulty.a && EntityMonster.a(world, pos, random) && EntityMonster.a(type, world, spawnReason, pos, random);
    }

    public static boolean c(EntityTypes<? extends EntityMonster> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return world.ai() != EnumDifficulty.a && EntityMonster.a(type, world, spawnReason, pos, random);
    }

    public static AttributeProvider.Builder gj() {
        return EntityInsentient.A().a(GenericAttributes.f);
    }

    @Override
    public boolean eb() {
        return true;
    }

    @Override
    protected boolean ec() {
        return true;
    }

    public boolean f(EntityHuman player) {
        return true;
    }

    @Override
    public ItemStack g(ItemStack stack) {
        if (stack.d() instanceof ItemProjectileWeapon) {
            Predicate<ItemStack> predicate = ((ItemProjectileWeapon)stack.d()).e();
            ItemStack itemStack = ItemProjectileWeapon.a(this, predicate);
            return itemStack.b() ? new ItemStack(Items.nH) : itemStack;
        }
        return ItemStack.b;
    }
}

