/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.EntityIllagerAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.joml.Vector3f;

public class EntityRavager
extends EntityRaider {
    private static final Predicate<Entity> e = entity -> entity.bv() && !(entity instanceof EntityRavager);
    private static final double bT = 0.3;
    private static final double bU = 0.35;
    private static final int bV = 8356754;
    private static final double bW = 0.5725490196078431;
    private static final double bX = 0.5137254901960784;
    private static final double bY = 0.4980392156862745;
    private static final int bZ = 10;
    public static final int b = 40;
    public int ca;
    public int cb;
    public int cc;

    public EntityRavager(EntityTypes<? extends EntityRavager> type, World world) {
        super((EntityTypes<? extends EntityRaider>)type, world);
        this.t(1.0f);
        this.bJ = 20;
        this.a(PathType.v, 0.0f);
    }

    @Override
    protected void z() {
        super.z();
        this.bO.a(0, new PathfinderGoalFloat(this));
        this.bO.a(4, new PathfinderGoalMeleeAttack(this, 1.0, true));
        this.bO.a(5, new PathfinderGoalRandomStrollLand(this, 0.4));
        this.bO.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.bO.a(10, new PathfinderGoalLookAtPlayer(this, EntityInsentient.class, 8.0f));
        this.bP.a(2, new PathfinderGoalHurtByTarget(this, EntityRaider.class).a(new Class[0]));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bP.a(4, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, true, entityliving -> !entityliving.m_()));
        this.bP.a(4, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    protected void R() {
        boolean flag = !(this.cN() instanceof EntityInsentient) || this.cN().ag().a(TagsEntity.b);
        boolean flag1 = !(this.cY() instanceof EntityBoat);
        this.bO.a(PathfinderGoal.Type.a, flag);
        this.bO.a(PathfinderGoal.Type.c, flag && flag1);
        this.bO.a(PathfinderGoal.Type.b, flag);
        this.bO.a(PathfinderGoal.Type.d, flag);
    }

    public static AttributeProvider.Builder s() {
        return EntityMonster.gj().a(GenericAttributes.a, 100.0).a(GenericAttributes.d, 0.3).a(GenericAttributes.c, 0.75).a(GenericAttributes.f, 12.0).a(GenericAttributes.g, 1.5).a(GenericAttributes.b, 32.0);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("AttackTick", this.ca);
        nbt.a("StunTick", this.cb);
        nbt.a("RoarTick", this.cc);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.ca = nbt.h("AttackTick");
        this.cb = nbt.h("StunTick");
        this.cc = nbt.h("RoarTick");
    }

    @Override
    public SoundEffect ac_() {
        return SoundEffects.ts;
    }

    @Override
    public int Z() {
        return 45;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + 0.0625f * scaleFactor, -0.0625f * scaleFactor);
    }

    @Override
    public void b_() {
        super.b_();
        if (this.bv()) {
            if (this.eX()) {
                this.a(GenericAttributes.d).a(0.0);
            } else {
                double d0 = this.q() != null ? 0.35 : 0.3;
                double d1 = this.a(GenericAttributes.d).b();
                this.a(GenericAttributes.d).a(MathHelper.d(0.1, d1, d0));
            }
            if (this.P && this.dL().X().b(GameRules.c)) {
                boolean flag = false;
                AxisAlignedBB axisalignedbb = this.cG().g(0.2);
                for (BlockPosition blockposition : BlockPosition.b(MathHelper.a(axisalignedbb.a), MathHelper.a(axisalignedbb.b), MathHelper.a(axisalignedbb.c), MathHelper.a(axisalignedbb.d), MathHelper.a(axisalignedbb.e), MathHelper.a(axisalignedbb.f))) {
                    IBlockData iblockdata = this.dL().a_(blockposition);
                    Block block = iblockdata.b();
                    if (!(block instanceof BlockLeaves) || !CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, iblockdata.u().g())) continue;
                    flag = this.dL().a(blockposition, true, this) || flag;
                }
                if (!flag && this.aA()) {
                    if (new EntityJumpEvent((LivingEntity)this.getBukkitLivingEntity()).callEvent()) {
                        this.fa();
                    } else {
                        this.r(false);
                    }
                }
            }
            if (this.cc > 0) {
                --this.cc;
                if (this.cc == 10) {
                    this.gp();
                }
            }
            if (this.ca > 0) {
                --this.ca;
            }
            if (this.cb > 0) {
                --this.cb;
                this.go();
                if (this.cb == 0) {
                    this.a(SoundEffects.tx, 1.0f, 1.0f);
                    this.cc = 20;
                }
            }
        }
    }

    private void go() {
        if (this.ag.a(6) == 0) {
            double d0 = this.dq() - (double)this.df() * Math.sin(this.aU * ((float)Math.PI / 180)) + (this.ag.j() * 0.6 - 0.3);
            double d1 = this.ds() + (double)this.dg() - 0.3;
            double d2 = this.dw() + (double)this.df() * Math.cos(this.aU * ((float)Math.PI / 180)) + (this.ag.j() * 0.6 - 0.3);
            this.dL().a(Particles.v, d0, d1, d2, 0.4980392156862745, 0.5137254901960784, 0.5725490196078431);
        }
    }

    @Override
    protected boolean eX() {
        return super.eX() || this.ca > 0 || this.cb > 0 || this.cc > 0;
    }

    @Override
    public boolean E(Entity entity) {
        return this.cb <= 0 && this.cc <= 0 ? super.E(entity) : false;
    }

    @Override
    protected void e(EntityLiving target) {
        if (this.cc == 0) {
            if (this.ag.j() < 0.5) {
                this.cb = 40;
                this.a(SoundEffects.tw, 1.0f, 1.0f);
                this.dL().a((Entity)this, (byte)39);
                target.g((Entity)this);
            } else {
                this.a((Entity)target);
            }
            target.T = true;
        }
    }

    private void gp() {
        if (this.bv()) {
            List<Entity> list = this.dL().a(EntityLiving.class, this.cG().g(4.0), e);
            for (EntityLiving entityLiving : list) {
                if (!(entityLiving instanceof EntityIllagerAbstract)) {
                    entityLiving.a(this.dM().b(this), 6.0f);
                }
                this.a((Entity)entityLiving);
            }
            Vec3D vec3d = this.cG().f();
            for (int i2 = 0; i2 < 40; ++i2) {
                double d0 = this.ag.k() * 0.2;
                double d1 = this.ag.k() * 0.2;
                double d2 = this.ag.k() * 0.2;
                this.dL().a(Particles.W, vec3d.c, vec3d.d, vec3d.e, d0, d1, d2);
            }
            this.a(GameEvent.u);
        }
    }

    private void a(Entity entity) {
        double d0 = entity.dq() - this.dq();
        double d1 = entity.dw() - this.dw();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        entity.push(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0, this);
    }

    @Override
    public void b(byte status) {
        if (status == 4) {
            this.ca = 10;
            this.a(SoundEffects.tr, 1.0f, 1.0f);
        } else if (status == 39) {
            this.cb = 40;
        }
        super.b(status);
    }

    public int t() {
        return this.ca;
    }

    public int gd() {
        return this.cb;
    }

    public int gn() {
        return this.cc;
    }

    @Override
    public boolean C(Entity target) {
        this.ca = 10;
        this.dL().a((Entity)this, (byte)4);
        this.a(SoundEffects.tr, 1.0f, 1.0f);
        return super.C(target);
    }

    @Override
    @Nullable
    protected SoundEffect w() {
        return SoundEffects.tq;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.tu;
    }

    @Override
    public SoundEffect l_() {
        return SoundEffects.tt;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.tv, 0.15f, 1.0f);
    }

    @Override
    public boolean a(IWorldReader world) {
        return !world.d(this.cG());
    }

    @Override
    public void a(int wave, boolean unused) {
    }

    @Override
    public boolean ge() {
        return false;
    }

    @Override
    protected AxisAlignedBB fW() {
        AxisAlignedBB axisalignedbb = super.fW();
        return axisalignedbb.f(0.05, 0.0, 0.05);
    }
}

