/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.SlimeChangeDirectionEvent;
import com.destroystokyo.paper.event.entity.SlimeSwimEvent;
import com.destroystokyo.paper.event.entity.SlimeTargetLivingEntityEvent;
import com.destroystokyo.paper.event.entity.SlimeWanderEvent;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.joml.Vector3f;

public class EntitySlime
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Integer> bT = DataWatcher.a(EntitySlime.class, DataWatcherRegistry.b);
    public static final int b = 1;
    public static final int c = 127;
    public float d;
    public float e;
    public float bS;
    private boolean bU;
    private boolean canWander = true;

    public EntitySlime(EntityTypes<? extends EntitySlime> type, World world) {
        super((EntityTypes<? extends EntityInsentient>)type, world);
        this.cC();
        this.bL = new ControllerMoveSlime(this);
    }

    @Override
    protected void z() {
        this.bO.a(1, new PathfinderGoalSlimeRandomJump(this));
        this.bO.a(2, new PathfinderGoalSlimeNearestPlayer(this));
        this.bO.a(3, new PathfinderGoalSlimeRandomDirection(this));
        this.bO.a(5, new PathfinderGoalSlimeIdle(this));
        this.bP.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, entityliving -> Math.abs(entityliving.ds() - this.ds()) <= 4.0));
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    public SoundCategory da() {
        return SoundCategory.f;
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(bT, 1);
    }

    @VisibleForTesting
    public void a(int size, boolean heal) {
        int j2 = MathHelper.a(size, 1, 127);
        this.an.b(bT, j2);
        this.ap();
        this.i_();
        this.a(GenericAttributes.a).a(j2 * j2);
        this.a(GenericAttributes.d).a(0.2f + 0.1f * (float)j2);
        this.a(GenericAttributes.f).a(j2);
        if (heal) {
            this.c(this.eL());
        }
        this.bJ = j2;
    }

    public int ge() {
        return this.an.b(bT);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("Paper.canWander", this.canWander);
        nbt.a("Size", this.ge() - 1);
        nbt.a("wasOnGround", this.bU);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        this.a(nbt.h("Size") + 1, false);
        super.a(nbt);
        if (nbt.e("Paper.canWander")) {
            this.canWander = nbt.q("Paper.canWander");
        }
        this.bU = nbt.q("wasOnGround");
    }

    public boolean gf() {
        return this.ge() <= 1;
    }

    protected ParticleParam t() {
        return Particles.Q;
    }

    @Override
    protected boolean V() {
        return this.ge() > 0;
    }

    @Override
    public void l() {
        this.e += (this.d - this.e) * 0.5f;
        this.bS = this.e;
        super.l();
        if (this.aA() && !this.bU) {
            int i2 = this.ge();
            for (int j2 = 0; j2 < i2 * 8; ++j2) {
                float f2 = this.ag.i() * ((float)Math.PI * 2);
                float f1 = this.ag.i() * 0.5f + 0.5f;
                float f22 = MathHelper.a(f2) * (float)i2 * 0.5f * f1;
                float f3 = MathHelper.b(f2) * (float)i2 * 0.5f * f1;
                this.dL().a(this.t(), this.dq() + (double)f22, this.ds(), this.dw() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.a(this.gc(), this.eV(), ((this.ag.i() - this.ag.i()) * 0.2f + 1.0f) / 0.8f);
            this.d = -0.5f;
        } else if (!this.aA() && this.bU) {
            this.d = 1.0f;
        }
        this.bU = this.aA();
        this.fZ();
    }

    protected void fZ() {
        this.d *= 0.6f;
    }

    protected int y() {
        return this.ag.a(20) + 10;
    }

    @Override
    public void i_() {
        double d0 = this.dq();
        double d1 = this.ds();
        double d2 = this.dw();
        super.i_();
        this.e(d0, d1, d2);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (bT.equals(data)) {
            this.i_();
            this.r(this.aW);
            this.aU = this.aW;
            if (this.aX() && this.ag.a(20) == 0) {
                this.bg();
            }
        }
        super.a(data);
    }

    public EntityTypes<? extends EntitySlime> ag() {
        return super.ag();
    }

    @Override
    public void a(Entity.RemovalReason reason) {
        int i2 = this.ge();
        if (!this.dL().B && i2 > 1 && this.ev()) {
            IChatBaseComponent ichatbasecomponent = this.ad();
            boolean flag = this.fT();
            float f2 = (float)i2 / 4.0f;
            int j2 = i2 / 2;
            int k2 = 2 + this.ag.a(3);
            SlimeSplitEvent event = new SlimeSplitEvent((Slime)this.getBukkitEntity(), k2);
            this.dL().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled() || event.getCount() <= 0) {
                super.a(reason);
                return;
            }
            k2 = event.getCount();
            ArrayList<EntityLiving> slimes = new ArrayList<EntityLiving>(j2);
            for (int l2 = 0; l2 < k2; ++l2) {
                float f1 = ((float)(l2 % 2) - 0.5f) * f2;
                float f22 = ((float)(l2 / 2) - 0.5f) * f2;
                EntitySlime entityslime = this.ag().a(this.dL());
                if (entityslime == null) continue;
                if (this.fK()) {
                    entityslime.fI();
                }
                entityslime.aware = this.aware;
                entityslime.b(ichatbasecomponent);
                entityslime.t(flag);
                entityslime.m(this.cq());
                entityslime.a(j2, true);
                entityslime.b(this.dq() + (double)f1, this.ds() + 0.5, this.dw() + (double)f22, this.ag.i() * 360.0f, 0.0f);
                slimes.add(entityslime);
            }
            if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, slimes, EntityTransformEvent.TransformReason.SPLIT).isCancelled()) {
                super.a(reason);
                return;
            }
            for (EntityLiving living : slimes) {
                this.dL().addFreshEntity(living, CreatureSpawnEvent.SpawnReason.SLIME_SPLIT);
            }
        }
        super.a(reason);
    }

    @Override
    public void g(Entity entity) {
        super.g(entity);
        if (entity instanceof EntityIronGolem && this.ga()) {
            this.j((EntityLiving)entity);
        }
    }

    @Override
    public void b_(EntityHuman player) {
        if (this.ga()) {
            this.j(player);
        }
    }

    protected void j(EntityLiving target) {
        if (this.bv()) {
            int i2 = this.ge();
            if (this.f((Entity)target) < 0.6 * (double)i2 * 0.6 * (double)i2 && this.E(target) && target.a(this.dM().b(this), this.gb())) {
                this.a(SoundEffects.vC, 1.0f, (this.ag.i() - this.ag.i()) * 0.2f + 1.0f);
                this.a((EntityLiving)this, (Entity)target);
            }
        }
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 0.625f * dimensions.b;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b - 0.015625f * (float)this.ge() * scaleFactor, 0.0f);
    }

    protected boolean ga() {
        return !this.gf() && this.cX();
    }

    protected float gb() {
        return (float)this.b(GenericAttributes.f);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return this.gf() ? SoundEffects.wt : SoundEffects.vE;
    }

    @Override
    public SoundEffect l_() {
        return this.gf() ? SoundEffects.ws : SoundEffects.vD;
    }

    protected SoundEffect gc() {
        return this.gf() ? SoundEffects.wv : SoundEffects.vG;
    }

    public static boolean c(EntityTypes<EntitySlime> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        if (world.ai() != EnumDifficulty.a) {
            if (spawnReason == EnumMobSpawn.c) {
                return random.a(10) == 0;
            }
            double maxHeightSwamp = world.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.surfaceBiome.maximum;
            double minHeightSwamp = world.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.surfaceBiome.minimum;
            if (world.s(pos).a(BiomeTags.ap) && (double)pos.v() > minHeightSwamp && (double)pos.v() < maxHeightSwamp && random.i() < 0.5f && random.i() < world.an() && world.z(pos) <= random.a(8)) {
                return EntitySlime.a(type, world, spawnReason, pos, random);
            }
            if (!(world instanceof GeneratorAccessSeed)) {
                return false;
            }
            ChunkCoordIntPair chunkcoordintpair = new ChunkCoordIntPair(pos);
            boolean flag = world.getMinecraftWorld().paperConfig().entities.spawning.allChunksAreSlimeChunks || SeededRandom.a(chunkcoordintpair.e, chunkcoordintpair.f, ((GeneratorAccessSeed)world).A(), world.getMinecraftWorld().spigotConfig.slimeSeed).a(10) == 0;
            double maxHeightSlimeChunk = world.getMinecraftWorld().paperConfig().entities.spawning.slimeSpawnHeight.slimeChunk.maximum;
            if (random.a(10) == 0 && flag && (double)pos.v() < maxHeightSlimeChunk) {
                return EntitySlime.a(type, world, spawnReason, pos, random);
            }
        }
        return false;
    }

    @Override
    public float eV() {
        return 0.4f * (float)this.ge();
    }

    @Override
    public int Y() {
        return 0;
    }

    protected boolean gg() {
        return this.ge() > 0;
    }

    @Override
    protected void fa() {
        Vec3D vec3d = this.do();
        this.o(vec3d.c, this.eY(), vec3d.e);
        this.au = true;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomsource = world.D_();
        int i2 = randomsource.a(3);
        if (i2 < 2 && randomsource.i() < 0.5f * difficulty.d()) {
            ++i2;
        }
        int j2 = 1 << i2;
        this.a(j2, true);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    float s() {
        float f2 = this.gf() ? 1.4f : 0.8f;
        return ((this.ag.i() - this.ag.i()) * 0.2f + 1.0f) * f2;
    }

    protected SoundEffect gd() {
        return this.gf() ? SoundEffects.wu : SoundEffects.vF;
    }

    @Override
    public EntitySize a(EntityPose pose) {
        return super.a(pose).a(0.255f * (float)this.ge());
    }

    public boolean canWander() {
        return this.canWander;
    }

    public void setWander(boolean canWander) {
        this.canWander = canWander;
    }

    private static class ControllerMoveSlime
    extends ControllerMove {
        private float l;
        private int m;
        private final EntitySlime n;
        private boolean o;

        public ControllerMoveSlime(EntitySlime slime) {
            super(slime);
            this.n = slime;
            this.l = 180.0f * slime.dB() / (float)Math.PI;
        }

        public void a(float targetYaw, boolean jumpOften) {
            this.l = targetYaw;
            this.o = jumpOften;
        }

        public void a(double speed) {
            this.h = speed;
            this.k = ControllerMove.Operation.b;
        }

        @Override
        public void a() {
            this.d.r(this.a(this.d.dB(), this.l, 90.0f));
            this.d.aW = this.d.dB();
            this.d.aU = this.d.dB();
            if (this.k != ControllerMove.Operation.b) {
                this.d.A(0.0f);
            } else {
                this.k = ControllerMove.Operation.a;
                if (this.d.aA()) {
                    this.d.w((float)(this.h * this.d.b(GenericAttributes.d)));
                    if (this.m-- <= 0) {
                        this.m = this.n.y();
                        if (this.o) {
                            this.m /= 3;
                        }
                        this.n.K().a();
                        if (this.n.gg()) {
                            this.n.a(this.n.gd(), this.n.eV(), this.n.s());
                        }
                    } else {
                        this.n.bk = 0.0f;
                        this.n.bm = 0.0f;
                        this.d.w(0.0f);
                    }
                } else {
                    this.d.w((float)(this.h * this.d.b(GenericAttributes.d)));
                }
            }
        }
    }

    private static class PathfinderGoalSlimeRandomJump
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeRandomJump(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
            slime.L().a(true);
        }

        @Override
        public boolean a() {
            return (this.a.aX() || this.a.bl()) && this.a.I() instanceof ControllerMoveSlime && this.a.canWander && new SlimeSwimEvent((Slime)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean Q_() {
            return true;
        }

        @Override
        public void e() {
            ControllerMove controllermove;
            if (this.a.ef().i() < 0.8f) {
                this.a.K().a();
            }
            if ((controllermove = this.a.I()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.2);
            }
        }
    }

    private static class PathfinderGoalSlimeNearestPlayer
    extends PathfinderGoal {
        private final EntitySlime a;
        private int b;

        public PathfinderGoalSlimeNearestPlayer(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            EntityLiving entityliving = this.a.q();
            if (entityliving == null || !entityliving.bv()) {
                return false;
            }
            if (!this.a.c(entityliving)) {
                return false;
            }
            return this.a.I() instanceof ControllerMoveSlime && this.a.canWander && new SlimeTargetLivingEntityEvent((Slime)this.a.getBukkitEntity(), (LivingEntity)entityliving.getBukkitEntity()).callEvent();
        }

        @Override
        public void c() {
            this.b = PathfinderGoalSlimeNearestPlayer.b(300);
            super.c();
        }

        @Override
        public boolean b() {
            EntityLiving entityliving = this.a.q();
            if (entityliving == null || !entityliving.bv()) {
                return false;
            }
            if (!this.a.c(entityliving)) {
                return false;
            }
            return --this.b > 0 && this.a.canWander && new SlimeTargetLivingEntityEvent((Slime)this.a.getBukkitEntity(), (LivingEntity)entityliving.getBukkitEntity()).callEvent();
        }

        @Override
        public boolean Q_() {
            return true;
        }

        @Override
        public void e() {
            ControllerMove controllermove;
            EntityLiving entityliving = this.a.q();
            if (entityliving != null) {
                this.a.a((Entity)entityliving, 10.0f, 10.0f);
            }
            if ((controllermove = this.a.I()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.a.dB(), this.a.ga());
            }
        }

        @Override
        public void d() {
            this.b = 0;
            this.a.h((EntityLiving)null);
        }
    }

    private static class PathfinderGoalSlimeRandomDirection
    extends PathfinderGoal {
        private final EntitySlime a;
        private float b;
        private int c;

        public PathfinderGoalSlimeRandomDirection(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.b));
        }

        @Override
        public boolean a() {
            return this.a.q() == null && (this.a.aA() || this.a.aX() || this.a.bl() || this.a.a(MobEffects.y)) && this.a.I() instanceof ControllerMoveSlime && this.a.canWander;
        }

        @Override
        public void e() {
            ControllerMove controllermove;
            if (--this.c <= 0) {
                this.c = this.a(40 + this.a.ef().a(60));
                this.b = this.a.ef().a(360);
                SlimeChangeDirectionEvent event = new SlimeChangeDirectionEvent((Slime)this.a.getBukkitEntity(), this.b);
                if (!this.a.canWander || !event.callEvent()) {
                    return;
                }
                this.b = event.getNewYaw();
            }
            if ((controllermove = this.a.I()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(this.b, false);
            }
        }
    }

    private static class PathfinderGoalSlimeIdle
    extends PathfinderGoal {
        private final EntitySlime a;

        public PathfinderGoalSlimeIdle(EntitySlime slime) {
            this.a = slime;
            this.a(EnumSet.of(PathfinderGoal.Type.c, PathfinderGoal.Type.a));
        }

        @Override
        public boolean a() {
            return !this.a.bN() && this.a.canWander && new SlimeWanderEvent((Slime)this.a.getBukkitEntity()).callEvent();
        }

        @Override
        public void e() {
            ControllerMove controllermove = this.a.I();
            if (controllermove instanceof ControllerMoveSlime) {
                ControllerMoveSlime entityslime_controllermoveslime = (ControllerMoveSlime)controllermove;
                entityslime_controllermoveslime.a(1.0);
            }
        }
    }
}

