/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.destroystokyo.paper.event.entity.WitchConsumePotionEvent;
import com.destroystokyo.paper.event.entity.WitchReadyPotionEvent;
import com.destroystokyo.paper.event.entity.WitchThrowPotionEvent;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalArrowAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTargetWitch;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestHealableRaider;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Witch;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.inventory.ItemStack;
import org.joml.Vector3f;

public class EntityWitch
extends EntityRaider
implements IRangedEntity {
    private static final UUID b = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier e = new AttributeModifier(b, "Drinking speed penalty", -0.25, AttributeModifier.Operation.a);
    private static final DataWatcherObject<Boolean> bT = DataWatcher.a(EntityWitch.class, DataWatcherRegistry.k);
    public int bU;
    private PathfinderGoalNearestHealableRaider<EntityRaider> bV;
    private PathfinderGoalNearestAttackableTargetWitch<EntityHuman> bW;

    public EntityWitch(EntityTypes<? extends EntityWitch> type, World world) {
        super((EntityTypes<? extends EntityRaider>)type, world);
    }

    @Override
    protected void z() {
        super.z();
        this.bV = new PathfinderGoalNearestHealableRaider<EntityRaider>(this, EntityRaider.class, true, entityliving -> entityliving != null && this.gs() && entityliving.ag() != EntityTypes.bj);
        this.bW = new PathfinderGoalNearestAttackableTargetWitch<EntityHuman>(this, EntityHuman.class, 10, true, false, (Predicate<EntityLiving>)null);
        this.bO.a(1, new PathfinderGoalFloat(this));
        this.bO.a(2, new PathfinderGoalArrowAttack(this, 1.0, 60, 10.0f));
        this.bO.a(2, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bO.a(3, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(3, new PathfinderGoalRandomLookaround(this));
        this.bP.a(1, new PathfinderGoalHurtByTarget(this, EntityRaider.class));
        this.bP.a(2, this.bV);
        this.bP.a(3, this.bW);
    }

    @Override
    protected void a_() {
        super.a_();
        this.al().a(bT, false);
    }

    @Override
    protected SoundEffect w() {
        return SoundEffects.Ad;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.Ah;
    }

    @Override
    public SoundEffect l_() {
        return SoundEffects.Af;
    }

    public void y(boolean drinking) {
        this.al().b(bT, drinking);
    }

    public boolean s() {
        return this.al().b(bT);
    }

    public static AttributeProvider.Builder t() {
        return EntityMonster.gj().a(GenericAttributes.a, 26.0).a(GenericAttributes.d, 0.25);
    }

    @Override
    public void b_() {
        if (!this.dL().B && this.bv()) {
            this.bV.k();
            if (this.bV.i() <= 0) {
                this.bW.a(true);
            } else {
                this.bW.a(false);
            }
            if (this.s()) {
                if (this.bU-- <= 0) {
                    this.y(false);
                    net.minecraft.world.item.ItemStack itemstack = this.eS();
                    this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.b);
                    if (itemstack.a(Items.rv)) {
                        List<MobEffect> list;
                        WitchConsumePotionEvent event = new WitchConsumePotionEvent((Witch)this.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(itemstack));
                        List<MobEffect> list2 = list = event.callEvent() ? PotionUtil.a(CraftItemStack.asNMSCopy(event.getPotion())) : null;
                        if (list != null) {
                            for (MobEffect mobeffect : list) {
                                this.addEffect(new MobEffect(mobeffect), EntityPotionEffectEvent.Cause.ATTACK);
                            }
                        }
                    }
                    this.a(GameEvent.l);
                    this.a(GenericAttributes.d).b(e.a());
                }
            } else {
                PotionRegistry potionregistry = null;
                if (this.ag.i() < 0.15f && ((Entity)this).a(TagsFluid.a) && !this.a(MobEffects.m)) {
                    potionregistry = Potions.y;
                } else if (this.ag.i() < 0.15f && (this.bM() || this.ew() != null && this.ew().a(DamageTypeTags.i)) && !this.a(MobEffects.l)) {
                    potionregistry = Potions.n;
                } else if (this.ag.i() < 0.05f && this.eu() < this.eL()) {
                    potionregistry = Potions.A;
                } else if (this.ag.i() < 0.5f && this.q() != null && !this.a(MobEffects.a) && this.q().f((Entity)this) > 121.0) {
                    potionregistry = Potions.p;
                }
                if (potionregistry != null) {
                    net.minecraft.world.item.ItemStack potion = PotionUtil.a(new net.minecraft.world.item.ItemStack(Items.rv), potionregistry);
                    this.setDrinkingPotion(potion);
                }
            }
            if (this.ag.i() < 7.5E-4f) {
                this.dL().a((Entity)this, (byte)15);
            }
        }
        super.b_();
    }

    public void setDrinkingPotion(net.minecraft.world.item.ItemStack potion) {
        ItemStack bukkitStack = WitchReadyPotionEvent.process((Witch)((Witch)this.getBukkitEntity()), (ItemStack)CraftItemStack.asCraftMirror(potion));
        this.a(EnumItemSlot.a, CraftItemStack.asNMSCopy(bukkitStack));
        this.bU = this.eS().r();
        this.y(true);
        if (!this.aS()) {
            this.dL().a((EntityHuman)null, this.dq(), this.ds(), this.dw(), SoundEffects.Ag, this.da(), 1.0f, 0.8f + this.ag.i() * 0.4f);
        }
        AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
        attributemodifiable.b(e.a());
        attributemodifiable.b(e);
    }

    @Override
    public SoundEffect ac_() {
        return SoundEffects.Ae;
    }

    @Override
    public void b(byte status) {
        if (status == 15) {
            for (int i2 = 0; i2 < this.ag.a(35) + 10; ++i2) {
                this.dL().a(Particles.ah, this.dq() + this.ag.k() * (double)0.13f, this.cG().e + 0.5 + this.ag.k() * (double)0.13f, this.dw() + this.ag.k() * (double)0.13f, 0.0, 0.0, 0.0);
            }
        } else {
            super.b(status);
        }
    }

    @Override
    protected float e(DamageSource source, float amount) {
        amount = super.e(source, amount);
        if (source.d() == this) {
            amount = 0.0f;
        }
        if (source.a(DamageTypeTags.k)) {
            amount *= 0.15f;
        }
        return amount;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        if (!this.s()) {
            Vec3D vec3d = target.do();
            double d0 = target.dq() + vec3d.c - this.dq();
            double d1 = target.du() - (double)1.1f - this.ds();
            double d2 = target.dw() + vec3d.e - this.dw();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            PotionRegistry potionregistry = Potions.C;
            if (target instanceof EntityRaider) {
                potionregistry = target.eu() <= 4.0f ? Potions.A : Potions.H;
                this.h((EntityLiving)null);
            } else if (d3 >= 8.0 && !target.a(MobEffects.b)) {
                potionregistry = Potions.s;
            } else if (target.eu() >= 8.0f && !target.a(MobEffects.s)) {
                potionregistry = Potions.E;
            } else if (d3 <= 3.0 && !target.a(MobEffects.r) && this.ag.i() < 0.25f) {
                potionregistry = Potions.N;
            }
            net.minecraft.world.item.ItemStack potion = PotionUtil.a(new net.minecraft.world.item.ItemStack(Items.uu), potionregistry);
            WitchThrowPotionEvent event = new WitchThrowPotionEvent((Witch)this.getBukkitEntity(), (LivingEntity)target.getBukkitEntity(), (ItemStack)CraftItemStack.asCraftMirror(potion));
            if (!event.callEvent()) {
                return;
            }
            potion = CraftItemStack.asNMSCopy(event.getPotion());
            EntityPotion entitypotion = new EntityPotion(this.dL(), this);
            entitypotion.a(potion);
            entitypotion.s(entitypotion.dD() - -20.0f);
            entitypotion.c(d0, d1 + d3 * 0.2, d2, 0.75f, 8.0f);
            if (!this.aS()) {
                this.dL().a((EntityHuman)null, this.dq(), this.ds(), this.dw(), SoundEffects.Ai, this.da(), 1.0f, 0.8f + this.ag.i() * 0.4f);
            }
            this.dL().b(entitypotion);
        }
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return 1.62f;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + 0.3125f * scaleFactor, 0.0f);
    }

    @Override
    public void a(int wave, boolean unused) {
    }

    @Override
    public boolean ge() {
        return false;
    }
}

