/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.base.Predicates;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreakDoor;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMoveThroughVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRemoveBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalZombieAttack;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.joml.Vector3f;

public class EntityZombie
extends EntityMonster {
    private static final UUID b = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier c = new AttributeModifier(b, "Baby speed boost", 0.5, AttributeModifier.Operation.b);
    private final AttributeModifier babyModifier;
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> bX = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.b);
    public static final DataWatcherObject<Boolean> bY = DataWatcher.a(EntityZombie.class, DataWatcherRegistry.k);
    public static final float e = 0.05f;
    public static final int bT = 50;
    public static final int bU = 40;
    public static final int bV = 7;
    protected static final float bW = 0.81f;
    private static final float bZ = 0.1f;
    public static final Predicate<EnumDifficulty> ca = enumdifficulty -> enumdifficulty == EnumDifficulty.d;
    private final PathfinderGoalBreakDoor cb;
    private boolean cc;
    private int cd;
    public int ce;
    private int lastTick;
    private boolean shouldBurnInDay;

    public EntityZombie(EntityTypes<? extends EntityZombie> type, World world) {
        super((EntityTypes<? extends EntityMonster>)type, world);
        this.babyModifier = new AttributeModifier(c.a(), c.b(), this.dL().paperConfig().entities.behavior.babyZombieMovementModifier, c.c());
        this.lastTick = MinecraftServer.currentTick;
        this.shouldBurnInDay = true;
        this.cb = new PathfinderGoalBreakDoor(this, (Predicate<EnumDifficulty>)Predicates.in((Collection)world.paperConfig().entities.behavior.doorBreakingDifficulty.getOrDefault(type, world.paperConfig().entities.behavior.doorBreakingDifficulty.get(EntityTypes.bp))));
    }

    public EntityZombie(World world) {
        this((EntityTypes<? extends EntityZombie>)EntityTypes.bp, world);
    }

    @Override
    protected void z() {
        if (this.dL().paperConfig().entities.behavior.zombiesTargetTurtleEggs) {
            this.bO.a(4, new a((EntityCreature)this, 1.0, 3));
        }
        this.bO.a(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bO.a(8, new PathfinderGoalRandomLookaround(this));
        this.s();
    }

    protected void s() {
        this.bO.a(2, new PathfinderGoalZombieAttack(this, 1.0, false));
        this.bO.a(6, new PathfinderGoalMoveThroughVillage(this, 1.0, true, 4, this::gl));
        this.bO.a(7, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bP.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]).a(EntityPigZombie.class));
        this.bP.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        if (this.dL().spigotConfig.zombieAggressiveTowardsVillager) {
            this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityVillagerAbstract>((EntityInsentient)this, EntityVillagerAbstract.class, false));
        }
        this.bP.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.bP.a(5, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.bU));
    }

    public static AttributeProvider.Builder gh() {
        return EntityMonster.gj().a(GenericAttributes.b, 35.0).a(GenericAttributes.d, 0.23f).a(GenericAttributes.f, 3.0).a(GenericAttributes.i, 2.0).a(GenericAttributes.m);
    }

    @Override
    protected void a_() {
        super.a_();
        this.al().a(d, false);
        this.al().a(bX, 0);
        this.al().a(bY, false);
    }

    public boolean gk() {
        return this.al().b(bY);
    }

    public boolean gl() {
        return this.cc;
    }

    public void x(boolean canBreakDoors) {
        if (this.t() && PathfinderGoalUtil.a(this)) {
            if (this.cc != canBreakDoors) {
                this.cc = canBreakDoors;
                ((Navigation)this.L()).b(canBreakDoors);
                if (canBreakDoors) {
                    this.bO.a(1, this.cb);
                } else {
                    this.bO.a(this.cb);
                }
            }
        } else if (this.cc) {
            this.bO.a(this.cb);
            this.cc = false;
        }
    }

    public boolean t() {
        return true;
    }

    @Override
    public boolean m_() {
        return this.al().b(d);
    }

    @Override
    public int ed() {
        int previousReward = this.bJ;
        if (this.m_()) {
            this.bJ = (int)((double)this.bJ * 2.5);
        }
        int reward = super.ed();
        this.bJ = previousReward;
        return reward;
    }

    @Override
    public void a(boolean baby) {
        this.al().b(d, baby);
        if (this.dL() != null && !this.dL().B) {
            AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
            attributemodifiable.b(this.babyModifier.a());
            if (baby) {
                attributemodifiable.b(this.babyModifier);
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (d.equals(data)) {
            this.i_();
        }
        super.a(data);
    }

    protected boolean ge() {
        return true;
    }

    @Override
    public void l() {
        if (!this.dL().B && this.bv() && !this.fT()) {
            if (this.gk()) {
                int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
                this.ce -= elapsedTicks;
                if (this.ce < 0) {
                    this.gg();
                }
            } else if (this.ge()) {
                if (((Entity)this).a(TagsFluid.a)) {
                    ++this.cd;
                    if (this.cd >= 600) {
                        this.b(300);
                    }
                } else {
                    this.cd = -1;
                }
            }
        }
        super.l();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public void b_() {
        if (this.bv()) {
            boolean flag;
            boolean bl = flag = this.ab_() && this.fX();
            if (flag) {
                ItemStack itemstack = this.c(EnumItemSlot.f);
                if (!itemstack.b()) {
                    if (itemstack.i()) {
                        itemstack.b(itemstack.k() + this.ag.a(2));
                        if (itemstack.k() >= itemstack.l()) {
                            this.d(EnumItemSlot.f);
                            this.a(EnumItemSlot.f, ItemStack.b);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.g(8);
                }
            }
        }
        super.b_();
    }

    public void stopDrowning() {
        this.ce = -1;
        this.al().b(bY, false);
    }

    public void b(int ticksUntilWaterConversion) {
        this.lastTick = MinecraftServer.currentTick;
        this.ce = ticksUntilWaterConversion;
        this.al().b(bY, true);
    }

    protected void gg() {
        this.b(EntityTypes.y);
        if (!this.aS()) {
            this.dL().a((EntityHuman)null, 1040, this.dl(), 0);
        }
    }

    protected void b(EntityTypes<? extends EntityZombie> entityType) {
        EntityZombie entityzombie = this.convertTo(entityType, true, EntityTransformEvent.TransformReason.DROWNED, CreatureSpawnEvent.SpawnReason.DROWNED);
        if (entityzombie != null) {
            entityzombie.E(entityzombie.dL().d_(entityzombie.dl()).d());
            entityzombie.x(entityzombie.t() && this.gl());
        } else {
            ((Zombie)this.getBukkitEntity()).setConversionTime(-1);
        }
    }

    public boolean ab_() {
        return this.shouldBurnInDay;
    }

    public void setShouldBurnInDay(boolean shouldBurnInDay) {
        this.shouldBurnInDay = shouldBurnInDay;
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        if (!super.a(source, amount)) {
            return false;
        }
        if (!(this.dL() instanceof WorldServer)) {
            return false;
        }
        WorldServer worldserver = (WorldServer)this.dL();
        EntityLiving entityliving = this.q();
        if (entityliving == null && source.d() instanceof EntityLiving) {
            entityliving = (EntityLiving)source.d();
        }
        if (entityliving != null && this.dL().ai() == EnumDifficulty.d && (double)this.ag.i() < this.b(GenericAttributes.m) && this.dL().X().b(GameRules.e)) {
            int i2 = MathHelper.a(this.dq());
            int j2 = MathHelper.a(this.ds());
            int k2 = MathHelper.a(this.dw());
            EntityZombie entityzombie = new EntityZombie(this.dL());
            for (int l2 = 0; l2 < 50; ++l2) {
                int i1 = i2 + MathHelper.a(this.ag, 7, 40) * MathHelper.a(this.ag, -1, 1);
                int j1 = j2 + MathHelper.a(this.ag, 7, 40) * MathHelper.a(this.ag, -1, 1);
                int k1 = k2 + MathHelper.a(this.ag, 7, 40) * MathHelper.a(this.ag, -1, 1);
                BlockPosition blockposition = new BlockPosition(i1, j1, k1);
                EntityTypes<?> entitytypes = entityzombie.ag();
                EntityPositionTypes.Surface entitypositiontypes_surface = EntityPositionTypes.a(entitytypes);
                if (!SpawnerCreature.a(entitypositiontypes_surface, this.dL(), blockposition, entitytypes) || !EntityPositionTypes.a(entitytypes, worldserver, EnumMobSpawn.j, blockposition, this.dL().z)) continue;
                entityzombie.e(i1, j1, k1);
                if (this.dL().hasNearbyAlivePlayerThatAffectsSpawning(i1, j1, k1, 7.0) || !this.dL().f(entityzombie) || !this.dL().g(entityzombie) || this.dL().d(entityzombie.cG())) continue;
                entityzombie.setTarget(entityliving, EntityTargetEvent.TargetReason.REINFORCEMENT_TARGET, true);
                entityzombie.a(worldserver, this.dL().d_(entityzombie.dl()), EnumMobSpawn.j, (GroupDataEntity)null, null);
                worldserver.addFreshEntityWithPassengers(entityzombie, CreatureSpawnEvent.SpawnReason.REINFORCEMENTS);
                this.a(GenericAttributes.m).c(new AttributeModifier("Zombie reinforcement caller charge", -0.05f, AttributeModifier.Operation.a));
                entityzombie.a(GenericAttributes.m).c(new AttributeModifier("Zombie reinforcement callee charge", -0.05f, AttributeModifier.Operation.a));
                break;
            }
        }
        return true;
    }

    @Override
    public boolean C(Entity target) {
        boolean flag = super.C(target);
        if (flag) {
            float f2 = this.dL().d_(this.dl()).b();
            if (this.eS().b() && this.bM() && this.ag.i() < f2 * 0.3f) {
                EntityCombustByEntityEvent event = new EntityCombustByEntityEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (org.bukkit.entity.Entity)target.getBukkitEntity(), 2 * (int)f2);
                this.dL().getCraftServer().getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    target.setSecondsOnFire(event.getDuration(), false);
                }
            }
        }
        return flag;
    }

    @Override
    protected SoundEffect w() {
        return SoundEffects.Ba;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.Bk;
    }

    @Override
    public SoundEffect l_() {
        return SoundEffects.Bf;
    }

    protected SoundEffect y() {
        return SoundEffects.Bq;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(this.y(), 0.15f, 1.0f);
    }

    @Override
    public EnumMonsterType eR() {
        return EnumMonsterType.b;
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        super.a(random, localDifficulty);
        float f2 = random.i();
        float f3 = this.dL().ai() == EnumDifficulty.d ? 0.05f : 0.01f;
        if (f2 < f3) {
            int i2 = random.a(3);
            if (i2 == 0) {
                this.a(EnumItemSlot.a, new ItemStack(Items.om));
            } else {
                this.a(EnumItemSlot.a, new ItemStack(Items.on));
            }
        }
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        nbt.a("IsBaby", this.m_());
        nbt.a("CanBreakDoors", this.gl());
        nbt.a("InWaterTime", this.aX() ? this.cd : -1);
        nbt.a("DrownedConversionTime", this.gk() ? this.ce : -1);
        nbt.a("Paper.ShouldBurnInDay", this.shouldBurnInDay);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(nbt.q("IsBaby"));
        this.x(nbt.q("CanBreakDoors"));
        this.cd = nbt.h("InWaterTime");
        if (nbt.b("DrownedConversionTime", 99) && nbt.h("DrownedConversionTime") > -1) {
            this.b(nbt.h("DrownedConversionTime"));
        }
        if (nbt.e("Paper.ShouldBurnInDay")) {
            this.shouldBurnInDay = nbt.q("Paper.ShouldBurnInDay");
        }
    }

    @Override
    public boolean a(WorldServer world, EntityLiving other) {
        double fallbackChance;
        boolean flag = super.a(world, other);
        double d2 = world.ai() == EnumDifficulty.d ? 100.0 : (fallbackChance = world.ai() == EnumDifficulty.c ? 50.0 : 0.0);
        if (this.ag.j() * 100.0 < world.paperConfig().entities.behavior.zombieVillagerInfectionChance.or(fallbackChance) && other instanceof EntityVillager) {
            EntityVillager entityvillager = (EntityVillager)other;
            flag = EntityZombie.zombifyVillager(world, entityvillager, this.dl(), this.aS(), CreatureSpawnEvent.SpawnReason.INFECTION) == null;
        }
        return flag;
    }

    public static EntityZombieVillager zombifyVillager(WorldServer worldserver, EntityVillager entityvillager, BlockPosition blockPosition, boolean silent, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityZombieVillager entityzombievillager = entityvillager.convertTo(EntityTypes.br, false, EntityTransformEvent.TransformReason.INFECTION, spawnReason);
        if (entityzombievillager != null) {
            entityzombievillager.a(worldserver, worldserver.d_(entityzombievillager.dl()), EnumMobSpawn.i, new GroupDataZombie(false, true), null);
            entityzombievillager.a(entityvillager.go());
            entityzombievillager.a(entityvillager.gy().a(DynamicOpsNBT.a));
            entityzombievillager.c(entityvillager.gf().a());
            entityzombievillager.b(entityvillager.t());
            if (!silent) {
                worldserver.a((EntityHuman)null, 1026, blockPosition, 0);
            }
        }
        return entityzombievillager;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        return this.m_() ? 0.93f : 1.74f;
    }

    @Override
    public boolean j(ItemStack stack) {
        return stack.a(Items.qd) && this.m_() && this.bN() ? false : super.j(stack);
    }

    @Override
    public boolean k(ItemStack stack) {
        return stack.a(Items.qs) ? false : super.k(stack);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomsource = world.D_();
        GroupDataEntity object = super.a(world, difficulty, spawnReason, entityData, entityNbt);
        float f2 = difficulty.d();
        this.s(this.dL().paperConfig().entities.behavior.mobsCanAlwaysPickUpLoot.zombies || randomsource.i() < 0.55f * f2);
        if (object == null) {
            object = new GroupDataZombie(EntityZombie.a(randomsource), true);
        }
        if (object instanceof GroupDataZombie) {
            GroupDataZombie entityzombie_groupdatazombie = (GroupDataZombie)object;
            if (entityzombie_groupdatazombie.a) {
                this.a(true);
                if (entityzombie_groupdatazombie.b) {
                    EntityChicken entitychicken1;
                    if ((double)randomsource.i() < 0.05) {
                        List<Entity> list = world.a(EntityChicken.class, this.cG().c(5.0, 3.0, 5.0), IEntitySelector.c);
                        if (!list.isEmpty()) {
                            EntityChicken entitychicken = (EntityChicken)list.get(0);
                            entitychicken.w(true);
                            this.n(entitychicken);
                        }
                    } else if ((double)randomsource.i() < 0.05 && (entitychicken1 = EntityTypes.q.a(this.dL())) != null) {
                        entitychicken1.b(this.dq(), this.ds(), this.dw(), this.dB(), 0.0f);
                        entitychicken1.a(world, difficulty, EnumMobSpawn.g, (GroupDataEntity)null, null);
                        entitychicken1.w(true);
                        this.n(entitychicken1);
                        world.addFreshEntity(entitychicken1, CreatureSpawnEvent.SpawnReason.MOUNT);
                    }
                }
            }
            this.x(this.t() && randomsource.i() < f2 * 0.1f);
            this.a(randomsource, difficulty);
            this.b(randomsource, difficulty);
        }
        if (this.c(EnumItemSlot.f).b()) {
            LocalDate localdate = LocalDate.now();
            int i2 = localdate.get(ChronoField.DAY_OF_MONTH);
            int j2 = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j2 == 10 && i2 == 31 && randomsource.i() < 0.25f) {
                this.a(EnumItemSlot.f, new ItemStack(randomsource.i() < 0.1f ? Blocks.eg : Blocks.ef));
                this.bR[EnumItemSlot.f.b()] = 0.0f;
            }
        }
        this.E(f2);
        return object;
    }

    public static boolean a(RandomSource random) {
        return random.i() < 0.05f;
    }

    protected void E(float chanceMultiplier) {
        this.gm();
        this.a(GenericAttributes.c).c(new AttributeModifier("Random spawn bonus", this.ag.j() * (double)0.05f, AttributeModifier.Operation.a));
        double d0 = this.ag.j() * 1.5 * (double)chanceMultiplier;
        if (d0 > 1.0) {
            this.a(GenericAttributes.b).c(new AttributeModifier("Random zombie-spawn bonus", d0, AttributeModifier.Operation.c));
        }
        if (this.ag.i() < chanceMultiplier * 0.05f) {
            this.a(GenericAttributes.m).c(new AttributeModifier("Leader zombie bonus", this.ag.j() * 0.25 + 0.5, AttributeModifier.Operation.a));
            this.a(GenericAttributes.a).c(new AttributeModifier("Leader zombie bonus", this.ag.j() * 3.0 + 1.0, AttributeModifier.Operation.c));
            this.x(this.t());
        }
    }

    protected void gm() {
        this.a(GenericAttributes.m).a(this.ag.j() * (double)0.1f);
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + 0.0625f * scaleFactor, 0.0f);
    }

    @Override
    protected float l(Entity vehicle) {
        return -0.7f;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        ItemStack itemstack;
        EntityCreeper entitycreeper;
        super.a(source, lootingMultiplier, allowDrops);
        Entity entity = source.d();
        if (entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).ge() && !(itemstack = this.gd()).b()) {
            entitycreeper.gf();
            this.b(itemstack);
        }
    }

    protected ItemStack gd() {
        return new ItemStack(Items.tu);
    }

    private class a
    extends PathfinderGoalRemoveBlock {
        a(EntityCreature mob, double speed, int range) {
            super(Blocks.mf, mob, speed, range);
        }

        @Override
        public void a(GeneratorAccess world, BlockPosition pos) {
            world.a((EntityHuman)null, pos, SoundEffects.Bg, SoundCategory.f, 0.5f, 0.9f + EntityZombie.this.ag.i() * 0.2f);
        }

        @Override
        public void a(World world, BlockPosition pos) {
            world.a((EntityHuman)null, pos, SoundEffects.yl, SoundCategory.e, 0.7f, 0.9f + world.z.i() * 0.2f);
        }

        @Override
        public double i() {
            return 1.14;
        }
    }

    public static class GroupDataZombie
    implements GroupDataEntity {
        public final boolean a;
        public final boolean b;

        public GroupDataZombie(boolean baby, boolean tryChickenJockey) {
            this.a = baby;
            this.b = tryChickenJockey;
        }
    }
}

