/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class EntityZombieVillager
extends EntityZombie
implements VillagerDataHolder {
    private static final Logger b = LogUtils.getLogger();
    public static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<VillagerData> d = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.t);
    private static final int bX = 3600;
    private static final int bY = 6000;
    private static final int bZ = 14;
    private static final int ca = 4;
    public int cb;
    @Nullable
    public UUID cc;
    @Nullable
    private NBTBase cd;
    @Nullable
    private NBTTagCompound ce;
    private int cf;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombieVillager(EntityTypes<? extends EntityZombieVillager> type, World world) {
        super((EntityTypes<? extends EntityZombie>)type, world);
        BuiltInRegistries.A.a(this.ag).ifPresent(holder_c -> this.a(this.go().a((VillagerProfession)holder_c.a())));
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(c, false);
        this.an.a(d, new VillagerData(VillagerType.c, VillagerProfession.b, 1));
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = VillagerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.go());
        Logger logger = b;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("VillagerData", (NBTBase)nbtbase));
        if (this.ce != null) {
            nbt.a("Offers", this.ce);
        }
        if (this.cd != null) {
            nbt.a("Gossips", this.cd);
        }
        nbt.a("ConversionTime", this.gn() ? this.cb : -1);
        if (this.cc != null) {
            nbt.a("ConversionPlayer", this.cc);
        }
        nbt.a("Xp", this.cf);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        if (nbt.b("VillagerData", 10)) {
            DataResult dataresult = VillagerData.c.parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("VillagerData")));
            Logger logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(this::a);
        }
        if (nbt.b("Offers", 10)) {
            this.ce = nbt.p("Offers");
        }
        if (nbt.b("Gossips", 9)) {
            this.cd = nbt.c("Gossips", 10);
        }
        if (nbt.b("ConversionTime", 99) && nbt.h("ConversionTime") > -1) {
            this.a(nbt.b("ConversionPlayer") ? nbt.a("ConversionPlayer") : null, nbt.h("ConversionTime"));
        }
        if (nbt.b("Xp", 3)) {
            this.cf = nbt.h("Xp");
        }
    }

    @Override
    public void l() {
        if (!this.dL().B && this.bv() && this.gn()) {
            int i2 = this.gq();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            this.cb -= (i2 *= elapsedTicks);
            if (this.cb <= 0) {
                this.c((WorldServer)this.dL());
            }
        }
        super.l();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        ItemStack itemstack = player.b(hand);
        if (itemstack.a(Items.pm)) {
            if (this.a(MobEffects.r)) {
                if (!player.fS().d) {
                    itemstack.h(1);
                }
                if (!this.dL().B) {
                    this.a(player.cv(), this.ag.a(2401) + 3600);
                }
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.b;
        }
        return super.b(player, hand);
    }

    @Override
    protected boolean ge() {
        return false;
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.gn() && this.cf == 0;
    }

    public boolean gn() {
        return this.al().b(c);
    }

    public void a(@Nullable UUID uuid, int delay) {
        this.startConverting(uuid, delay, true);
    }

    public void startConverting(@Nullable UUID uuid, int delay, boolean broadcastEntityEvent) {
        this.cc = uuid;
        this.cb = delay;
        this.al().b(c, true);
        this.removeEffect(MobEffects.r, EntityPotionEffectEvent.Cause.CONVERSION);
        this.addEffect(new MobEffect(MobEffects.e, delay, Math.min(this.dL().ai().a() - 1, 0)), EntityPotionEffectEvent.Cause.CONVERSION);
        if (broadcastEntityEvent) {
            this.dL().a((Entity)this, (byte)16);
        }
    }

    @Override
    public void b(byte status) {
        if (status == 16) {
            if (!this.aS()) {
                this.dL().a(this.dq(), this.du(), this.dw(), SoundEffects.Bt, this.da(), 1.0f + this.ag.i(), this.ag.i() * 0.7f + 0.3f, false);
            }
        } else {
            super.b(status);
        }
    }

    private void c(WorldServer world) {
        EntityHuman entityhuman;
        EntityVillager entityvillager = this.convertTo(EntityTypes.bf, false, EntityTransformEvent.TransformReason.CURED, CreatureSpawnEvent.SpawnReason.CURED);
        if (entityvillager == null) {
            ((ZombieVillager)this.getBukkitEntity()).setConversionTime(-1);
            return;
        }
        for (EnumItemSlot enumitemslot : EnumItemSlot.VALUES) {
            ItemStack itemstack = this.c(enumitemslot);
            if (itemstack.b()) continue;
            if (EnchantmentManager.d(itemstack)) {
                entityvillager.a_(enumitemslot.b() + 300).a(itemstack);
                continue;
            }
            double d0 = this.f(enumitemslot);
            if (!(d0 > 1.0)) continue;
            this.forceDrops = true;
            this.b(itemstack);
            this.forceDrops = false;
        }
        entityvillager.a(this.go());
        if (this.cd != null) {
            entityvillager.a(this.cd);
        }
        if (this.ce != null) {
            entityvillager.b(new MerchantRecipeList(this.ce));
        }
        entityvillager.u(this.cf);
        entityvillager.a(world, world.d_(entityvillager.dl()), EnumMobSpawn.i, (GroupDataEntity)null, null);
        entityvillager.c(world);
        if (this.cc != null && (entityhuman = world.getGlobalPlayerByUUID(this.cc)) instanceof EntityPlayer) {
            CriterionTriggers.r.a((EntityPlayer)entityhuman, this, entityvillager);
            world.a(ReputationEvent.a, (Entity)entityhuman, entityvillager);
        }
        entityvillager.addEffect(new MobEffect(MobEffects.i, 200, 0), EntityPotionEffectEvent.Cause.CONVERSION);
        if (!this.aS()) {
            world.a((EntityHuman)null, 1027, this.dl(), 0);
        }
    }

    private int gq() {
        int i2 = 1;
        if (this.ag.i() < 0.01f) {
            int j2 = 0;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k2 = (int)this.dq() - 4; k2 < (int)this.dq() + 4 && j2 < 14; ++k2) {
                for (int l2 = (int)this.ds() - 4; l2 < (int)this.ds() + 4 && j2 < 14; ++l2) {
                    for (int i1 = (int)this.dw() - 4; i1 < (int)this.dw() + 4 && j2 < 14; ++i1) {
                        IBlockData iblockdata = this.dL().a_(blockposition_mutableblockposition.d(k2, l2, i1));
                        if (!iblockdata.a(Blocks.eX) && !(iblockdata.b() instanceof BlockBed)) continue;
                        if (this.ag.i() < 0.3f) {
                            ++i2;
                        }
                        ++j2;
                    }
                }
            }
        }
        return i2;
    }

    @Override
    public float eW() {
        return this.m_() ? (this.ag.i() - this.ag.i()) * 0.2f + 2.0f : (this.ag.i() - this.ag.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEffect w() {
        return SoundEffects.Br;
    }

    @Override
    public SoundEffect d(DamageSource source) {
        return SoundEffects.Bv;
    }

    @Override
    public SoundEffect l_() {
        return SoundEffects.Bu;
    }

    @Override
    public SoundEffect y() {
        return SoundEffects.Bw;
    }

    @Override
    protected ItemStack gd() {
        return ItemStack.b;
    }

    public void c(NBTTagCompound offerData) {
        this.ce = offerData;
    }

    @Override
    public void a(NBTBase gossipData) {
        this.cd = gossipData;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.a(this.go().a(VillagerType.a(world.s(this.dl()))));
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public void a(VillagerData villagerData) {
        VillagerData villagerdata1 = this.go();
        if (villagerdata1.b() != villagerData.b()) {
            this.ce = null;
        }
        this.an.b(d, villagerData);
    }

    @Override
    public VillagerData go() {
        return this.an.b(d);
    }

    public int gp() {
        return this.cf;
    }

    @Override
    public void b(int xp) {
        this.cf = xp;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + 0.175f * scaleFactor, 0.0f);
    }
}

