/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.hoglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.EntityZoglin;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.monster.hoglin.HoglinAI;
import net.minecraft.world.entity.monster.hoglin.IOglin;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.joml.Vector3f;

public class EntityHoglin
extends EntityAnimal
implements IMonster,
IOglin {
    private static final DataWatcherObject<Boolean> bW = DataWatcher.a(EntityHoglin.class, DataWatcherRegistry.k);
    private static final float bX = 0.2f;
    private static final int bY = 40;
    private static final float bZ = 0.3f;
    private static final int ca = 1;
    private static final float cb = 0.6f;
    private static final int cc = 6;
    private static final float cd = 0.5f;
    private static final int ce = 300;
    private int cf;
    public int cg;
    public boolean ch;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super EntityHoglin>>> bT = ImmutableList.of(SensorType.c, SensorType.d, SensorType.n, SensorType.m);
    protected static final ImmutableList<? extends MemoryModuleType<?>> bU = ImmutableList.of(MemoryModuleType.r, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.n, MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.t, MemoryModuleType.o, MemoryModuleType.p, MemoryModuleType.ap, (Object[])new MemoryModuleType[]{MemoryModuleType.z, MemoryModuleType.ar, MemoryModuleType.as, MemoryModuleType.ao, MemoryModuleType.J, MemoryModuleType.av, MemoryModuleType.aw, MemoryModuleType.Y});

    public EntityHoglin(EntityTypes<? extends EntityHoglin> type, World world) {
        super((EntityTypes<? extends EntityAnimal>)type, world);
        this.bJ = 5;
    }

    @Override
    public boolean a(EntityHuman player) {
        return !this.fR();
    }

    public static AttributeProvider.Builder s() {
        return EntityMonster.gj().a(GenericAttributes.a, 40.0).a(GenericAttributes.d, 0.3f).a(GenericAttributes.c, 0.6f).a(GenericAttributes.g, 1.0).a(GenericAttributes.f, 6.0);
    }

    @Override
    public boolean C(Entity target) {
        if (!(target instanceof EntityLiving)) {
            return false;
        }
        this.cf = 10;
        this.dL().a((Entity)this, (byte)4);
        this.a(SoundEffects.kO, 1.0f, this.eW());
        HoglinAI.a(this, (EntityLiving)target);
        return IOglin.a(this, (EntityLiving)target);
    }

    @Override
    protected void e(EntityLiving target) {
        if (this.t()) {
            IOglin.b(this, target);
        }
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean bl = super.a(source, amount);
        if (this.dL().B) {
            return false;
        }
        if (bl && source.d() instanceof EntityLiving) {
            HoglinAI.b(this, (EntityLiving)source.d());
        }
        return bl;
    }

    protected BehaviorController.b<EntityHoglin> dO() {
        return BehaviorController.a(bU, bT);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return HoglinAI.a(this.dO().a(dynamic));
    }

    public BehaviorController<EntityHoglin> dN() {
        return super.dN();
    }

    @Override
    protected void X() {
        this.dL().ad().a("hoglinBrain");
        this.dN().a((WorldServer)this.dL(), this);
        this.dL().ad().c();
        HoglinAI.a(this);
        if (this.y()) {
            ++this.cg;
            if (this.cg > 300) {
                this.b(SoundEffects.kP);
                this.c((WorldServer)this.dL());
            }
        } else {
            this.cg = 0;
        }
    }

    @Override
    public void b_() {
        if (this.cf > 0) {
            --this.cf;
        }
        super.b_();
    }

    @Override
    protected void m() {
        if (this.m_()) {
            this.bJ = 3;
            this.a(GenericAttributes.f).a(0.5);
        } else {
            this.bJ = 5;
            this.a(GenericAttributes.f).a(6.0);
        }
    }

    public static boolean c(EntityTypes<EntityHoglin> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return !world.a_(pos.d()).a(Blocks.kK);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        if (world.D_().i() < 0.2f) {
            this.a(true);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.fK();
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        if (HoglinAI.a(this, pos)) {
            return -1.0f;
        }
        return world.a_(pos.d()).a(Blocks.ow) ? 10.0f : 0.0f;
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + 0.09375f * scaleFactor, 0.0f);
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult interactionResult = super.b(player, hand);
        if (interactionResult.a()) {
            this.fI();
        }
        return interactionResult;
    }

    @Override
    public void b(byte status) {
        if (status == 4) {
            this.cf = 10;
            this.a(SoundEffects.kO, 1.0f, this.eW());
        } else {
            super.b(status);
        }
    }

    @Override
    public int gd() {
        return this.cf;
    }

    @Override
    public boolean eb() {
        return true;
    }

    @Override
    public int ed() {
        return this.bJ;
    }

    private void c(WorldServer word) {
        EntityZoglin zoglin = this.a(EntityTypes.bo, true);
        if (zoglin != null) {
            zoglin.b(new MobEffect(MobEffects.i, 200, 0));
        } else {
            this.cg = 0;
        }
    }

    @Override
    public boolean m(ItemStack stack) {
        return stack.a(Items.dg);
    }

    public boolean t() {
        return !this.m_();
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(bW, false);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.gk()) {
            nbt.a("IsImmuneToZombification", true);
        }
        nbt.a("TimeInOverworld", this.cg);
        if (this.ch) {
            nbt.a("CannotBeHunted", true);
        }
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.w(nbt.q("IsImmuneToZombification"));
        this.cg = nbt.h("TimeInOverworld");
        this.x(nbt.q("CannotBeHunted"));
    }

    public void w(boolean immuneToZombification) {
        this.al().b(bW, immuneToZombification);
    }

    public boolean gk() {
        return this.al().b(bW);
    }

    public boolean y() {
        return !this.dL().C_().b() && !this.gk() && !this.fT();
    }

    private void x(boolean cannotBeHunted) {
        this.ch = cannotBeHunted;
    }

    public boolean gj() {
        return this.t() && !this.ch;
    }

    @Override
    @Nullable
    public EntityAgeable a(WorldServer world, EntityAgeable entity) {
        EntityHoglin hoglin = EntityTypes.W.a(world);
        if (hoglin != null) {
            hoglin.fI();
        }
        return hoglin;
    }

    @Override
    public boolean ge() {
        return !HoglinAI.c(this) && super.ge();
    }

    @Override
    public SoundCategory da() {
        return SoundCategory.f;
    }

    @Override
    protected SoundEffect w() {
        return this.dL().B ? null : HoglinAI.b(this).orElse(null);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.kR;
    }

    @Override
    public SoundEffect l_() {
        return SoundEffects.kQ;
    }

    @Override
    protected SoundEffect aL() {
        return SoundEffects.lw;
    }

    @Override
    protected SoundEffect aM() {
        return SoundEffects.lv;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.kT, 0.15f, 1.0f);
    }

    protected void b(SoundEffect sound) {
        this.a(sound, this.eV(), this.eW());
    }

    @Override
    protected void W() {
        super.W();
        PacketDebug.a(this);
    }
}

