/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityCreeper;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.monster.piglin.EntityPiglinArmPose;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityPiglin
extends EntityPiglinAbstract
implements ICrossbow,
InventoryCarrier {
    private static final DataWatcherObject<Boolean> bV = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bW = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> bX = DataWatcher.a(EntityPiglin.class, DataWatcherRegistry.k);
    private static final UUID bY = UUID.fromString("766bfa64-11f3-11ea-8d71-362b9e155667");
    private static final AttributeModifier bZ = new AttributeModifier(bY, "Baby speed boost", (double)0.2f, AttributeModifier.Operation.b);
    private static final int ca = 16;
    private static final float cb = 0.35f;
    private static final int cc = 5;
    private static final float cd = 1.6f;
    private static final float ce = 0.1f;
    private static final int cf = 3;
    private static final float cg = 0.2f;
    private static final float ch = 0.82f;
    private static final double ci = 0.5;
    public final InventorySubcontainer cj = new InventorySubcontainer(8);
    public boolean ck;
    protected static final ImmutableList<SensorType<? extends Sensor<? super EntityPiglin>>> bT = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.f, SensorType.k);
    protected static final ImmutableList<MemoryModuleType<?>> bU = ImmutableList.of(MemoryModuleType.n, MemoryModuleType.v, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.an, MemoryModuleType.am, MemoryModuleType.K, MemoryModuleType.aO, MemoryModuleType.x, MemoryModuleType.y, (Object[])new MemoryModuleType[]{MemoryModuleType.m, MemoryModuleType.E, MemoryModuleType.o, MemoryModuleType.p, MemoryModuleType.q, MemoryModuleType.t, MemoryModuleType.aa, MemoryModuleType.ab, MemoryModuleType.z, MemoryModuleType.ac, MemoryModuleType.ad, MemoryModuleType.af, MemoryModuleType.ae, MemoryModuleType.ah, MemoryModuleType.ai, MemoryModuleType.ag, MemoryModuleType.ak, MemoryModuleType.L, MemoryModuleType.aq, MemoryModuleType.s, MemoryModuleType.ar, MemoryModuleType.as, MemoryModuleType.aj, MemoryModuleType.al, MemoryModuleType.at, MemoryModuleType.au, MemoryModuleType.av});
    public Set<Item> allowedBarterItems = new HashSet<Item>();
    public Set<Item> interestItems = new HashSet<Item>();

    public EntityPiglin(EntityTypes<? extends EntityPiglinAbstract> type, World world) {
        super(type, world);
        this.bJ = 5;
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        if (this.m_()) {
            nbt.a("IsBaby", true);
        }
        if (this.ck) {
            nbt.a("CannotHunt", true);
        }
        this.a_(nbt);
        NBTTagList barterList = new NBTTagList();
        this.allowedBarterItems.stream().map(BuiltInRegistries.i::b).map(MinecraftKey::toString).map(NBTTagString::a).forEach(barterList::add);
        nbt.a("Bukkit.BarterList", barterList);
        NBTTagList interestList = new NBTTagList();
        this.interestItems.stream().map(BuiltInRegistries.i::b).map(MinecraftKey::toString).map(NBTTagString::a).forEach(interestList::add);
        nbt.a("Bukkit.InterestList", interestList);
    }

    @Override
    public void a(NBTTagCompound nbt) {
        super.a(nbt);
        this.a(nbt.q("IsBaby"));
        this.y(nbt.q("CannotHunt"));
        this.c(nbt);
        this.allowedBarterItems = nbt.c("Bukkit.BarterList", 8).stream().map(NBTBase::r_).map(MinecraftKey::a).map(BuiltInRegistries.i::a).collect(Collectors.toCollection(HashSet::new));
        this.interestItems = nbt.c("Bukkit.InterestList", 8).stream().map(NBTBase::r_).map(MinecraftKey::a).map(BuiltInRegistries.i::a).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    @VisibleForDebug
    public InventorySubcontainer y() {
        return this.cj;
    }

    @Override
    protected void a(DamageSource source, int lootingMultiplier, boolean allowDrops) {
        EntityCreeper entitycreeper;
        super.a(source, lootingMultiplier, allowDrops);
        Entity entity = source.d();
        if (entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).ge()) {
            ItemStack itemstack = new ItemStack(Items.tx);
            entitycreeper.gf();
            this.b(itemstack);
        }
        this.cj.f().forEach(this::b);
    }

    protected ItemStack l(ItemStack stack) {
        return this.cj.a(stack);
    }

    protected boolean m(ItemStack stack) {
        return this.cj.b(stack);
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(bV, false);
        this.an.a(bW, false);
        this.an.a(bX, false);
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        super.a(data);
        if (bV.equals(data)) {
            this.i_();
        }
    }

    public static AttributeProvider.Builder gk() {
        return EntityMonster.gj().a(GenericAttributes.a, 16.0).a(GenericAttributes.d, 0.35f).a(GenericAttributes.f, 5.0);
    }

    public static boolean b(EntityTypes<EntityPiglin> type, GeneratorAccess world, EnumMobSpawn spawnReason, BlockPosition pos, RandomSource random) {
        return !world.a_(pos.d()).a(Blocks.kK);
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        RandomSource randomsource = world.D_();
        if (spawnReason != EnumMobSpawn.d) {
            if (randomsource.i() < 0.2f) {
                this.a(true);
            } else if (this.ge()) {
                this.a(EnumItemSlot.a, this.gm());
            }
        }
        PiglinAI.a(this, world.D_());
        this.a(randomsource, difficulty);
        this.b(randomsource, difficulty);
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    protected boolean V() {
        return false;
    }

    @Override
    public boolean h(double distanceSquared) {
        return !this.fK();
    }

    @Override
    protected void a(RandomSource random, DifficultyDamageScaler localDifficulty) {
        if (this.ge()) {
            this.a(EnumItemSlot.f, new ItemStack(Items.pa), random);
            this.a(EnumItemSlot.e, new ItemStack(Items.pb), random);
            this.a(EnumItemSlot.d, new ItemStack(Items.pc), random);
            this.a(EnumItemSlot.c, new ItemStack(Items.pd), random);
        }
    }

    private void a(EnumItemSlot slot, ItemStack stack, RandomSource random) {
        if (random.i() < 0.1f) {
            this.a(slot, stack);
        }
    }

    protected BehaviorController.b<EntityPiglin> dO() {
        return BehaviorController.a(bU, bT);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return PiglinAI.a(this, this.dO().a(dynamic));
    }

    public BehaviorController<EntityPiglin> dN() {
        return super.dN();
    }

    @Override
    public EnumInteractionResult b(EntityHuman player, EnumHand hand) {
        EnumInteractionResult enuminteractionresult = super.b(player, hand);
        if (enuminteractionresult.a()) {
            return enuminteractionresult;
        }
        if (!this.dL().B) {
            return PiglinAI.a(this, player, hand);
        }
        boolean flag = PiglinAI.b(this, player.b(hand)) && this.gf() != EntityPiglinArmPose.d;
        return flag ? EnumInteractionResult.a : EnumInteractionResult.d;
    }

    @Override
    protected float b(EntityPose pose, EntitySize dimensions) {
        float f2 = super.b(pose, dimensions);
        return this.m_() ? f2 - 0.82f : f2;
    }

    @Override
    public void a(boolean baby) {
        this.al().b(bV, baby);
        if (!this.dL().B) {
            AttributeModifiable attributemodifiable = this.a(GenericAttributes.d);
            attributemodifiable.b(bZ.a());
            if (baby) {
                attributemodifiable.b(bZ);
            }
        }
    }

    @Override
    public boolean m_() {
        return this.al().b(bV);
    }

    private void y(boolean cannotHunt) {
        this.ck = cannotHunt;
    }

    @Override
    protected boolean s() {
        return !this.ck;
    }

    @Override
    protected void X() {
        this.dL().ad().a("piglinBrain");
        this.dN().a((WorldServer)this.dL(), this);
        this.dL().ad().c();
        PiglinAI.a(this);
        super.X();
    }

    @Override
    public int ed() {
        return this.bJ;
    }

    @Override
    protected void c(WorldServer world) {
        PiglinAI.b(this);
        this.forceDrops = true;
        this.cj.f().forEach(this::b);
        this.forceDrops = false;
        super.c(world);
    }

    private ItemStack gm() {
        return (double)this.ag.i() < 0.5 ? new ItemStack(Items.uZ) : new ItemStack(Items.oh);
    }

    public boolean gn() {
        return this.an.b(bW);
    }

    @Override
    public void b(boolean charging) {
        this.an.b(bW, charging);
    }

    @Override
    public void a() {
        this.bb = 0;
    }

    @Override
    public EntityPiglinArmPose gf() {
        return this.gl() ? EntityPiglinArmPose.e : (PiglinAI.a(this.eT()) ? EntityPiglinArmPose.d : (this.fV() && this.gg() ? EntityPiglinArmPose.a : (this.gn() ? EntityPiglinArmPose.c : (this.fV() && this.b(Items.uZ) ? EntityPiglinArmPose.b : EntityPiglinArmPose.f))));
    }

    public boolean gl() {
        return this.an.b(bX);
    }

    public void x(boolean dancing) {
        this.an.b(bX, dancing);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag = super.a(source, amount);
        if (this.dL().B) {
            return false;
        }
        if (flag && source.d() instanceof EntityLiving) {
            PiglinAI.a(this, (EntityLiving)source.d());
        }
        return flag;
    }

    @Override
    public void a(EntityLiving target, float pullProgress) {
        this.b(this, 1.6f);
    }

    @Override
    public void a(EntityLiving target, ItemStack crossbow, IProjectile projectile, float multiShotSpray) {
        this.a(this, target, projectile, multiShotSpray, 1.6f);
    }

    @Override
    public boolean a(ItemProjectileWeapon weapon) {
        return weapon == Items.uZ;
    }

    protected void n(ItemStack stack) {
        this.b(EnumItemSlot.a, stack);
    }

    protected void o(ItemStack stack) {
        if (stack.a(PiglinAI.c) || this.allowedBarterItems.contains(stack.d())) {
            this.a(EnumItemSlot.b, stack);
            this.e(EnumItemSlot.b);
        } else {
            this.b(EnumItemSlot.b, stack);
        }
    }

    @Override
    public boolean k(ItemStack stack) {
        return this.dL().X().b(GameRules.c) && this.fJ() && PiglinAI.a(this, stack);
    }

    protected boolean p(ItemStack stack) {
        EnumItemSlot enumitemslot = EntityInsentient.h(stack);
        ItemStack itemstack1 = this.c(enumitemslot);
        return this.b(stack, itemstack1);
    }

    @Override
    protected boolean b(ItemStack newStack, ItemStack oldStack) {
        boolean flag1;
        if (EnchantmentManager.d(oldStack)) {
            return false;
        }
        boolean flag = PiglinAI.isLovedItem(newStack, this) || newStack.a(Items.uZ);
        boolean bl = flag1 = PiglinAI.isLovedItem(oldStack, this) || oldStack.a(Items.uZ);
        return flag && !flag1 ? true : (!flag && flag1 ? false : (this.ge() && !newStack.a(Items.uZ) && oldStack.a(Items.uZ) ? false : super.b(newStack, oldStack)));
    }

    @Override
    protected void b(EntityItem item) {
        PiglinAI.a(this, item);
    }

    @Override
    public boolean a(Entity entity, boolean force) {
        if (this.m_() && entity.ag() == EntityTypes.W) {
            entity = this.b(entity, 3);
        }
        return super.a(entity, force);
    }

    private Entity b(Entity entity, int maxLevel) {
        List<Entity> list = entity.cP();
        return maxLevel != 1 && !list.isEmpty() ? this.b(list.get(0), maxLevel - 1) : entity;
    }

    @Override
    protected SoundEffect w() {
        return this.dL().B ? null : (SoundEffect)PiglinAI.c(this).orElse(null);
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.rZ;
    }

    @Override
    public SoundEffect l_() {
        return SoundEffects.rX;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.sb, 0.15f, 1.0f);
    }

    protected void b(SoundEffect sound) {
        this.a(sound, this.eV(), this.eW());
    }

    @Override
    protected void gh() {
        this.b(SoundEffects.sc);
    }
}

