/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.event.entity.WardenAngerChangeEvent;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.warden.SonicBoom;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.monster.warden.WardenAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.Pathfinder;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jetbrains.annotations.Contract;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class Warden
extends EntityMonster
implements VibrationSystem {
    private static final Logger bV = LogUtils.getLogger();
    private static final int bW = 40;
    private static final int bX = 200;
    private static final int bY = 500;
    private static final float bZ = 0.3f;
    private static final float ca = 1.0f;
    private static final float cb = 1.5f;
    private static final int cc = 30;
    private static final DataWatcherObject<Integer> cd = DataWatcher.a(Warden.class, DataWatcherRegistry.b);
    private static final int ce = 200;
    private static final int cf = 260;
    private static final int cg = 20;
    private static final int ch = 120;
    private static final int ci = 20;
    private static final int cj = 35;
    private static final int ck = 10;
    private static final int cl = 20;
    private static final int cm = 100;
    private static final int cn = 20;
    private static final int co = 30;
    private static final float cp = 4.5f;
    private static final float cq = 0.7f;
    private static final int cr = 30;
    private int cs;
    private int ct;
    private int cu;
    private int cv;
    public AnimationState b = new AnimationState();
    public AnimationState c = new AnimationState();
    public AnimationState d = new AnimationState();
    public AnimationState e = new AnimationState();
    public AnimationState bT = new AnimationState();
    public AnimationState bU = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.b> cw = new DynamicGameEventListener<VibrationSystem.b>(new VibrationSystem.b(this));
    private final VibrationSystem.d cx = new a();
    private VibrationSystem.a cy = new VibrationSystem.a();
    AngerManagement cz = new AngerManagement(this::a, Collections.emptyList());

    public Warden(EntityTypes<? extends EntityMonster> type, World world) {
        super(type, world);
        this.bJ = 5;
        this.L().a(true);
        this.a(PathType.m, 0.0f);
        this.a(PathType.q, 8.0f);
        this.a(PathType.f, 8.0f);
        this.a(PathType.i, 8.0f);
        this.a(PathType.o, 0.0f);
        this.a(PathType.n, 0.0f);
    }

    @Override
    public Packet<PacketListenerPlayOut> di() {
        return new PacketPlayOutSpawnEntity(this, this.c(EntityPose.n) ? 1 : 0);
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packet) {
        super.a(packet);
        if (packet.o() == 1) {
            this.b(EntityPose.n);
        }
    }

    @Override
    public boolean a(IWorldReader world) {
        return super.a(world) && world.a((Entity)this, this.ag().n().a(this.dj()));
    }

    @Override
    public float a(BlockPosition pos, IWorldReader world) {
        return 0.0f;
    }

    @Override
    public boolean b(DamageSource damageSource) {
        return this.gh() && !damageSource.a(DamageTypeTags.d) ? true : super.b(damageSource);
    }

    boolean gh() {
        return this.c(EntityPose.o) || this.c(EntityPose.n);
    }

    @Override
    protected boolean o(Entity entity) {
        return false;
    }

    @Override
    public boolean fF() {
        return true;
    }

    @Override
    protected float aK() {
        return this.Z + 0.55f;
    }

    public static AttributeProvider.Builder s() {
        return EntityMonster.gj().a(GenericAttributes.a, 500.0).a(GenericAttributes.d, 0.3f).a(GenericAttributes.c, 1.0).a(GenericAttributes.g, 1.5).a(GenericAttributes.f, 30.0);
    }

    @Override
    public boolean aV() {
        return true;
    }

    @Override
    public float eV() {
        return 4.0f;
    }

    @Override
    @Nullable
    protected SoundEffect w() {
        return !this.c(EntityPose.l) && !this.gh() ? this.y().b() : null;
    }

    @Override
    protected SoundEffect d(DamageSource source) {
        return SoundEffects.zD;
    }

    @Override
    public SoundEffect l_() {
        return SoundEffects.zz;
    }

    @Override
    protected void b(BlockPosition pos, IBlockData state) {
        this.a(SoundEffects.zN, 10.0f, 1.0f);
    }

    @Override
    public boolean C(Entity target) {
        this.dL().a((Entity)this, (byte)4);
        this.a(SoundEffects.zy, 10.0f, this.eW());
        SonicBoom.a((EntityLiving)this, 40);
        return super.C(target);
    }

    @Override
    protected void a_() {
        super.a_();
        this.an.a(cd, 0);
    }

    public int t() {
        return this.an.b(cd);
    }

    private void gk() {
        this.an.b(cd, this.gn());
    }

    @Override
    public void l() {
        World world = this.dL();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            VibrationSystem.c.a((World)worldserver, this.cy, this.cx);
            if (this.fK() || this.U()) {
                WardenAi.a((EntityLiving)this);
            }
        }
        super.l();
        if (this.dL().w_()) {
            if (this.ah % this.gl() == 0) {
                this.cu = 10;
                if (!this.aS()) {
                    this.dL().a(this.dq(), this.ds(), this.dw(), SoundEffects.zC, this.da(), 5.0f, this.eW(), false);
                }
            }
            this.ct = this.cs;
            if (this.cs > 0) {
                --this.cs;
            }
            this.cv = this.cu;
            if (this.cu > 0) {
                --this.cu;
            }
            switch (this.an()) {
                case n: {
                    this.a(this.d);
                    break;
                }
                case o: {
                    this.a(this.e);
                }
            }
        }
    }

    @Override
    protected void X() {
        WorldServer worldserver = (WorldServer)this.dL();
        worldserver.ad().a("wardenBrain");
        this.dN().a(worldserver, this);
        this.dL().ad().c();
        super.X();
        if ((this.ah + this.ah()) % 120 == 0) {
            Warden.a(worldserver, this.dj(), this, 20);
        }
        if (this.ah % 20 == 0) {
            this.cz.a(worldserver, this::a);
            this.gk();
        }
        WardenAi.a(this);
    }

    @Override
    public void b(byte status) {
        if (status == 4) {
            this.b.a();
            this.bT.a(this.ah);
        } else if (status == 61) {
            this.cs = 10;
        } else if (status == 62) {
            this.bU.a(this.ah);
        } else {
            super.b(status);
        }
    }

    private int gl() {
        float f2 = (float)this.t() / (float)AngerLevel.c.a();
        return 40 - MathHelper.d(MathHelper.a(f2, 0.0f, 1.0f) * 30.0f);
    }

    public float E(float tickDelta) {
        return MathHelper.i(tickDelta, this.ct, this.cs) / 10.0f;
    }

    public float F(float tickDelta) {
        return MathHelper.i(tickDelta, this.cv, this.cu) / 10.0f;
    }

    private void a(AnimationState animationState) {
        if ((float)animationState.b() < 4500.0f) {
            RandomSource randomsource = this.ef();
            IBlockData iblockdata = this.bi();
            if (iblockdata.l() != EnumRenderType.a) {
                for (int i2 = 0; i2 < 30; ++i2) {
                    double d0 = this.dq() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    double d1 = this.ds();
                    double d2 = this.dw() + (double)MathHelper.b(randomsource, -0.7f, 0.7f);
                    this.dL().a(new ParticleParamBlock(Particles.c, iblockdata), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Override
    public void a(DataWatcherObject<?> data) {
        if (Entity.as.equals(data)) {
            switch (this.an()) {
                case n: {
                    this.d.a(this.ah);
                    break;
                }
                case o: {
                    this.e.a(this.ah);
                    break;
                }
                case l: {
                    this.b.a(this.ah);
                    break;
                }
                case m: {
                    this.c.a(this.ah);
                }
            }
        }
        super.a(data);
    }

    @Override
    public boolean cL() {
        return this.gh();
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        return WardenAi.a(this, dynamic);
    }

    public BehaviorController<Warden> dN() {
        return super.dN();
    }

    @Override
    protected void W() {
        super.W();
        PacketDebug.a(this);
    }

    @Override
    public void a(BiConsumer<DynamicGameEventListener<?>, WorldServer> callback) {
        World world = this.dL();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            callback.accept(this.cw, worldserver);
        }
    }

    @Contract(value="null->false")
    public boolean a(@Nullable Entity entity) {
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            if (this.dL() == entity.dL() && IEntitySelector.e.test(entity) && !this.s(entity) && entityliving.ag() != EntityTypes.d && entityliving.ag() != EntityTypes.bi && !entityliving.cq() && !entityliving.ev() && this.dL().B_().a(entityliving.cG())) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    public static void a(WorldServer world, Vec3D pos, @Nullable Entity entity, int range) {
        MobEffect mobeffect = new MobEffect(MobEffects.G, 260, 0, false, false);
        MobEffectUtil.addEffectToPlayersAround(world, entity, pos, range, mobeffect, 200, EntityPotionEffectEvent.Cause.WARDEN);
    }

    @Override
    public void b(NBTTagCompound nbt) {
        super.b(nbt);
        DataResult dataresult = AngerManagement.a(this::a).encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cz);
        Logger logger = bV;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("anger", (NBTBase)nbtbase));
        dataresult = VibrationSystem.a.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cy);
        logger = bV;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("listener", (NBTBase)nbtbase));
    }

    @Override
    public void a(NBTTagCompound nbt) {
        Logger logger;
        DataResult dataresult;
        super.a(nbt);
        if (nbt.e("anger")) {
            dataresult = AngerManagement.a(this::a).parse(new Dynamic<NBTBase>(DynamicOpsNBT.a, nbt.c("anger")));
            logger = bV;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(angermanagement -> {
                this.cz = angermanagement;
            });
            this.gk();
        }
        if (nbt.b("listener", 10)) {
            dataresult = VibrationSystem.a.a.parse(new Dynamic<NBTTagCompound>(DynamicOpsNBT.a, nbt.p("listener")));
            logger = bV;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(vibrationsystem_a -> {
                this.cy = vibrationsystem_a;
            });
        }
    }

    private void gm() {
        if (!this.c(EntityPose.l)) {
            this.a(this.y().c(), 10.0f, this.eW());
        }
    }

    public AngerLevel y() {
        return AngerLevel.a(this.gn());
    }

    private int gn() {
        return this.cz.b(this.q());
    }

    public void b(Entity entity) {
        this.cz.a(entity);
    }

    public void c(@Nullable Entity entity) {
        this.a(entity, 35, true);
    }

    @VisibleForTesting
    public void a(@Nullable Entity entity, int amount, boolean listening) {
        if (!this.fT() && this.a(entity)) {
            int activeAnger = this.cz.b(entity);
            WardenAngerChangeEvent event = new WardenAngerChangeEvent((org.bukkit.entity.Warden)this.getBukkitEntity(), (org.bukkit.entity.Entity)entity.getBukkitEntity(), activeAnger, Math.min(150, activeAnger + amount));
            this.dL().getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
            amount = event.getNewAnger() - activeAnger;
            WardenAi.a((EntityLiving)this);
            boolean flag1 = !(this.dN().c(MemoryModuleType.o).orElse(null) instanceof EntityHuman);
            int j2 = this.cz.a(entity, amount);
            if (entity instanceof EntityHuman && flag1 && AngerLevel.a(j2).d()) {
                this.dN().b(MemoryModuleType.o);
            }
            if (listening) {
                this.gm();
            }
        }
    }

    public Optional<EntityLiving> gd() {
        return this.y().d() ? this.cz.a() : Optional.empty();
    }

    @Override
    @Nullable
    public EntityLiving q() {
        return this.dN().c(MemoryModuleType.o).orElse(null);
    }

    @Override
    public boolean h(double distanceSquared) {
        return false;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess world, DifficultyDamageScaler difficulty, EnumMobSpawn spawnReason, @Nullable GroupDataEntity entityData, @Nullable NBTTagCompound entityNbt) {
        this.dN().a(MemoryModuleType.aD, Unit.a, 1200L);
        if (spawnReason == EnumMobSpawn.k) {
            this.b(EntityPose.n);
            this.dN().a(MemoryModuleType.aB, Unit.a, WardenAi.a);
            this.a(SoundEffects.zv, 5.0f, 1.0f);
        }
        return super.a(world, difficulty, spawnReason, entityData, entityNbt);
    }

    @Override
    public boolean a(DamageSource source, float amount) {
        boolean flag = super.a(source, amount);
        if (!(this.dL().B || this.fT() || this.gh())) {
            Entity entity = source.d();
            this.a(entity, AngerLevel.c.a() + 20, false);
            if (this.bz.c(MemoryModuleType.o).isEmpty() && entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                if (!source.b() || this.a((Entity)entityliving, 5.0)) {
                    this.j(entityliving);
                }
            }
        }
        return flag;
    }

    public void j(EntityLiving target) {
        this.dN().b(MemoryModuleType.ax);
        this.dN().a(MemoryModuleType.o, target);
        this.dN().b(MemoryModuleType.E);
        SonicBoom.a((EntityLiving)this, 200);
    }

    @Override
    public EntitySize a(EntityPose pose) {
        EntitySize entitysize = super.a(pose);
        return this.gh() ? EntitySize.c(entitysize.a, 1.0f) : entitysize;
    }

    @Override
    public boolean bs() {
        return !this.gh() && super.bs();
    }

    @Override
    protected void D(Entity entity) {
        if (!this.fT() && !this.dN().a(MemoryModuleType.aG)) {
            this.dN().a(MemoryModuleType.aG, Unit.a, 20L);
            this.c(entity);
            WardenAi.a(this, entity.dl());
        }
        super.D(entity);
    }

    @VisibleForTesting
    public AngerManagement ge() {
        return this.cz;
    }

    @Override
    protected NavigationAbstract b(World world) {
        return new Navigation(this, world){

            @Override
            protected Pathfinder a(int range) {
                this.o = new PathfinderNormal();
                this.o.a(true);
                return new Pathfinder(this.o, range){

                    @Override
                    protected float a(PathPoint a2, PathPoint b2) {
                        return a2.b(b2);
                    }
                };
            }
        };
    }

    @Override
    protected Vector3f a(Entity passenger, EntitySize dimensions, float scaleFactor) {
        return new Vector3f(0.0f, dimensions.b + 0.25f * scaleFactor, 0.0f);
    }

    @Override
    public VibrationSystem.a gf() {
        return this.cy;
    }

    @Override
    public VibrationSystem.d gg() {
        return this.cx;
    }

    private class a
    implements VibrationSystem.d {
        private static final int b = 16;
        private final PositionSource c;

        a() {
            this.c = new EntityPositionSource(Warden.this, Warden.this.cH());
        }

        @Override
        public int a() {
            return 16;
        }

        @Override
        public PositionSource b() {
            return this.c;
        }

        @Override
        public TagKey<GameEvent> c() {
            return GameEventTags.b;
        }

        @Override
        public boolean d() {
            return true;
        }

        @Override
        public boolean a(WorldServer world, BlockPosition pos, GameEvent event, GameEvent.a emitter) {
            if (!(Warden.this.fT() || Warden.this.ev() || Warden.this.dN().a(MemoryModuleType.aH) || Warden.this.gh() || !world.B_().a(pos))) {
                EntityLiving entityliving;
                Entity entity = emitter.a();
                if (entity instanceof EntityLiving && !Warden.this.a((Entity)(entityliving = (EntityLiving)entity))) {
                    boolean flag = false;
                    return flag;
                }
                boolean flag = true;
                return flag;
            }
            return false;
        }

        @Override
        public void a(WorldServer world, BlockPosition pos, GameEvent event, @Nullable Entity sourceEntity, @Nullable Entity entity, float distance) {
            if (!Warden.this.ev()) {
                Warden.this.bz.a(MemoryModuleType.aH, Unit.a, 40L);
                world.a((Entity)Warden.this, (byte)61);
                Warden.this.a(SoundEffects.zO, 5.0f, Warden.this.eW());
                BlockPosition blockposition1 = pos;
                if (entity != null) {
                    if (Warden.this.a(entity, 30.0)) {
                        if (Warden.this.dN().a(MemoryModuleType.az)) {
                            if (Warden.this.a(entity)) {
                                blockposition1 = entity.dl();
                            }
                            Warden.this.c(entity);
                        } else {
                            Warden.this.a(entity, 10, true);
                        }
                    }
                    Warden.this.dN().a(MemoryModuleType.az, Unit.a, 100L);
                } else {
                    Warden.this.c(sourceEntity);
                }
                if (!Warden.this.y().d()) {
                    Optional<EntityLiving> optional = Warden.this.cz.a();
                    if (entity != null || optional.isEmpty() || optional.get() == sourceEntity) {
                        WardenAi.a(Warden.this, blockposition1);
                    }
                }
            }
        }
    }
}

