/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class WardenSpawnTracker {
    public static final Codec<WardenSpawnTracker> a = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.i.fieldOf("ticks_since_last_warning").orElse((Object)0).forGetter(manager -> manager.g), (App)ExtraCodecs.i.fieldOf("warning_level").orElse((Object)0).forGetter(manager -> manager.h), (App)ExtraCodecs.i.fieldOf("cooldown_ticks").orElse((Object)0).forGetter(manager -> manager.i)).apply((Applicative)instance, WardenSpawnTracker::new));
    public static final int b = 4;
    private static final double c = 16.0;
    private static final int d = 48;
    private static final int e = 12000;
    private static final int f = 200;
    public int g;
    private int h;
    public int i;

    public WardenSpawnTracker(int ticksSinceLastWarning, int warningLevel, int cooldownTicks) {
        this.g = ticksSinceLastWarning;
        this.h = warningLevel;
        this.i = cooldownTicks;
    }

    public void a() {
        if (this.g >= 12000) {
            this.f();
            this.g = 0;
        } else {
            ++this.g;
        }
        if (this.i > 0) {
            --this.i;
        }
    }

    public void b() {
        this.g = 0;
        this.h = 0;
        this.i = 0;
    }

    public static OptionalInt a(WorldServer world, BlockPosition pos, EntityPlayer player) {
        if (WardenSpawnTracker.a(world, pos)) {
            return OptionalInt.empty();
        }
        List<EntityPlayer> list = WardenSpawnTracker.b(world, pos);
        if (!list.contains(player)) {
            list.add(player);
        }
        if (list.stream().anyMatch(nearbyPlayer -> nearbyPlayer.Y().map(WardenSpawnTracker::d).orElse(false))) {
            return OptionalInt.empty();
        }
        Optional<WardenSpawnTracker> optional = list.stream().flatMap(playerx -> playerx.Y().stream()).max(Comparator.comparingInt(WardenSpawnTracker::c));
        if (optional.isPresent()) {
            WardenSpawnTracker wardenSpawnTracker = optional.get();
            wardenSpawnTracker.e();
            list.forEach(nearbyPlayer -> nearbyPlayer.Y().ifPresent(warningManager -> warningManager.a(wardenSpawnTracker)));
            return OptionalInt.of(wardenSpawnTracker.h);
        }
        return OptionalInt.empty();
    }

    private boolean d() {
        return this.i > 0;
    }

    private static boolean a(WorldServer world, BlockPosition pos) {
        AxisAlignedBB aABB = AxisAlignedBB.a(Vec3D.b(pos), 48.0, 48.0, 48.0);
        return !world.a(Warden.class, aABB).isEmpty();
    }

    private static List<EntityPlayer> b(WorldServer world, BlockPosition pos) {
        Vec3D vec3 = Vec3D.b(pos);
        Predicate<EntityPlayer> predicate = player -> player.dj().a((IPosition)vec3, 16.0);
        return world.a(predicate.and(EntityLiving::bv).and(IEntitySelector.f));
    }

    public void e() {
        if (!this.d()) {
            this.g = 0;
            this.i = 200;
            this.a(this.c() + 1);
        }
    }

    private void f() {
        this.a(this.c() - 1);
    }

    public void a(int warningLevel) {
        this.h = MathHelper.a(warningLevel, 0, 4);
    }

    public int c() {
        return this.h;
    }

    private void a(WardenSpawnTracker other) {
        this.h = other.h;
        this.i = other.i;
        this.g = other.g;
    }
}

